/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.IdentifierAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.meta.snmp.SNMPTableEntry;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.StaticTableRowMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.ConfigFileUtil;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.AuChannelDb_AuChannel;
import com.bwanms.validation.WeakNotNull;
import com.bwanms.validation.WeakRange;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;

@Entity
@SNMPTableEntry(entryOID="1.3.6.1.4.1.12394.1.2.2.11.1", indexColumns={"RbSlotNumber", "RbAuChannelId"})
public class RbAuChannelConfigEntry
extends StaticTableRowMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private String instance;
    private Integer rbSlotNumber;
    private Integer rbAuChannelId;
    private Integer rbAuChannelAssociatedRadioClusterId;
    private Integer rbAuChannelAssociatedOduId;
    private String rbAuChannelTxFrequency;
    private String rbAuChannelRxFrequency;
    private Integer rbAuChannelAdminStatus;
    private Integer rbAuChannelOperStatus;
    private String rbAuChannelConfiguredTxFrequency;
    private Integer rbAuChannelOduActualFrequencyBand;
    public static final int RbAuChannelAdminStatusEnable = 1;
    public static final int RbAuChannelAdminStatusDisable = 2;
    public static final int RbAuChannelOperStatusUnknown = 0;
    public static final int RbAuChannelOperStatusUp = 1;
    public static final int RbAuChannelOperStatusDown = 2;

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public final void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.1.1.1", type=2)
    @IdentifierAttribute
    public Integer getRbSlotNumber() {
        return this.rbSlotNumber;
    }

    public void setRbSlotNumber(Integer rbSlotNumber) {
        this.rbSlotNumber = rbSlotNumber;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.11.1.1", type=2, readOnly=true)
    @IdentifierAttribute
    public Integer getRbAuChannelId() {
        return this.rbAuChannelId;
    }

    public void setRbAuChannelId(Integer rbAuChannelId) {
        this.rbAuChannelId = rbAuChannelId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.11.1.2", type=2, readOnly=true)
    @Column(name="rbAuChannelAssocRadioClustId")
    @StateAttribute
    public Integer getRbAuChannelAssociatedRadioClusterId() {
        return this.rbAuChannelAssociatedRadioClusterId;
    }

    public void setRbAuChannelAssociatedRadioClusterId(Integer rbAuChannelAssociatedRadioClusterId) {
        this.rbAuChannelAssociatedRadioClusterId = rbAuChannelAssociatedRadioClusterId;
    }

    @WeakNotNull
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.11.1.3", type=2, readOnly=false)
    @ConfigAttribute
    public Integer getRbAuChannelAssociatedOduId() {
        return this.rbAuChannelAssociatedOduId;
    }

    public void setRbAuChannelAssociatedOduId(Integer rbAuChannelAssociatedOduId) {
        this.rbAuChannelAssociatedOduId = rbAuChannelAssociatedOduId;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.11.1.4", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @StateAttribute
    public String getRbAuChannelTxFrequency() {
        return this.rbAuChannelTxFrequency;
    }

    public void setRbAuChannelTxFrequency(String rbAuChannelTxFrequency) {
        this.rbAuChannelTxFrequency = rbAuChannelTxFrequency;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.11.1.5", type=-128, readOnly=true)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @StateAttribute
    public String getRbAuChannelRxFrequency() {
        return this.rbAuChannelRxFrequency;
    }

    public void setRbAuChannelRxFrequency(String rbAuChannelRxFrequency) {
        this.rbAuChannelRxFrequency = rbAuChannelRxFrequency;
    }

    @WeakRange(min=0L, max=2L)
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.11.1.6", type=2, readOnly=false)
    @ConfigAttribute
    public Integer getRbAuChannelAdminStatus() {
        return this.rbAuChannelAdminStatus;
    }

    public void setRbAuChannelAdminStatus(Integer rbAuChannelAdminStatus) {
        this.rbAuChannelAdminStatus = rbAuChannelAdminStatus;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.11.1.9", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbAuChannelOperStatus() {
        return this.rbAuChannelOperStatus;
    }

    public void setRbAuChannelOperStatus(Integer rbAuChannelOperStatus) {
        this.rbAuChannelOperStatus = rbAuChannelOperStatus;
    }

    public String toStringRbAuChannelAdminStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "Enable";
                break;
            }
            case 2: {
                result = "Disable";
                break;
            }
            default: {
                result = "undefined";
            }
        }
        return result;
    }

    public String toStringRbAuChannelOperStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                result = "unknown(0)";
                break;
            }
            case 1: {
                result = "up(1)";
                break;
            }
            case 2: {
                result = "down(2)";
                break;
            }
            default: {
                result = "undefined";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.11.1.7", type=-128, readOnly=false)
    @Type(type="com.bwanms.persistence.usertypes.EscapedString")
    @Column(name="RbAuChannelConfigTxFreq")
    @ConfigAttribute
    public String getRbAuChannelConfiguredTxFrequency() {
        return this.rbAuChannelConfiguredTxFrequency;
    }

    public void setRbAuChannelConfiguredTxFrequency(String rbAuChannelConfiguredTxFrequency) {
        this.rbAuChannelConfiguredTxFrequency = rbAuChannelConfiguredTxFrequency;
    }

    @Column(name="RbAuChnOduActFreqBand")
    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.11.1.8", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbAuChannelOduActualFrequencyBand() {
        return this.rbAuChannelOduActualFrequencyBand;
    }

    public void setRbAuChannelOduActualFrequencyBand(Integer rbAuChannelOduActualFrequencyBand) {
        this.rbAuChannelOduActualFrequencyBand = rbAuChannelOduActualFrequencyBand;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbSlotNumber=").append(this.rbSlotNumber).append(", ");
        result.append("rbAuChannelId=").append(this.rbAuChannelId).append(", ");
        result.append("rbAuChannelAssociatedRadioClusterId=").append(this.rbAuChannelAssociatedRadioClusterId).append(", ");
        result.append("rbAuChannelAssociatedOduId=").append(this.rbAuChannelAssociatedOduId).append(", ");
        result.append("rbAuChannelTxFrequency=").append(this.rbAuChannelTxFrequency).append(", ");
        result.append("rbAuChannelRxFrequency=").append(this.rbAuChannelRxFrequency).append(", ");
        result.append("rbAuChannelAdminStatus=").append(this.toStringRbAuChannelAdminStatus(this.rbAuChannelAdminStatus)).append(", ");
        result.append("rbAuChannelConfiguredTxFrequency=").append(this.rbAuChannelConfiguredTxFrequency).append(", ");
        result.append("rbAuChannelOduActualFrequencyBand=").append(this.rbAuChannelOduActualFrequencyBand).append(", ");
        result.append("]");
        return result.toString();
    }

    @Transient
    public String getRowKey() {
        return this.getRbSlotNumber() + "." + this.getRbAuChannelId();
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbAuChannelConfigEntry.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbAuChannelConfigEntry>(){

            public ManagedObjectAccessHandler<RbAuChannelConfigEntry> createHandler() {
                return new ConfigFileMOAccessHandler();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbAuChannelConfigEntry.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbAuChannelConfigEntry>(){

            public ManagedObjectAccessHandler<RbAuChannelConfigEntry> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbAuChannelConfigEntry.class);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigFileMOAccessHandler
    extends AbstractConfigFileMOAccessHandler<RbAuChannelConfigEntry, AuChannelDb_AuChannel> {
        private ConfigFileMOAccessHandler() {
        }

        @Override
        protected RbAuChannelConfigEntry createEntry() {
            return new RbAuChannelConfigEntry();
        }

        @Override
        protected Class<AuChannelDb_AuChannel> getDataObjectClass() {
            return AuChannelDb_AuChannel.class;
        }

        @Override
        protected void populateEntry(RbAuChannelConfigEntry entry, AuChannelDb_AuChannel dataObject) {
            entry.setRbAuChannelId(dataObject.getID());
            entry.setRbSlotNumber(ConfigFileUtil.configFileAUIDToRbSlotNumber(dataObject.getAUID()));
            entry.setRbAuChannelConfiguredTxFrequency(Double.toString((double)dataObject.getTxFrequency().longValue() / 1000.0));
            entry.setRbAuChannelAdminStatus(dataObject.getAdminStatus());
            entry.setRbAuChannelAssociatedOduId(dataObject.getAssociatedOdu());
        }
    }
}

