/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.mediation.MOAccessSession;
import com.bwanms.mediation.MediationException;
import com.bwanms.meta.mo.ConfigAttribute;
import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.model.Equipment;
import com.bwanms.rb.configfile.ConfigFileUtil;
import com.bwanms.rb.mo.configfile.AbstractConfigFileMOAccessHandler;
import com.bwanms.rb.mo.configfile.PhyMacAuDb_PhyMacAu;
import java.util.List;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@EmbeddableSuperclass
public class RbAuATPCParameters
extends ScalarMO {
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private Integer rbAuATPCSupport;
    private Integer rbAuOptimalRSSI;
    public static final int RbAuATPCSupportEnabled = 1;
    public static final int RbAuATPCSupportDisabled = 2;
    public static final int RbAuATPCSupportNotDefined = 3;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.4.1", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbAuATPCSupport() {
        return this.rbAuATPCSupport;
    }

    public void setRbAuATPCSupport(Integer rbAuATPCSupport) {
        this.rbAuATPCSupport = rbAuATPCSupport;
    }

    public String toStringRbAuATPCSupport(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "enabled(1)";
                break;
            }
            case 2: {
                result = "disabled(2)";
                break;
            }
            case 3: {
                result = "notDefined(3)";
                break;
            }
            case 0: {
                result = "NA(0)";
            }
            default: {
                result = "NA";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.7.2.4.2", type=2)
    @ConfigAttribute
    public Integer getRbAuOptimalRSSI() {
        return this.rbAuOptimalRSSI;
    }

    public void setRbAuOptimalRSSI(Integer rbAuOptimalRSSI) {
        this.rbAuOptimalRSSI = rbAuOptimalRSSI;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(((Object)((Object)this)).getClass().getName()).append('[');
        result.append("rbAuATPCSupport=").append(this.toStringRbAuATPCSupport(this.rbAuATPCSupport)).append(", ");
        result.append("rbAuOptimalRSSI=").append(this.rbAuOptimalRSSI).append(", ");
        result.append("]");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ConfigFileMOAccessHandler<E extends RbAuATPCParameters>
    extends AbstractConfigFileMOAccessHandler<E, PhyMacAuDb_PhyMacAu> {
        int auid = 0;

        protected ConfigFileMOAccessHandler() {
        }

        @Override
        public List<E> fetch(Equipment eq, MOAccessSession access, String networkResource, String instanceQuery) throws MediationException {
            this.auid = ConfigFileUtil.rbSlotNumberToConfigFileAuID(ConfigFileUtil.getSlotNumberFromNetworkResource(networkResource));
            return super.fetch(eq, access, networkResource, instanceQuery);
        }

        @Override
        protected Class<PhyMacAuDb_PhyMacAu> getDataObjectClass() {
            return PhyMacAuDb_PhyMacAu.class;
        }

        @Override
        protected void populateEntry(E entry, PhyMacAuDb_PhyMacAu dataObject) {
            if (dataObject.getAUID() == this.auid) {
                ((RbAuATPCParameters)((Object)entry)).setRbAuOptimalRSSI(dataObject.getAtpcOptimalRssi());
            }
        }
    }
}

