/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.mo;

import com.bwanms.meta.mo.StateAttribute;
import com.bwanms.meta.snmp.SNMPParameter;
import com.bwanms.mo.DefaultManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandler;
import com.bwanms.mo.ManagedObjectAccessHandlerFactory;
import com.bwanms.mo.ManagedObjectAccessHandlerRegistry;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.mo.snmp.ScalarMO;
import com.bwanms.protocols.snmp.SNMP;
import com.bwanms.rb.configfile.RbConfigFile;
import com.bwanms.rb.mo.configfile.NullConfigFileMOAccessHandler;
import javax.persistence.Entity;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class RbAcuConfigurationGroup
extends ScalarMO {
    private static final long serialVersionUID = -4596930688842418548L;
    private NetworkResourceConfiguration nrConfiguration;
    private long id;
    private Integer rbAcuOperStatus;
    private String rbAcuFaultStatus;
    private String rbAcuLedStatus;
    public static final int RbAcuFaultStatusOk = 1;
    public static final int RbAcuFaultStatusFailed = 2;
    public static final int RbAcuFaultStatusNotInstalled = 3;

    @Id(generate=GeneratorType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne
    @JoinColumn(name="nrConfigId")
    public NetworkResourceConfiguration getNRConfiguration() {
        return this.nrConfiguration;
    }

    public void setNRConfiguration(NetworkResourceConfiguration nrConfiguration) {
        this.nrConfiguration = nrConfiguration;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.6.1.0", type=2, readOnly=true)
    @StateAttribute
    public Integer getRbAcuOperStatus() {
        return this.rbAcuOperStatus;
    }

    public void setRbAcuOperStatus(Integer rbAcuOperStatus) {
        this.rbAcuOperStatus = rbAcuOperStatus;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.6.2.0", type=4, readOnly=true)
    @StateAttribute
    public String getRbAcuFaultStatus() {
        return this.rbAcuFaultStatus;
    }

    public void setRbAcuFaultStatus(String rbAcuFaultStatus) {
        this.rbAcuFaultStatus = rbAcuFaultStatus;
    }

    public String toStringRbAcuFaultStatus(Integer value) {
        String result = null;
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                result = "ok(1)";
                break;
            }
            case 2: {
                result = "failed(2)";
                break;
            }
            case 3: {
                result = "notInstalled(3)";
                break;
            }
            default: {
                result = "!!undefined(" + value + ")";
            }
        }
        return result;
    }

    @SNMPParameter(OID="1.3.6.1.4.1.12394.1.2.2.6.3.0", type=4, readOnly=true)
    @StateAttribute
    public String getRbAcuLedStatus() {
        return this.rbAcuLedStatus;
    }

    public void setRbAcuLedStatus(String rbAcuLedStatus) {
        this.rbAcuLedStatus = rbAcuLedStatus;
    }

    static {
        ManagedObjectAccessHandlerRegistry.registerHandler(RbAcuConfigurationGroup.class, RbConfigFile.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbAcuConfigurationGroup>(){

            public ManagedObjectAccessHandler<RbAcuConfigurationGroup> createHandler() {
                return new NullConfigFileMOAccessHandler<RbAcuConfigurationGroup>();
            }
        });
        ManagedObjectAccessHandlerRegistry.registerHandler(RbAcuConfigurationGroup.class, SNMP.class, (ManagedObjectAccessHandlerFactory)new ManagedObjectAccessHandlerFactory<RbAcuConfigurationGroup>(){

            public ManagedObjectAccessHandler<RbAcuConfigurationGroup> createHandler() {
                return new DefaultManagedObjectAccessHandler(RbAcuConfigurationGroup.class);
            }
        });
    }
}

