/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.legacy;

import com.bwanms.model.Equipment;
import com.bwanms.rb.model.RbAU;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbNPU;
import com.bwanms.rb.model.RbSU;
import com.bwanms.util.legacylancher.ILegacyEquipmentLauncherProperties;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbLegacyEquipmentLauncherProperties
implements ILegacyEquipmentLauncherProperties {
    public HashMap<String, Object> getEquipmentProperties(Equipment equipment) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        if (equipment.isReachable()) {
            String EUID = null;
            String name = null;
            String url = null;
            if (equipment instanceof RbBaseStationEquipment || equipment instanceof RbSU) {
                EUID = equipment.getEUID();
                name = equipment.getName();
            } else if (equipment instanceof RbAU) {
                RbAU au = (RbAU)equipment;
                RbBS bs = au.getManagerBS();
                if (bs != null && bs.isReachable()) {
                    EUID = bs.getEUID();
                    name = bs.getName();
                    url = "bwanms://config/" + EUID + "/AU." + au.getSlotNumber() + "/";
                }
                equipment = bs;
            } else if (equipment instanceof RbNPU) {
                RbNPU npu = (RbNPU)equipment;
                RbBS bs = npu.getManagerBS();
                if (bs != null && bs.isReachable()) {
                    EUID = bs.getEUID();
                    name = bs.getName();
                    url = "bwanms://config/" + EUID + "/NPU/";
                }
                equipment = bs;
            }
            propertiesMap.put("EUID", EUID);
            propertiesMap.put("name", name);
            propertiesMap.put("url", url);
            propertiesMap.put("equipment", equipment);
        }
        return propertiesMap;
    }
}

