/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.templates;

import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.Templates;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.model.Template;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbBSPFServersTable;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.services.RbBSPFServerValues;
import com.bwanms.rb.model.services.RbVoiceDomainGlobal;
import com.bwanms.rb.model.services.RbVoiceDomainGlobalTemplate;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.TemplateNameDialog;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.ServerValidationException;
import java.awt.Component;
import java.awt.Dialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoiceDomainTemplateManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(VoiceDomainTemplateManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbVoiceDomainGlobal.class);
    private static String[] columnNames = new String[]{"Name", "IPAddress", "UDPPort", "VlanId"};
    private String[] columnAttribNames = new String[]{"Name", "IPAddress", "", ""};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public VoiceDomainTemplateManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], this.columnAttribNames[0], i18n.translateString(columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], this.columnAttribNames[1], i18n.translateString(columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], this.columnAttribNames[2], i18n.translateString(columnNames[2]), (Comparator)new EntityManagerRowComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], this.columnAttribNames[3], i18n.translateString(columnNames[3]), (Comparator)new EntityManagerRowComparator(3)));
        this.entityRowProvider = new VoiceDomainTemplateRowCreator(VoiceDomainTemplateManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("IPAddress"), "rbBSPFServerValues.ipAddress", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("UDPPort"), "rbBSPFServerValues.portNumber", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("VlanId"), "rbBSPFServerValues.pfVlan", 1, 1, null, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new VoiceDomainTemplateManagerAction("Select", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new VoiceDomainTemplateManagerAction("Delete", 1));
        this.declaredActions.add(new VoiceDomainTemplateManagerAction("GetFromDevice", 1));
    }

    protected String getBaseName() {
        return RbVoiceDomainGlobalTemplate.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    public List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        ((VoiceDomainTemplateManagerAction)this.declaredActions.get(0)).setSelectorListener(selectorListener);
    }

    public String getTitle() {
        return i18n.translateString("VoiceDomain");
    }

    public String getHelpTopic() {
        return "ngnms.help.templates_services";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VoiceDomainTemplateRowCreator
    extends EntityManagerRowProviderBase {
        private static final long serialVersionUID = -8283697666542474126L;

        public VoiceDomainTemplateRowCreator(List<String> attributes) {
            super(attributes);
        }

        protected String readEntityId(Serializable entity) {
            return String.valueOf(((RbVoiceDomainGlobalTemplate)entity).getId());
        }

        protected List<Serializable> readAttributeValues(Serializable entity) {
            List ret = super.readAttributeValues(entity);
            ret.set(1, ((RbVoiceDomainGlobalTemplate)entity).getRbBSPFServerValues().getIpAddress());
            ret.set(2, ((RbVoiceDomainGlobalTemplate)entity).getRbBSPFServerValues().getPortNumber());
            ret.set(3, ((RbVoiceDomainGlobalTemplate)entity).getRbBSPFServerValues().getPfVlan());
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VoiceDomainTemplateManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public VoiceDomainTemplateManagerAction(String name, int category) {
            this(name, category, null);
        }

        public VoiceDomainTemplateManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
            this.name = name;
            this.category = category;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            if ("Select".equals(this.name) && 1 == selection.size() && this.selectorListener != null) {
                this.selectorListener.entitiesSelected(manager.getSelection());
                return;
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                boolean confirmed = false;
                confirmed = FrameUtil.showConfirmation((Component)manager.getUI());
                if (!confirmed) return;
                for (Serializable entityRow : selection) {
                    try {
                        RbVoiceDomainGlobalTemplate template = (RbVoiceDomainGlobalTemplate)entityRow;
                        ServiceRegistry.getEntityManagerService().delete((Serializable)template);
                        Templates.updateListForClass(RbVoiceDomainGlobalTemplate.class);
                        if (!(manager instanceof EntityChangeListener)) continue;
                        EntityChangeListener listener = (EntityChangeListener)manager;
                        listener.entityRemoved(entityRow);
                    }
                    catch (ServiceException e) {
                        log.error((Object)"Failed to delete voice domain template.", (Throwable)e);
                    }
                }
                return;
            } else {
                if (!"GetFromDevice".equals(this.name)) return;
                SelectorView selectorView = Selectors.getSelectorView(RbVoiceDomainsEntry.class, null);
                SelectorUtil.display2ModalSelector((JComponent)manager.getUI(), (SelectorView)selectorView);
                List selectedList = selectorView.getSelection();
                if (selectedList.isEmpty()) return;
                RbVoiceDomainsEntry selected = (RbVoiceDomainsEntry)((Object)selectedList.get(0));
                RbVoiceDomainGlobalTemplate template = this.createTemplate(selected);
                if (this.checkForMatchingTemplate(template)) {
                    TemplateNameDialog dialog = new TemplateNameDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(manager.getUI())));
                    dialog.setModal(true);
                    dialog.setLocationRelativeTo((Component)dialog.getParent());
                    dialog.setTemplate((Template)template);
                    dialog.pack();
                    dialog.setSize(300, 140);
                    dialog.setVisible(true);
                    template = (RbVoiceDomainGlobalTemplate)dialog.getTemplate();
                    if (dialog.getCancelPressed() || !(manager instanceof EntityChangeListener)) return;
                    EntityChangeListener listener = (EntityChangeListener)manager;
                    listener.entityAdded((Serializable)template);
                    return;
                } else {
                    try {
                        template = (RbVoiceDomainGlobalTemplate)ServiceRegistry.getTemplateManagerService().saveTemplate((Template)template);
                        Templates.updateListForClass(RbVoiceDomainGlobalTemplate.class);
                        if (!(manager instanceof EntityChangeListener)) return;
                        EntityChangeListener listener = (EntityChangeListener)manager;
                        listener.entityAdded((Serializable)template);
                        return;
                    }
                    catch (ServerValidationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public boolean checkForMatchingTemplate(RbVoiceDomainGlobalTemplate templateVoiceDomain) {
            boolean match = false;
            for (Template template : Templates.getTemplates(RbVoiceDomainGlobalTemplate.class)) {
                RbVoiceDomainGlobalTemplate vdTemplate = (RbVoiceDomainGlobalTemplate)template;
                if (!vdTemplate.getName().equals(templateVoiceDomain.getName())) continue;
                match = true;
                break;
            }
            return match;
        }

        private RbVoiceDomainGlobalTemplate createTemplate(RbVoiceDomainsEntry selected) {
            RbVoiceDomainGlobalTemplate template = new RbVoiceDomainGlobalTemplate();
            template.setName(selected.getRbVoiceDomainName());
            ArrayList<Class<RbBSPFServersTable>> moClasses = new ArrayList<Class<RbBSPFServersTable>>();
            ArrayList results = new ArrayList();
            try {
                moClasses.add(RbBSPFServersTable.class);
                results.addAll(ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(selected.getNRConfiguration().getManagedEquipment().getId(), selected.getNRConfiguration().getName(), moClasses, false));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!results.isEmpty()) {
                RbBSPFServersTable pfServerTable = (RbBSPFServersTable)((Object)results.get(0));
                RbBSPFServersEntry pfServerEntry = this.findPFServerSEntry(selected.getRbVoiceDomainPrimaryPFIpAddress(), pfServerTable);
                RbBSPFServerValues pfServerValues = new RbBSPFServerValues();
                pfServerValues.setIpAddress(pfServerEntry.getRbBSPFServerAddress());
                pfServerValues.setPortNumber(pfServerEntry.getRbBSPFServerPortNumber());
                pfServerValues.setPfVlan(pfServerEntry.getRbBSPFServerPFVlan());
                pfServerValues.setSharedSecret(pfServerEntry.getRbBSPFServerSharedString());
                template.setRbBSPFServerValues(pfServerValues);
            }
            return template;
        }

        private RbBSPFServersEntry findPFServerSEntry(String ipAddress, RbBSPFServersTable table) {
            if (ipAddress != null) {
                for (RbBSPFServersEntry entry : table.getEntries()) {
                    if (!entry.getRbBSPFServerAddress().equals(ipAddress)) continue;
                    return entry;
                }
            }
            return null;
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Open") || this.name.equals("Select")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("Delete")) {
                return 0 < selectionSize;
            }
            return true;
        }

        public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
        }
    }
}

