/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.templates;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryFilter;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.gui.manager.generic.EntityQueryStrategyBase;
import com.bwanms.gui.manager.generic.SimpleEntityQueryStrategy;
import com.bwanms.persistence.Datastore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Query;

public class ServiceGroupQueryStrategy
extends EntityQueryStrategyBase {
    private static Logger logger = Logger.getLogger(SimpleEntityQueryStrategy.class);
    private String queryString;
    private int pageSize;

    public EntityQueryResults performQuery(EntityQueryFilter filter, EntityQuerySort sort, int pageSize, int pageNumber) {
        this.pageSize = pageSize;
        this.queryString = filter.getFilterQueryString();
        boolean addWhereClause = !this.queryString.contains(" where ");
        this.queryString = addWhereClause ? this.queryString + " where rbServiceGroupIndex <= 10 " : this.queryString + " and rbServiceGroupIndex <= 10 ";
        if (sort != null) {
            this.queryString = this.queryString + " " + sort.getSortQueryString();
        }
        this.rowCreator = filter.getEntityRowCreator();
        logger.debug((Object)("---- queryString: " + this.queryString));
        return this.getPage(pageNumber);
    }

    public EntityQueryResults getPage(int pageNumber) {
        try {
            ArrayList<EntityManagerRow> page = new ArrayList<EntityManagerRow>(this.pageSize);
            Query query = Datastore.session().createQuery(this.queryString);
            List results = query.list();
            for (int idx = pageNumber * this.pageSize; page.size() < this.pageSize && idx < results.size(); ++idx) {
                Serializable nextObj = (Serializable)results.get(idx);
                page.add(this.rowCreator.createRow(nextObj));
            }
            logger.debug((Object)("  ---- resultsCount: " + results.size() + "  pageResultsCount: " + page.size()));
            return new EntityQueryResults(results.size(), this.pageSize, pageNumber, page);
        }
        catch (HibernateException he) {
            logger.error((Object)he.getMessage(), (Throwable)he);
            return null;
        }
    }

    public void closeQuery() {
    }
}

