/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.templates;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.Templates;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.model.Template;
import com.bwanms.rb.gui.templates.QoSProfileTemplateEditorContainer;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbQoSProfileTemplate;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.TemplateNameDialog;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.awt.Component;
import java.awt.Dialog;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QoSProfileTemplateManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(QoSProfileTemplateManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbQoSProfile.class);
    private String[] columnNames = new String[]{"Name", "Type", "CIR/PS", "MIR/SI", "CT"};
    private String[] columnAttribNames = new String[]{"Name", "Type", "Param1", "Param2", "ParamTime"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public QoSProfileTemplateManagerConfig() {
        this.columns.add(new EntityManagerColumn(this.columnNames[0], this.columnAttribNames[0], i18n.translateString(this.columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(this.columnNames[1], this.columnAttribNames[1], i18n.translateString(this.columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(this.columnNames[2], this.columnAttribNames[2], i18n.translateString(this.columnNames[2]), (Comparator)new EntityManagerRowComparator(2)));
        this.columns.add(new EntityManagerColumn(this.columnNames[3], this.columnAttribNames[3], i18n.translateString(this.columnNames[3]), (Comparator)new EntityManagerRowComparator(3)));
        this.columns.add(new EntityManagerColumn(this.columnNames[4], this.columnAttribNames[4], i18n.translateString(this.columnNames[4]), (Comparator)new EntityManagerRowComparator(4)));
        this.entityRowProvider = new QoSProfileTemplateRowCreator(QoSProfileTemplateManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.newFilters();
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new QoSProfileTemplateManagerAction("New", 1));
        this.defaultAction = new QoSProfileTemplateManagerAction("Open", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new QoSProfileTemplateManagerAction("Delete", 1));
        this.declaredActions.add(new QoSProfileTemplateManagerAction("GetFromDevice", 1));
    }

    private void newFilters() {
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)0, i18n.translateString(RbQoSProfile.toStringType(0))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbQoSProfile.toStringType(1))));
        items.add(new ComboItem((Object)2, i18n.translateString(RbQoSProfile.toStringType(2))));
        items.add(new ComboItem((Object)3, i18n.translateString(RbQoSProfile.toStringType(3))));
        EntityManagerFilterCriteria type = new EntityManagerFilterCriteria(i18n.translateString("Type"), "type", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)type);
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("CIR/PS"), "param1", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("MIR/SI"), "param2", 1, 1, null, false));
        items = new Vector();
        items.add(new ComboItem((Object)0, i18n.translateString("None")));
        items.add(new ComboItem((Object)1, i18n.translateString(RbQoSProfile.toStringParamTime(1))));
        items.add(new ComboItem((Object)2, i18n.translateString(RbQoSProfile.toStringParamTime(2))));
        items.add(new ComboItem((Object)3, i18n.translateString(RbQoSProfile.toStringParamTime(3))));
        EntityManagerFilterCriteria ct = new EntityManagerFilterCriteria(i18n.translateString("CT"), "paramTime", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)ct);
    }

    protected String getBaseName() {
        return RbQoSProfileTemplate.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        this.defaultAction = new QoSProfileTemplateManagerAction("Select", 1, selectorListener);
        this.declaredActions.set(1, this.defaultAction);
        if (this.declaredActions.size() > 2) {
            this.declaredActions.remove(0);
        }
    }

    public String getTitle() {
        return i18n.translateString("QoSProfileTemplate");
    }

    public String getHelpTopic() {
        return "ngnms.help.templates_services";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QoSProfileTemplateRowCreator
    extends EntityManagerRowProviderBase {
        private static final long serialVersionUID = -2121719171917076869L;

        public QoSProfileTemplateRowCreator(List<String> attributes) {
            super(attributes);
        }

        protected String readEntityId(Serializable entity) {
            return String.valueOf(((RbQoSProfileTemplate)entity).getId());
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List ret = super.getDisplayValues(entityRow);
            ret.set(1, i18n.translateString(RbQoSProfile.toStringType(Integer.parseInt((String)ret.get(1)))));
            if (!((RbQoSProfileTemplate)entityRow.getEntity()).getType().equals(0)) {
                ret.set(4, i18n.translateString(RbQoSProfile.toStringParamTime(Integer.parseInt((String)ret.get(4)))));
            } else {
                ret.set(4, "");
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QoSProfileTemplateManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public QoSProfileTemplateManagerAction(String name, int category) {
            this(name, category, null);
        }

        public QoSProfileTemplateManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
            this.name = name;
            this.category = category;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            if ("New".equals(this.name)) {
                try {
                    new QoSProfileTemplateEditorContainer(new RbQoSProfileTemplate());
                    return;
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow((Component)manager.getUI(), ex.getMessage());
                }
                return;
            } else if ("Open".equals(this.name) && 1 == selection.size()) {
                RbQoSProfileTemplate qosTemplate = (RbQoSProfileTemplate)selection.get(0);
                try {
                    new QoSProfileTemplateEditorContainer(qosTemplate);
                    return;
                }
                catch (ServiceException ex) {
                    MessageBox.Error.quickShow((Component)manager.getUI(), ex.getMessage());
                }
                return;
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                boolean confirmed = false;
                confirmed = FrameUtil.showConfirmation((Component)manager.getUI());
                if (!confirmed) return;
                for (Serializable entityRow : selection) {
                    try {
                        RbQoSProfileTemplate template = (RbQoSProfileTemplate)entityRow;
                        ServiceRegistry.getEntityManagerService().delete((Serializable)template);
                        Templates.updateListForClass(RbQoSProfileTemplate.class);
                        if (!(manager instanceof EntityChangeListener)) continue;
                        EntityChangeListener listener = (EntityChangeListener)manager;
                        listener.entityRemoved(entityRow);
                    }
                    catch (ServiceException e) {
                        log.error((Object)"Failed to delete QoS profile template.", (Throwable)e);
                    }
                }
                return;
            } else if ("Select".equals(this.name) && 1 == selection.size()) {
                this.selectorListener.entitiesSelected(manager.getSelection());
                return;
            } else {
                if (!"GetFromDevice".equals(this.name)) return;
                SelectorView selectorView = Selectors.getSelectorView(RbQoSProfileConfigEntry.class, null);
                SelectorUtil.display2ModalSelector((JComponent)manager.getUI(), (SelectorView)selectorView);
                List selectedList = selectorView.getSelection();
                if (selectedList.isEmpty()) return;
                RbQoSProfileConfigEntry selected = (RbQoSProfileConfigEntry)((Object)selectedList.get(0));
                RbQoSProfileTemplate template = new RbQoSProfileTemplate();
                template.setName(selected.getRbQoSProfileName());
                template.setType(selected.getRbQoSProfileType());
                template.setParam1(selected.getRbQoSProfileParam1());
                template.setParam2(selected.getRbQoSProfileParam2());
                template.setParamTime(selected.getRbQoSProfileParamTime());
                if (this.checkForMatchingTemplate(template)) {
                    TemplateNameDialog dialog = new TemplateNameDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(manager.getUI())));
                    dialog.setModal(true);
                    dialog.setLocationRelativeTo((Component)dialog.getParent());
                    dialog.setTemplate((Template)template);
                    dialog.pack();
                    dialog.setSize(300, 140);
                    dialog.setVisible(true);
                    template = (RbQoSProfileTemplate)dialog.getTemplate();
                    if (dialog.getCancelPressed() || !(manager instanceof EntityChangeListener)) return;
                    EntityChangeListener listener = (EntityChangeListener)manager;
                    listener.entityAdded((Serializable)template);
                    return;
                } else {
                    try {
                        template = (RbQoSProfileTemplate)ServiceRegistry.getTemplateManagerService().saveTemplate((Template)template);
                        Templates.updateListForClass(RbQoSProfileTemplate.class);
                        if (!(manager instanceof EntityChangeListener)) return;
                        EntityChangeListener listener = (EntityChangeListener)manager;
                        listener.entityAdded((Serializable)template);
                        return;
                    }
                    catch (ServerValidationException ex) {
                        // empty catch block
                    }
                }
            }
        }

        public boolean checkForMatchingTemplate(RbQoSProfileTemplate templateQos) {
            boolean match = false;
            for (Template template : Templates.getTemplates(RbQoSProfileTemplate.class)) {
                RbQoSProfileTemplate frTemplate = (RbQoSProfileTemplate)template;
                if (!frTemplate.getName().equals(templateQos.getName())) continue;
                match = true;
                break;
            }
            return match;
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Open") || this.name.equals("Select")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("Delete")) {
                return 0 < selectionSize;
            }
            return true;
        }
    }
}

