/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.templates;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.Templates;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.model.Template;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigTable;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbPolicyRuleTemplate;
import com.bwanms.rb.model.services.RbQoSProfileValues;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.TemplateNameDialog;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.ServerValidationException;
import java.awt.Component;
import java.awt.Dialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyRuleTemplateManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(PolicyRuleTemplateManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbPolicyRule.class);
    private String[] columnNames = new String[]{"Name", "Type", "DownQoSUpperLimit", "DownQoSUpperLimit", "DownQoSUpperLimit", "DownQoSUpperLimit", "UpQoSUpperLimit", "UpQoSUpperLimit", "UpQoSUpperLimit", "UpQoSUpperLimit"};
    private String[] columnAttribNames = new String[]{"Name", "PriorityType", "DownQoSUpperLimit1", "DownQoSUpperLimit2", "DownQoSUpperLimit3", "DownQoSUpperLimit4", "UpQoSUpperLimit1", "UpQoSUpperLimit2", "UpQoSUpperLimit3", "UpQoSUpperLimit4"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public PolicyRuleTemplateManagerConfig() {
        int i;
        this.columns.add(new EntityManagerColumn(this.columnNames[0], this.columnAttribNames[0], i18n.translateString(this.columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(this.columnNames[1], this.columnAttribNames[1], i18n.translateString(this.columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        for (i = 2; i < 6; ++i) {
            this.columns.add(new EntityManagerColumn(this.columnNames[i], this.columnAttribNames[i], i18n.translateString(this.columnNames[i], new Object[]{String.valueOf(i - 1)}), (Comparator)new EntityManagerRowComparator(i)));
        }
        for (i = 6; i < 10; ++i) {
            this.columns.add(new EntityManagerColumn(this.columnNames[i], this.columnAttribNames[i], i18n.translateString(this.columnNames[i], new Object[]{String.valueOf(i - 5)}), (Comparator)new EntityManagerRowComparator(i)));
        }
        this.entityRowProvider = new PolicyRuleTemplateRowCreator(PolicyRuleTemplateManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.setTypeFilterCriteria();
        this.newFilters();
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new PolicyRuleTemplateManagerAction("Select", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new PolicyRuleTemplateManagerAction("Delete", 1));
        this.declaredActions.add(new PolicyRuleTemplateManagerAction("GetFromDevice", 1));
    }

    private void newFilters() {
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("DownQoSUpper1"), "downQoSUpperLimit1", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("DownQoSUpper2"), "downQoSUpperLimit2", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("DownQoSUpper3"), "downQoSUpperLimit3", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("DownQoSUpper4"), "downQoSUpperLimit4", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("UpQoSUpper1"), "upQoSUpperLimit1", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("UpQoSUpper2"), "upQoSUpperLimit2", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("UpQoSUpper3"), "upQoSUpperLimit3", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("UpQoSUpper4"), "upQoSUpperLimit4", 1, 1, null, false));
    }

    private void setTypeFilterCriteria() {
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)1, i18n.translateString(RbPolicyRule.toStringPriorityType(1))));
        items.add(new ComboItem((Object)2, i18n.translateString(RbPolicyRule.toStringPriorityType(2))));
        EntityManagerFilterCriteria newTypeCriteria = new EntityManagerFilterCriteria(i18n.translateString("Type"), "priorityType", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)newTypeCriteria);
    }

    protected String getBaseName() {
        return RbPolicyRuleTemplate.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        ((PolicyRuleTemplateManagerAction)this.declaredActions.get(0)).setSelectorListener(selectorListener);
    }

    public String getTitle() {
        return i18n.translateString("PolicyRule");
    }

    public String getHelpTopic() {
        return "ngnms.help.templates_services";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PolicyRuleTemplateRowCreator
    extends EntityManagerRowProviderBase {
        private static final long serialVersionUID = 6472456354741067692L;

        public PolicyRuleTemplateRowCreator(List<String> attributes) {
            super(attributes);
        }

        protected String readEntityId(Serializable entity) {
            return String.valueOf(((RbPolicyRuleTemplate)entity).getId());
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List ret = super.getDisplayValues(entityRow);
            ret.set(1, i18n.translateString(RbPolicyRule.toStringPriorityType(Integer.parseInt((String)ret.get(1)))));
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PolicyRuleTemplateManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public PolicyRuleTemplateManagerAction(String name, int category) {
            this(name, category, null);
        }

        public PolicyRuleTemplateManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
            this.name = name;
            this.category = category;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            if ("Select".equals(this.name) && 1 == selection.size() && this.selectorListener != null) {
                this.selectorListener.entitiesSelected(manager.getSelection());
                return;
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                boolean confirmed = false;
                confirmed = FrameUtil.showConfirmation((Component)manager.getUI());
                if (!confirmed) return;
                for (Serializable entityRow : selection) {
                    try {
                        RbPolicyRuleTemplate template = (RbPolicyRuleTemplate)entityRow;
                        ServiceRegistry.getEntityManagerService().delete((Serializable)template);
                        Templates.updateListForClass(RbPolicyRuleTemplate.class);
                        if (!(manager instanceof EntityChangeListener)) continue;
                        EntityChangeListener listener = (EntityChangeListener)manager;
                        listener.entityRemoved(entityRow);
                    }
                    catch (ServiceException e) {
                        log.error((Object)"Failed to delete policy rule template.", (Throwable)e);
                    }
                }
                return;
            } else {
                if (!"GetFromDevice".equals(this.name)) return;
                SelectorView selectorView = Selectors.getSelectorView(RbPolicyRuleConfigEntry.class, null);
                SelectorUtil.display2ModalSelector((JComponent)manager.getUI(), (SelectorView)selectorView);
                List selectedList = selectorView.getSelection();
                if (selectedList.isEmpty()) return;
                RbPolicyRuleConfigEntry selected = (RbPolicyRuleConfigEntry)((Object)selectedList.get(0));
                RbPolicyRuleTemplate template = this.createTemplate(selected);
                if (this.checkForMatchingTemplate(template)) {
                    TemplateNameDialog dialog = new TemplateNameDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(manager.getUI())));
                    dialog.setModal(true);
                    dialog.setLocationRelativeTo((Component)dialog.getParent());
                    dialog.setTemplate((Template)template);
                    dialog.pack();
                    dialog.setSize(300, 140);
                    dialog.setVisible(true);
                    template = (RbPolicyRuleTemplate)dialog.getTemplate();
                    if (dialog.getCancelPressed() || !(manager instanceof EntityChangeListener)) return;
                    EntityChangeListener listener = (EntityChangeListener)manager;
                    listener.entityAdded((Serializable)template);
                    return;
                } else {
                    try {
                        template = (RbPolicyRuleTemplate)ServiceRegistry.getTemplateManagerService().saveTemplate((Template)template);
                        Templates.updateListForClass(RbPolicyRuleTemplate.class);
                        if (!(manager instanceof EntityChangeListener)) return;
                        EntityChangeListener listener = (EntityChangeListener)manager;
                        listener.entityAdded((Serializable)template);
                        return;
                    }
                    catch (ServerValidationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public boolean checkForMatchingTemplate(RbPolicyRuleTemplate templatePolicy) {
            boolean match = false;
            for (Template template : Templates.getTemplates(RbPolicyRuleTemplate.class)) {
                RbPolicyRuleTemplate frTemplate = (RbPolicyRuleTemplate)template;
                if (!frTemplate.getName().equals(templatePolicy.getName())) continue;
                match = true;
                break;
            }
            return match;
        }

        private RbPolicyRuleTemplate createTemplate(RbPolicyRuleConfigEntry selected) {
            RbPolicyRuleTemplate template = new RbPolicyRuleTemplate();
            template.setName(selected.getRbPolicyRuleName());
            template.setPriorityType(selected.getRbPolicyRulePriorityType());
            template.setDownQoSUpperLimit1(selected.getRbPolicyRuleDownQoSUpperLimit1());
            template.setDownQoSUpperLimit2(selected.getRbPolicyRuleDownQoSUpperLimit2());
            template.setDownQoSUpperLimit3(selected.getRbPolicyRuleDownQoSUpperLimit3());
            template.setDownQoSUpperLimit4(selected.getRbPolicyRuleDownQoSUpperLimit4());
            template.setUpQoSUpperLimit1(selected.getRbPolicyRuleUpQoSUpperLimit1());
            template.setUpQoSUpperLimit2(selected.getRbPolicyRuleUpQoSUpperLimit2());
            template.setUpQoSUpperLimit3(selected.getRbPolicyRuleUpQoSUpperLimit3());
            template.setUpQoSUpperLimit4(selected.getRbPolicyRuleUpQoSUpperLimit4());
            ArrayList<Class<RbQoSProfileConfigTable>> moClasses = new ArrayList<Class<RbQoSProfileConfigTable>>();
            ArrayList results = new ArrayList();
            try {
                moClasses.add(RbQoSProfileConfigTable.class);
                results.addAll(ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(selected.getNRConfiguration().getManagedEquipment().getId(), selected.getNRConfiguration().getName(), moClasses, false));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            RbQoSProfileConfigTable qosTable = (RbQoSProfileConfigTable)((Object)results.get(0));
            RbQoSProfileConfigEntry qosDownEntry1 = this.findQoSEntry(selected.getRbPolicyRuleDownQoSProfileIdx1(), qosTable);
            RbQoSProfileConfigEntry qosDownEntry2 = this.findQoSEntry(selected.getRbPolicyRuleDownQoSProfileIdx2(), qosTable);
            RbQoSProfileConfigEntry qosDownEntry3 = this.findQoSEntry(selected.getRbPolicyRuleDownQoSProfileIdx3(), qosTable);
            RbQoSProfileConfigEntry qosDownEntry4 = this.findQoSEntry(selected.getRbPolicyRuleDownQoSProfileIdx4(), qosTable);
            if (qosDownEntry1 != null) {
                template.setDownQoSProfile1(this.fillQos(qosDownEntry1));
            }
            if (qosDownEntry2 != null) {
                template.setDownQoSProfile2(this.fillQos(qosDownEntry2));
            }
            if (qosDownEntry3 != null) {
                template.setDownQoSProfile3(this.fillQos(qosDownEntry3));
            }
            if (qosDownEntry4 != null) {
                template.setDownQoSProfile4(this.fillQos(qosDownEntry4));
            }
            RbQoSProfileConfigEntry qosUpEntry1 = this.findQoSEntry(selected.getRbPolicyRuleUpQoSProfileIdx1(), qosTable);
            RbQoSProfileConfigEntry qosUpEntry2 = this.findQoSEntry(selected.getRbPolicyRuleUpQoSProfileIdx2(), qosTable);
            RbQoSProfileConfigEntry qosUpEntry3 = this.findQoSEntry(selected.getRbPolicyRuleUpQoSProfileIdx3(), qosTable);
            RbQoSProfileConfigEntry qosUpEntry4 = this.findQoSEntry(selected.getRbPolicyRuleUpQoSProfileIdx4(), qosTable);
            if (qosUpEntry1 != null) {
                template.setUpQoSProfile1(this.fillQos(qosUpEntry1));
            }
            if (qosUpEntry2 != null) {
                template.setUpQoSProfile2(this.fillQos(qosUpEntry2));
            }
            if (qosUpEntry3 != null) {
                template.setUpQoSProfile3(this.fillQos(qosUpEntry3));
            }
            if (qosUpEntry4 != null) {
                template.setUpQoSProfile4(this.fillQos(qosUpEntry4));
            }
            return template;
        }

        private RbQoSProfileValues fillQos(RbQoSProfileConfigEntry qosEntry) {
            RbQoSProfileValues qosValues = new RbQoSProfileValues();
            qosValues.setName(qosEntry.getRbQoSProfileName());
            qosValues.setParam1(qosEntry.getRbQoSProfileParam1());
            qosValues.setParam2(qosEntry.getRbQoSProfileParam2());
            qosValues.setParamTime(qosEntry.getRbQoSProfileParamTime());
            qosValues.setType(qosEntry.getRbQoSProfileType());
            return qosValues;
        }

        private RbQoSProfileConfigEntry findQoSEntry(Long idx, RbQoSProfileConfigTable table) {
            if (idx != null) {
                for (RbQoSProfileConfigEntry entry : table.getEntries()) {
                    if (!entry.getRbQoSProfileIdx().equals(idx)) continue;
                    return entry;
                }
            }
            return null;
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Open") || this.name.equals("Select")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("Delete")) {
                return 0 < selectionSize;
            }
            return true;
        }

        public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
        }
    }
}

