/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.templates;

import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.Templates;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.model.Template;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.RbBSPFServersTable;
import com.bwanms.rb.model.services.RbBSPFServerGlobal;
import com.bwanms.rb.model.services.RbBSPFServerGlobalTemplate;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.TemplateNameDialog;
import com.bwanms.util.FrameUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PFServerTemplateManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(PFServerTemplateManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbBSPFServerGlobal.class);
    private static String[] columnNames = new String[]{"Name", "IPAddress", "UDPPort", "VlanId"};
    private String[] columnAttribNames = new String[]{"name", "ipAddress", "portNumber", "pfVlan"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public PFServerTemplateManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], this.columnAttribNames[0], i18n.translateString(columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], this.columnAttribNames[1], i18n.translateString(columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], this.columnAttribNames[2], i18n.translateString(columnNames[2]), (Comparator)new EntityManagerRowComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], this.columnAttribNames[3], i18n.translateString(columnNames[3]), (Comparator)new EntityManagerRowComparator(3)));
        this.entityRowProvider = new VoiceDomainTemplateRowCreator(PFServerTemplateManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("IPAddress"), "ipAddress", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("UDPPort"), "portNumber", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("VlanId"), "pfVlan", 1, 1, null, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new PFServerTemplateManagerAction("Select", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new PFServerTemplateManagerAction("Delete", 1));
        this.declaredActions.add(new PFServerTemplateManagerAction("GetFromDevice", 1));
    }

    protected String getBaseName() {
        return RbBSPFServerGlobalTemplate.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        ((PFServerTemplateManagerAction)this.declaredActions.get(0)).setSelectorListener(selectorListener);
    }

    public String getTitle() {
        return i18n.translateString("PFServer");
    }

    public String getHelpTopic() {
        return "ngnms.help.templates_services";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VoiceDomainTemplateRowCreator
    extends EntityManagerRowProviderBase {
        private static final long serialVersionUID = -8283697666542474126L;

        public VoiceDomainTemplateRowCreator(List<String> attributes) {
            super(attributes);
        }

        protected String readEntityId(Serializable entity) {
            return String.valueOf(((RbBSPFServerGlobalTemplate)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PFServerTemplateManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public PFServerTemplateManagerAction(String name, int category) {
            this(name, category, null);
        }

        public PFServerTemplateManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
            this.name = name;
            this.category = category;
        }

        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            if ("Select".equals(this.name) && 1 == selection.size() && this.selectorListener != null) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                boolean confirmed = false;
                confirmed = FrameUtil.showConfirmation((Component)manager.getUI());
                if (confirmed) {
                    for (Serializable entityRow : selection) {
                        try {
                            RbBSPFServerGlobalTemplate template = (RbBSPFServerGlobalTemplate)entityRow;
                            ServiceRegistry.getEntityManagerService().delete((Serializable)template);
                            Templates.updateListForClass(RbBSPFServerGlobalTemplate.class);
                            if (!(manager instanceof EntityChangeListener)) continue;
                            EntityChangeListener listener = (EntityChangeListener)manager;
                            listener.entityRemoved(entityRow);
                        }
                        catch (ServiceException e) {
                            log.error((Object)"Failed to delete voice domain template.", (Throwable)e);
                        }
                    }
                }
            } else if ("GetFromDevice".equals(this.name)) {
                SelectorView selectorView = Selectors.getSelectorView(RbBSPFServersEntry.class, null);
                SelectorUtil.display2ModalSelector((JComponent)manager.getUI(), (SelectorView)selectorView);
                List selectedList = selectorView.getSelection();
                if (!selectedList.isEmpty()) {
                    RbBSPFServersEntry selected = (RbBSPFServersEntry)((Object)selectedList.get(0));
                    RbBSPFServerGlobalTemplate template = this.createTemplate(selected);
                    TemplateNameDialog dialog = new TemplateNameDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(manager.getUI())));
                    dialog.setModal(true);
                    dialog.setLocationRelativeTo((Component)dialog.getParent());
                    dialog.setTemplate((Template)template);
                    dialog.pack();
                    dialog.setSize(300, 140);
                    dialog.setVisible(true);
                    template = (RbBSPFServerGlobalTemplate)dialog.getTemplate();
                    if (!dialog.getCancelPressed() && manager instanceof EntityChangeListener) {
                        EntityChangeListener listener = (EntityChangeListener)manager;
                        listener.entityAdded((Serializable)template);
                    }
                }
            }
        }

        private RbBSPFServerGlobalTemplate createTemplate(RbBSPFServersEntry selected) {
            RbBSPFServerGlobalTemplate template = new RbBSPFServerGlobalTemplate();
            template.setIpAddress(selected.getRbBSPFServerAddress());
            template.setPortNumber(selected.getRbBSPFServerPortNumber());
            template.setPfVlan(selected.getRbBSPFServerPFVlan());
            template.setSharedString(selected.getRbBSPFServerSharedString());
            return template;
        }

        private RbBSPFServersEntry findPFServerSEntry(String ipAddress, RbBSPFServersTable table) {
            if (ipAddress != null) {
                for (RbBSPFServersEntry entry : table.getEntries()) {
                    if (!entry.getRbBSPFServerAddress().equals(ipAddress)) continue;
                    return entry;
                }
            }
            return null;
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Open") || this.name.equals("Select")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("Delete")) {
                return 0 < selectionSize;
            }
            return true;
        }

        public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
        }
    }
}

