/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.templates;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.Templates;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.model.Template;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigTable;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbForwardingRuleTemplate;
import com.bwanms.rb.model.services.RbQoSProfileValues;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.TemplateNameDialog;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.ServerValidationException;
import java.awt.Component;
import java.awt.Dialog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardingRuleTemplateManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(ForwardingRuleTemplateManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbForwardingRule.class);
    private static String[] columnNames = new String[]{"Name", "Type", "UnicastRelaying", "MulticastRelaying", "UnknownAddressForwardingPolicy", "MulticastVLAN", "QosProfileName"};
    private static String[] columnAttribNames = new String[]{"Name", "type", "UnicastRelaying", "MulticastRelaying", "UnknownAddrPolicy", "MulticastVLAN", ""};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public ForwardingRuleTemplateManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], columnAttribNames[2], i18n.translateString(columnNames[2]), (Comparator)new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], columnAttribNames[3], i18n.translateString(columnNames[3]), (Comparator)new EntityManagerRowDisplayComparator(3)));
        this.columns.add(new EntityManagerColumn(columnNames[4], columnAttribNames[4], i18n.translateString(columnNames[4]), (Comparator)new EntityManagerRowDisplayComparator(4)));
        this.columns.add(new EntityManagerColumn(columnNames[5], columnAttribNames[5], i18n.translateString(columnNames[5]), (Comparator)new EntityManagerRowComparator(5)));
        this.columns.add(new EntityManagerColumn(columnNames[6], columnAttribNames[6], i18n.translateString(columnNames[6]), (Comparator)new EntityManagerRowDisplayComparator(6)));
        this.entityRowProvider = new ForwardingRuleTemplateRowCreator(ForwardingRuleTemplateManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Name"), "name", 1, 1, null, false));
        this.setTypeFilterCriteria();
        this.newFilters();
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new ForwardingRuleTemplateManagerAction("Select", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new ForwardingRuleTemplateManagerAction("Delete", 1));
        this.declaredActions.add(new ForwardingRuleTemplateManagerAction("GetFromDevice", 1));
    }

    private void newFilters() {
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)2, i18n.translateString(RbForwardingRule.toStringUnicastRelaying(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbForwardingRule.toStringUnicastRelaying(1))));
        EntityManagerFilterCriteria unicastRelayingCriteria = new EntityManagerFilterCriteria(i18n.translateString("UnicastRelaying"), "unicastRelaying", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)unicastRelayingCriteria);
        items = new Vector();
        items.add(new ComboItem((Object)2, i18n.translateString(RbForwardingRule.toStringMulticastRelaying(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbForwardingRule.toStringMulticastRelaying(1))));
        EntityManagerFilterCriteria multicastRelayingCriteria = new EntityManagerFilterCriteria(i18n.translateString("MulticastRelaying"), "multicastRelaying", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)multicastRelayingCriteria);
        items = new Vector();
        items.add(new ComboItem((Object)2, i18n.translateString(RbForwardingRule.toStringUnknownAddrPolicy(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbForwardingRule.toStringUnknownAddrPolicy(1))));
        EntityManagerFilterCriteria unknownForwardingPolicy = new EntityManagerFilterCriteria(i18n.translateString("UnknownAddressForwardingPolicy"), "unknownAddrPolicy", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)unknownForwardingPolicy);
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("MulticastVLAN"), "multicastVLAN", 1, 1, null, false));
    }

    private void setTypeFilterCriteria() {
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)1, i18n.translateString(RbForwardingRule.toStringType(1))));
        items.add(new ComboItem((Object)2, i18n.translateString(RbForwardingRule.toStringType(2))));
        items.add(new ComboItem((Object)3, i18n.translateString(RbForwardingRule.toStringType(3))));
        items.add(new ComboItem((Object)4, i18n.translateString(RbForwardingRule.toStringType(4))));
        items.add(new ComboItem((Object)5, i18n.translateString(RbForwardingRule.toStringType(5))));
        items.add(new ComboItem((Object)6, i18n.translateString(RbForwardingRule.toStringType(6))));
        items.add(new ComboItem((Object)7, i18n.translateString(RbForwardingRule.toStringType(7))));
        EntityManagerFilterCriteria newTypeCriteria = new EntityManagerFilterCriteria(i18n.translateString("Type"), "type", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)newTypeCriteria);
    }

    protected String getBaseName() {
        return RbForwardingRuleTemplate.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        ((ForwardingRuleTemplateManagerAction)this.declaredActions.get(0)).setSelectorListener(selectorListener);
    }

    public String getTitle() {
        return i18n.translateString("ForwardingRule");
    }

    public String getHelpTopic() {
        return "ngnms.help.templates_services";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardingRuleTemplateRowCreator
    extends EntityManagerRowProviderBase {
        private static final long serialVersionUID = -8283697666542474126L;

        public ForwardingRuleTemplateRowCreator(List<String> attributes) {
            super(attributes);
        }

        protected String readEntityId(Serializable entity) {
            return String.valueOf(((RbForwardingRuleTemplate)entity).getId());
        }

        protected List<Serializable> readAttributeValues(Serializable entity) {
            List ret = super.readAttributeValues(entity);
            ret.set(6, ((RbForwardingRuleTemplate)entity).getQoS().getName());
            return ret;
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            Integer vlan;
            List ret = super.getDisplayValues(entityRow);
            if (!"".equals(ret.get(1))) {
                ret.set(1, i18n.translateString(RbForwardingRule.toStringType(Integer.parseInt((String)ret.get(1)))));
            }
            if (!"".equals(ret.get(2))) {
                ret.set(2, i18n.translateString(RbForwardingRule.toStringUnicastRelaying(Integer.parseInt((String)ret.get(2)))));
            }
            if (!"".equals(ret.get(3))) {
                ret.set(3, i18n.translateString(RbForwardingRule.toStringMulticastRelaying(Integer.parseInt((String)ret.get(3)))));
            }
            if (!"".equals(ret.get(4))) {
                ret.set(4, i18n.translateString(RbForwardingRule.toStringUnknownAddrPolicy(Integer.parseInt((String)ret.get(4)))));
            }
            if ((vlan = Integer.valueOf(Integer.parseInt((String)ret.get(5)))).equals(4095)) {
                ret.set(5, i18n.translateString("none"));
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardingRuleTemplateManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public ForwardingRuleTemplateManagerAction(String name, int category) {
            this(name, category, null);
        }

        public ForwardingRuleTemplateManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
            this.name = name;
            this.category = category;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            if ("Select".equals(this.name) && 1 == selection.size() && this.selectorListener != null) {
                this.selectorListener.entitiesSelected(manager.getSelection());
                return;
            } else if ("Delete".equals(this.name) && !selection.isEmpty()) {
                boolean confirmed = false;
                confirmed = FrameUtil.showConfirmation((Component)manager.getUI());
                if (!confirmed) return;
                for (Serializable entityRow : selection) {
                    try {
                        RbForwardingRuleTemplate template = (RbForwardingRuleTemplate)entityRow;
                        ServiceRegistry.getEntityManagerService().delete((Serializable)template);
                        Templates.updateListForClass(RbForwardingRuleTemplate.class);
                        if (!(manager instanceof EntityChangeListener)) continue;
                        EntityChangeListener listener = (EntityChangeListener)manager;
                        listener.entityRemoved(entityRow);
                    }
                    catch (ServiceException e) {
                        log.error((Object)"Failed to delete forwarding rule template.", (Throwable)e);
                    }
                }
                return;
            } else {
                if (!"GetFromDevice".equals(this.name)) return;
                SelectorView selectorView = Selectors.getSelectorView(RbForwardingRuleConfigEntry.class, null);
                SelectorUtil.display2ModalSelector((JComponent)manager.getUI(), (SelectorView)selectorView);
                List selectedList = selectorView.getSelection();
                if (selectedList.isEmpty()) return;
                RbForwardingRuleConfigEntry selected = (RbForwardingRuleConfigEntry)((Object)selectedList.get(0));
                RbForwardingRuleTemplate template = this.createTemplate(selected);
                if (this.checkForMatchingTemplate(template)) {
                    TemplateNameDialog dialog = new TemplateNameDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(manager.getUI())));
                    dialog.setModal(true);
                    dialog.setLocationRelativeTo((Component)dialog.getParent());
                    dialog.setTemplate((Template)template);
                    dialog.pack();
                    dialog.setSize(300, 140);
                    dialog.setVisible(true);
                    template = (RbForwardingRuleTemplate)dialog.getTemplate();
                    if (dialog.getCancelPressed() || !(manager instanceof EntityChangeListener)) return;
                    EntityChangeListener listener = (EntityChangeListener)manager;
                    listener.entityAdded((Serializable)template);
                    return;
                } else {
                    try {
                        template = (RbForwardingRuleTemplate)ServiceRegistry.getTemplateManagerService().saveTemplate((Template)template);
                        Templates.updateListForClass(RbForwardingRuleTemplate.class);
                        if (!(manager instanceof EntityChangeListener)) return;
                        EntityChangeListener listener = (EntityChangeListener)manager;
                        listener.entityAdded((Serializable)template);
                        return;
                    }
                    catch (ServerValidationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public boolean checkForMatchingTemplate(RbForwardingRuleTemplate templateFwd) {
            boolean match = false;
            for (Template template : Templates.getTemplates(RbForwardingRuleTemplate.class)) {
                RbForwardingRuleTemplate frTemplate = (RbForwardingRuleTemplate)template;
                if (!frTemplate.getName().equals(templateFwd.getName())) continue;
                match = true;
                break;
            }
            return match;
        }

        private RbForwardingRuleTemplate createTemplate(RbForwardingRuleConfigEntry selected) {
            RbForwardingRuleTemplate template = new RbForwardingRuleTemplate();
            template.setName(selected.getRbForwardingRuleName());
            template.setMulticastRelaying(selected.getRbForwardingRuleMulticastRelaying());
            template.setMulticastVLAN(selected.getRbForwardingRuleMulticastVLAN());
            template.setUnicastRelaying(selected.getRbForwardingRuleUnicastRelaying());
            template.setUnknownAddrPolicy(selected.getRbForwardingUnknownAddrPolicy());
            template.setType(selected.getRbForwardingRuleType());
            ArrayList<Class<RbQoSProfileConfigTable>> moClasses = new ArrayList<Class<RbQoSProfileConfigTable>>();
            ArrayList results = new ArrayList();
            try {
                moClasses.add(RbQoSProfileConfigTable.class);
                results.addAll(ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(selected.getNRConfiguration().getManagedEquipment().getId(), selected.getNRConfiguration().getName(), moClasses, false));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!results.isEmpty()) {
                RbQoSProfileConfigTable qosTable = (RbQoSProfileConfigTable)((Object)results.get(0));
                RbQoSProfileConfigEntry qosEntry = this.findQoSEntry(selected.getRbForwardingRuleMulticastQoSIdx(), qosTable);
                RbQoSProfileValues qosValues = new RbQoSProfileValues();
                qosValues.setName(qosEntry.getRbQoSProfileName());
                qosValues.setParam1(qosEntry.getRbQoSProfileParam1());
                qosValues.setParam2(qosEntry.getRbQoSProfileParam2());
                qosValues.setParamTime(qosEntry.getRbQoSProfileParamTime());
                qosValues.setType(qosEntry.getRbQoSProfileType());
                template.setQoS(qosValues);
            }
            return template;
        }

        private RbQoSProfileConfigEntry findQoSEntry(Long idx, RbQoSProfileConfigTable table) {
            if (idx != null) {
                for (RbQoSProfileConfigEntry entry : table.getEntries()) {
                    if (!entry.getRbQoSProfileIdx().equals(idx)) continue;
                    return entry;
                }
            }
            return null;
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Open") || this.name.equals("Select")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("Delete")) {
                return 0 < selectionSize;
            }
            return true;
        }

        public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
        }
    }
}

