/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.templates;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.model.Equipment;
import com.bwanms.model.Task;
import com.bwanms.rb.gui.managers.RbEntityManagerFilterView;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbVoiceDomainGlobal;
import com.bwanms.rb.tasks.multipleconfiguration.RbBSMultipleConfigTask;
import com.bwanms.util.FrameUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTemplateVoiceDomainManagerConfig
extends EntityManagerConfig {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbVoiceDomainGlobal.class);
    private static String[] columnNames = new String[]{"Name", "pfIPAddress", "UDPPort", "VlanId", "BS"};
    private String[] columnAttribNames = new String[]{"rbVoiceDomainName", "rbVoiceDomainPrimaryPFIpAddress", "", "", ""};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public DeviceTemplateVoiceDomainManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], this.columnAttribNames[0], i18n.translateString(columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], this.columnAttribNames[1], i18n.translateString(columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], this.columnAttribNames[2], i18n.translateString(columnNames[2]), (Comparator)new EntityManagerRowComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], this.columnAttribNames[3], i18n.translateString(columnNames[3]), (Comparator)new EntityManagerRowComparator(3)));
        this.columns.add(new EntityManagerColumn(columnNames[4], this.columnAttribNames[4], i18n.translateString(columnNames[4]), (Comparator)new EntityManagerRowDisplayComparator(4)));
        this.entityRowProvider = new VoiceDomainTemplateRowCreator(DeviceTemplateVoiceDomainManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Name"), "rbVoiceDomainName", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("IPAddress"), "rbVoiceDomainPrimaryPFIpAddress", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("BSName"), "NRConfiguration.configuration.equipment.name", 1, 1, null, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new DeviceManagerTemplateManagerAction("Configure", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new DeviceManagerTemplateManagerAction("MultipleConfiguration", 1));
    }

    public ManagerFilterView getFilterView() {
        return new RbEntityManagerFilterView(this.getManagerName(), this.getBaseName(), this.getFilterCriteria(), this.getEntityRowProvider());
    }

    protected String getBaseName() {
        return RbVoiceDomainsEntry.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        this.defaultAction = new DeviceManagerTemplateManagerAction("Select", 1, selectorListener);
        this.declaredActions.set(0, this.defaultAction);
        if (this.declaredActions.size() > 2) {
            this.declaredActions.remove(0);
        }
    }

    public String getTitle() {
        return i18n.translateString("DeviceVoiceDomainTemplate");
    }

    public String getHelpTopic() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VoiceDomainTemplateRowCreator
    extends EntityManagerRowProviderBase {
        private Map<Long, String> passwdList = new HashMap<Long, String>();
        private static final long serialVersionUID = -8283697666542474126L;

        protected Serializable readClientData(Serializable entity) {
            return (Serializable)((Object)this.passwdList.get(((RbVoiceDomainsEntry)((Object)entity)).getId()));
        }

        public VoiceDomainTemplateRowCreator(List<String> attributes) {
            super(attributes);
        }

        protected List<Serializable> readAttributeValues(Serializable entity) {
            List ret = super.readAttributeValues(entity);
            String pfServerIp = ((RbVoiceDomainsEntry)((Object)entity)).getRbVoiceDomainPrimaryPFIpAddress();
            List rbBSPFServersEntryList = ((RbVoiceDomainsEntry)((Object)entity)).getNRConfiguration().retrieveManagedObjects(RbBSPFServersEntry.class, pfServerIp.toString());
            if (rbBSPFServersEntryList != null && rbBSPFServersEntryList.size() > 0) {
                RbBSPFServersEntry rbBSPFServersEntry = (RbBSPFServersEntry)((Object)rbBSPFServersEntryList.get(0));
                ret.set(2, rbBSPFServersEntry.getRbBSPFServerPortNumber());
                ret.set(3, rbBSPFServersEntry.getRbBSPFServerPFVlan());
                String passwd = rbBSPFServersEntry.getRbBSPFServerSharedString();
                this.passwdList.put(((RbVoiceDomainsEntry)((Object)entity)).getId(), passwd);
            }
            RbBaseStationEquipment managedEquipment = (RbBaseStationEquipment)((RbVoiceDomainsEntry)((Object)entity)).getNRConfiguration().getManagedEquipment();
            ret.set(4, managedEquipment.getName());
            return ret;
        }

        protected String readEntityId(Serializable entity) {
            return String.valueOf(((RbVoiceDomainsEntry)((Object)entity)).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeviceManagerTemplateManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public DeviceManagerTemplateManagerAction(String name, int category) {
            this(name, category, null);
        }

        public DeviceManagerTemplateManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
            this.name = name;
            this.category = category;
        }

        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            if ("Select".equals(this.name)) {
                if (1 == selection.size() && this.selectorListener != null) {
                    this.selectorListener.entitiesSelected(manager.getSelection());
                }
            } else if ("Configure".equals(this.name)) {
                if (1 == selection.size()) {
                    RbVoiceDomainsEntry rbVoiceDomainsEntry = (RbVoiceDomainsEntry)((Object)selection.get(0));
                    RbBaseStationEquipment bs = (RbBaseStationEquipment)rbVoiceDomainsEntry.getNRConfiguration().getManagedEquipment();
                    ConfigApplicationView configAppView = new ConfigApplicationView((Equipment)bs);
                    if (null == configAppView.getConfiguration()) {
                        throw new RuntimeException("Configuration does not exist for BS: " + bs.getEUID());
                    }
                    String url = "bwanms://config/" + bs.getEUID() + "/Services/VoiceDomain?voiceDomainId=" + rbVoiceDomainsEntry.getRbVoiceDomainIdx();
                    configAppView.fireAction(url);
                    FrameUtil.runFrame((JFrame)FrameUtil.createFrame(), (String)(bs.getName() + " " + bs.getIPAddress()), (View)configAppView, (int)1024, (int)768, (boolean)true);
                }
            } else if ("MultipleConfiguration".equals(this.name)) {
                RbVoiceDomainsEntry rbVoiceDomainsEntry = (RbVoiceDomainsEntry)((Object)selection.get(0));
                RbBSMultipleConfigTask task = new RbBSMultipleConfigTask();
                task.setVoiceDomainName(rbVoiceDomainsEntry.getRbVoiceDomainName());
                task.setPfServerIPAddress(rbVoiceDomainsEntry.getRbVoiceDomainPrimaryPFIpAddress());
                List displayValues = manager.getSelectionData();
                if (displayValues != null && displayValues.size() > 0) {
                    task.setPfServerUdpPort((Integer)((EntityManagerRow)displayValues.get(0)).getAttributeValue(2));
                    task.setPfServerVlanId((Integer)((EntityManagerRow)displayValues.get(0)).getAttributeValue(3));
                    task.setPfServerSharedSecret((String)((Object)((EntityManagerRow)displayValues.get(0)).getClientData()));
                }
                task.setFromVoiceDomainViewer(true);
                new TaskEditorFormContainer(((Object)((Object)task)).getClass(), (Task)task);
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if ("Configure".equals(this.name) || "MultipleConfiguration".equals(this.name) || "Select".equals(this.name)) {
                return 1 == selectionSize;
            }
            return false;
        }
    }
}

