/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.templates;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.rb.gui.managers.RbEntityManagerFilterView;
import com.bwanms.rb.gui.templates.ForwardingRuleTemplateManagerConfig;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.ui.components.ComboItem;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceTemplateForwardingRuleManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(ForwardingRuleTemplateManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbForwardingRule.class);
    private String[] columnNames = new String[]{"Name", "Type", "UnicastRelaying", "MulticastRelaying", "UnknownAddressForwardingPolicy", "MulticastVLAN", "QosProfileName", "BS"};
    private String[] columnAttribNames = new String[]{"rbForwardingRuleName", "rbForwardingRuleType", "rbForwardingRuleUnicastRelaying", "rbForwardingRuleMulticastRelaying", "rbForwardingUnknownAddrPolicy", "rbForwardingRuleMulticastVLAN", "", ""};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public DeviceTemplateForwardingRuleManagerConfig() {
        this.columns.add(new EntityManagerColumn(this.columnNames[0], this.columnAttribNames[0], i18n.translateString(this.columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(this.columnNames[1], this.columnAttribNames[1], i18n.translateString(this.columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(this.columnNames[2], this.columnAttribNames[2], i18n.translateString(this.columnNames[2]), (Comparator)new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(this.columnNames[3], this.columnAttribNames[3], i18n.translateString(this.columnNames[3]), (Comparator)new EntityManagerRowDisplayComparator(3)));
        this.columns.add(new EntityManagerColumn(this.columnNames[4], this.columnAttribNames[4], i18n.translateString(this.columnNames[4]), (Comparator)new EntityManagerRowComparator(4)));
        this.columns.add(new EntityManagerColumn(this.columnNames[5], this.columnAttribNames[5], i18n.translateString(this.columnNames[5]), (Comparator)new EntityManagerRowDisplayComparator(5)));
        this.columns.add(new EntityManagerColumn(this.columnNames[6], this.columnAttribNames[6], i18n.translateString(this.columnNames[6]), (Comparator)new EntityManagerRowDisplayComparator(6)));
        this.columns.add(new EntityManagerColumn(this.columnNames[7], this.columnAttribNames[7], i18n.translateString(this.columnNames[7]), (Comparator)new EntityManagerRowDisplayComparator(7)));
        this.entityRowProvider = new ForwardingRuleTemplateRowCreator(DeviceTemplateForwardingRuleManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Name"), "rbForwardingRuleName", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("BSName"), "NRConfiguration.configuration.equipment.name", 1, 1, null, false));
        this.setTypeFilterCriteria();
        this.newFilters();
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new DeviceManagerTemplateManagerAction("Select", 1);
        this.declaredActions.add(this.defaultAction);
    }

    public ManagerFilterView getFilterView() {
        return new RbEntityManagerFilterView(this.getManagerName(), this.getBaseName(), this.getFilterCriteria(), this.getEntityRowProvider());
    }

    private void newFilters() {
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)2, i18n.translateString(RbForwardingRule.toStringUnicastRelaying(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbForwardingRule.toStringUnicastRelaying(1))));
        EntityManagerFilterCriteria unicastRelayingCriteria = new EntityManagerFilterCriteria(i18n.translateString("UnicastRelaying"), "rbForwardingRuleUnicastRelaying", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)unicastRelayingCriteria);
        items = new Vector();
        items.add(new ComboItem((Object)2, i18n.translateString(RbForwardingRule.toStringMulticastRelaying(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbForwardingRule.toStringMulticastRelaying(1))));
        EntityManagerFilterCriteria multicastRelayingCriteria = new EntityManagerFilterCriteria(i18n.translateString("MulticastRelaying"), "rbForwardingRuleMulticastRelaying", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)multicastRelayingCriteria);
        items = new Vector();
        items.add(new ComboItem((Object)2, i18n.translateString(RbForwardingRule.toStringUnknownAddrPolicy(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbForwardingRule.toStringUnknownAddrPolicy(1))));
        EntityManagerFilterCriteria unknownForwardingPolicy = new EntityManagerFilterCriteria(i18n.translateString("UnknownAddressForwardingPolicy"), "rbForwardingUnknownAddrPolicy", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)unknownForwardingPolicy);
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("MulticastVLAN"), "rbForwardingRuleMulticastVLAN", 1, 1, null, false));
    }

    private void setTypeFilterCriteria() {
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)1, i18n.translateString(RbForwardingRule.toStringType(1))));
        items.add(new ComboItem((Object)2, i18n.translateString(RbForwardingRule.toStringType(2))));
        items.add(new ComboItem((Object)3, i18n.translateString(RbForwardingRule.toStringType(3))));
        items.add(new ComboItem((Object)4, i18n.translateString(RbForwardingRule.toStringType(4))));
        items.add(new ComboItem((Object)5, i18n.translateString(RbForwardingRule.toStringType(5))));
        items.add(new ComboItem((Object)6, i18n.translateString(RbForwardingRule.toStringType(6))));
        items.add(new ComboItem((Object)7, i18n.translateString(RbForwardingRule.toStringType(7))));
        EntityManagerFilterCriteria newTypeCriteria = new EntityManagerFilterCriteria(i18n.translateString("Type"), "rbForwardingRuleType", 2, 3, items, false);
        this.filterCriteria.add((ManagerFilterCriteria)newTypeCriteria);
    }

    protected String getBaseName() {
        return RbForwardingRuleConfigEntry.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        this.defaultAction = new DeviceManagerTemplateManagerAction("Select", 1, selectorListener);
        this.declaredActions.set(0, this.defaultAction);
        if (this.declaredActions.size() > 2) {
            this.declaredActions.remove(0);
        }
    }

    public String getTitle() {
        return i18n.translateString("DeviceProfileTemplate");
    }

    public String getHelpTopic() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardingRuleTemplateRowCreator
    extends EntityManagerRowProviderBase {
        private static final long serialVersionUID = -8283697666542474126L;

        public ForwardingRuleTemplateRowCreator(List<String> attributes) {
            super(attributes);
        }

        protected List<Serializable> readAttributeValues(Serializable entity) {
            List ret = super.readAttributeValues(entity);
            Long qosIdx = ((RbForwardingRuleConfigEntry)((Object)entity)).getRbForwardingRuleMulticastQoSIdx();
            ret.set(6, ((RbQoSProfileConfigEntry)((Object)((RbForwardingRuleConfigEntry)((Object)entity)).getNRConfiguration().retrieveManagedObjects(RbQoSProfileConfigEntry.class, qosIdx.toString()).get(0))).getRbQoSProfileName());
            ret.set(7, ((RbForwardingRuleConfigEntry)((Object)entity)).getNRConfiguration().getManagedEquipment().getName());
            return ret;
        }

        protected String readEntityId(Serializable entity) {
            return String.valueOf(((RbForwardingRuleConfigEntry)((Object)entity)).getId());
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            Integer vlan;
            List ret = super.getDisplayValues(entityRow);
            if (!"".equals(ret.get(1))) {
                ret.set(1, i18n.translateString(RbForwardingRule.toStringType(Integer.parseInt((String)ret.get(1)))));
            }
            if (!"".equals(ret.get(2))) {
                ret.set(2, i18n.translateString(RbForwardingRule.toStringUnicastRelaying(Integer.parseInt((String)ret.get(2)))));
            }
            if (!"".equals(ret.get(3))) {
                ret.set(3, i18n.translateString(RbForwardingRule.toStringMulticastRelaying(Integer.parseInt((String)ret.get(3)))));
            }
            if (!"".equals(ret.get(4))) {
                ret.set(4, i18n.translateString(RbForwardingRule.toStringUnknownAddrPolicy(Integer.parseInt((String)ret.get(4)))));
            }
            if ((vlan = Integer.valueOf(Integer.parseInt((String)ret.get(5)))).equals(4095)) {
                ret.set(5, i18n.translateString("none"));
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DeviceManagerTemplateManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public DeviceManagerTemplateManagerAction(String name, int category) {
            this(name, category, null);
        }

        public DeviceManagerTemplateManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.selectorListener = selectorListener;
            this.name = name;
            this.category = category;
        }

        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            if ("Select".equals(this.name) && 1 == selection.size()) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Select")) {
                return 1 == selectionSize;
            }
            return false;
        }
    }
}

