/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.subscribers;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.mo.ManagedObject;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.model.Equipment;
import com.bwanms.rb.gui.configuration.services.RbServiceConfigEntryEditorView;
import com.bwanms.rb.gui.subscribers.RbSubscriberEditorAssembly;
import com.bwanms.rb.gui.subscribers.RbSubscriberEditorView;
import com.bwanms.rb.gui.subscribers.SubscriberServicesEditorPanel;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.services.RbForwardingRuleConfigEntry;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.mo.services.RbQoSProfileConfigEntry;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.services.UnifiedMORequest;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriberServiceEditorComponent {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SubscriberServiceEditorComponent.class);
    private static final Logger log = Logger.getLogger(SubscriberServiceEditorComponent.class);
    private SubscriberServicesEditorPanel servicesEditorPanel;
    private RbServiceConfigEntryEditorView serviceConfigEntryEditorView = new RbServiceConfigEntryEditorView();
    private RbSubscriber subscriber;
    private List<RbServiceConfigEntry> services;
    private List<ManagedObject> managedObjects;
    private RbBaseStationEquipment equipment;
    private RbServiceConfigEntry service;
    private Map<Long, List<ManagedObject>> mosCache = new HashMap<Long, List<ManagedObject>>();
    private RbSubscriberEditorView view;

    public void install(SubscriberServicesEditorPanel servicesEditorPanel) {
        this.servicesEditorPanel = servicesEditorPanel;
        servicesEditorPanel.getRbServiceConfigEntryEditorPanel1().getController().setMACEnhancedMode(true);
        this.serviceConfigEntryEditorView.setPanel(servicesEditorPanel.getRbServiceConfigEntryEditorPanel1());
        servicesEditorPanel.getTable().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SubscriberServiceEditorComponent.this.selectEntry();
            }
        });
        servicesEditorPanel.getTable().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                SubscriberServiceEditorComponent.this.selectEntry();
            }
        });
        if (!Security.getSecurity().checkPermissions("Av:ConfigureSubscribers", "write")) {
            servicesEditorPanel.getBtnApply().setEnabled(false);
        }
        servicesEditorPanel.getBtnAdd().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubscriberServiceEditorComponent.this.addService();
            }
        });
        servicesEditorPanel.getBtnDelete().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubscriberServiceEditorComponent.this.delete();
            }
        });
        servicesEditorPanel.getBtnApply().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubscriberServiceEditorComponent.this.apply();
            }
        });
        servicesEditorPanel.getBtnRefresh().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubscriberServiceEditorComponent.this.refreshListAndClearEditor();
            }
        });
    }

    public void refreshListAndClearEditor() {
        this.refreshList();
        this.servicesEditorPanel.clearEditor();
    }

    private void refreshList() {
        EntityManagerTableModel<RbServiceConfigEntry> model = this.servicesEditorPanel.getTableModel();
        model.clearTable();
        this.mosCache.clear();
        if (this.subscriber.getId() > 0L) {
            try {
                RbSubscriberEditorAssembly assembly = (RbSubscriberEditorAssembly)ServiceRegistry.getEntityManagerService().get(((Object)((Object)this.subscriber)).getClass(), this.subscriber.getId(), "Editor");
                this.services = assembly.getSupportedServiceEntries();
                for (RbServiceConfigEntry entry : this.services) {
                    model.addRow((Object)entry, String.valueOf(entry.getId()));
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
    }

    protected void apply() {
        UnifiedMOSupport table = (UnifiedMOSupport)this.managedObjects.get(0);
        List<InvalidValue> iValues = this.serviceConfigEntryEditorView.configureEntity(this.service);
        if (iValues != null && iValues.size() > 0) {
            FrameUtil.showError((Component)this.servicesEditorPanel, (String)iValues.get(0).getMessage(), (String)i18n.translateString("Error"));
            table.revertInstance(this.service.getRowKey());
        } else {
            if (this.service.getId() == 0L) {
                if (!this.checkNewServiceName((UnifiedMOSupport<RbServiceConfigEntry>)table)) {
                    return;
                }
                table.addInstance((ManagedObject)this.service);
            } else {
                table.updateInstance((ManagedObject)this.service);
            }
            if (this.checkMACAddress()) {
                this.submitMO((ManagedObject)table, new Runnable(){

                    public void run() {
                        SubscriberServiceEditorComponent.this.refreshListAndClearEditor();
                        SubscriberServiceEditorComponent.this.selectServiceRow(SubscriberServiceEditorComponent.this.service);
                        SubscriberServiceEditorComponent.this.selectEntry();
                    }
                }, new Runnable(){

                    public void run() {
                        SubscriberServiceEditorComponent.this.refreshList();
                        SubscriberServiceEditorComponent.this.selectServiceRow(SubscriberServiceEditorComponent.this.service);
                    }
                });
            }
        }
    }

    private void selectServiceRow(RbServiceConfigEntry service) {
        if (service != null) {
            for (RbServiceConfigEntry serviceEntry : this.servicesEditorPanel.getTableModel().getEntities()) {
                if (!serviceEntry.getRowKey().equals(service.getRowKey())) continue;
                int rowNumber = this.servicesEditorPanel.getTableModel().getEntityRow(String.valueOf(serviceEntry.getId()));
                if (rowNumber != -1) {
                    this.servicesEditorPanel.getTable().setRowSelectionInterval(rowNumber, rowNumber);
                    continue;
                }
                this.servicesEditorPanel.getTable().clearSelection();
            }
        } else {
            this.servicesEditorPanel.getTable().clearSelection();
        }
    }

    private boolean checkMACAddress() {
        String rbServiceSuMacAddress = this.service.getRbServiceSuMacAddress();
        UnifiedMOSupport table = (UnifiedMOSupport)this.managedObjects.get(3);
        for (RbRegisteredSuEntry entry : table.getInstances()) {
            if (!entry.getRbSuMacAddr().toLowerCase().equals(rbServiceSuMacAddress.toLowerCase())) continue;
            if (entry.getRbSuPersistence() == 1) {
                if (FrameUtil.showConfirmation((Component)this.servicesEditorPanel, (String)i18n.translateString("ChangeSuPersistenceToPermanent"))) {
                    RbRegisteredSuEntry modifiableRbRegisteredSuEntry = (RbRegisteredSuEntry)table.findInstance(entry.getRowKey());
                    modifiableRbRegisteredSuEntry.setRbSuPersistence(2);
                    table.updateInstance((ManagedObject)modifiableRbRegisteredSuEntry);
                    if (this.synchSubmitMO((ManagedObject)table)) {
                        this.serviceConfigEntryEditorView.setSubscriberUnits(table.getInstances());
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        log.debug((Object)("New MAC address " + rbServiceSuMacAddress));
        ArrayList<RbRegisteredSuEntry> suEntries = new ArrayList<RbRegisteredSuEntry>();
        for (RbRegisteredSuEntry suEntry : suEntries) {
            suEntries.add(suEntry);
        }
        UnifiedMOSupport cloneTable = new UnifiedMOSupport(RbRegisteredSuEntry.class, suEntries);
        cloneTable.setNRConfigName(table.getNRConfigName());
        RbRegisteredSuEntry newSu = new RbRegisteredSuEntry();
        newSu.setRbSuMacAddr(rbServiceSuMacAddress);
        newSu.setRbSuPersistence(2);
        cloneTable.addInstance((ManagedObject)newSu);
        if (this.synchSubmitMO((ManagedObject)cloneTable)) {
            this.managedObjects.set(3, (ManagedObject)cloneTable);
            return true;
        }
        FrameUtil.showError((Component)this.servicesEditorPanel, (String)i18n.translateString("MACError"), null);
        return false;
    }

    protected void delete() {
        int row = this.servicesEditorPanel.getTable().getSelectedRow();
        log.debug((Object)String.format("Row %d to be deleted", row));
        if (row >= 0 && FrameUtil.showConfirmation((Component)this.servicesEditorPanel)) {
            UnifiedMOSupport table = (UnifiedMOSupport)this.managedObjects.get(0);
            long subscIdx = this.service.getRbSubscriberIdx();
            table.removeInstance(this.service.getRowKey());
            boolean done = this.synchSubmitMO((ManagedObject)table);
            if (done) {
                boolean used = false;
                for (RbServiceConfigEntry entry : table.getInstances()) {
                    if (entry.getRbSubscriberIdx() != subscIdx) continue;
                    used = true;
                    break;
                }
                if (!used && FrameUtil.showConfirmation((Component)this.servicesEditorPanel, (String)i18n.translateString("DeleteSubscriber"))) {
                    UnifiedMOSupport subscTable = (UnifiedMOSupport)this.managedObjects.get(2);
                    for (RbSubscriberEntry entry : subscTable.getInstances()) {
                        if (entry.getRbSubscriberIdx() != subscIdx) continue;
                        subscTable.removeInstance(entry.getRowKey());
                        this.submitMO((ManagedObject)subscTable, null, null);
                        break;
                    }
                }
                this.refreshListAndClearEditor();
            }
        }
    }

    protected void addService() {
        SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, (String)(RbBaseStationEquipment.class.getName() + "subscriber_service_selector"), (String)"singleSelection");
        if (selectorView == null) {
            throw new IllegalArgumentException("Selector View must be defined!");
        }
        SelectorUtil.displayModalSelector((JComponent)this.servicesEditorPanel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (selection.size() > 0) {
            this.equipment = (RbBaseStationEquipment)((Object)selection.get(0));
            if (this.equipment.isReachable()) {
                if (this.equipment.getSwitchingMode() == RbBaseStationEquipment.SWITCHING_MODE_IP_CS) {
                    MessageBox.Error.quickShow((Component)this.servicesEditorPanel, i18n.translateString("ForSwitchingModeIpCsServicesCanBeCreatedOnlyWithRADIUS"));
                    return;
                }
                this.serviceConfigEntryEditorView.setEquipment(this.equipment);
                this.managedObjects = this.getMOs();
                this.updateTitle();
                UnifiedMOSupport table = (UnifiedMOSupport)this.managedObjects.get(2);
                RbSubscriberEntry subscriber = this.findOrDeploySubscriber((UnifiedMOSupport<RbSubscriberEntry>)table);
                if (subscriber != null) {
                    List<RbSubscriberEntry> entries = Arrays.asList(subscriber);
                    String nrConfigName = table.getNRConfigName();
                    table = new UnifiedMOSupport(RbSubscriberEntry.class, entries);
                    table.setNRConfigName(nrConfigName);
                    this.managedObjects.set(2, (ManagedObject)table);
                    this.service = new RbServiceConfigEntry(this.equipment.isTDDDuplexMode());
                    this.service.setRbServiceIdx(-1L);
                    this.servicesEditorPanel.showEditor();
                    this.updateView();
                }
            } else {
                MessageBox.Error.quickShow((Component)this.servicesEditorPanel, i18n.translateString("BSUnreachable"));
            }
        }
    }

    protected void selectEntry() {
        int row = this.servicesEditorPanel.getTable().getSelectedRow();
        log.debug((Object)String.format("Row %d selected", row));
        if (row >= 0) {
            this.service = this.services.get(row);
            this.servicesEditorPanel.showEditor();
            this.equipment = (RbBaseStationEquipment)this.service.getNRConfiguration().getManagedEquipment();
            if (this.equipment.isReachable()) {
                this.serviceConfigEntryEditorView.setEquipment(this.equipment);
                this.managedObjects = this.getMOs();
                if (this.managedObjects.size() > 0 && this.locateService((UnifiedMOSupport<RbServiceConfigEntry>)((UnifiedMOSupport)this.managedObjects.get(0)))) {
                    this.updateTitle();
                    this.updateView();
                } else {
                    this.servicesEditorPanel.clearEditor();
                    MessageBox.Error.quickShow((Component)this.servicesEditorPanel, i18n.translateString("ServiceNotFound"));
                    this.refreshListAndClearEditor();
                }
            } else {
                this.servicesEditorPanel.clearEditor();
                MessageBox.Error.quickShow((Component)this.servicesEditorPanel, i18n.translateString("BSUnreachable"));
                this.refreshListAndClearEditor();
            }
        } else {
            this.servicesEditorPanel.clearEditor();
        }
    }

    private void updateTitle() {
        TitledBorder titledB = new TitledBorder(this.equipment.getName());
        CompoundBorder temp = new CompoundBorder(titledB, this.servicesEditorPanel.getServiceEditorBorder().getInsideBorder());
        this.servicesEditorPanel.getRbServiceConfigEntryEditorPanel1().setBorder(temp);
    }

    private void updateView() {
        this.serviceConfigEntryEditorView.setServices((UnifiedMOSupport<RbServiceConfigEntry>)((UnifiedMOSupport)this.managedObjects.get(0)));
        this.serviceConfigEntryEditorView.setServiceProfiles(((UnifiedMOSupport)this.managedObjects.get(1)).getInstances());
        this.serviceConfigEntryEditorView.setSubscribers(((UnifiedMOSupport)this.managedObjects.get(2)).getInstances());
        this.serviceConfigEntryEditorView.setSubscriberUnits(((UnifiedMOSupport)this.managedObjects.get(3)).getInstances());
        this.serviceConfigEntryEditorView.setForwardingRules(((UnifiedMOSupport)this.managedObjects.get(4)).getInstances());
        this.serviceConfigEntryEditorView.setPolicyRules(((UnifiedMOSupport)this.managedObjects.get(5)).getInstances());
        this.serviceConfigEntryEditorView.setQoSProfiles(((UnifiedMOSupport)this.managedObjects.get(6)).getInstances());
        this.serviceConfigEntryEditorView.setVPLDomains(((UnifiedMOSupport)this.managedObjects.get(7)).getInstances());
        this.serviceConfigEntryEditorView.setEntity(this.service);
    }

    private boolean locateService(UnifiedMOSupport<RbServiceConfigEntry> table) {
        for (RbServiceConfigEntry entry : table.getInstances()) {
            if (!entry.getRbServiceIdx().equals(this.service.getRbServiceIdx())) continue;
            this.service = (RbServiceConfigEntry)table.findInstance(entry.getRowKey());
            return true;
        }
        return false;
    }

    public RbSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(RbSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    private List<ManagedObject> getMOs() {
        if (this.mosCache.get(this.equipment.getId()) != null) {
            return this.mosCache.get(this.equipment.getId());
        }
        ArrayList<ManagedObject> managedObjects = new ArrayList<ManagedObject>();
        List<UnifiedMORequest> requests = this.getManagedObjectRequests(this.equipment);
        this.getMOsFromEquipment(this.equipment, managedObjects, requests);
        this.mosCache.put(this.equipment.getId(), managedObjects);
        return managedObjects;
    }

    private List<UnifiedMORequest> getManagedObjectRequests(Equipment equipment) {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add(this.createRequest(equipment.getId(), "BS", RbServiceConfigEntry.class, "*"));
        ret.add(this.createRequest(equipment.getId(), "BS", RbServiceTemplateConfigEntry.class, "*"));
        ret.add(this.createRequest(equipment.getId(), "BS", RbSubscriberEntry.class, "*"));
        ret.add(this.createRequest(equipment.getId(), "BS", RbRegisteredSuEntry.class, "*"));
        ret.add(this.createRequest(equipment.getId(), "BS", RbForwardingRuleConfigEntry.class, "*"));
        ret.add(this.createRequest(equipment.getId(), "BS", RbPolicyRuleConfigEntry.class, "*"));
        ret.add(this.createRequest(equipment.getId(), "BS", RbQoSProfileConfigEntry.class, "*"));
        ret.add(this.createRequest(equipment.getId(), "BS", RbVoiceDomainsEntry.class, "*"));
        return ret;
    }

    protected UnifiedMORequest createRequest(long id, String networkResourceName, Class<? extends ManagedObject> moClass, String instanceQuery) {
        return new UnifiedMORequest(id, networkResourceName, moClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMOsFromEquipment(Equipment equipment, List<ManagedObject> managedObjects, List<UnifiedMORequest> requests) {
        try {
            this.servicesEditorPanel.setCursor(Cursor.getPredefinedCursor(3));
            for (UnifiedMORequest moRequest : requests) {
                UnifiedMOSupport moSupport = new UnifiedMOSupport(moRequest.getMoClass(), ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(moRequest.getEquipmentId(), moRequest.getNetworkResource(), moRequest.getMoClass(), moRequest.getInstanceQuery() == null ? "*" : moRequest.getInstanceQuery(), false));
                moSupport.setNRConfigName(moRequest.getNetworkResource());
                managedObjects.add((ManagedObject)moSupport);
            }
        }
        catch (ServiceException ex) {
            log.error((Object)ex, (Throwable)ex);
            FrameUtil.showError((Component)this.servicesEditorPanel, (String)i18n.translateString("GetError"), (String)i18n.translateString("Error"));
        }
        finally {
            this.servicesEditorPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private boolean checkNewServiceName(UnifiedMOSupport<RbServiceConfigEntry> unifiedMO) {
        for (RbServiceConfigEntry entry : unifiedMO.getInstances()) {
            if (!this.service.getRbServiceName().equals(entry.getRbServiceName()) || this.service.getRowKey().equals(entry.getRowKey())) continue;
            FrameUtil.showError((Component)this.servicesEditorPanel, (String)i18n.translateString("AServiceWithTheSameNameIsAlreadyDeployed"), (String)i18n.translateString("Error"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitMO(ManagedObject mo, Runnable okRunnable, Runnable failRunnable) {
        ArrayList<ManagedObject> newManagedObjects = new ArrayList<ManagedObject>();
        newManagedObjects.add(mo);
        boolean success = false;
        try {
            this.servicesEditorPanel.setCursor(Cursor.getPredefinedCursor(3));
            ServiceRegistry.getConfigurationService().updateCurrentConfiguration(this.equipment.getId(), newManagedObjects);
            success = true;
        }
        catch (ServiceException ex) {
            FrameUtil.showError((Component)this.servicesEditorPanel, (String)i18n.translateString("SetError"), (String)i18n.translateString("Error"));
        }
        finally {
            this.servicesEditorPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (success && okRunnable != null) {
            okRunnable.run();
        }
        if (!success && failRunnable != null) {
            failRunnable.run();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RbSubscriberEntry findOrDeploySubscriber(UnifiedMOSupport<RbSubscriberEntry> table) {
        RbSubscriberEntry entry = null;
        if (this.subscriber.getId() == 0L) {
            if (!FrameUtil.showConfirmation((Component)this.servicesEditorPanel, (String)i18n.translateString("SaveSubscriber"))) return null;
            RbSubscriber temp = this.view.save();
            if (temp == null) {
                return null;
            }
            this.subscriber = temp;
        } else {
            entry = this.chekTableForSubscriber(table);
            if (entry == null && this.existsSubscriberWithSameSubscriberID(table)) {
                MessageBox.Error.quickShow((Component)this.servicesEditorPanel, i18n.translateString("ASubscriberWithTheSameSubscriberIDButNotTheSameParametersWasFound"));
                return null;
            }
        }
        if (entry != null || !FrameUtil.showConfirmation((Component)this.servicesEditorPanel, (String)i18n.translateString("DeploySubscriber"))) return entry;
        entry = new RbSubscriberEntry();
        entry.setRbSubscriberIdx(-1L);
        entry.setRbSubscriberID(this.subscriber.getSubscriberId());
        entry.setRbSubscriberFirstName(this.subscriber.getFirstName());
        entry.setRbSubscriberLastName(this.subscriber.getLastName());
        entry.setRbSubscriberInfo(this.subscriber.getSnmpDescription());
        entry.setRbSubscriberAdminStatus(1);
        table.addInstance((ManagedObject)entry);
        boolean done = this.synchSubmitMO((ManagedObject)table);
        if (!done) {
            FrameUtil.showError((Component)this.servicesEditorPanel, (String)i18n.translateString("SubscriberError"), null);
            return null;
        }
        this.refreshSubscribers();
        return this.chekTableForSubscriber((UnifiedMOSupport<RbSubscriberEntry>)((UnifiedMOSupport)this.managedObjects.get(2)));
    }

    private void refreshSubscribers() {
        ArrayList<UnifiedMORequest> ret = new ArrayList<UnifiedMORequest>();
        ret.add(this.createRequest(this.equipment.getId(), "BS", RbSubscriberEntry.class, "*"));
        ArrayList<ManagedObject> newMOs = new ArrayList<ManagedObject>();
        this.getMOsFromEquipment(this.equipment, newMOs, ret);
        this.managedObjects.set(2, (ManagedObject)newMOs.get(0));
    }

    private RbSubscriberEntry chekTableForSubscriber(UnifiedMOSupport<RbSubscriberEntry> table) {
        for (RbSubscriberEntry entry : table.getInstances()) {
            if (!this.nullSafeEquals(entry.getRbSubscriberID(), this.subscriber.getSubscriberId()) || !this.nullSafeEquals(entry.getRbSubscriberFirstName(), this.subscriber.getFirstName()) || !this.nullSafeEquals(entry.getRbSubscriberLastName(), this.subscriber.getLastName()) || !this.nullSafeEquals(entry.getRbSubscriberInfo(), this.subscriber.getSnmpDescription())) continue;
            return entry;
        }
        return null;
    }

    private boolean existsSubscriberWithSameSubscriberID(UnifiedMOSupport<RbSubscriberEntry> table) {
        for (RbSubscriberEntry entry : table.getInstances()) {
            if (!this.nullSafeEquals(entry.getRbSubscriberID(), this.subscriber.getSubscriberId())) continue;
            return true;
        }
        return false;
    }

    private boolean synchSubmitMO(ManagedObject mo) {
        final ArrayList temp = new ArrayList();
        this.submitMO(mo, new Runnable(){

            public void run() {
                temp.add(true);
            }
        }, new Runnable(){

            public void run() {
                temp.add(false);
            }
        });
        while (temp.size() == 0) {
        }
        return (Boolean)temp.get(0);
    }

    public boolean nullSafeEquals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || x.toString().equals("")) {
            return y == null || y.toString().equals("");
        }
        return x.equals(y);
    }

    public void setSelectedEntry(RbServiceConfigEntry serviceEntity) {
        EntityManagerTableModel<RbServiceConfigEntry> model = this.servicesEditorPanel.getTableModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            RbServiceConfigEntry entity = (RbServiceConfigEntry)((Object)model.getEntity(i));
            if (entity.getId() != serviceEntity.getId()) continue;
            this.servicesEditorPanel.getTable().getSelectionModel().setSelectionInterval(i, i);
            this.selectEntry();
        }
    }

    public void setView(RbSubscriberEditorView view) {
        this.view = view;
    }
}

