/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.subscribers;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.Equipment;
import com.bwanms.rb.gui.subscribers.RbSubscriberDeploymentTabPanel;
import com.bwanms.rb.gui.subscribers.RbSubscriberEditorAssembly;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.mo.services.RbSubscriberTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FrameUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubscriberDeploymentComponent {
    private static final Logger log = Logger.getLogger(SubscriberDeploymentComponent.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SubscriberDeploymentComponent.class);
    private RbSubscriberDeploymentTabPanel panel;
    private RbSubscriber subscriber;
    private List<RbBaseStationEquipment> equipments;
    private Map<Long, RbSubscriberEntry> entries;

    public void install(RbSubscriberDeploymentTabPanel deploymentTabPanel) {
        this.panel = deploymentTabPanel;
        this.panel.getBtnRefresh().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubscriberDeploymentComponent.this.refreshList();
            }
        });
        if (!Security.getSecurity().checkPermissions("Av:ConfigureSubscribers", "write")) {
            this.panel.getBtnApply().setEnabled(false);
        }
        this.panel.getBtnApply().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SubscriberDeploymentComponent.this.apply();
            }
        });
    }

    public void refreshList() {
        EntityManagerTableModel<Object[]> model = this.panel.getTableModel();
        model.clearTable();
        try {
            RbSubscriberEditorAssembly assembly = (RbSubscriberEditorAssembly)ServiceRegistry.getEntityManagerService().get(((Object)((Object)this.subscriber)).getClass(), this.subscriber.getId(), "Editor");
            this.equipments = assembly.getSupportedBSs();
            this.entries = assembly.getSupportedSubscriberEntries();
            for (RbBaseStationEquipment equipment : this.equipments) {
                model.addRow((Object)new Object[]{equipment, this.entries.get(equipment.getId())}, String.valueOf(equipment.getId()));
            }
            model.setColumnReadonly(0, true);
            model.setColumnReadonly(1, true);
            model.setColumnReadonly(2, true);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply() {
        EntityManagerTableModel<Object[]> model = this.panel.getTableModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (model.getRowState(row) != 3) continue;
            Object[] values = (Object[])model.getEntity(row);
            Equipment equipment = (Equipment)values[0];
            RbSubscriberEntry subscriber = (RbSubscriberEntry)((Object)values[1]);
            try {
                this.panel.setCursor(Cursor.getPredefinedCursor(3));
                ArrayList<Class<RbSubscriberTable>> moClass = new ArrayList<Class<RbSubscriberTable>>();
                moClass.add(RbSubscriberTable.class);
                List mos = ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(equipment.getId(), "BS", moClass, true);
                RbSubscriberTable table = (RbSubscriberTable)((Object)mos.get(0));
                RbSubscriberEntry entry = (RbSubscriberEntry)table.findEntry(subscriber.getRowKey());
                if (entry != null) {
                    entry.setRbSubscriberAdminStatus((Integer)model.getValueAt(row, 3));
                    ServiceRegistry.getConfigurationService().updateCurrentConfiguration(equipment.getId(), mos);
                    continue;
                }
                FrameUtil.showError((Component)this.panel, (String)i18n.translateString("SubscriberUndeployed"), null);
                continue;
            }
            catch (ServiceException e) {
                log.debug((Object)e, (Throwable)e);
                FrameUtil.showError((Component)this.panel, (String)i18n.translateString("SetError"), null);
                continue;
            }
            finally {
                this.panel.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        this.refreshList();
    }

    public RbSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(RbSubscriber subscriber) {
        this.subscriber = subscriber;
    }
}

