/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.subscribers;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.model.Subscriber;
import com.bwanms.rb.gui.subscribers.SubscriberDeploymentComponent;
import com.bwanms.rb.gui.subscribers.SubscriberEditorPanel;
import com.bwanms.rb.gui.subscribers.SubscriberServiceEditorComponent;
import com.bwanms.rb.gui.subscribers.SubscriberTabbedEditorPanel;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.model.services.RbSubscriber;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSubscriberEditorView
extends AbstractBindedEditorView<Subscriber> {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(RbSubscriberEditorView.class);
    private SubscriberTabbedEditorPanel panel = new SubscriberTabbedEditorPanel();
    private Binder subscriberBinder;
    private SubscriberServiceEditorComponent serviceEditorComponent = new SubscriberServiceEditorComponent();
    private SubscriberDeploymentComponent deploymentComponent;

    public RbSubscriberEditorView() {
        this.serviceEditorComponent.install(this.panel.getSubscriberServicesEditorPanel1());
        this.deploymentComponent = new SubscriberDeploymentComponent();
        this.deploymentComponent.install(this.panel.getDeploymentTabPanel());
        this.panel.getSubscriberServicesEditorPanel1().addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                RbSubscriberEditorView.this.adjustOKButton(true);
            }

            public void componentShown(ComponentEvent e) {
                RbSubscriberEditorView.this.adjustOKButton(false);
            }
        });
        this.panel.getDeploymentTabPanel().addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                RbSubscriberEditorView.this.adjustOKButton(true);
            }

            public void componentShown(ComponentEvent e) {
                RbSubscriberEditorView.this.adjustOKButton(false);
            }
        });
    }

    private void adjustOKButton(boolean isEnabled) {
        try {
            EntityEditorContainer container = (EntityEditorContainer)this.getEditorViewContext();
            container.getForm().getDefaultButton().setEnabled(isEnabled);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        this.subscriberBinder = new DefaultBinder((Object)this.panel.getSubscriberEditorPanel(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtSubscriberId", "subscriberId", i18n.translateString("SubscriberId"))).add((Binding)new JTextFieldBinding("txtFirstName", "firstName", i18n.translateString("FirstName"))).add((Binding)new JTextFieldBinding("txtLastName", "lastName", i18n.translateString("LastName"))).add((Binding)new JTextFieldBinding("txtSNMPDescription", "snmpDescription", i18n.translateString("Description"))).add((Binding)new JTextFieldBinding("txtName", "name")).add((Binding)new JTextFieldBinding("txtDescription", "description")).add((Binding)new JTextFieldBinding("txtPhoneNumber", "phoneNumber")).add((Binding)new JTextFieldBinding("txtMobileNumber", "mobileNumber")).add((Binding)new JTextFieldBinding("txtFaxNumber", "faxNumber")).add((Binding)new JTextFieldBinding("txtEMail", "email")).add((Binding)new JTextFieldBinding("txtAddress1", "addressLine1")).add((Binding)new JTextFieldBinding("txtAddress2", "addressLine2"));
        binders.add(this.subscriberBinder);
        return binders;
    }

    public void fillUI(Subscriber entity) {
        this.serviceEditorComponent.setSubscriber((RbSubscriber)entity);
        this.serviceEditorComponent.setView(this);
        this.deploymentComponent.setSubscriber((RbSubscriber)entity);
        SubscriberEditorPanel subscPanel = this.panel.getSubscriberEditorPanel();
        if (entity.getId() > 0L) {
            subscPanel.getTxtSubscriberId().setEditable(false);
            subscPanel.getTxtFirstName().setEditable(false);
            subscPanel.getTxtLastName().setEditable(false);
            subscPanel.getTxtSNMPDescription().setEditable(false);
            this.serviceEditorComponent.refreshListAndClearEditor();
            this.deploymentComponent.refreshList();
        }
    }

    public List<InvalidValue> configureEntity(Subscriber entity) {
        return super.configureEntity((Serializable)entity);
    }

    public JComponent getUI() {
        return this.panel;
    }

    public String getTitle() {
        return i18n.translateString("Subscriber");
    }

    public void processExternalInvalidValues(List<InvalidValue> invalidValues) {
        ArrayList UIinvalidValues = new ArrayList();
        this.subscriberBinder.toUIInvalidValues(UIinvalidValues, invalidValues);
        invalidValues.clear();
        invalidValues.addAll(UIinvalidValues);
    }

    public String getApplicationPermission() {
        return "Av:ConfigureSubscribers";
    }

    public void setClientData(Object data) {
        if (!(data instanceof RbServiceConfigEntry)) {
            throw new RuntimeException("Illegal service for RbSubscriber " + data.getClass());
        }
        RbServiceConfigEntry service = (RbServiceConfigEntry)((Object)data);
        this.panel.getTabbedPane1().setSelectedIndex(1);
        if (0L != service.getId()) {
            this.serviceEditorComponent.setSelectedEntry(service);
        } else {
            this.serviceEditorComponent.addService();
        }
    }

    public String getHelpTopic() {
        return "adding_editing_subscribers";
    }

    public RbSubscriber save() {
        RbSubscriber sub = (RbSubscriber)((Object)this.getEditorViewContext().save());
        if (sub != null) {
            this.serviceEditorComponent.setSubscriber(sub);
            this.deploymentComponent.setSubscriber(sub);
        }
        return sub;
    }
}

