/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.subscribers;

import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.NetworkResourceConfiguration;
import com.bwanms.model.entity.Assembler;
import com.bwanms.model.entity.AssemblerFactory;
import com.bwanms.model.entity.Assembly;
import com.bwanms.model.entity.DefaultAssembly;
import com.bwanms.rb.gui.subscribers.RbSubscriberEditorAssembly;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.mo.services.RbSubscriberEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.services.ServiceException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSubscriberAssemblerFactory
implements AssemblerFactory<RbSubscriber> {
    public Assembler<RbSubscriber> createAssembler(Class<? extends RbSubscriber> baseClass, String assembler) {
        if ("Editor".equals(assembler)) {
            return new Assembler<RbSubscriber>(){

                public Assembly<RbSubscriber> getAssembly(RbSubscriber entity) throws ServiceException {
                    RbSubscriberEditorAssembly ret = new RbSubscriberEditorAssembly(entity);
                    List<RbBaseStationEquipment> supportedBSs = entity.getSupportingEquipment();
                    Vector<RbServiceConfigEntry> supportedServiceEntries = new Vector<RbServiceConfigEntry>();
                    HashMap<Long, RbSubscriberEntry> supportedSubscriberEntries = new HashMap<Long, RbSubscriberEntry>();
                    for (RbBaseStationEquipment bs : supportedBSs) {
                        EquipmentConfiguration bsConfiguration = bs.findCurrentConfiguration();
                        NetworkResourceConfiguration bsNRConfig = bsConfiguration.findNetworkResourceConfiguration("BS");
                        List subscriberTable = bsNRConfig.retrieveManagedObjects(RbSubscriberEntry.class, "*");
                        long subscriberIdx = 0L;
                        for (RbSubscriberEntry entry : subscriberTable) {
                            if (!entity.getSubscriberId().equals(entry.getRbSubscriberID())) continue;
                            supportedSubscriberEntries.put(bs.getId(), entry);
                            subscriberIdx = entry.getRbSubscriberIdx();
                            break;
                        }
                        List serviceConfigTable = bsNRConfig.retrieveManagedObjects(RbServiceConfigEntry.class, "*");
                        for (RbServiceConfigEntry entry : serviceConfigTable) {
                            if (subscriberIdx != entry.getRbSubscriberIdx()) continue;
                            supportedServiceEntries.add(entry);
                        }
                    }
                    ret.setSupportedBSs(supportedBSs);
                    ret.setSupportedSubscriberEntries(supportedSubscriberEntries);
                    ret.setSupportedServiceEntries(supportedServiceEntries);
                    return ret;
                }
            };
        }
        return new Assembler<RbSubscriber>(){

            public Assembly<RbSubscriber> getAssembly(RbSubscriber entity) throws ServiceException {
                return new DefaultAssembly((Serializable)((Object)entity));
            }
        };
    }
}

