/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.services;

import com.bwanms.gui.EditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityEditorContainer;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.mo.UnifiedMOSupport;
import com.bwanms.model.Equipment;
import com.bwanms.model.entity.Assembly;
import com.bwanms.rb.gui.configuration.services.RbServiceConfigEntryEditorView;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbBaseStationNRConfiguration;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import java.awt.Window;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceEntryEditorContainer
extends EntityEditorContainer<RbServiceConfigEntry> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceEntryEditorContainer.class);
    public static final String ASSEMBLER_NAME = RbServiceEntryEditorContainer.class.getName() + ".assembler";
    RbBaseStationNRConfiguration nrConfig = null;

    public RbServiceEntryEditorContainer(RbServiceConfigEntry entity) throws ServiceException {
        super((Serializable)((Object)entity));
    }

    public RbServiceEntryEditorContainer(RbServiceConfigEntry entity, Window owner, boolean returnImmediately) throws ServiceException {
        super((Serializable)((Object)entity), owner, returnImmediately);
    }

    public RbServiceEntryEditorContainer(RbServiceConfigEntry entity, Window owner) throws ServiceException {
        super((Serializable)((Object)entity), owner);
    }

    protected void saveEntity() {
        this.view.setEntity((Object)this.getEntity());
    }

    public String getEntityId() {
        return String.valueOf(((RbServiceConfigEntry)((Object)this.getEntity())).getId());
    }

    public EditorView<RbServiceConfigEntry> initView() {
        Equipment equipment = this.nrConfig.getConfigurationEquipment();
        RbServiceConfigEntryEditorView view = new RbServiceConfigEntryEditorView(equipment instanceof RbBaseStationEquipment ? (RbBaseStationEquipment)equipment : null);
        view.setSubscribers(this.nrConfig.getRbSubscriberEntries());
        view.setServices((UnifiedMOSupport<RbServiceConfigEntry>)new UnifiedMOSupport(RbServiceConfigEntry.class, this.nrConfig.getRbServiceConfigEntries()));
        view.setServiceProfiles(this.nrConfig.getRbServiceTemplateConfigEntries());
        view.setForwardingRules(this.nrConfig.getRbForwardingRuleConfigEntries());
        view.setPolicyRules(this.nrConfig.getRbPolicyRuleConfigEntries());
        view.setQoSProfiles(this.nrConfig.getRbQoSProfileConfigEntries());
        view.setSubscriberUnits(this.nrConfig.getRbRegisteredSuEntries());
        view.setVPLDomains(this.nrConfig.getRbVoiceDomainsEntries());
        view.setServiceGroup(this.nrConfig.getRbServiceGroupEntries());
        return view;
    }

    protected RbServiceConfigEntry loadEntity(RbServiceConfigEntry entity) throws ServiceException {
        Equipment eq = entity.getNRConfiguration().getConfigurationEquipment();
        Assembly equipmentAssembly = ServiceRegistry.getEntityManagerService().get(eq.getClass(), eq.getId(), ASSEMBLER_NAME);
        EquipmentConfiguration configuration = ((Equipment)equipmentAssembly.getEntity()).findCurrentConfiguration();
        this.nrConfig = (RbBaseStationNRConfiguration)configuration.findPrimaryNetworkResourceConfiguration();
        return (RbServiceConfigEntry)this.nrConfig.getRbServiceConfigTable().findEntry(entity.getRowKey());
    }

    public String getTitle() {
        return i18n.translateString("ServiceEditor");
    }

    protected String getEntityClass() {
        return i18n.translateString(RbServiceConfigEntry.class.getName());
    }

    protected String getEntityName() {
        return this.getEntity() != null ? ((RbServiceConfigEntry)((Object)this.getEntity())).getRbServiceName() : "";
    }
}

