/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.services;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.MACAddressTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.servicemanager.ServiceManagerUtil;
import com.bwanms.model.Equipment;
import com.bwanms.model.ServiceProfile;
import com.bwanms.model.Subscriber;
import com.bwanms.rb.gui.services.RbServiceEditorPanel;
import com.bwanms.rb.gui.services.RbServiceEditorTabbedPanel;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.services.RbService;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.FrameUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceEditorView
extends AbstractBindedEditorView<RbService> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceEditorView.class);
    private static final Internationalizer ddI18N = Internationalizer.getInternationalizer((String)"com.bwanms.ddi");
    private static final Logger log = Logger.getLogger(RbServiceEditorView.class);
    private RbServiceEditorPanel panel;
    private Binder binder;
    private RbServiceEditorTabbedPanel tabbed = new RbServiceEditorTabbedPanel();

    public RbServiceEditorView() {
        this.panel = this.tabbed.getRbServiceEditorPanel1();
        this.tabbed.getDeploymentTabPanel().getBtnDeploy().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbServiceEditorView.this.deployService();
            }
        });
    }

    public List<Binder> getBinders() {
        JComboBoxBinding vlanClassificationBinding = new JComboBoxBinding(i18n, "comboVLANClassificationMode", "rbServiceVLANClassificationMode");
        ArrayList<Binder> binders = new ArrayList<Binder>();
        this.binder = new DefaultBinder((Object)this.panel, (Object)this.entity).add((Binding)new JTextFieldBinding("txtServiceName", "serviceName", i18n.translateString("ServiceName"))).add((Binding)new JTextFieldBinding("txtSuMACAddress", "subscriberUnitEUID", (ValueTranslator)new MACAddressTranslator(true), i18n.translateString("SuMACAddress"))).add((Binding)new JComboBoxBinding(i18n, "comboAdministrativeState", "adminStatus", i18n.translateString("AdministrativeState"))).add((Binding)new JComboBoxBinding(i18n, "comboHybridMode", "rbServiceVLANHybridMode", i18n.translateString("HybridMode"))).add((Binding)vlanClassificationBinding).add((Binding)new JSpinnerBinding("spnrAccessVLAN", "rbServiceAccessVLAN", i18n.translateString("AccessVLAN")));
        binders.add(this.binder);
        return binders;
    }

    public void fillUI(RbService entity) {
        this.panel.getTxtServiceType().setText(ddI18N.translateString(((Object)((Object)entity)).getClass().getName()));
        this.panel.setServiceProfileSelectorClass(entity.getServiceProfileClass());
        this.panel.getSelectorServiceProfile().setValue((Object)entity.getServiceProfile());
        this.panel.getSelectorSubscriber().setValue((Object)entity.getSubscriber());
        this.panel.getTxtOperationalState().setText(ServiceManagerUtil.getOperStatusStr((int)entity.getOpStatus()));
        if (entity.getLastActiveInstance() != null) {
            this.panel.getTxtLastDeployedOn().setText(entity.getLastActiveInstance().getEUID());
        }
        int[] vlanList = new int[16];
        if (entity.getRbServiceClientSiteVLANList() != null) {
            vlanList = RbServiceEditorView.getVLANListFromCommaSeparated(entity.getRbServiceClientSiteVLANList());
        }
        SimpleRowTableModel model = this.panel.getTableModel();
        int rowCount = 16;
        if (entity.getRbServiceVLANHybridMode() == null || entity.getRbServiceVLANHybridMode() == 1) {
            rowCount = 15;
        }
        for (int row = 0; row < rowCount; ++row) {
            model.addNewRow(null, true);
            model.setInitialValueAt((Object)(row + 1), row, 0);
            model.setRowState(row, 4);
            if (vlanList[row] == 0) continue;
            model.setInitialValueAt((Object)vlanList[row], row, 1);
            model.setRowState(row, 0);
        }
        if (entity.getId() > 0L) {
            this.updateDeploymentTab(entity);
        }
        this.panel.getController().controlVLANClassificationMode();
        this.panel.getController().handleAccessVLAN();
    }

    private void updateDeploymentTab(RbService entity) {
        EntityManagerTableModel<Equipment> model1 = this.tabbed.getDeploymentTabPanel().getTableModel();
        List equipments = ServiceRegistry.getServiceManagementService().findServiceInstances(entity.getId());
        model1.clearTable();
        for (Equipment equipment : equipments) {
            model1.addRow((Object)equipment, String.valueOf(equipment.getId()));
        }
    }

    public List<InvalidValue> configureEntity(RbService entity) {
        FormUtil.stopTableEditing((JTable)this.panel.getTable());
        ArrayList<InvalidValue> iValues = new ArrayList<InvalidValue>();
        entity.setRbServiceClientSiteVLANList(this.getCommaSeparatedFromVLANList(entity, iValues));
        entity.setServiceProfile((ServiceProfile)this.panel.getSelectorServiceProfile().getValue());
        entity.setSubscriber((Subscriber)this.panel.getSelectorSubscriber().getValue());
        iValues.addAll(super.configureEntity((Serializable)((Object)entity)));
        if (iValues.isEmpty() && this.shouldWarn() && !FrameUtil.showConfirmation((Component)this.getUI(), (String)i18n.translateString("warning"))) {
            iValues.add(new InvalidValue(i18n.translateString("canceled"), RbService.class, "", (Object)"", null));
        }
        return iValues;
    }

    private boolean shouldWarn() {
        return ((RbService)((Object)this.entity)).getRbServiceVLANHybridMode() == 2 && ((RbService)((Object)this.entity)).getRbServiceClientSiteVLANListCount() == 0 && ((RbServiceProfile)((RbService)((Object)this.entity)).getServiceProfile()).getVLANTransparencyMode() == 1;
    }

    public static int[] getVLANListFromCommaSeparated(String commaSeparated) {
        String[] parts = commaSeparated.split(",");
        int[] vlanList = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            vlanList[i] = "".equals(parts[i]) ? 0 : Integer.parseInt(parts[i]);
        }
        return vlanList;
    }

    private String getCommaSeparatedFromVLANList(RbService entity, List<InvalidValue> values) {
        SimpleRowTableModel model = this.panel.getTableModel();
        StringBuffer buf = new StringBuffer();
        int counter = 0;
        HashSet<String> valuesSet = new HashSet<String>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (model.getValueAt(i, 1) == null || model.getValueAt(i, 1).toString().equals("0") || model.getRowState(i) == 1) continue;
            if (0 > (Integer)model.getValueAt(i, 1) || (Integer)model.getValueAt(i, 1) > 4094) {
                values.add(new InvalidValue(i18n.translateString("invalidVLAN", new Object[]{String.valueOf(i + 1)}), RbService.class, "", model.getValueAt(i, 1), (Object)entity));
            }
            if (valuesSet.contains(model.getValueAt(i, 1).toString())) {
                values.add(new InvalidValue(i18n.translateString("duplicateVLAN", new Object[]{String.valueOf(i + 1)}), RbServiceConfigEntry.class, "", model.getValueAt(i, 1), (Object)entity));
            } else {
                valuesSet.add(model.getValueAt(i, 1).toString());
                buf.append(model.getValueAt(i, 1).toString());
            }
            buf.append(",");
            ++counter;
        }
        entity.setRbServiceClientSiteVLANListCount(counter);
        int rowCount = 16;
        if (counter < rowCount) {
            for (int i = counter; i < rowCount; ++i) {
                buf.append("0,");
            }
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    private void deployService() {
        if (this.ctx != null && this.ctx.save() != null) {
            SelectorView selectorView = Selectors.getSelectorView(RbBaseStationEquipment.class, (String)"singleSelection");
            SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
            List selection = selectorView.getSelection();
            if (selection.size() > 0) {
                RbBaseStationEquipment equipment = (RbBaseStationEquipment)((Object)selection.get(0));
                List equipments = ServiceRegistry.getServiceManagementService().findServiceInstances(((RbService)((Object)this.entity)).getId());
                boolean contains = false;
                for (Equipment eq : equipments) {
                    if (eq.getId() != equipment.getId()) continue;
                    contains = true;
                    break;
                }
                if (!contains || contains && FrameUtil.showConfirmation((Component)this.panel, (String)i18n.translateString("serviceAlreadyDeployed"))) {
                    log.info((Object)("DEPLOYING SERVICE " + ((RbService)((Object)this.entity)).getName() + "(" + ((RbService)((Object)this.entity)).getId() + ")" + " ON DEVICE " + equipment.getName() + "(" + equipment.getId() + ")"));
                    ServiceRegistry.getServiceManagementService().deployService(((RbService)((Object)this.entity)).getId(), equipment.getId());
                    this.updateDeploymentTab((RbService)((Object)this.entity));
                }
            }
        }
    }

    public JComponent getUI() {
        return this.tabbed;
    }

    public String getTitle() {
        return "Service";
    }

    public String getApplicationPermission() {
        return "Av:ConfigureServices";
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.service";
    }
}

