/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles.preview;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Preview;
import com.bwanms.rb.gui.configuration.services.RbServiceProfileEditorView;
import com.bwanms.rb.gui.configuration.services.preview.ServiceProfilePreviewTabbedPanel;
import com.bwanms.rb.gui.serviceprofiles.preview.RbForwardingRulePreview;
import com.bwanms.rb.gui.serviceprofiles.preview.RbPolicyRulePreview;
import com.bwanms.rb.model.services.RbL2ServiceProfile;
import com.bwanms.rb.model.services.RbPPPoEServiceProfile;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.model.services.RbVoIPServiceProfile;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceProfilePreview
implements Preview<RbServiceProfile> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileEditorView.class);
    private ServiceProfilePreviewTabbedPanel panel;
    private RbForwardingRulePreview frPreview;
    private RbPolicyRulePreview prPreview;

    public RbServiceProfilePreview() {
        this(new ServiceProfilePreviewTabbedPanel());
    }

    public RbServiceProfilePreview(ServiceProfilePreviewTabbedPanel panel) {
        this.panel = panel;
        this.initFRPreview();
        this.initPRPreview();
    }

    private void initPRPreview() {
        this.prPreview = new RbPolicyRulePreview(this.panel.getPolicyRulePreviewPanel1());
    }

    private void initFRPreview() {
        this.frPreview = new RbForwardingRulePreview(this.panel.getForwardingRulePreviewPanel1());
    }

    public void setEntity(RbServiceProfile entity) {
        this.panel.getTxtServiceProfileName().setText(entity.getName());
        this.panel.getTxtServiceProfileType().setText(i18n.translateString(entity.toStringRbServiceTemplateType()));
        if (entity.getVPLId() != null) {
            this.panel.getTxtVPLId().setText(entity.getVPLId() >= 4095 ? i18n.translateString("None") : entity.getVPLId().toString());
        }
        this.panel.getTxtVLANTransparencyMode().setText(i18n.translateString(RbServiceProfile.toStringRbServiceTemplateVLANTransparencyMode(entity.getVLANTransparencyMode())));
        this.panel.getTxtPriorityMarkingMode().setText(i18n.translateString(RbServiceProfile.toStringRbServiceTemplateQoSMarkingMode(entity.getPriorityMarkingMode())));
        this.panel.getTxtPriorityMarkingValue().setText(entity.getPriorityMarkingValue().toString());
        if (entity instanceof RbL2ServiceProfile) {
            this.panel.getTxtMaxNumberOfVoiceCalls().setText(((RbL2ServiceProfile)entity).getMaxNumberOfSimultaneousCalls().toString());
            this.frPreview.setEntity(((RbL2ServiceProfile)entity).getForwardingRule());
            this.prPreview.setEntity(((RbL2ServiceProfile)entity).getPolicyRule());
        } else if (entity instanceof RbVoIPServiceProfile) {
            this.panel.getTxtMaxNumberOfVoiceCalls().setText(((RbVoIPServiceProfile)entity).getMaxNumberOfSimultaneousCalls().toString());
            this.frPreview.setEntity(((RbVoIPServiceProfile)entity).getForwardingRule());
            this.panel.getTabbedPane1().remove(this.panel.getPolicyRulePreviewPanel1());
        } else if (entity instanceof RbPPPoEServiceProfile) {
            this.frPreview.setEntity(((RbPPPoEServiceProfile)entity).getForwardingRule());
            this.prPreview.setEntity(((RbPPPoEServiceProfile)entity).getPolicyRule());
        }
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return "Preview";
    }

    public RbForwardingRulePreview getFrPreview() {
        return this.frPreview;
    }

    public RbPolicyRulePreview getPrPreview() {
        return this.prPreview;
    }
}

