/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles.preview;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Preview;
import com.bwanms.rb.gui.configuration.services.RbServiceProfileEditorView;
import com.bwanms.rb.gui.configuration.services.preview.PolicyRulePreviewPanel;
import com.bwanms.rb.gui.configuration.services.preview.PolicyRulePreviewPart;
import com.bwanms.rb.gui.serviceprofiles.preview.RbQoSPreview;
import com.bwanms.rb.mo.services.RbPolicyRuleConfigEntry;
import com.bwanms.rb.model.services.RbPolicyRule;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbPolicyRulePreview
implements Preview<RbPolicyRule> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileEditorView.class);
    private PolicyRulePreviewPanel panel;
    private RbQoSPreview upQoSPreview1;
    private RbQoSPreview upQoSPreview2;
    private RbQoSPreview upQoSPreview3;
    private RbQoSPreview upQoSPreview4;
    private RbQoSPreview downQoSPreview1;
    private RbQoSPreview downQoSPreview2;
    private RbQoSPreview downQoSPreview3;
    private RbQoSPreview downQoSPreview4;

    public RbPolicyRulePreview() {
        this(new PolicyRulePreviewPanel());
    }

    public RbPolicyRulePreview(PolicyRulePreviewPanel panel) {
        this.panel = panel;
        this.initQoS();
    }

    private void initQoS() {
        PolicyRulePreviewPart part1 = this.panel.getPolicyRulePreviewPart1();
        this.upQoSPreview1 = new RbQoSPreview(part1.getQoSPreviewPanel1());
        this.upQoSPreview2 = new RbQoSPreview(part1.getQoSPreviewPanel2());
        this.upQoSPreview3 = new RbQoSPreview(part1.getQoSPreviewPanel3());
        this.upQoSPreview4 = new RbQoSPreview(part1.getQoSPreviewPanel4());
        PolicyRulePreviewPart part2 = this.panel.getPolicyRulePreviewPart2();
        this.downQoSPreview1 = new RbQoSPreview(part2.getQoSPreviewPanel1());
        this.downQoSPreview2 = new RbQoSPreview(part2.getQoSPreviewPanel2());
        this.downQoSPreview3 = new RbQoSPreview(part2.getQoSPreviewPanel3());
        this.downQoSPreview4 = new RbQoSPreview(part2.getQoSPreviewPanel4());
    }

    public void setEntity(RbPolicyRule entity) {
        if (entity != null) {
            this.panel.getTxtName().setText(entity.getName());
            this.panel.getTxtPriorityType().setText(i18n.translateString(RbPolicyRuleConfigEntry.toStringRbPolicyRulePriorityType(entity.getPriorityType())));
            PolicyRulePreviewPart part1 = this.panel.getPolicyRulePreviewPart1();
            part1.getTxtUpperLimit1().setText(entity.getUpQoSUpperLimit1().toString());
            part1.getTxtUpperLimit2().setText(entity.getUpQoSUpperLimit2().toString());
            part1.getTxtUpperLimit3().setText(entity.getUpQoSUpperLimit3().toString());
            part1.getTxtUpperLimit4().setText(entity.getUpQoSUpperLimit4().toString());
            PolicyRulePreviewPart part2 = this.panel.getPolicyRulePreviewPart2();
            part2.getTxtUpperLimit1().setText(entity.getDownQoSUpperLimit1().toString());
            part2.getTxtUpperLimit2().setText(entity.getDownQoSUpperLimit2().toString());
            part2.getTxtUpperLimit3().setText(entity.getDownQoSUpperLimit3().toString());
            part2.getTxtUpperLimit4().setText(entity.getDownQoSUpperLimit4().toString());
            this.setQoSValues(entity);
        }
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return "Preview";
    }

    private void setQoSValues(RbPolicyRule entity) {
        this.upQoSPreview1.setEntity(entity.getUpQoSProfile1());
        this.upQoSPreview2.setEntity(entity.getUpQoSProfile2());
        this.upQoSPreview3.setEntity(entity.getUpQoSProfile3());
        this.upQoSPreview4.setEntity(entity.getUpQoSProfile4());
        this.downQoSPreview1.setEntity(entity.getDownQoSProfile1());
        this.downQoSPreview2.setEntity(entity.getDownQoSProfile2());
        this.downQoSPreview3.setEntity(entity.getDownQoSProfile3());
        this.downQoSPreview4.setEntity(entity.getDownQoSProfile4());
    }
}

