/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles.preview;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Preview;
import com.bwanms.rb.gui.configuration.services.RbServiceProfileEditorView;
import com.bwanms.rb.gui.configuration.services.preview.ForwardingRulePreviewPanel;
import com.bwanms.rb.gui.serviceprofiles.preview.RbQoSPreview;
import com.bwanms.rb.model.services.RbForwardingRule;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbForwardingRulePreview
implements Preview<RbForwardingRule> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileEditorView.class);
    private ForwardingRulePreviewPanel panel;
    private RbQoSPreview qoSPreview;

    public RbForwardingRulePreview() {
        this(new ForwardingRulePreviewPanel());
    }

    public RbForwardingRulePreview(ForwardingRulePreviewPanel panel) {
        this.panel = panel;
        this.initQoSPreview();
    }

    private void initQoSPreview() {
        this.qoSPreview = new RbQoSPreview(this.panel.getQoSPreviewPanel1());
    }

    public void setEntity(RbForwardingRule entity) {
        if (entity != null) {
            this.panel.getTxtName().setText(entity.getName());
            this.panel.getTxtType().setText(i18n.translateString(RbForwardingRule.toStringType(entity.getType())));
            if (entity.getType() != 2) {
                this.panel.getTxtUnicastRelaying().setText(i18n.translateString(RbForwardingRule.toStringUnicastRelaying(entity.getUnicastRelaying())));
                this.panel.getTxtMulticastRelaying().setText(i18n.translateString(RbForwardingRule.toStringMulticastRelaying(entity.getMulticastRelaying())));
                this.panel.getTxtUnknownAddressForwardingPolicy().setText(i18n.translateString(RbForwardingRule.toStringUnknownAddrPolicy(entity.getUnknownAddrPolicy())));
            }
            if (entity.getMulticastVLAN() != null) {
                this.panel.getTxtMulticastVLAN().setText(new Integer(4095).equals(entity.getMulticastVLAN()) ? i18n.translateString("None") : entity.getMulticastVLAN().toString());
            }
            this.qoSPreview.setEntity(entity.getQoS());
        }
    }

    public JComponent getUI() {
        return this.panel;
    }

    public boolean close() {
        return false;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return i18n.translateString("ForwardingRulePreview");
    }
}

