/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.Templates;
import com.bwanms.model.Template;
import com.bwanms.rb.gui.serviceprofiles.VoiceDomainEditor;
import com.bwanms.rb.model.services.RbBSPFServerGlobal;
import com.bwanms.rb.model.services.RbBSPFServerGlobalTemplate;
import com.bwanms.rb.model.services.RbVoiceDomainGlobal;
import com.bwanms.rb.model.services.RbVoiceDomainGlobalTemplate;
import com.bwanms.ui.components.TemplateNameDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class VoiceDomainEditorPanelController {
    public static final String BOGUS = "strBogus";
    private VoiceDomainEditor panel;

    public VoiceDomainEditorPanelController(VoiceDomainEditor panel) {
        this.panel = panel;
    }

    public void controlVPLIdSpnr() {
        if (((Integer)this.panel.getSpnrVLAN().getValue()).equals(4095)) {
            this.panel.getSpnrVLAN().setEnabled(false);
            this.panel.getCkbxVLAN().setSelected(true);
        }
    }

    public void controlVPLIdCkbx() {
        if (this.panel.getCkbxVLAN().isSelected()) {
            this.panel.getSpnrVLAN().setValue(4095);
            this.panel.getSpnrVLAN().setEnabled(false);
        } else {
            this.panel.getSpnrVLAN().setValue(0);
            this.panel.getSpnrVLAN().setEnabled(true);
        }
    }

    public void txtSharedSecretFocusGain() {
        if (!this.panel.getTxtRetypeSharedSecret().isEditable()) {
            this.panel.getTxtSharedSecret().setText("");
            this.panel.getTxtRetypeSharedSecret().setEditable(true);
            this.panel.getTxtRetypeSharedSecret().setText("");
        }
    }

    public void txtSharedSecretFocusLost() {
        if (this.panel.getTxtSharedSecret().getPassword().length == 0) {
            this.panel.getTxtRetypeSharedSecret().setEditable(false);
            this.panel.getTxtSharedSecret().setText(BOGUS);
            this.panel.getTxtRetypeSharedSecret().setText(BOGUS);
        }
    }

    public void importVoiceDomainTemplate() {
        SelectorView selectorView = Selectors.getSelectorView(RbVoiceDomainGlobalTemplate.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            RbVoiceDomainGlobalTemplate voiceDomainTemplate = (RbVoiceDomainGlobalTemplate)selection.get(0);
            this.applyVoiceDomainTemplate(voiceDomainTemplate);
        }
        Templates.updateListForClass(RbVoiceDomainGlobalTemplate.class);
    }

    public void saveAsVoiceDomainTemplate() {
        TemplateNameDialog dialog = new TemplateNameDialog((Frame)((JFrame)SwingUtilities.getWindowAncestor(this.panel)));
        RbVoiceDomainGlobal temp = new RbVoiceDomainGlobal();
        temp.setVoiceDomainName(this.panel.getTxtVoiceDomainName().getText());
        RbBSPFServerGlobal tempPFServer = new RbBSPFServerGlobal();
        tempPFServer.setIpAddress(this.panel.getTxtIpAddress().getText());
        tempPFServer.setPortNumber((Integer)this.panel.getSpnrUDPPort().getValue());
        tempPFServer.setPfVlan((Integer)this.panel.getSpnrVLAN().getValue());
        temp.setPrimaryPFServer(tempPFServer);
        RbVoiceDomainGlobalTemplate template = new RbVoiceDomainGlobalTemplate();
        template = template.createTemplateFromInstance(temp);
        dialog.setModal(true);
        dialog.setTemplate((Template)template);
        dialog.setLocationRelativeTo((Component)dialog.getParent());
        dialog.pack();
        dialog.setSize(300, 140);
        dialog.setVisible(true);
    }

    public void applyVoiceDomainTemplate(RbVoiceDomainGlobalTemplate template) {
        this.panel.getTxtVoiceDomainName().setText(template.getName());
        this.panel.getTxtIpAddress().setText(template.getRbBSPFServerValues().getIpAddress());
        this.panel.getSpnrUDPPort().setValue(template.getRbBSPFServerValues().getPortNumber());
        this.panel.getSpnrVLAN().setValue(template.getRbBSPFServerValues().getPfVlan());
    }

    public void importPFServerTemplate() {
        SelectorView selectorView = Selectors.getSelectorView(RbBSPFServerGlobalTemplate.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            RbBSPFServerGlobalTemplate pfServerTemplate = (RbBSPFServerGlobalTemplate)selection.get(0);
            this.applyPFServerTemplate(pfServerTemplate);
        }
        Templates.updateListForClass(RbBSPFServerGlobalTemplate.class);
    }

    public void saveAsPFServerTemplate() {
        TemplateNameDialog dialog = new TemplateNameDialog((Frame)((JFrame)SwingUtilities.getWindowAncestor(this.panel)));
        RbBSPFServerGlobal temp = new RbBSPFServerGlobal();
        temp.setIpAddress(this.panel.getTxtIpAddress().getText());
        temp.setPortNumber((Integer)this.panel.getSpnrUDPPort().getValue());
        temp.setPfVlan((Integer)this.panel.getSpnrVLAN().getValue());
        RbBSPFServerGlobalTemplate template = new RbBSPFServerGlobalTemplate();
        template = template.createTemplateFromInstance(temp);
        dialog.setModal(true);
        dialog.setTemplate((Template)template);
        dialog.setLocationRelativeTo((Component)dialog.getParent());
        dialog.pack();
        dialog.setSize(300, 140);
        dialog.setVisible(true);
    }

    public void applyPFServerTemplate(RbBSPFServerGlobalTemplate template) {
        this.panel.getTxtIpAddress().setText(template.getIpAddress());
        this.panel.getSpnrUDPPort().setValue(template.getPortNumber());
        this.panel.getSpnrVLAN().setValue(template.getPfVlan());
    }
}

