/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Templates;
import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.model.Equipment;
import com.bwanms.model.ServiceProfile;
import com.bwanms.rb.gui.serviceprofiles.BinderUtil;
import com.bwanms.rb.gui.serviceprofiles.ServiceProfileEditorTabbed;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbForwardingRuleTemplate;
import com.bwanms.rb.model.services.RbQoSProfileTemplate;
import com.bwanms.rb.model.services.RbVoIPServiceProfile;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoIPServiceProfileView
extends AbstractBindedEditorView<ServiceProfile> {
    Internationalizer i18n = Internationalizer.getInternationalizer(RbVoIPServiceProfile.class);
    ServiceProfileEditorTabbed panel;
    private AbstractBinder forwardingRuleQoSBinder;
    private AbstractBinder forwardingRuleBinder;

    public ServiceProfileEditorTabbed getUI() {
        if (this.panel == null) {
            this.panel = new ServiceProfileEditorTabbed();
            this.panel.getForwardingRuleEditor1().getComboType().addItem(new ComboItem((Object)1, this.i18n.translateString(RbForwardingRule.toStringType(1))));
            this.panel.getForwardingRuleEditor1().getComboType().addItem(new ComboItem((Object)3, this.i18n.translateString(RbForwardingRule.toStringType(3))));
        }
        return this.panel;
    }

    public String getTitle() {
        return this.i18n.translateString("VoIPServiceProfile");
    }

    public List<InvalidValue> configureEntity(ServiceProfile entity) {
        String frName;
        if (this.panel.getController().transparentModeSelected()) {
            this.forwardingRuleQoSBinder.setEnabled(false);
            this.forwardingRuleBinder.setEnabled(false);
            RbVoIPServiceProfile sp = (RbVoIPServiceProfile)entity;
            sp.getForwardingRule().makeNull();
        } else {
            this.forwardingRuleQoSBinder.setEnabled(true);
            this.forwardingRuleBinder.setEnabled(true);
        }
        List iValues = super.configureEntity((Serializable)entity);
        if (iValues != null && iValues.size() > 0) {
            this.panel.getForwardingRuleEditor1().validateTransparentFR(iValues);
        }
        if ("@@Transparent@@".equals((frName = this.getUI().getForwardingRuleEditor1().getTxtFRName().getText()).trim())) {
            iValues.add(new InvalidValue(this.i18n.translateString("TransparentCantBeDeployed"), JTextField.class, this.i18n.translateString("ForwardingRule"), (Object)frName, (Object)this.getUI().getForwardingRuleEditor1().getTxtFRName()));
        }
        return iValues;
    }

    public void fillUI(ServiceProfile entity) {
        RbVoIPServiceProfile serviceProfile = (RbVoIPServiceProfile)entity;
        this.panel.getTxtServiceProfileType().setText(this.i18n.translateString("rbVoIP(3)"));
        this.panel.getController().controlPriorityMarkingMode();
        this.panel.getController().controlVLANTransparencyMode();
        if (this.panel.getTabbedPane1().getTabCount() == 4) {
            this.panel.getTabbedPane1().removeTabAt(2);
        } else if (serviceProfile.getVLANTransparencyMode() != null && serviceProfile.getVLANTransparencyMode() == 1 && this.panel.getTabbedPane1().getTabCount() == 3) {
            this.panel.getTabbedPane1().removeTabAt(1);
        }
        this.panel.getForwardingRuleEditor1().getQoSProfileEditor().getController().manageParametersForType();
        this.panel.getForwardingRuleEditor1().getController().checkMulticast();
        if (serviceProfile.getId() > 0L) {
            EntityManagerTableModel<Equipment> model = this.panel.getDeploymentTabPanel1().getTableModel();
            List equipments = ServiceRegistry.getServiceManagementService().findServiceProfileInstances(serviceProfile.getId());
            model.clearTable();
            for (Equipment equipment : equipments) {
                model.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
        }
    }

    public List<Binder> getBinders() {
        Templates.updateListForClass(RbQoSProfileTemplate.class);
        Templates.updateListForClass(RbForwardingRuleTemplate.class);
        ArrayList<Binder> binders = new ArrayList<Binder>();
        RbVoIPServiceProfile serviceProfile = (RbVoIPServiceProfile)((Object)this.entity);
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtServiceProfileName", "serviceProfileName", this.i18n.translateString("serviceProfileName"))).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboPriorityMarkingMode", "priorityMarkingMode")).add((Binding)new JSpinnerBinding("spnrPriorityMarkingValue", "priorityMarkingValue", this.i18n.translateString("priorityMarkingValue"))).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboVLANTransparencyMode", "vLANTransparencyMode")).add((Binding)new JSpinnerBinding("spnrVPLId", "VPLId", this.i18n.translateString("VPLId"))).add((Binding)new JSpinnerBinding("spnrNoOfSimultaneousCalls", "maxNumberOfSimultaneousCalls", this.i18n.translateString("maxNumberOfSimultaneousCalls"))));
        this.forwardingRuleBinder = (AbstractBinder)new DefaultBinder((Object)this.panel.getForwardingRuleEditor1(), (Object)serviceProfile.getForwardingRule()).add((Binding)new JTextFieldBinding("txtFRName", "name", this.i18n.translateString("name"))).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboUnicastRelaying", "unicastRelaying")).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboUnknownAddressForwardingPolicy", "unknownAddrPolicy")).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboMulticasRelaying", "multicastRelaying")).add((Binding)new JComboBoxBinding(this.i18n, "comboType", "type")).add((Binding)new JSpinnerBinding("spnrMulticastVLAN", "multicastVLAN", this.i18n.translateString("multicastVLAN")));
        binders.add((Binder)this.forwardingRuleBinder);
        this.forwardingRuleQoSBinder = BinderUtil.bindQoS(this.panel.getForwardingRuleEditor1().getQoSProfileEditor(), serviceProfile.getForwardingRule().getQoS());
        binders.add((Binder)this.forwardingRuleQoSBinder);
        this.panel.getForwardingRuleEditor1().getController().setBinders((Binder)this.forwardingRuleBinder, (Binder)this.forwardingRuleQoSBinder);
        return binders;
    }

    public String getApplicationPermission() {
        return "Av:ConfigureSLA";
    }

    public String getHelpTopic() {
        return "ngnms.help.adding_editing_service_profile";
    }
}

