/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Templates;
import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.util.SortedTableModel;
import com.bwanms.model.Equipment;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.gui.serviceprofiles.BinderUtil;
import com.bwanms.rb.gui.serviceprofiles.ServiceProfileEditorTabbed;
import com.bwanms.rb.gui.serviceprofiles.VoiceDomainPreview;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbForwardingRuleTemplate;
import com.bwanms.rb.model.services.RbManagedVoIPServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbPolicyRuleTemplate;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbQoSProfileTemplate;
import com.bwanms.rb.model.services.RbVoIPServiceProfile;
import com.bwanms.rb.model.services.RbVoiceDomainGlobalTemplate;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbManagedVoIPServiceProfileView
extends AbstractBindedEditorView<RbManagedVoIPServiceProfile> {
    Internationalizer i18n = Internationalizer.getInternationalizer(RbManagedVoIPServiceProfile.class);
    private static final Logger logger = Logger.getLogger(RbManagedVoIPServiceProfileView.class);
    private ServiceProfileEditorTabbed panel;
    private AbstractBinder forwardingRuleQoSBinder;
    private AbstractBinder forwardingRuleBinder;
    private AbstractBinder policyRuleBinderDown;
    private AbstractBinder policyRuleBinderUp;
    private Binder policy;

    public ServiceProfileEditorTabbed getUI() {
        if (this.panel == null) {
            this.panel = new ServiceProfileEditorTabbed(true);
            this.panel.getForwardingRuleEditor1().getComboType().addItem(new ComboItem((Object)6, this.i18n.translateString(RbForwardingRule.toStringType(6))));
            this.panel.getBtnSelectVoiceDomain().addActionListener(new ActionListener(){
                private JDialog jDialog;
                private JOptionPane jOptionPane;
                private JTable jTable = new JTable();
                private JScrollPane jScrollPane = new JScrollPane(this.jTable);
                private DefaultTableModel defaultTableModel;
                private String[] options;
                {
                    this.defaultTableModel = new DefaultTableModel(new String[]{RbManagedVoIPServiceProfileView.this.i18n.translateString("VoiceDomainName")}, 0){
                        private static final long serialVersionUID = 1L;

                        public boolean isCellEditable(int row, int column) {
                            return false;
                        }
                    };
                    this.options = new String[]{RbManagedVoIPServiceProfileView.this.i18n.translateString("Select"), RbManagedVoIPServiceProfileView.this.i18n.translateString("Cancel")};
                    this.jTable.setModel((TableModel)new SortedTableModel((TableModel)this.defaultTableModel, this.jTable.getTableHeader()));
                    this.jTable.setSelectionMode(0);
                    this.jTable.addMouseListener(new MouseAdapter(){

                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() > 1 && e.getButton() == 1) {
                                jOptionPane.setValue(options[0]);
                                jDialog.setVisible(false);
                            }
                        }
                    });
                    this.jOptionPane = new JOptionPane(this.jScrollPane, -1, -1, null, this.options, this.options[0]);
                }

                public void actionPerformed(ActionEvent e) {
                    int selectedRow;
                    this.defaultTableModel.getDataVector().clear();
                    this.jTable.getSelectionModel().clearSelection();
                    List voiceDomainList = RbManagedVoIPServiceProfileView.getVoiceDomainList();
                    if (voiceDomainList != null) {
                        for (String name : voiceDomainList) {
                            this.defaultTableModel.addRow(new String[]{name});
                        }
                    }
                    if (this.jDialog == null) {
                        this.jDialog = this.jOptionPane.createDialog(RbManagedVoIPServiceProfileView.this.panel, RbManagedVoIPServiceProfileView.this.i18n.translateString("SelectVoiceDomain"));
                    }
                    this.jDialog.setVisible(true);
                    if (this.jOptionPane.getValue() == this.options[0] && (selectedRow = this.jTable.getSelectedRow()) != -1) {
                        RbManagedVoIPServiceProfileView.this.panel.getTxtVoiceDomain().setText((String)this.jTable.getValueAt(selectedRow, 0));
                    }
                }
            });
            this.panel.getDeploymentTabPanel1().getBtnPreviewVoiceDomain().addActionListener(new ActionListener(){
                private VoiceDomainPreview voiceDomainPreview = new VoiceDomainPreview();

                public void actionPerformed(ActionEvent e) {
                    int selectedRow = RbManagedVoIPServiceProfileView.this.panel.getDeploymentTabPanel1().getTblEquipment().getSelectedRow();
                    String voiceDomainName = RbManagedVoIPServiceProfileView.this.panel.getTxtVoiceDomain().getText();
                    if (selectedRow != -1) {
                        String euid = (String)RbManagedVoIPServiceProfileView.this.panel.getDeploymentTabPanel1().getTblEquipment().getValueAt(selectedRow, 2);
                        RbBSPFServersEntry rbBSPFServersEntry = RbManagedVoIPServiceProfileView.getRbBSPFServersEntry(euid, voiceDomainName);
                        if (rbBSPFServersEntry != null) {
                            this.voiceDomainPreview.getTxtVoiceDomainName().setText(voiceDomainName);
                            this.voiceDomainPreview.getTxtIpAddress().setText(rbBSPFServersEntry.getRbBSPFServerAddress());
                            this.voiceDomainPreview.getTxtUDPPort().setText(String.valueOf(rbBSPFServersEntry.getRbBSPFServerPortNumber()));
                            this.voiceDomainPreview.getTxtVlanId().setText(String.valueOf(rbBSPFServersEntry.getRbBSPFServerPFVlan()));
                            JOptionPane.showOptionDialog(RbManagedVoIPServiceProfileView.this.panel, this.voiceDomainPreview, RbManagedVoIPServiceProfileView.this.i18n.translateString("Preview"), -1, -1, null, new String[]{RbManagedVoIPServiceProfileView.this.i18n.translateString("ok")}, RbManagedVoIPServiceProfileView.this.i18n.translateString("ok"));
                        } else {
                            MessageBox.Info.quickShow((Component)RbManagedVoIPServiceProfileView.this.panel, RbManagedVoIPServiceProfileView.this.i18n.translateString("VoiceDomainNotFound", new Object[]{voiceDomainName, euid}));
                        }
                    } else {
                        MessageBox.Alert.quickShow((Component)RbManagedVoIPServiceProfileView.this.panel, RbManagedVoIPServiceProfileView.this.i18n.translateString("PleaseSelectABs"));
                    }
                }
            });
        }
        return this.panel;
    }

    private static List<String> getVoiceDomainList() {
        List voiceDomainList = null;
        try {
            LightQuery<String> q = new LightQuery<String>(String.class){

                public List<String> execute() {
                    String qry = "SELECT DISTINCT vd.rbVoiceDomainName FROM " + RbVoiceDomainsEntry.class.getName() + " AS vd";
                    List ret = Datastore.session().createQuery(qry).list();
                    return ret;
                }
            };
            voiceDomainList = ServiceRegistry.getEntityManagerService().retrieveByQuery((LightQuery)q);
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
        }
        return voiceDomainList;
    }

    private static RbBSPFServersEntry getRbBSPFServersEntry(final String euid, final String voiceDomainName) {
        try {
            LightQuery<RbBSPFServersEntry> q = new LightQuery<RbBSPFServersEntry>(RbBSPFServersEntry.class){

                public List<RbBSPFServersEntry> execute() {
                    String qry = "SELECT pf FROM " + RbVoiceDomainsEntry.class.getName() + " AS vd, " + RbBSPFServersEntry.class.getName() + " AS pf" + " WHERE vd.NRConfiguration.configuration.equipment.EUID = :euid" + " AND vd.rbVoiceDomainPrimaryPFIpAddress = pf.rbBSPFServerAddress" + " AND vd.rbVoiceDomainName = :voiceDomainName";
                    List ret = Datastore.session().createQuery(qry).setParameter("euid", (Object)euid).setParameter("voiceDomainName", (Object)voiceDomainName).list();
                    return ret;
                }
            };
            List pFServerList = ServiceRegistry.getEntityManagerService().retrieveByQuery((LightQuery)q);
            if (pFServerList != null && pFServerList.size() > 0) {
                return (RbBSPFServersEntry)((Object)pFServerList.get(0));
            }
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
        }
        return null;
    }

    public String getTitle() {
        return this.i18n.translateString("ManagedVoIPServiceProfile");
    }

    public List<InvalidValue> configureEntity(RbManagedVoIPServiceProfile entity) {
        String frName;
        if (this.panel.getController().transparentModeSelected()) {
            this.forwardingRuleQoSBinder.setEnabled(false);
            this.forwardingRuleBinder.setEnabled(false);
            entity.getForwardingRule().makeNull();
        } else {
            this.forwardingRuleQoSBinder.setEnabled(true);
            this.forwardingRuleBinder.setEnabled(true);
        }
        List iValues = super.configureEntity((Serializable)((Object)entity));
        entity.getPolicyRule().validateName(iValues, this.policy, this.i18n);
        entity.getForwardingRule().validateMulticastVLAN(iValues, (Binder)this.forwardingRuleBinder, this.i18n);
        ArrayList myValues = new ArrayList();
        ArrayList<InvalidValue> myInvalidValues1 = new ArrayList<InvalidValue>();
        entity.getPolicyRule().validatePolicyUpperLimitsDown(myInvalidValues1, this.i18n);
        ArrayList<InvalidValue> myInvalidValues2 = new ArrayList<InvalidValue>();
        entity.getPolicyRule().validatePolicyUpperLimitsUp(myInvalidValues2, this.i18n);
        this.policyRuleBinderDown.toUIInvalidValues(myValues, myInvalidValues1);
        this.policyRuleBinderUp.toUIInvalidValues(myValues, myInvalidValues2);
        iValues.addAll(myValues);
        Integer frType = entity.getForwardingRule().getType();
        if (null != frType && frType != 6) {
            iValues.add(new InvalidValue(this.i18n.translateString("TemplateTypeMismatch"), JComboBox.class, "type", (Object)frType, (Object)this.getUI().getForwardingRuleEditor1().getComboType()));
        }
        ArrayList<RbQoSProfile> qosList = new ArrayList<RbQoSProfile>();
        RbQoSProfile qosForwarding = entity.getForwardingRule().getQoS();
        if (!qosForwarding.isValueNull()) {
            qosList.add(qosForwarding);
        }
        qosList.add(entity.getPolicyRule().getDownQoSProfile1());
        qosList.add(entity.getPolicyRule().getDownQoSProfile2());
        qosList.add(entity.getPolicyRule().getDownQoSProfile3());
        qosList.add(entity.getPolicyRule().getDownQoSProfile4());
        qosList.add(entity.getPolicyRule().getUpQoSProfile1());
        qosList.add(entity.getPolicyRule().getUpQoSProfile2());
        qosList.add(entity.getPolicyRule().getUpQoSProfile3());
        qosList.add(entity.getPolicyRule().getUpQoSProfile4());
        if (entity.getVoiceDomainName() == null || entity.getVoiceDomainName().length() == 0) {
            iValues.add(new InvalidValue(this.i18n.translateString("PleaseAddAVoiceDomain"), JTextField.class, this.i18n.translateString("VoiceDomain"), (Object)"", (Object)this.getUI().getTxtVoiceDomain()));
        }
        if (iValues.isEmpty() && !this.checkQoSUnique(qosList).isEmpty()) {
            String qosNames = new String();
            for (RbQoSProfile qosProfile : this.checkQoSUnique(qosList)) {
                if (qosNames.equals("")) {
                    qosNames = qosNames + qosProfile.getName();
                    continue;
                }
                qosNames = qosNames + ", " + qosProfile.getName();
            }
            if (!FrameUtil.showConfirmation((Component)this.panel, (String)this.i18n.translateString("SameQoSProfiles", new Object[]{qosNames}))) {
                iValues.add(new InvalidValue(this.i18n.translateString("AbortedByUser"), RbPolicyRule.class, "QoSProfiles", (Object)"", null));
            }
        }
        if ("@@Transparent@@".equals((frName = this.getUI().getForwardingRuleEditor1().getTxtFRName().getText()).trim())) {
            iValues.add(new InvalidValue(this.i18n.translateString("TransparentCantBeDeployed"), JTextField.class, this.i18n.translateString("ForwardingRule"), (Object)frName, (Object)this.getUI().getForwardingRuleEditor1().getTxtFRName()));
        }
        return iValues;
    }

    public void fillUI(RbManagedVoIPServiceProfile entity) {
        this.panel.getTxtServiceProfileType().setText(this.i18n.translateString(entity.toStringRbServiceTemplateType()));
        this.panel.getController().controlPriorityMarkingMode();
        this.panel.getController().controlVLANTransparencyMode();
        this.panel.getForwardingRuleEditor1().getQoSProfileEditor().getController().manageParametersForType();
        this.panel.getForwardingRuleEditor1().getController().checkMulticast();
        this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().manageQoSLimitsAndType();
        this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().manageQoSLimitsAndType();
        this.panel.getPolicyRuleEditorH1().getController().checkForMatchingTemplate();
        if (entity.getId() > 0L) {
            EntityManagerTableModel<Equipment> model = this.panel.getDeploymentTabPanel1().getTableModel();
            List equipments = ServiceRegistry.getServiceManagementService().findServiceProfileInstances(entity.getId());
            model.clearTable();
            for (Equipment equipment : equipments) {
                model.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
        }
    }

    public List<Binder> getBinders() {
        Templates.updateListForClass(RbQoSProfileTemplate.class);
        Templates.updateListForClass(RbForwardingRuleTemplate.class);
        Templates.updateListForClass(RbPolicyRuleTemplate.class);
        Templates.updateListForClass(RbVoiceDomainGlobalTemplate.class);
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtServiceProfileName", "serviceProfileName", this.i18n.translateString("serviceProfileName"))).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboPriorityMarkingMode", "priorityMarkingMode", this.i18n.translateString("priorityMarkingMode"))).add((Binding)new JSpinnerBinding("spnrPriorityMarkingValue", "priorityMarkingValue", this.i18n.translateString("priorityMarkingValue"))).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboVLANTransparencyMode", "vLANTransparencyMode", this.i18n.translateString("vLANTransparencyMode"))).add((Binding)new JSpinnerBinding("spnrVPLId", "VPLId", this.i18n.translateString("VPLId"))).add((Binding)new JSpinnerBinding("spnrNoOfSimultaneousCalls", "maxNumberOfSimultaneousCalls", this.i18n.translateString("maxNumberOfSimultaneousCalls"))).add((Binding)new JTextFieldBinding("txtVoiceDomain", "voiceDomainName", this.i18n.translateString("VoiceDomainName"))));
        this.forwardingRuleBinder = (AbstractBinder)new DefaultBinder((Object)this.panel.getForwardingRuleEditor1(), (Object)((RbManagedVoIPServiceProfile)((Object)this.entity)).getForwardingRule()).add((Binding)new JTextFieldBinding("txtFRName", "name", this.i18n.translateString("name"))).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboUnicastRelaying", "unicastRelaying", this.i18n.translateString("unicastRelaying"))).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboUnknownAddressForwardingPolicy", "unknownAddrPolicy", this.i18n.translateString("unknownAddrPolicy"))).add((Binding)new JComboBoxBinding(Internationalizer.getInternationalizer(RbVoIPServiceProfile.class), "comboMulticasRelaying", "multicastRelaying", this.i18n.translateString("multicastRelaying"))).add((Binding)new JComboBoxBinding(this.i18n, "comboType", "type", this.i18n.translateString("type"))).add((Binding)new JSpinnerBinding("spnrMulticastVLAN", "multicastVLAN", this.i18n.translateString("multicastVLAN")));
        binders.add((Binder)this.forwardingRuleBinder);
        this.forwardingRuleQoSBinder = BinderUtil.bindQoS(this.panel.getForwardingRuleEditor1().getQoSProfileEditor(), ((RbManagedVoIPServiceProfile)((Object)this.entity)).getForwardingRule().getQoS());
        binders.add((Binder)this.forwardingRuleQoSBinder);
        this.panel.getForwardingRuleEditor1().getController().setBinders((Binder)this.forwardingRuleBinder, (Binder)this.forwardingRuleQoSBinder);
        AbstractBinder downQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH1(), ((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getDownQoSProfile1());
        binders.add((Binder)downQoS1);
        AbstractBinder downQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH2(), ((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getDownQoSProfile2());
        binders.add((Binder)downQoS2);
        AbstractBinder downQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH3(), ((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getDownQoSProfile3());
        binders.add((Binder)downQoS3);
        AbstractBinder downQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH4(), ((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getDownQoSProfile4());
        binders.add((Binder)downQoS4);
        AbstractBinder upQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH1(), ((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getUpQoSProfile1());
        binders.add((Binder)upQoS1);
        AbstractBinder upQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH2(), ((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getUpQoSProfile2());
        binders.add((Binder)upQoS2);
        AbstractBinder upQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH3(), ((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getUpQoSProfile3());
        binders.add((Binder)upQoS3);
        AbstractBinder upQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH4(), ((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getUpQoSProfile4());
        binders.add((Binder)upQoS4);
        this.policy = new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1(), (Object)((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule()).add((Binding)new JTextFieldBinding("txtPRName", "name", this.i18n.translateString("prName"))).add((Binding)new JComboBoxBinding(this.i18n, "comboPriorityType", "priorityType", this.i18n.translateString("priorityType")));
        binders.add(this.policy);
        this.policyRuleBinderDown = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2(), (Object)((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "downQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "downQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "downQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "downQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit4")));
        binders.add((Binder)this.policyRuleBinderDown);
        this.policyRuleBinderUp = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1(), (Object)((RbManagedVoIPServiceProfile)((Object)this.entity)).getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "upQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "upQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "upQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "upQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit4")));
        binders.add((Binder)this.policyRuleBinderUp);
        this.panel.getPolicyRuleEditorH1().getController().setBinders((Binder)downQoS1, (Binder)downQoS2, (Binder)downQoS3, (Binder)downQoS4, (Binder)upQoS1, (Binder)upQoS2, (Binder)upQoS3, (Binder)upQoS4, (Binder)this.policyRuleBinderUp, (Binder)this.policyRuleBinderDown, this.policy);
        return binders;
    }

    private List<RbQoSProfile> checkQoSUnique(List<RbQoSProfile> qosList) {
        ArrayList<RbQoSProfile> result = new ArrayList<RbQoSProfile>();
        for (int i = 0; i < qosList.size(); ++i) {
            for (int j = i + 1; j < qosList.size(); ++j) {
                if (!qosList.get(i).isNameEqual(qosList.get(j))) continue;
                if (!result.isEmpty()) {
                    boolean isUnique = true;
                    for (RbQoSProfile qosProfile : result) {
                        if (!qosProfile.getName().equalsIgnoreCase(qosList.get(i).getName())) continue;
                        isUnique = false;
                    }
                    if (!isUnique) continue;
                    result.add(qosList.get(i));
                    continue;
                }
                result.add(qosList.get(i));
            }
        }
        return result;
    }

    public String getApplicationPermission() {
        return "Av:ConfigureSLA";
    }

    public String getHelpTopic() {
        return "ngnms.help.adding_editing_service_profile";
    }
}

