/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Templates;
import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.gui.util.SortedTableModel;
import com.bwanms.model.Equipment;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.gui.serviceprofiles.BinderUtil;
import com.bwanms.rb.gui.serviceprofiles.ServiceProfileEditorTabbed;
import com.bwanms.rb.gui.serviceprofiles.VoiceDomainPreview;
import com.bwanms.rb.mo.RbBSPFServersEntry;
import com.bwanms.rb.mo.services.RbVoiceDomainsEntry;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbForwardingRuleTemplate;
import com.bwanms.rb.model.services.RbIPModeMngVoIPServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbPolicyRuleTemplate;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbQoSProfileTemplate;
import com.bwanms.rb.model.services.RbVoiceDomainGlobalTemplate;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbIpModeManagedVoIPServiceProfileView
extends AbstractBindedEditorView<RbIPModeMngVoIPServiceProfile> {
    Internationalizer i18n = Internationalizer.getInternationalizer(RbIPModeMngVoIPServiceProfile.class);
    private static final Logger logger = Logger.getLogger(RbIpModeManagedVoIPServiceProfileView.class);
    private ServiceProfileEditorTabbed panel;
    private AbstractBinder forwardingRuleQoSBinder;
    private AbstractBinder policyRuleBinderDown;
    private AbstractBinder policyRuleBinderUp;
    private Binder policy;

    public ServiceProfileEditorTabbed getUI() {
        if (this.panel == null) {
            this.panel = new ServiceProfileEditorTabbed(true);
            this.panel.getForwardingRuleEditor1().getComboType().addItem(new ComboItem((Object)7, this.i18n.translateString(RbForwardingRule.toStringType(7))));
            this.panel.getBtnSelectVoiceDomain().addActionListener(new ActionListener(){
                private JDialog jDialog;
                private JOptionPane jOptionPane;
                private JTable jTable = new JTable();
                private JScrollPane jScrollPane = new JScrollPane(this.jTable);
                private DefaultTableModel defaultTableModel;
                private String[] options;
                {
                    this.defaultTableModel = new DefaultTableModel(new String[]{RbIpModeManagedVoIPServiceProfileView.this.i18n.translateString("VoiceDomainName")}, 0){
                        private static final long serialVersionUID = 1L;

                        public boolean isCellEditable(int row, int column) {
                            return false;
                        }
                    };
                    this.options = new String[]{RbIpModeManagedVoIPServiceProfileView.this.i18n.translateString("Select"), RbIpModeManagedVoIPServiceProfileView.this.i18n.translateString("Cancel")};
                    this.jTable.setModel((TableModel)new SortedTableModel((TableModel)this.defaultTableModel, this.jTable.getTableHeader()));
                    this.jTable.setSelectionMode(0);
                    this.jTable.addMouseListener(new MouseAdapter(){

                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() > 1 && e.getButton() == 1) {
                                jOptionPane.setValue(options[0]);
                                jDialog.setVisible(false);
                            }
                        }
                    });
                    this.jOptionPane = new JOptionPane(this.jScrollPane, -1, -1, null, this.options, this.options[0]);
                }

                public void actionPerformed(ActionEvent e) {
                    int selectedRow;
                    this.defaultTableModel.getDataVector().clear();
                    this.jTable.getSelectionModel().clearSelection();
                    List voiceDomainList = RbIpModeManagedVoIPServiceProfileView.getVoiceDomainList();
                    if (voiceDomainList != null) {
                        for (String name : voiceDomainList) {
                            this.defaultTableModel.addRow(new String[]{name});
                        }
                    }
                    if (this.jDialog == null) {
                        this.jDialog = this.jOptionPane.createDialog(RbIpModeManagedVoIPServiceProfileView.this.panel, RbIpModeManagedVoIPServiceProfileView.this.i18n.translateString("SelectVoiceDomain"));
                    }
                    this.jDialog.setVisible(true);
                    if (this.jOptionPane.getValue() == this.options[0] && (selectedRow = this.jTable.getSelectedRow()) != -1) {
                        RbIpModeManagedVoIPServiceProfileView.this.panel.getTxtVoiceDomain().setText((String)this.jTable.getValueAt(selectedRow, 0));
                    }
                }
            });
            this.panel.getDeploymentTabPanel1().getBtnPreviewVoiceDomain().addActionListener(new ActionListener(){
                private VoiceDomainPreview voiceDomainPreview = new VoiceDomainPreview();

                public void actionPerformed(ActionEvent e) {
                    int selectedRow = RbIpModeManagedVoIPServiceProfileView.this.panel.getDeploymentTabPanel1().getTblEquipment().getSelectedRow();
                    String voiceDomainName = RbIpModeManagedVoIPServiceProfileView.this.panel.getTxtVoiceDomain().getText();
                    if (selectedRow != -1) {
                        String euid = (String)RbIpModeManagedVoIPServiceProfileView.this.panel.getDeploymentTabPanel1().getTblEquipment().getValueAt(selectedRow, 2);
                        RbBSPFServersEntry rbBSPFServersEntry = RbIpModeManagedVoIPServiceProfileView.getRbBSPFServersEntry(euid, voiceDomainName);
                        if (rbBSPFServersEntry != null) {
                            this.voiceDomainPreview.getTxtVoiceDomainName().setText(voiceDomainName);
                            this.voiceDomainPreview.getTxtIpAddress().setText(rbBSPFServersEntry.getRbBSPFServerAddress());
                            this.voiceDomainPreview.getTxtUDPPort().setText(String.valueOf(rbBSPFServersEntry.getRbBSPFServerPortNumber()));
                            this.voiceDomainPreview.getTxtVlanId().setText(String.valueOf(rbBSPFServersEntry.getRbBSPFServerPFVlan()));
                            JOptionPane.showOptionDialog(RbIpModeManagedVoIPServiceProfileView.this.panel, this.voiceDomainPreview, RbIpModeManagedVoIPServiceProfileView.this.i18n.translateString("Preview"), -1, -1, null, new String[]{RbIpModeManagedVoIPServiceProfileView.this.i18n.translateString("ok")}, RbIpModeManagedVoIPServiceProfileView.this.i18n.translateString("ok"));
                        } else {
                            MessageBox.Info.quickShow((Component)RbIpModeManagedVoIPServiceProfileView.this.panel, RbIpModeManagedVoIPServiceProfileView.this.i18n.translateString("VoiceDomainNotFound", new Object[]{voiceDomainName, euid}));
                        }
                    } else {
                        MessageBox.Alert.quickShow((Component)RbIpModeManagedVoIPServiceProfileView.this.panel, RbIpModeManagedVoIPServiceProfileView.this.i18n.translateString("PleaseSelectABs"));
                    }
                }
            });
        }
        return this.panel;
    }

    private static List<String> getVoiceDomainList() {
        List voiceDomainList = null;
        try {
            LightQuery<String> q = new LightQuery<String>(String.class){

                public List<String> execute() {
                    String qry = "SELECT DISTINCT vd.rbVoiceDomainName FROM " + RbVoiceDomainsEntry.class.getName() + " AS vd";
                    List ret = Datastore.session().createQuery(qry).list();
                    return ret;
                }
            };
            voiceDomainList = ServiceRegistry.getEntityManagerService().retrieveByQuery((LightQuery)q);
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
        }
        return voiceDomainList;
    }

    private static RbBSPFServersEntry getRbBSPFServersEntry(final String euid, final String voiceDomainName) {
        try {
            LightQuery<RbBSPFServersEntry> q = new LightQuery<RbBSPFServersEntry>(RbBSPFServersEntry.class){

                public List<RbBSPFServersEntry> execute() {
                    String qry = "SELECT pf FROM " + RbVoiceDomainsEntry.class.getName() + " AS vd, " + RbBSPFServersEntry.class.getName() + " AS pf" + " WHERE vd.NRConfiguration.configuration.equipment.EUID = :euid" + " AND vd.rbVoiceDomainPrimaryPFIpAddress = pf.rbBSPFServerAddress" + " AND vd.rbVoiceDomainName = :voiceDomainName";
                    List ret = Datastore.session().createQuery(qry).setParameter("euid", (Object)euid).setParameter("voiceDomainName", (Object)voiceDomainName).list();
                    return ret;
                }
            };
            List pFServerList = ServiceRegistry.getEntityManagerService().retrieveByQuery((LightQuery)q);
            if (pFServerList != null && pFServerList.size() > 0) {
                return (RbBSPFServersEntry)((Object)pFServerList.get(0));
            }
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
        }
        return null;
    }

    public String getTitle() {
        return this.i18n.translateString("IPModeMngVoIPServiceProfile");
    }

    public List<InvalidValue> configureEntity(RbIPModeMngVoIPServiceProfile entity) {
        List iValues = super.configureEntity((Serializable)((Object)entity));
        entity.getPolicyRule().validateName(iValues, this.policy, this.i18n);
        ArrayList myValues = new ArrayList();
        ArrayList<InvalidValue> myInvalidValues1 = new ArrayList<InvalidValue>();
        entity.getPolicyRule().validatePolicyUpperLimitsDown(myInvalidValues1, this.i18n);
        ArrayList<InvalidValue> myInvalidValues2 = new ArrayList<InvalidValue>();
        entity.getPolicyRule().validatePolicyUpperLimitsUp(myInvalidValues2, this.i18n);
        this.policyRuleBinderDown.toUIInvalidValues(myValues, myInvalidValues1);
        this.policyRuleBinderUp.toUIInvalidValues(myValues, myInvalidValues2);
        iValues.addAll(myValues);
        Integer frType = entity.getForwardingRule().getType();
        if (null != frType && frType != 7) {
            iValues.add(new InvalidValue(this.i18n.translateString("TemplateTypeMismatch"), JComboBox.class, "type", (Object)frType, (Object)this.getUI().getForwardingRuleEditor1().getComboType()));
        }
        ArrayList<RbQoSProfile> qosList = new ArrayList<RbQoSProfile>();
        RbQoSProfile qosForwarding = entity.getForwardingRule().getQoS();
        if (!qosForwarding.isValueNull()) {
            qosList.add(qosForwarding);
        }
        qosList.add(entity.getPolicyRule().getDownQoSProfile1());
        qosList.add(entity.getPolicyRule().getDownQoSProfile2());
        qosList.add(entity.getPolicyRule().getDownQoSProfile3());
        qosList.add(entity.getPolicyRule().getDownQoSProfile4());
        qosList.add(entity.getPolicyRule().getUpQoSProfile1());
        qosList.add(entity.getPolicyRule().getUpQoSProfile2());
        qosList.add(entity.getPolicyRule().getUpQoSProfile3());
        qosList.add(entity.getPolicyRule().getUpQoSProfile4());
        if (iValues.isEmpty() && !this.checkQoSUnique(qosList).isEmpty()) {
            String qosNames = new String();
            for (RbQoSProfile qosProfile : this.checkQoSUnique(qosList)) {
                if (qosNames.equals("")) {
                    qosNames = qosNames + qosProfile.getName();
                    continue;
                }
                qosNames = qosNames + ", " + qosProfile.getName();
            }
            if (!FrameUtil.showConfirmation((Component)this.panel, (String)this.i18n.translateString("SameQoSProfiles", new Object[]{qosNames}))) {
                iValues.add(new InvalidValue(this.i18n.translateString("AbortedByUser"), RbPolicyRule.class, "QoSProfiles", (Object)"", null));
            }
        }
        return iValues;
    }

    public void fillUI(RbIPModeMngVoIPServiceProfile entity) {
        this.panel.getTxtServiceProfileType().setText(this.i18n.translateString(entity.toStringRbServiceTemplateType()));
        this.panel.getController().controlPriorityMarkingMode();
        this.panel.getController().controlVLANTransparencyMode();
        this.panel.getPolicyRuleEditorH1().setType(7);
        if (entity.getVLANTransparencyMode() != null && entity.getVLANTransparencyMode() == 1 && this.panel.getTabbedPane1().getTabCount() == 3) {
            this.panel.getTabbedPane1().removeTabAt(1);
        }
        this.panel.getComboVLANTransparencyMode().setVisible(false);
        this.panel.getLblVLANTransparencyMode().setVisible(false);
        this.panel.getSpnrVPLId().setVisible(false);
        this.panel.getLblVPLID().setVisible(false);
        this.panel.getComboPriorityMarkingMode().setVisible(false);
        this.panel.getLblPriorityMarkingMode().setVisible(false);
        this.panel.getSpnrPriorityMarkingValue().setVisible(false);
        this.panel.getLblPriorityMarkingValue().setVisible(false);
        this.panel.getCkbxNoneVPLId().setVisible(false);
        this.panel.getForwardingRuleEditor1().getSpnrMulticastVLAN().setVisible(false);
        this.panel.getForwardingRuleEditor1().getLblMulticastVLAN().setVisible(false);
        this.panel.getForwardingRuleEditor1().getCkbxMulticastVLAN().setVisible(false);
        this.panel.getForwardingRuleEditor1().getQoSProfileEditor().getController().manageParametersForType();
        this.panel.getForwardingRuleEditor1().getController().checkMulticast();
        this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().manageQoSLimitsAndType();
        this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().manageQoSLimitsAndType();
        this.panel.getPolicyRuleEditorH1().getController().checkForMatchingTemplate();
        this.panel.getPolicyRuleEditorH1().remove8021pPriorityType();
        this.panel.getTabbedPane1().removeTabAt(1);
        if (entity.getId() > 0L) {
            EntityManagerTableModel<Equipment> model = this.panel.getDeploymentTabPanel1().getTableModel();
            List equipments = ServiceRegistry.getServiceManagementService().findServiceProfileInstances(entity.getId());
            model.clearTable();
            for (Equipment equipment : equipments) {
                model.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
        }
    }

    public List<Binder> getBinders() {
        Templates.updateListForClass(RbQoSProfileTemplate.class);
        Templates.updateListForClass(RbForwardingRuleTemplate.class);
        Templates.updateListForClass(RbPolicyRuleTemplate.class);
        Templates.updateListForClass(RbVoiceDomainGlobalTemplate.class);
        ArrayList<Binder> binders = new ArrayList<Binder>();
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtServiceProfileName", "serviceProfileName", this.i18n.translateString("serviceProfileName"))).add((Binding)new JSpinnerBinding("spnrNoOfSimultaneousCalls", "maxNumberOfSimultaneousCalls", this.i18n.translateString("maxNumberOfSimultaneousCalls"))).add((Binding)new JTextFieldBinding("txtVoiceDomain", "voiceDomainName", this.i18n.translateString("VoiceDomainName"))));
        AbstractBinder downQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH1(), ((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getDownQoSProfile1());
        binders.add((Binder)downQoS1);
        AbstractBinder downQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH2(), ((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getDownQoSProfile2());
        binders.add((Binder)downQoS2);
        AbstractBinder downQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH3(), ((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getDownQoSProfile3());
        binders.add((Binder)downQoS3);
        AbstractBinder downQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH4(), ((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getDownQoSProfile4());
        binders.add((Binder)downQoS4);
        AbstractBinder upQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH1(), ((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getUpQoSProfile1());
        binders.add((Binder)upQoS1);
        AbstractBinder upQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH2(), ((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getUpQoSProfile2());
        binders.add((Binder)upQoS2);
        AbstractBinder upQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH3(), ((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getUpQoSProfile3());
        binders.add((Binder)upQoS3);
        AbstractBinder upQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH4(), ((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule().getUpQoSProfile4());
        binders.add((Binder)upQoS4);
        this.policy = new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1(), (Object)((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule()).add((Binding)new JTextFieldBinding("txtPRName", "name", this.i18n.translateString("prName"))).add((Binding)new JComboBoxBinding(this.i18n, "comboPriorityType", "priorityType", this.i18n.translateString("priorityType")));
        binders.add(this.policy);
        this.policyRuleBinderDown = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2(), (Object)((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "downQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "downQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "downQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "downQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit4")));
        binders.add((Binder)this.policyRuleBinderDown);
        this.policyRuleBinderUp = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1(), (Object)((RbIPModeMngVoIPServiceProfile)((Object)this.entity)).getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "upQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "upQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "upQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "upQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit4")));
        binders.add((Binder)this.policyRuleBinderUp);
        this.panel.getPolicyRuleEditorH1().getController().setBinders((Binder)downQoS1, (Binder)downQoS2, (Binder)downQoS3, (Binder)downQoS4, (Binder)upQoS1, (Binder)upQoS2, (Binder)upQoS3, (Binder)upQoS4, (Binder)this.policyRuleBinderUp, (Binder)this.policyRuleBinderDown, this.policy);
        return binders;
    }

    private List<RbQoSProfile> checkQoSUnique(List<RbQoSProfile> qosList) {
        ArrayList<RbQoSProfile> result = new ArrayList<RbQoSProfile>();
        for (int i = 0; i < qosList.size(); ++i) {
            for (int j = i + 1; j < qosList.size(); ++j) {
                if (!qosList.get(i).isNameEqual(qosList.get(j))) continue;
                if (!result.isEmpty()) {
                    boolean isUnique = true;
                    for (RbQoSProfile qosProfile : result) {
                        if (!qosProfile.getName().equalsIgnoreCase(qosList.get(i).getName())) continue;
                        isUnique = false;
                    }
                    if (!isUnique) continue;
                    result.add(qosList.get(i));
                    continue;
                }
                result.add(qosList.get(i));
            }
        }
        return result;
    }

    public String getApplicationPermission() {
        return "Av:ConfigureSLA";
    }

    public String getHelpTopic() {
        return "ngnms.help.adding_editing_service_profile";
    }
}

