/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.model.Equipment;
import com.bwanms.model.ServiceProfile;
import com.bwanms.rb.gui.serviceprofiles.BinderUtil;
import com.bwanms.rb.gui.serviceprofiles.PolicyRuleEditorH;
import com.bwanms.rb.gui.serviceprofiles.PolicyRuleEditorHPart;
import com.bwanms.rb.gui.serviceprofiles.ServiceProfileEditorTabbed;
import com.bwanms.rb.model.services.RbIPModeVoIPServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FrameUtil;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbIPModeVoIPServiceProfileView
extends AbstractBindedEditorView<ServiceProfile> {
    Internationalizer i18n = Internationalizer.getInternationalizer(RbIPModeVoIPServiceProfile.class);
    ServiceProfileEditorTabbed panel = new ServiceProfileEditorTabbed();
    private AbstractBinder policyRuleBinderDown;
    private AbstractBinder policyRuleBinderUp;
    private Binder policy;

    public ServiceProfileEditorTabbed getUI() {
        return this.panel;
    }

    public String getTitle() {
        return this.i18n.translateString("IPModeVoIPServiceProfile");
    }

    public List<InvalidValue> configureEntity(ServiceProfile entity) {
        RbIPModeVoIPServiceProfile ipModeVoIP = (RbIPModeVoIPServiceProfile)entity;
        List iValues = super.configureEntity((Serializable)entity);
        RbIPModeVoIPServiceProfile serviceProfile = (RbIPModeVoIPServiceProfile)entity;
        RbPolicyRule policyRule = serviceProfile.getPolicyRule();
        if (policyRule.getPriorityType() != 1) {
            iValues.add(new InvalidValue(this.i18n.translateString("UnknownPriorityType", new Object[]{this.i18n.translateString(RbPolicyRule.toStringPriorityType(1))}), JComboBox.class, "priorityType", (Object)this.i18n.translateString(RbPolicyRule.toStringPriorityType(policyRule.getPriorityType())), (Object)this.getUI().getPolicyRuleEditorH1().getComboPriorityType()));
        }
        policyRule.validateName(iValues, this.policy, this.i18n);
        ArrayList myValues = new ArrayList();
        ArrayList<InvalidValue> myInvalidValues1 = new ArrayList<InvalidValue>();
        ipModeVoIP.getPolicyRule().validatePolicyUpperLimitsDown(myInvalidValues1, this.i18n);
        ArrayList<InvalidValue> myInvalidValues2 = new ArrayList<InvalidValue>();
        ipModeVoIP.getPolicyRule().validatePolicyUpperLimitsUp(myInvalidValues2, this.i18n);
        this.policyRuleBinderDown.toUIInvalidValues(myValues, myInvalidValues1);
        this.policyRuleBinderUp.toUIInvalidValues(myValues, myInvalidValues2);
        iValues.addAll(myValues);
        ArrayList<RbQoSProfile> qosList = new ArrayList<RbQoSProfile>();
        RbQoSProfile qosForwarding = serviceProfile.getForwardingRule().getQoS();
        if (!qosForwarding.isValueNull()) {
            qosList.add(qosForwarding);
        }
        qosList.add(policyRule.getDownQoSProfile1());
        qosList.add(policyRule.getDownQoSProfile2());
        qosList.add(policyRule.getDownQoSProfile3());
        qosList.add(policyRule.getDownQoSProfile4());
        qosList.add(policyRule.getUpQoSProfile1());
        qosList.add(policyRule.getUpQoSProfile2());
        qosList.add(policyRule.getUpQoSProfile3());
        qosList.add(policyRule.getUpQoSProfile4());
        if (iValues.isEmpty() && !this.checkQoSUnique(qosList).isEmpty()) {
            String qosNames = new String();
            for (RbQoSProfile qosProfile : this.checkQoSUnique(qosList)) {
                if (qosNames.equals("")) {
                    qosNames = qosNames + qosProfile.getName();
                    continue;
                }
                qosNames = qosNames + ", " + qosProfile.getName();
            }
            if (!FrameUtil.showConfirmation((Component)this.panel, (String)this.i18n.translateString("SameQoSProfiles", new Object[]{qosNames}))) {
                iValues.add(new InvalidValue(this.i18n.translateString("AbortedByUser"), RbPolicyRule.class, "QoSProfiles", (Object)"", null));
            }
        }
        return iValues;
    }

    private List<RbQoSProfile> checkQoSUnique(List<RbQoSProfile> qosList) {
        ArrayList<RbQoSProfile> result = new ArrayList<RbQoSProfile>();
        for (int i = 0; i < qosList.size(); ++i) {
            for (int j = i + 1; j < qosList.size(); ++j) {
                if (!qosList.get(i).isNameEqual(qosList.get(j))) continue;
                if (!result.isEmpty()) {
                    boolean isUnique = true;
                    for (RbQoSProfile qosProfile : result) {
                        if (!qosProfile.getName().equalsIgnoreCase(qosList.get(i).getName())) continue;
                        isUnique = false;
                    }
                    if (!isUnique) continue;
                    result.add(qosList.get(i));
                    continue;
                }
                result.add(qosList.get(i));
            }
        }
        return result;
    }

    public void fillUI(ServiceProfile entity) {
        PolicyRuleEditorH policyRuleEditorH1 = this.panel.getPolicyRuleEditorH1();
        this.panel.getPolicyRuleEditorH1().remove8021pPriorityType();
        policyRuleEditorH1.setType(5);
        Integer rbServiceTemplateType = ((RbServiceProfile)entity).rbServiceTemplateType();
        PolicyRuleEditorHPart policyRuleEditorHPart1 = policyRuleEditorH1.getPolicyRuleEditorHPart1();
        PolicyRuleEditorHPart policyRuleEditorHPart2 = policyRuleEditorH1.getPolicyRuleEditorHPart2();
        this.configQosProfileEditorControler(rbServiceTemplateType, policyRuleEditorHPart1, policyRuleEditorHPart2);
        RbIPModeVoIPServiceProfile serviceProfile = (RbIPModeVoIPServiceProfile)entity;
        this.panel.getTxtServiceProfileType().setText(this.i18n.translateString("rbIPModeVoIP(5)"));
        if (this.panel.getTabbedPane1().getTabCount() == 4) {
            this.panel.getTabbedPane1().removeTabAt(0);
            this.panel.getTabbedPane1().removeTabAt(0);
        }
        policyRuleEditorH1.getPolicyRuleEditorHPart1().manageQoSLimitsAndType();
        policyRuleEditorH1.getPolicyRuleEditorHPart2().manageQoSLimitsAndType();
        policyRuleEditorH1.getController().checkForMatchingTemplate();
        if (serviceProfile.getId() > 0L) {
            EntityManagerTableModel<Equipment> model = this.panel.getDeploymentTabPanel1().getTableModel();
            List equipments = ServiceRegistry.getServiceManagementService().findServiceProfileInstances(serviceProfile.getId());
            model.clearTable();
            for (Equipment equipment : equipments) {
                model.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
        }
    }

    private void configQosProfileEditorControler(Integer rbServiceTemplateType, PolicyRuleEditorHPart policyRuleEditorHPart1, PolicyRuleEditorHPart policyRuleEditorHPart2) {
        policyRuleEditorHPart1.getQoSProfileEditorH1().getController().setServiceProfileType(rbServiceTemplateType);
        policyRuleEditorHPart1.getQoSProfileEditorH2().getController().setServiceProfileType(rbServiceTemplateType);
        policyRuleEditorHPart1.getQoSProfileEditorH3().getController().setServiceProfileType(rbServiceTemplateType);
        policyRuleEditorHPart1.getQoSProfileEditorH4().getController().setServiceProfileType(rbServiceTemplateType);
        policyRuleEditorHPart2.getQoSProfileEditorH1().getController().setServiceProfileType(rbServiceTemplateType);
        policyRuleEditorHPart2.getQoSProfileEditorH2().getController().setServiceProfileType(rbServiceTemplateType);
        policyRuleEditorHPart2.getQoSProfileEditorH3().getController().setServiceProfileType(rbServiceTemplateType);
        policyRuleEditorHPart2.getQoSProfileEditorH4().getController().setServiceProfileType(rbServiceTemplateType);
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        RbIPModeVoIPServiceProfile serviceProfile = (RbIPModeVoIPServiceProfile)((Object)this.entity);
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtServiceProfileName", "serviceProfileName", this.i18n.translateString("serviceProfileName"))));
        AbstractBinder downQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH1(), serviceProfile.getPolicyRule().getDownQoSProfile1());
        binders.add((Binder)downQoS1);
        AbstractBinder downQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH2(), serviceProfile.getPolicyRule().getDownQoSProfile2());
        binders.add((Binder)downQoS2);
        AbstractBinder downQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH3(), serviceProfile.getPolicyRule().getDownQoSProfile3());
        binders.add((Binder)downQoS3);
        AbstractBinder downQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH4(), serviceProfile.getPolicyRule().getDownQoSProfile4());
        binders.add((Binder)downQoS4);
        AbstractBinder upQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH1(), serviceProfile.getPolicyRule().getUpQoSProfile1());
        binders.add((Binder)upQoS1);
        AbstractBinder upQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH2(), serviceProfile.getPolicyRule().getUpQoSProfile2());
        binders.add((Binder)upQoS2);
        AbstractBinder upQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH3(), serviceProfile.getPolicyRule().getUpQoSProfile3());
        binders.add((Binder)upQoS3);
        AbstractBinder upQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH4(), serviceProfile.getPolicyRule().getUpQoSProfile4());
        binders.add((Binder)upQoS4);
        this.policy = new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1(), (Object)serviceProfile.getPolicyRule()).add((Binding)new JTextFieldBinding("txtPRName", "name", this.i18n.translateString("prName"))).add((Binding)new JComboBoxBinding(this.i18n, "comboPriorityType", "priorityType", this.i18n.translateString("priorityType")));
        binders.add(this.policy);
        this.policyRuleBinderDown = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2(), (Object)serviceProfile.getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "downQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "downQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "downQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "downQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit4")));
        binders.add((Binder)this.policyRuleBinderDown);
        this.policyRuleBinderUp = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1(), (Object)serviceProfile.getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "upQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "upQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "upQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "upQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit4")));
        binders.add((Binder)this.policyRuleBinderUp);
        this.panel.getPolicyRuleEditorH1().getController().setBinders((Binder)downQoS1, (Binder)downQoS2, (Binder)downQoS3, (Binder)downQoS4, (Binder)upQoS1, (Binder)upQoS2, (Binder)upQoS3, (Binder)upQoS4, (Binder)this.policyRuleBinderUp, (Binder)this.policyRuleBinderDown, this.policy);
        return binders;
    }

    public String getApplicationPermission() {
        return "Av:ConfigureSLA";
    }

    public String getHelpTopic() {
        return "ngnms.help.adding_editing_service_profile";
    }
}

