/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.Templates;
import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.model.Template;
import com.bwanms.rb.gui.serviceprofiles.QoSProfileEditorH;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbQoSProfileTemplate;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.TemplateNameDialog;
import com.bwanms.util.FormUtil;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QoSProfileEditorController
implements EntitiesSelectedCallback {
    private QoSProfileEditorH panel;
    private Internationalizer i18n = Internationalizer.getInternationalizer(RbQoSProfile.class);
    private JFrame selectorFrame;
    private AbstractBinder binder;
    private int serviceProfileType;
    private List<ComboItem> removableItems = new ArrayList<ComboItem>();

    public QoSProfileEditorController(QoSProfileEditorH editorH) {
        this.panel = editorH;
    }

    public void manageParametersForType() {
        int selType;
        Integer integerType = (Integer)FormUtil.getSelectedValue((JComboBox)this.panel.getComboQoSType());
        int n = selType = integerType == null ? -1 : integerType;
        if (!this.panel.isCtVisible()) {
            this.panel.setCTVisible(true);
        }
        this.panel.getTxtParam1().setEnabled(true);
        this.panel.getTxtParam2().setEnabled(true);
        switch (selType) {
            case 0: {
                this.panel.setCTVisible(false);
                this.panel.getLblParam1().setText(this.i18n.translateString("PS"));
                this.panel.getLblParam2().setText(this.i18n.translateString("SI"));
                this.resolveComboCt(0, this.getServiceProfileType(), this.panel.getComboCT());
                break;
            }
            case 1: {
                this.panel.getLblParam1().setText(this.i18n.translateString("CIR"));
                this.panel.getLblParam2().setText(this.i18n.translateString("MIR"));
                this.panel.getTxtParam2().setEnabled(false);
                this.panel.getTxtParam2().setText("");
                this.resolveComboCt(1, this.getServiceProfileType(), this.panel.getComboCT());
                break;
            }
            case 2: {
                this.panel.getLblParam1().setText(this.i18n.translateString("CIR"));
                this.panel.getLblParam2().setText(this.i18n.translateString("MIR"));
                this.resolveComboCt(2, this.getServiceProfileType(), this.panel.getComboCT());
                break;
            }
            case 3: {
                this.panel.getLblParam1().setText(this.i18n.translateString("CIR"));
                this.panel.getLblParam2().setText(this.i18n.translateString("MIR"));
                this.panel.getTxtParam1().setEnabled(false);
                this.resolveComboCt(3, this.getServiceProfileType(), this.panel.getComboCT());
                this.panel.getTxtParam1().setText("");
            }
        }
        this.checkForMatchingTemplate();
    }

    private void resolveComboCt(int qOsType, int spType, JComboBox comboCT) {
        block3: {
            block2: {
                if (qOsType != 1 && qOsType != 2) break block2;
                for (ComboItem ci : this.removableItems) {
                    if (((DefaultComboBoxModel)this.panel.getComboCT().getModel()).getIndexOf(ci) >= 0) continue;
                    this.panel.getComboCT().addItem(ci);
                }
                break block3;
            }
            if (qOsType != 3 || spType != 4 && spType != 5) break block3;
            for (ComboItem ci : this.removableItems) {
                this.panel.getComboCT().removeItem(ci);
            }
        }
    }

    public void importTemplate() {
        SelectorView selectorView = Selectors.getSelectorView(RbQoSProfileTemplate.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            RbQoSProfileTemplate qosTemplate = (RbQoSProfileTemplate)selection.get(0);
            this.applyTemplate(qosTemplate);
        }
        Templates.updateListForClass(RbQoSProfileTemplate.class);
        this.checkForMatchingTemplate();
    }

    public void saveAsTemplate() {
        TemplateNameDialog dialog = new TemplateNameDialog((Frame)((JFrame)SwingUtilities.getWindowAncestor(this.panel)));
        RbQoSProfile temp = new RbQoSProfile();
        this.binder.fillBeanFromUI((Object)temp);
        RbQoSProfileTemplate template = new RbQoSProfileTemplate();
        template = template.createTemplateFromInstance(temp);
        dialog.setModal(true);
        dialog.setTemplate((Template)template);
        dialog.setTitle(this.i18n.translateString("saveTemplate"));
        dialog.setLocationRelativeTo((Component)dialog.getParent());
        dialog.pack();
        dialog.setSize(300, 140);
        dialog.setVisible(true);
        this.checkForMatchingTemplate();
    }

    public void entitiesSelected(List<Serializable> selectedEntities) {
        if (!selectedEntities.isEmpty()) {
            RbQoSProfileTemplate qosTemplate = (RbQoSProfileTemplate)selectedEntities.get(0);
            this.applyTemplate(qosTemplate);
        }
        this.selectorFrame.dispose();
        Templates.updateListForClass(RbQoSProfileTemplate.class);
    }

    public void applyTemplate(RbQoSProfileTemplate template) {
        this.panel.getLblTemplateName().setText(template.getName());
        RbQoSProfile temp = template.createInstanceFromTemplate();
        this.binder.fillUIFromBean((Object)temp);
        this.manageParametersForType();
    }

    public void setBinder(Binder qoSBinder) {
        this.binder = (AbstractBinder)qoSBinder;
    }

    public boolean matchTemplate(RbQoSProfileTemplate template) {
        RbQoSProfile temp = new RbQoSProfile();
        if (this.binder != null && this.binder.fillBeanFromUI((Object)temp) && template.matches(temp)) {
            this.panel.getLblTemplateName().setText(template.getName());
            return true;
        }
        return false;
    }

    public void checkForMatchingTemplate() {
    }

    public int getServiceProfileType() {
        return this.serviceProfileType;
    }

    public void setServiceProfileType(int serviceProfileType) {
        this.serviceProfileType = serviceProfileType;
    }

    public List<ComboItem> getAllItems() {
        return this.removableItems;
    }
}

