/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.Templates;
import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.model.Template;
import com.bwanms.rb.gui.serviceprofiles.PolicyRuleEditorH;
import com.bwanms.rb.gui.serviceprofiles.PolicyRuleEditorHPart;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbPolicyRuleTemplate;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.ui.components.TemplateNameDialog;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.Frame;
import java.io.Serializable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyRuleEditorHController
implements EntitiesSelectedCallback {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbForwardingRule.class);
    private PolicyRuleEditorH panel;
    private AbstractBinder downQoS1;
    private AbstractBinder downQoS2;
    private AbstractBinder downQoS3;
    private AbstractBinder downQoS4;
    private AbstractBinder upQoS1;
    private AbstractBinder upQoS2;
    private AbstractBinder upQoS3;
    private AbstractBinder upQoS4;
    private AbstractBinder part1;
    private AbstractBinder part2;
    private JFrame selectorFrame;
    private AbstractBinder policy;

    public PolicyRuleEditorHController(PolicyRuleEditorH editorH) {
        this.panel = editorH;
    }

    public void importTemplate() {
        SelectorView selectorView = Selectors.getSelectorView(RbPolicyRuleTemplate.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            RbPolicyRuleTemplate qosTemplate = (RbPolicyRuleTemplate)selection.get(0);
            Integer policyRuleTemplateType = qosTemplate.getPriorityType();
            if ((Integer.valueOf(7).equals(this.panel.getType()) || Integer.valueOf(4).equals(this.panel.getType()) || Integer.valueOf(5).equals(this.panel.getType())) && !Integer.valueOf(1).equals(policyRuleTemplateType)) {
                MessageBox.Error.quickShow((Component)this.panel, i18n.translateString("InvalidPolicyRuleTemplate"));
                return;
            }
            this.applyTemplate(qosTemplate);
        }
        Templates.updateListForClass(RbPolicyRuleTemplate.class);
        this.checkForMatchingTemplate();
    }

    public void applyTemplate(RbPolicyRuleTemplate template) {
        this.panel.getTxtPRName().setText(template.getName());
        this.panel.getLblTemplateName().setText(template.getName());
        RbPolicyRule temp = template.createInstanceFromTemplate();
        this.part1.fillUIFromBean((Object)temp);
        this.part2.fillUIFromBean((Object)temp);
        this.policy.fillUIFromBean((Object)temp);
        this.fillQoSUI(temp.getDownQoSProfile1(), this.downQoS1);
        this.fillQoSUI(temp.getDownQoSProfile2(), this.downQoS2);
        this.fillQoSUI(temp.getDownQoSProfile3(), this.downQoS3);
        this.fillQoSUI(temp.getDownQoSProfile4(), this.downQoS4);
        this.fillQoSUI(temp.getUpQoSProfile1(), this.upQoS1);
        this.fillQoSUI(temp.getUpQoSProfile2(), this.upQoS2);
        this.fillQoSUI(temp.getUpQoSProfile3(), this.upQoS3);
        this.fillQoSUI(temp.getUpQoSProfile4(), this.upQoS4);
        this.panel.getPolicyRuleEditorHPart2().manageQoSLimitsAndType();
        this.panel.getPolicyRuleEditorHPart1().manageQoSLimitsAndType();
        this.checkForMatchingTemplate();
    }

    private void fillQoSUI(RbQoSProfile qos, AbstractBinder qosBinder) {
        if (qos != null) {
            qosBinder.fillUIFromBean((Object)qos);
        }
    }

    public void entitiesSelected(List<Serializable> selectedEntities) {
        if (!selectedEntities.isEmpty()) {
            RbPolicyRuleTemplate qosTemplate = (RbPolicyRuleTemplate)selectedEntities.get(0);
            this.applyTemplate(qosTemplate);
        }
        this.selectorFrame.dispose();
        Templates.updateListForClass(RbPolicyRuleTemplate.class);
    }

    public void saveAsTemplate() {
        TemplateNameDialog dialog = new TemplateNameDialog((Frame)((JFrame)SwingUtilities.getWindowAncestor(this.panel)));
        RbPolicyRule temp = new RbPolicyRule();
        RbQoSProfile down1 = new RbQoSProfile();
        RbQoSProfile down2 = new RbQoSProfile();
        RbQoSProfile down3 = new RbQoSProfile();
        RbQoSProfile down4 = new RbQoSProfile();
        RbQoSProfile up1 = new RbQoSProfile();
        RbQoSProfile up2 = new RbQoSProfile();
        RbQoSProfile up3 = new RbQoSProfile();
        RbQoSProfile up4 = new RbQoSProfile();
        PolicyRuleEditorHPart part = this.panel.getPolicyRuleEditorHPart2();
        if (part.getQoSProfileEditorH1().isEnabled() && this.downQoS1 != null && this.downQoS1.fillBeanFromUI((Object)down1)) {
            temp.setDownQoSProfile1(down1);
        }
        if (part.getQoSProfileEditorH2().isEnabled() && this.downQoS2 != null && this.downQoS2.fillBeanFromUI((Object)down2)) {
            temp.setDownQoSProfile2(down2);
        }
        if (part.getQoSProfileEditorH3().isEnabled() && this.downQoS3 != null && this.downQoS3.fillBeanFromUI((Object)down3)) {
            temp.setDownQoSProfile3(down3);
        }
        if (part.getQoSProfileEditorH4().isEnabled() && this.downQoS4 != null && this.downQoS4.fillBeanFromUI((Object)down4)) {
            temp.setDownQoSProfile4(down4);
        }
        if ((part = this.panel.getPolicyRuleEditorHPart1()).getQoSProfileEditorH1().isEnabled() && this.upQoS1 != null && this.upQoS1.fillBeanFromUI((Object)up1)) {
            temp.setUpQoSProfile1(up1);
        }
        if (part.getQoSProfileEditorH2().isEnabled() && this.upQoS2 != null && this.upQoS2.fillBeanFromUI((Object)up2)) {
            temp.setUpQoSProfile2(up2);
        }
        if (part.getQoSProfileEditorH3().isEnabled() && this.upQoS3 != null && this.upQoS3.fillBeanFromUI((Object)up3)) {
            temp.setUpQoSProfile3(up3);
        }
        if (part.getQoSProfileEditorH4().isEnabled() && this.upQoS4 != null && this.upQoS4.fillBeanFromUI((Object)up4)) {
            temp.setUpQoSProfile4(up4);
        }
        if (this.part1 != null && this.part1.fillBeanFromUI((Object)temp) && this.part2 != null && this.part2.fillBeanFromUI((Object)temp) && this.policy != null && this.policy.fillBeanFromUI((Object)temp)) {
            RbPolicyRuleTemplate template = new RbPolicyRuleTemplate();
            template = template.createTemplateFromInstance(temp);
            dialog.setModal(true);
            dialog.setTitle(i18n.translateString("saveTemplate"));
            dialog.setLocationRelativeTo((Component)dialog.getParent());
            dialog.setTemplate((Template)template);
            dialog.pack();
            dialog.setSize(300, 140);
            dialog.setVisible(true);
        }
        this.checkForMatchingTemplate();
    }

    public void checkForMatchingTemplate() {
    }

    public boolean matchTemplate(RbPolicyRuleTemplate template) {
        RbPolicyRule temp = new RbPolicyRule();
        RbQoSProfile down1 = new RbQoSProfile();
        RbQoSProfile down2 = new RbQoSProfile();
        RbQoSProfile down3 = new RbQoSProfile();
        RbQoSProfile down4 = new RbQoSProfile();
        RbQoSProfile up1 = new RbQoSProfile();
        RbQoSProfile up2 = new RbQoSProfile();
        RbQoSProfile up3 = new RbQoSProfile();
        RbQoSProfile up4 = new RbQoSProfile();
        PolicyRuleEditorHPart part = this.panel.getPolicyRuleEditorHPart2();
        if (part.getQoSProfileEditorH1().isEnabled() && this.downQoS1 != null && this.downQoS1.fillBeanFromUI((Object)down1)) {
            temp.setDownQoSProfile1(down1);
        }
        if (part.getQoSProfileEditorH2().isEnabled() && this.downQoS2 != null && this.downQoS2.fillBeanFromUI((Object)down2)) {
            temp.setDownQoSProfile2(down2);
        }
        if (part.getQoSProfileEditorH3().isEnabled() && this.downQoS3 != null && this.downQoS3.fillBeanFromUI((Object)down3)) {
            temp.setDownQoSProfile3(down3);
        }
        if (part.getQoSProfileEditorH4().isEnabled() && this.downQoS4 != null && this.downQoS4.fillBeanFromUI((Object)down4)) {
            temp.setDownQoSProfile4(down4);
        }
        if ((part = this.panel.getPolicyRuleEditorHPart1()).getQoSProfileEditorH1().isEnabled() && this.upQoS1 != null && this.upQoS1.fillBeanFromUI((Object)up1)) {
            temp.setUpQoSProfile1(up1);
        }
        if (part.getQoSProfileEditorH2().isEnabled() && this.upQoS2 != null && this.upQoS2.fillBeanFromUI((Object)up2)) {
            temp.setUpQoSProfile2(up2);
        }
        if (part.getQoSProfileEditorH3().isEnabled() && this.upQoS3 != null && this.upQoS3.fillBeanFromUI((Object)up3)) {
            temp.setUpQoSProfile3(up3);
        }
        if (part.getQoSProfileEditorH4().isEnabled() && this.upQoS4 != null && this.upQoS4.fillBeanFromUI((Object)up4)) {
            temp.setUpQoSProfile4(up4);
        }
        if (this.part1 != null && this.part1.fillBeanFromUI((Object)temp) && this.part2 != null && this.part2.fillBeanFromUI((Object)temp) && this.policy != null && this.policy.fillBeanFromUI((Object)temp) && template.matches(temp)) {
            this.panel.getLblTemplateName().setText(template.getName());
            return true;
        }
        return false;
    }

    public void setBinders(Binder downQoS1, Binder downQoS2, Binder downQoS3, Binder downQoS4, Binder upQoS1, Binder upQoS2, Binder upQoS3, Binder upQoS4, Binder part1, Binder part2, Binder policy) {
        this.policy = (AbstractBinder)policy;
        this.downQoS1 = (AbstractBinder)downQoS1;
        this.panel.getPolicyRuleEditorHPart2().getQoSProfileEditorH1().getController().setBinder(downQoS1);
        this.downQoS2 = (AbstractBinder)downQoS2;
        this.panel.getPolicyRuleEditorHPart2().getQoSProfileEditorH2().getController().setBinder(downQoS2);
        this.downQoS3 = (AbstractBinder)downQoS3;
        this.panel.getPolicyRuleEditorHPart2().getQoSProfileEditorH3().getController().setBinder(downQoS3);
        this.downQoS4 = (AbstractBinder)downQoS4;
        this.panel.getPolicyRuleEditorHPart2().getQoSProfileEditorH4().getController().setBinder(downQoS4);
        this.upQoS1 = (AbstractBinder)upQoS1;
        this.panel.getPolicyRuleEditorHPart1().getQoSProfileEditorH1().getController().setBinder(upQoS1);
        this.upQoS2 = (AbstractBinder)upQoS2;
        this.panel.getPolicyRuleEditorHPart1().getQoSProfileEditorH2().getController().setBinder(upQoS2);
        this.upQoS3 = (AbstractBinder)upQoS3;
        this.panel.getPolicyRuleEditorHPart1().getQoSProfileEditorH3().getController().setBinder(upQoS3);
        this.upQoS4 = (AbstractBinder)upQoS4;
        this.panel.getPolicyRuleEditorHPart1().getQoSProfileEditorH4().getController().setBinder(upQoS4);
        this.part1 = (AbstractBinder)part1;
        this.part2 = (AbstractBinder)part2;
    }
}

