/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Templates;
import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.model.Equipment;
import com.bwanms.model.ServiceProfile;
import com.bwanms.rb.gui.serviceprofiles.BinderUtil;
import com.bwanms.rb.gui.serviceprofiles.ServiceProfileEditorTabbed;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbForwardingRuleTemplate;
import com.bwanms.rb.model.services.RbPPPoEServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbPolicyRuleTemplate;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbQoSProfileTemplate;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FrameUtil;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPPoEServiceProfileView
extends AbstractBindedEditorView<ServiceProfile> {
    Internationalizer i18n = Internationalizer.getInternationalizer(RbPPPoEServiceProfile.class);
    ServiceProfileEditorTabbed panel;
    private AbstractBinder forwardingRuleQoSBinder;
    private AbstractBinder forwardingRuleBinder;
    private AbstractBinder policyRuleBinderDown;
    private AbstractBinder policyRuleBinderUp;
    private Binder policy;
    private final String PROPERTY_NAME_FWRULE_MULTICASTVLAN = this.i18n.translateString("multicastVLAN");

    public ServiceProfileEditorTabbed getUI() {
        if (this.panel == null) {
            this.panel = new ServiceProfileEditorTabbed();
            this.panel.getForwardingRuleEditor1().getComboType().addItem(new ComboItem((Object)2, this.i18n.translateString(RbForwardingRule.toStringType(2))));
        }
        return this.panel;
    }

    public String getTitle() {
        return this.i18n.translateString("PPPoEServiceProfile");
    }

    public List<InvalidValue> configureEntity(ServiceProfile entity) {
        String frName;
        RbPPPoEServiceProfile pppoe = (RbPPPoEServiceProfile)entity;
        if (this.panel.getController().transparentModeSelected()) {
            this.forwardingRuleQoSBinder.setEnabled(false);
            this.forwardingRuleBinder.setEnabled(false);
            pppoe.getForwardingRule().makeNull();
        } else {
            this.forwardingRuleQoSBinder.setEnabled(true);
            this.forwardingRuleBinder.setEnabled(true);
        }
        List iValues = super.configureEntity((Serializable)entity);
        RbPPPoEServiceProfile serviceProfile = (RbPPPoEServiceProfile)entity;
        serviceProfile.getPolicyRule().validateName(iValues, this.policy, this.i18n);
        ArrayList myValues = new ArrayList();
        ArrayList<InvalidValue> myInvalidValues1 = new ArrayList<InvalidValue>();
        pppoe.getPolicyRule().validatePolicyUpperLimitsDown(myInvalidValues1, this.i18n);
        ArrayList<InvalidValue> myInvalidValues2 = new ArrayList<InvalidValue>();
        pppoe.getPolicyRule().validatePolicyUpperLimitsUp(myInvalidValues2, this.i18n);
        this.policyRuleBinderDown.toUIInvalidValues(myValues, myInvalidValues1);
        this.policyRuleBinderUp.toUIInvalidValues(myValues, myInvalidValues2);
        iValues.addAll(myValues);
        ArrayList<RbQoSProfile> qosList = new ArrayList<RbQoSProfile>();
        RbQoSProfile qosForwarding = serviceProfile.getForwardingRule().getQoS();
        if (!qosForwarding.isValueNull()) {
            qosList.add(qosForwarding);
        }
        qosList.add(serviceProfile.getPolicyRule().getDownQoSProfile1());
        qosList.add(serviceProfile.getPolicyRule().getDownQoSProfile2());
        qosList.add(serviceProfile.getPolicyRule().getDownQoSProfile3());
        qosList.add(serviceProfile.getPolicyRule().getDownQoSProfile4());
        qosList.add(serviceProfile.getPolicyRule().getUpQoSProfile1());
        qosList.add(serviceProfile.getPolicyRule().getUpQoSProfile2());
        qosList.add(serviceProfile.getPolicyRule().getUpQoSProfile3());
        qosList.add(serviceProfile.getPolicyRule().getUpQoSProfile4());
        if (iValues.isEmpty() && !this.checkQoSUnique(qosList).isEmpty()) {
            String qosNames = new String();
            for (RbQoSProfile qosProfile : this.checkQoSUnique(qosList)) {
                if (qosNames.equals("")) {
                    qosNames = qosNames + qosProfile.getName();
                    continue;
                }
                qosNames = qosNames + ", " + qosProfile.getName();
            }
            if (!FrameUtil.showConfirmation((Component)this.panel, (String)this.i18n.translateString("SameQoSProfiles", new Object[]{qosNames}))) {
                iValues.add(new InvalidValue(this.i18n.translateString("AbortedByUser"), RbPolicyRule.class, "QoSProfiles", (Object)"", null));
            }
        }
        if (iValues != null && iValues.size() > 0) {
            this.panel.getForwardingRuleEditor1().validateTransparentFR(iValues);
        }
        if ("@@Transparent@@".equals((frName = this.getUI().getForwardingRuleEditor1().getTxtFRName().getText()).trim())) {
            iValues.add(new InvalidValue(this.i18n.translateString("TransparentCantBeDeployed"), JTextField.class, this.i18n.translateString("ForwardingRule"), (Object)frName, (Object)this.getUI().getForwardingRuleEditor1().getTxtFRName()));
        }
        return iValues;
    }

    private List<RbQoSProfile> checkQoSUnique(List<RbQoSProfile> qosList) {
        ArrayList<RbQoSProfile> result = new ArrayList<RbQoSProfile>();
        for (int i = 0; i < qosList.size(); ++i) {
            for (int j = i + 1; j < qosList.size(); ++j) {
                if (!qosList.get(i).isNameEqual(qosList.get(j))) continue;
                if (!result.isEmpty()) {
                    boolean isUnique = true;
                    for (RbQoSProfile qosProfile : result) {
                        if (!qosProfile.getName().equalsIgnoreCase(qosList.get(i).getName())) continue;
                        isUnique = false;
                    }
                    if (!isUnique) continue;
                    result.add(qosList.get(i));
                    continue;
                }
                result.add(qosList.get(i));
            }
        }
        return result;
    }

    public void fillUI(ServiceProfile entity) {
        RbPPPoEServiceProfile serviceProfile = (RbPPPoEServiceProfile)entity;
        this.panel.getTxtServiceProfileType().setText(this.i18n.translateString("rbPPPoE(2)"));
        this.panel.getSpnrNoOfSimultaneousCalls().setEnabled(false);
        this.panel.getController().removeDSCP();
        this.panel.getController().controlPriorityMarkingMode();
        this.panel.getController().controlVLANTransparencyMode();
        this.panel.getForwardingRuleEditor1().getQoSProfileEditor().getController().manageParametersForType();
        this.panel.getForwardingRuleEditor1().getController().checkMulticast();
        this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().manageQoSLimitsAndType();
        this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().manageQoSLimitsAndType();
        this.panel.getPolicyRuleEditorH1().getController().checkForMatchingTemplate();
        if (serviceProfile.getId() > 0L) {
            EntityManagerTableModel<Equipment> model = this.panel.getDeploymentTabPanel1().getTableModel();
            List equipments = ServiceRegistry.getServiceManagementService().findServiceProfileInstances(serviceProfile.getId());
            model.clearTable();
            for (Equipment equipment : equipments) {
                model.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
        }
    }

    public List<Binder> getBinders() {
        Templates.updateListForClass(RbQoSProfileTemplate.class);
        Templates.updateListForClass(RbForwardingRuleTemplate.class);
        Templates.updateListForClass(RbPolicyRuleTemplate.class);
        ArrayList<Binder> binders = new ArrayList<Binder>();
        RbPPPoEServiceProfile serviceProfile = (RbPPPoEServiceProfile)((Object)this.entity);
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtServiceProfileName", "serviceProfileName", this.i18n.translateString("serviceProfileName"))).add((Binding)new JComboBoxBinding(this.i18n, "comboPriorityMarkingMode", "priorityMarkingMode")).add((Binding)new JSpinnerBinding("spnrPriorityMarkingValue", "priorityMarkingValue", this.i18n.translateString("priorityMarkingValue"))).add((Binding)new JComboBoxBinding(this.i18n, "comboVLANTransparencyMode", "vLANTransparencyMode")).add((Binding)new JSpinnerBinding("spnrVPLId", "VPLId", this.i18n.translateString("VPLId"))));
        this.forwardingRuleBinder = (AbstractBinder)new DefaultBinder((Object)this.panel.getForwardingRuleEditor1(), (Object)serviceProfile.getForwardingRule()).add((Binding)new JTextFieldBinding("txtFRName", "name", this.i18n.translateString("name"))).add((Binding)new JComboBoxBinding(this.i18n, "comboType", "type")).add((Binding)new JSpinnerBinding("spnrMulticastVLAN", "multicastVLAN", this.i18n.translateString("multicastVLAN")));
        binders.add((Binder)this.forwardingRuleBinder);
        this.forwardingRuleQoSBinder = BinderUtil.bindQoS(this.panel.getForwardingRuleEditor1().getQoSProfileEditor(), serviceProfile.getForwardingRule().getQoS());
        binders.add((Binder)this.forwardingRuleQoSBinder);
        this.panel.getForwardingRuleEditor1().getController().setBinders((Binder)this.forwardingRuleBinder, (Binder)this.forwardingRuleQoSBinder);
        AbstractBinder downQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH1(), serviceProfile.getPolicyRule().getDownQoSProfile1());
        binders.add((Binder)downQoS1);
        AbstractBinder downQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH2(), serviceProfile.getPolicyRule().getDownQoSProfile2());
        binders.add((Binder)downQoS2);
        AbstractBinder downQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH3(), serviceProfile.getPolicyRule().getDownQoSProfile3());
        binders.add((Binder)downQoS3);
        AbstractBinder downQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH4(), serviceProfile.getPolicyRule().getDownQoSProfile4());
        binders.add((Binder)downQoS4);
        AbstractBinder upQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH1(), serviceProfile.getPolicyRule().getUpQoSProfile1());
        binders.add((Binder)upQoS1);
        AbstractBinder upQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH2(), serviceProfile.getPolicyRule().getUpQoSProfile2());
        binders.add((Binder)upQoS2);
        AbstractBinder upQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH3(), serviceProfile.getPolicyRule().getUpQoSProfile3());
        binders.add((Binder)upQoS3);
        AbstractBinder upQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH4(), serviceProfile.getPolicyRule().getUpQoSProfile4());
        binders.add((Binder)upQoS4);
        this.policy = new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1(), (Object)serviceProfile.getPolicyRule()).add((Binding)new JTextFieldBinding("txtPRName", "name", this.i18n.translateString("prName"))).add((Binding)new JComboBoxBinding(this.i18n, "comboPriorityType", "priorityType"));
        binders.add(this.policy);
        this.policyRuleBinderDown = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2(), (Object)serviceProfile.getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "downQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "downQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "downQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "downQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("downQoSUpperLimi41")));
        binders.add((Binder)this.policyRuleBinderDown);
        this.policyRuleBinderUp = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1(), (Object)serviceProfile.getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "upQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "upQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "upQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "upQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), this.i18n.translateString("upQoSUpperLimit4")));
        binders.add((Binder)this.policyRuleBinderUp);
        this.panel.getPolicyRuleEditorH1().getController().setBinders((Binder)downQoS1, (Binder)downQoS2, (Binder)downQoS3, (Binder)downQoS4, (Binder)upQoS1, (Binder)upQoS2, (Binder)upQoS3, (Binder)upQoS4, (Binder)this.policyRuleBinderUp, (Binder)this.policyRuleBinderDown, this.policy);
        return binders;
    }

    public String getApplicationPermission() {
        return "Av:ConfigureSLA";
    }

    public String getHelpTopic() {
        return "ngnms.help.adding_editing_service_profile";
    }
}

