/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.AbstractBindedEditorView;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.Templates;
import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binder;
import com.bwanms.gui.binding.Binding;
import com.bwanms.gui.binding.DefaultBinder;
import com.bwanms.gui.binding.JComboBoxBinding;
import com.bwanms.gui.binding.JSpinnerBinding;
import com.bwanms.gui.binding.JTextFieldBinding;
import com.bwanms.gui.binding.translators.ParserValueTranslator;
import com.bwanms.gui.binding.translators.ValueTranslator;
import com.bwanms.model.Equipment;
import com.bwanms.model.ServiceProfile;
import com.bwanms.rb.gui.serviceprofiles.BinderUtil;
import com.bwanms.rb.gui.serviceprofiles.ServiceProfileEditorTabbed;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbForwardingRuleTemplate;
import com.bwanms.rb.model.services.RbL2ServiceProfile;
import com.bwanms.rb.model.services.RbPolicyRule;
import com.bwanms.rb.model.services.RbPolicyRuleTemplate;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.rb.model.services.RbQoSProfileTemplate;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.EntityManagerTableModel;
import com.bwanms.util.FrameUtil;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L2ServiceProfileView
extends AbstractBindedEditorView<ServiceProfile> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbL2ServiceProfile.class);
    ServiceProfileEditorTabbed panel;
    private AbstractBinder forwardingRuleBinder;
    private AbstractBinder forwardingRuleQoSBinder;
    private AbstractBinder policyRuleBinderDown;
    private AbstractBinder policyRuleBinderUp;
    private Binder policy;

    public ServiceProfileEditorTabbed getUI() {
        if (this.panel == null) {
            this.panel = new ServiceProfileEditorTabbed();
            this.panel.getForwardingRuleEditor1().getComboType().addItem(new ComboItem((Object)1, i18n.translateString(RbForwardingRule.toStringType(1))));
            this.panel.getForwardingRuleEditor1().getComboType().addItem(new ComboItem((Object)3, i18n.translateString(RbForwardingRule.toStringType(3))));
        }
        return this.panel;
    }

    public String getTitle() {
        return i18n.translateString("L2ServiceProfile");
    }

    public List<InvalidValue> configureEntity(ServiceProfile entity) {
        Integer frType;
        RbL2ServiceProfile l2 = (RbL2ServiceProfile)entity;
        if (this.panel.getController().transparentModeSelected()) {
            this.forwardingRuleQoSBinder.setEnabled(false);
            this.forwardingRuleBinder.setEnabled(false);
            l2.getForwardingRule().makeNull();
        } else {
            this.forwardingRuleQoSBinder.setEnabled(true);
            this.forwardingRuleBinder.setEnabled(true);
        }
        List iValues = super.configureEntity((Serializable)entity);
        RbL2ServiceProfile serviceProfile = (RbL2ServiceProfile)entity;
        serviceProfile.getPolicyRule().validateName(iValues, this.policy, i18n);
        ArrayList myValues = new ArrayList();
        ArrayList<InvalidValue> myInvalidValues1 = new ArrayList<InvalidValue>();
        l2.getPolicyRule().validatePolicyUpperLimitsDown(myInvalidValues1, i18n);
        ArrayList<InvalidValue> myInvalidValues2 = new ArrayList<InvalidValue>();
        l2.getPolicyRule().validatePolicyUpperLimitsUp(myInvalidValues2, i18n);
        this.policyRuleBinderDown.toUIInvalidValues(myValues, myInvalidValues1);
        this.policyRuleBinderUp.toUIInvalidValues(myValues, myInvalidValues2);
        iValues.addAll(myValues);
        String frName = this.getUI().getForwardingRuleEditor1().getTxtFRName().getText();
        if ("@@Transparent@@".equals(frName.trim())) {
            iValues.add(new InvalidValue(i18n.translateString("TransparentCantBeDeployed"), JTextField.class, i18n.translateString("ForwardingRule"), (Object)frName, (Object)this.getUI().getForwardingRuleEditor1().getTxtFRName()));
        }
        if (null != (frType = serviceProfile.getForwardingRule().getType()) && frType != 1 && frType != 3) {
            iValues.add(new InvalidValue(i18n.translateString("TemplateTypeMismatch"), JComboBox.class, "type", (Object)frType, (Object)this.getUI().getForwardingRuleEditor1().getComboType()));
        }
        if (iValues != null && iValues.size() > 0) {
            this.panel.getForwardingRuleEditor1().validateTransparentFR(iValues);
        }
        ArrayList<RbQoSProfile> qosList = new ArrayList<RbQoSProfile>();
        RbQoSProfile qosForwarding = serviceProfile.getForwardingRule().getQoS();
        if (!qosForwarding.isValueNull()) {
            qosList.add(qosForwarding);
        }
        qosList.add(serviceProfile.getPolicyRule().getDownQoSProfile1());
        qosList.add(serviceProfile.getPolicyRule().getDownQoSProfile2());
        qosList.add(serviceProfile.getPolicyRule().getDownQoSProfile3());
        qosList.add(serviceProfile.getPolicyRule().getDownQoSProfile4());
        qosList.add(serviceProfile.getPolicyRule().getUpQoSProfile1());
        qosList.add(serviceProfile.getPolicyRule().getUpQoSProfile2());
        qosList.add(serviceProfile.getPolicyRule().getUpQoSProfile3());
        qosList.add(serviceProfile.getPolicyRule().getUpQoSProfile4());
        if (iValues.isEmpty() && !this.checkQoSUnique(qosList).isEmpty()) {
            String qosNames = new String();
            for (RbQoSProfile qosProfile : this.checkQoSUnique(qosList)) {
                if (qosNames.equals("")) {
                    qosNames = qosNames + qosProfile.getName();
                    continue;
                }
                qosNames = qosNames + ", " + qosProfile.getName();
            }
            if (!FrameUtil.showConfirmation((Component)this.panel, (String)i18n.translateString("SameQoSProfiles", new Object[]{qosNames}))) {
                iValues.add(new InvalidValue(i18n.translateString("AbortedByUser"), RbPolicyRule.class, "QoSProfiles", (Object)"", null));
            }
        }
        return iValues;
    }

    private List<RbQoSProfile> checkQoSUnique(List<RbQoSProfile> qosList) {
        ArrayList<RbQoSProfile> result = new ArrayList<RbQoSProfile>();
        for (int i = 0; i < qosList.size(); ++i) {
            for (int j = i + 1; j < qosList.size(); ++j) {
                if (!qosList.get(i).isNameEqual(qosList.get(j))) continue;
                if (!result.isEmpty()) {
                    boolean isUnique = true;
                    for (RbQoSProfile qosProfile : result) {
                        if (!qosProfile.getName().equalsIgnoreCase(qosList.get(i).getName())) continue;
                        isUnique = false;
                    }
                    if (!isUnique) continue;
                    result.add(qosList.get(i));
                    continue;
                }
                result.add(qosList.get(i));
            }
        }
        return result;
    }

    public void fillUI(ServiceProfile entity) {
        Templates.updateListForClass(RbQoSProfileTemplate.class);
        Templates.updateListForClass(RbForwardingRuleTemplate.class);
        Templates.updateListForClass(RbPolicyRuleTemplate.class);
        RbL2ServiceProfile serviceProfile = (RbL2ServiceProfile)entity;
        this.panel.getTxtServiceProfileType().setText(i18n.translateString("rbLayerII(1)"));
        this.panel.getController().controlPriorityMarkingMode();
        this.panel.getController().controlVLANTransparencyMode();
        this.panel.getForwardingRuleEditor1().getQoSProfileEditor().getController().manageParametersForType();
        this.panel.getForwardingRuleEditor1().getController().checkMulticast();
        this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().manageQoSLimitsAndType();
        this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().manageQoSLimitsAndType();
        this.panel.getPolicyRuleEditorH1().getController().checkForMatchingTemplate();
        if (serviceProfile.getId() > 0L) {
            EntityManagerTableModel<Equipment> model = this.panel.getDeploymentTabPanel1().getTableModel();
            List equipments = ServiceRegistry.getServiceManagementService().findServiceProfileInstances(serviceProfile.getId());
            model.clearTable();
            for (Equipment equipment : equipments) {
                model.addRow((Object)equipment, String.valueOf(equipment.getId()));
            }
        }
    }

    public List<Binder> getBinders() {
        ArrayList<Binder> binders = new ArrayList<Binder>();
        RbL2ServiceProfile serviceProfile = (RbL2ServiceProfile)((Object)this.entity);
        binders.add(new DefaultBinder((Object)this.getUI(), (Object)this.entity).add((Binding)new JTextFieldBinding("txtServiceProfileName", "serviceProfileName", i18n.translateString("serviceProfileName"))).add((Binding)new JComboBoxBinding(i18n, "comboPriorityMarkingMode", "priorityMarkingMode", i18n.translateString("priorityMarkingMode"))).add((Binding)new JSpinnerBinding("spnrPriorityMarkingValue", "priorityMarkingValue", i18n.translateString("priorityMarkingValue"))).add((Binding)new JComboBoxBinding(i18n, "comboVLANTransparencyMode", "vLANTransparencyMode", i18n.translateString("vLANTransparencyMode"))).add((Binding)new JSpinnerBinding("spnrVPLId", "VPLId", i18n.translateString("VPLId"))).add((Binding)new JSpinnerBinding("spnrNoOfSimultaneousCalls", "maxNumberOfSimultaneousCalls", i18n.translateString("maxNumberOfSimultaneousCalls"))));
        this.forwardingRuleBinder = (AbstractBinder)new DefaultBinder((Object)this.panel.getForwardingRuleEditor1(), (Object)serviceProfile.getForwardingRule()).add((Binding)new JTextFieldBinding("txtFRName", "name", i18n.translateString("name"))).add((Binding)new JComboBoxBinding(i18n, "comboUnicastRelaying", "unicastRelaying", i18n.translateString("unicastRelaying"))).add((Binding)new JComboBoxBinding(i18n, "comboUnknownAddressForwardingPolicy", "unknownAddrPolicy", i18n.translateString("unknownAddrPolicy"))).add((Binding)new JComboBoxBinding(i18n, "comboMulticasRelaying", "multicastRelaying", i18n.translateString("multicastRelaying"))).add((Binding)new JSpinnerBinding("spnrMulticastVLAN", "multicastVLAN", i18n.translateString("multicastVLAN"))).add((Binding)new JComboBoxBinding(i18n, "comboType", "type", i18n.translateString("forwardingType")));
        binders.add((Binder)this.forwardingRuleBinder);
        this.forwardingRuleQoSBinder = BinderUtil.bindQoS(this.panel.getForwardingRuleEditor1().getQoSProfileEditor(), serviceProfile.getForwardingRule().getQoS());
        binders.add((Binder)this.forwardingRuleQoSBinder);
        this.panel.getForwardingRuleEditor1().getController().setBinders((Binder)this.forwardingRuleBinder, (Binder)this.forwardingRuleQoSBinder);
        AbstractBinder downQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH1(), serviceProfile.getPolicyRule().getDownQoSProfile1());
        binders.add((Binder)downQoS1);
        AbstractBinder downQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH2(), serviceProfile.getPolicyRule().getDownQoSProfile2());
        binders.add((Binder)downQoS2);
        AbstractBinder downQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH3(), serviceProfile.getPolicyRule().getDownQoSProfile3());
        binders.add((Binder)downQoS3);
        AbstractBinder downQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2().getQoSProfileEditorH4(), serviceProfile.getPolicyRule().getDownQoSProfile4());
        binders.add((Binder)downQoS4);
        AbstractBinder upQoS1 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH1(), serviceProfile.getPolicyRule().getUpQoSProfile1());
        binders.add((Binder)upQoS1);
        AbstractBinder upQoS2 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH2(), serviceProfile.getPolicyRule().getUpQoSProfile2());
        binders.add((Binder)upQoS2);
        AbstractBinder upQoS3 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH3(), serviceProfile.getPolicyRule().getUpQoSProfile3());
        binders.add((Binder)upQoS3);
        AbstractBinder upQoS4 = BinderUtil.bindQoS(this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1().getQoSProfileEditorH4(), serviceProfile.getPolicyRule().getUpQoSProfile4());
        binders.add((Binder)upQoS4);
        this.policy = new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1(), (Object)serviceProfile.getPolicyRule()).add((Binding)new JTextFieldBinding("txtPRName", "name", i18n.translateString("prName"))).add((Binding)new JComboBoxBinding(i18n, "comboPriorityType", "priorityType", i18n.translateString("priorityType")));
        binders.add(this.policy);
        this.policyRuleBinderDown = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart2(), (Object)serviceProfile.getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "downQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), i18n.translateString("downQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "downQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), i18n.translateString("downQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "downQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), i18n.translateString("downQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "downQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), i18n.translateString("downQoSUpperLimit4")));
        binders.add((Binder)this.policyRuleBinderDown);
        this.policyRuleBinderUp = (AbstractBinder)new DefaultBinder((Object)this.panel.getPolicyRuleEditorH1().getPolicyRuleEditorHPart1(), (Object)serviceProfile.getPolicyRule()).add((Binding)new JTextFieldBinding("txtUpperLimit1", "upQoSUpperLimit1", (ValueTranslator)new ParserValueTranslator(Long.class), i18n.translateString("upQoSUpperLimit1"))).add((Binding)new JTextFieldBinding("txtUpperLimit2", "upQoSUpperLimit2", (ValueTranslator)new ParserValueTranslator(Long.class), i18n.translateString("upQoSUpperLimit2"))).add((Binding)new JTextFieldBinding("txtUpperLimit3", "upQoSUpperLimit3", (ValueTranslator)new ParserValueTranslator(Long.class), i18n.translateString("upQoSUpperLimit3"))).add((Binding)new JTextFieldBinding("txtUpperLimit4", "upQoSUpperLimit4", (ValueTranslator)new ParserValueTranslator(Long.class), i18n.translateString("upQoSUpperLimit4")));
        binders.add((Binder)this.policyRuleBinderUp);
        this.panel.getPolicyRuleEditorH1().getController().setBinders((Binder)downQoS1, (Binder)downQoS2, (Binder)downQoS3, (Binder)downQoS4, (Binder)upQoS1, (Binder)upQoS2, (Binder)upQoS3, (Binder)upQoS4, (Binder)this.policyRuleBinderUp, (Binder)this.policyRuleBinderDown, this.policy);
        return binders;
    }

    public String getApplicationPermission() {
        return "Av:ConfigureSLA";
    }

    public String getHelpTopic() {
        return "ngnms.help.adding_editing_service_profile";
    }
}

