/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.serviceprofiles;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.Templates;
import com.bwanms.gui.binding.AbstractBinder;
import com.bwanms.gui.binding.Binder;
import com.bwanms.model.Template;
import com.bwanms.rb.gui.serviceprofiles.ForwardingRuleEditor;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbForwardingRuleTemplate;
import com.bwanms.rb.model.services.RbQoSProfile;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.TemplateNameDialog;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ForwardingRuleEditorController {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbForwardingRule.class);
    private ForwardingRuleEditor panel;
    private AbstractBinder binder;
    private AbstractBinder qosBinder;

    public ForwardingRuleEditorController(ForwardingRuleEditor editor) {
        this.panel = editor;
    }

    public void controlMulticasVlanSpnr() {
        if (((Integer)this.panel.getSpnrMulticastVLAN().getValue()).equals(4095)) {
            this.panel.getSpnrMulticastVLAN().setEnabled(false);
            this.panel.getCkbxMulticastVLAN().setSelected(true);
        }
        this.checkForMatchingTemplate();
    }

    public void checkType() {
        if (Integer.valueOf(1).equals(this.panel.getComboType().getSelectedItem()) || Integer.valueOf(6).equals(this.panel.getComboType().getSelectedItem()) || Integer.valueOf(7).equals(this.panel.getComboType().getSelectedItem())) {
            if (this.panel.getComboMulticasRelaying().getItemCount() == 0) {
                this.panel.getComboMulticasRelaying().addItem(new ComboItem((Object)2, RbForwardingRule.toStringMulticastRelaying(2)));
                this.panel.getComboMulticasRelaying().addItem(new ComboItem((Object)1, RbForwardingRule.toStringMulticastRelaying(1)));
            }
            if (this.panel.getComboUnicastRelaying().getItemCount() == 0) {
                this.panel.getComboUnicastRelaying().addItem(new ComboItem((Object)2, RbForwardingRule.toStringUnicastRelaying(2)));
                this.panel.getComboUnicastRelaying().addItem(new ComboItem((Object)1, RbForwardingRule.toStringUnicastRelaying(1)));
            }
            if (this.panel.getComboUnknownAddressForwardingPolicy().getItemCount() == 0) {
                this.panel.getComboUnknownAddressForwardingPolicy().addItem(new ComboItem((Object)2, RbForwardingRule.toStringUnknownAddrPolicy(2)));
                this.panel.getComboUnknownAddressForwardingPolicy().addItem(new ComboItem((Object)1, RbForwardingRule.toStringUnknownAddrPolicy(1)));
            }
            this.panel.getComboMulticasRelaying().setEnabled(true);
            this.panel.getComboUnicastRelaying().setEnabled(true);
            this.panel.getComboUnknownAddressForwardingPolicy().setEnabled(true);
        }
        if (Integer.valueOf(2).equals(this.panel.getComboType().getSelectedItem()) || Integer.valueOf(3).equals(this.panel.getComboType().getSelectedItem())) {
            this.panel.getComboMulticasRelaying().removeAllItems();
            this.panel.getComboMulticasRelaying().setEnabled(false);
            this.panel.getComboUnicastRelaying().removeAllItems();
            this.panel.getComboUnicastRelaying().setEnabled(false);
            this.panel.getComboUnknownAddressForwardingPolicy().removeAllItems();
            this.panel.getComboUnknownAddressForwardingPolicy().setEnabled(false);
        }
        i18n.translateCombo(this.panel.getComboUnknownAddressForwardingPolicy());
        i18n.translateCombo(this.panel.getComboMulticasRelaying());
        i18n.translateCombo(this.panel.getComboUnicastRelaying());
    }

    public void controlMulticastVlanCkbx() {
        if (this.panel.getCkbxMulticastVLAN().isSelected()) {
            this.panel.getSpnrMulticastVLAN().setValue(4095);
            this.panel.getSpnrMulticastVLAN().setEnabled(false);
        } else {
            this.panel.getSpnrMulticastVLAN().setValue(1);
            this.panel.getSpnrMulticastVLAN().setEnabled(true);
        }
        this.checkForMatchingTemplate();
    }

    public void checkMulticast() {
        if (((Integer)this.panel.getSpnrMulticastVLAN().getValue()).equals(4095) || this.panel.getCkbxMulticastVLAN().isSelected()) {
            this.panel.getSpnrMulticastVLAN().setValue(4095);
            this.panel.getSpnrMulticastVLAN().setEnabled(false);
            this.panel.getCkbxMulticastVLAN().setSelected(true);
        } else {
            this.panel.getSpnrMulticastVLAN().setEnabled(true);
            this.panel.getCkbxMulticastVLAN().setSelected(false);
        }
        this.checkForMatchingTemplate();
    }

    public void applyTemplate(RbForwardingRuleTemplate template) {
        this.panel.getTxtFRName().setText(template.getName());
        this.panel.getLblTemplateName().setText(template.getName());
        this.panel.getSpnrMulticastVLAN().setValue(1);
        this.panel.getSpnrMulticastVLAN().setEnabled(true);
        this.panel.getCkbxMulticastVLAN().setSelected(false);
        RbForwardingRule temp = template.createInstanceFromTemplate();
        this.binder.fillUIFromBean((Object)temp);
        RbQoSProfile qos = temp.getQoS();
        this.qosBinder.fillUIFromBean((Object)qos);
        this.checkMulticast();
        this.panel.getQoSProfileEditor().getController().manageParametersForType();
    }

    public void setBinders(Binder forwardingRuleQoSBinder, Binder qosBinder) {
        this.binder = (AbstractBinder)forwardingRuleQoSBinder;
        this.qosBinder = (AbstractBinder)qosBinder;
        this.panel.getQoSProfileEditor().getController().setBinder(qosBinder);
    }

    public boolean matchTemplate(RbForwardingRuleTemplate template) {
        RbForwardingRule temp = new RbForwardingRule();
        RbQoSProfile tempQoS = new RbQoSProfile();
        if (this.qosBinder != null && this.qosBinder.fillBeanFromUI((Object)tempQoS)) {
            temp.setQoS(tempQoS);
        }
        if (this.binder != null && this.binder.fillBeanFromUI((Object)temp) && template.matches(temp)) {
            this.panel.getLblTemplateName().setText(template.getName());
            return true;
        }
        return false;
    }

    public void checkForMatchingTemplate() {
    }

    public void importTemplate() {
        SelectorView selectorView = Selectors.getSelectorView(RbForwardingRuleTemplate.class, null);
        SelectorUtil.displayModalSelector((JComponent)this.panel, (SelectorView)selectorView);
        List selection = selectorView.getSelection();
        if (!selection.isEmpty()) {
            RbForwardingRuleTemplate forwardingRuleTemplate = (RbForwardingRuleTemplate)selection.get(0);
            ComboItem comboType = (ComboItem)this.panel.getComboType().getSelectedItem();
            Integer fwRuleTemplateType = forwardingRuleTemplate.getType();
            Integer serviceTemplateType = (Integer)comboType.getValue();
            if (Integer.valueOf(2).equals(serviceTemplateType)) {
                if (!Integer.valueOf(2).equals(fwRuleTemplateType)) {
                    MessageBox.Error.quickShow((Component)this.panel, i18n.translateString("InvalidTemplateType(PPPoE)"));
                    return;
                }
            } else if (Integer.valueOf(1).equals(serviceTemplateType) || Integer.valueOf(3).equals(serviceTemplateType)) {
                if (!Integer.valueOf(1).equals(fwRuleTemplateType) && !Integer.valueOf(3).equals(fwRuleTemplateType)) {
                    MessageBox.Error.quickShow((Component)this.panel, i18n.translateString("InvalidTemplateType(L2,VoIP)"));
                    return;
                }
            } else if (Integer.valueOf(6).equals(serviceTemplateType)) {
                if (!Integer.valueOf(6).equals(fwRuleTemplateType)) {
                    MessageBox.Error.quickShow((Component)this.panel, i18n.translateString("InvalidTemplateType(ManagedVoIP)"));
                    return;
                }
            } else if (Integer.valueOf(7).equals(serviceTemplateType) && !Integer.valueOf(7).equals(fwRuleTemplateType)) {
                MessageBox.Error.quickShow((Component)this.panel, i18n.translateString("InvalidTemplateType(IPMode_ManagedVoIP)"));
                return;
            }
            this.applyTemplate(forwardingRuleTemplate);
        }
        Templates.updateListForClass(RbForwardingRuleTemplate.class);
        this.checkForMatchingTemplate();
    }

    public void saveAsTemplate() {
        TemplateNameDialog dialog = new TemplateNameDialog((Frame)((JFrame)SwingUtilities.getWindowAncestor(this.panel)));
        RbForwardingRule temp = new RbForwardingRule();
        this.binder.fillBeanFromUI((Object)temp);
        RbQoSProfile tempQoS = new RbQoSProfile();
        if (this.qosBinder != null && this.qosBinder.fillBeanFromUI((Object)tempQoS)) {
            temp.setQoS(tempQoS);
        }
        RbForwardingRuleTemplate template = new RbForwardingRuleTemplate();
        template = template.createTemplateFromInstance(temp);
        dialog.setModal(true);
        dialog.setTitle(i18n.translateString("saveTemplate"));
        dialog.setTemplate((Template)template);
        dialog.setLocationRelativeTo((Component)dialog.getParent());
        dialog.pack();
        dialog.setSize(300, 140);
        dialog.setVisible(true);
        this.checkForMatchingTemplate();
    }
}

