/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.selectors.service;

import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.selectors.GenericSelfContainedSelectorView;
import com.bwanms.gui.servicemanager.ServiceManagerConfig;
import com.bwanms.rb.model.services.RbService;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceSelectorView
extends GenericSelfContainedSelectorView<RbService> {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceSelectorView.class);

    public RbServiceSelectorView(Class<? extends RbService> baseClass) {
        ((RbServiceManagerConfig)this.config).setBaseName(baseClass.getName());
    }

    public EntityManagerConfig initConfigAndSetSelectionListener() {
        RbServiceManagerConfig config = new RbServiceManagerConfig();
        config.setSelectorListener((EntitiesSelectedCallback)this);
        return config;
    }

    public String[] getColumnNames() {
        return this.config.getColumnTitles();
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return ((RbServiceManagerConfig)this.config).getEntityRowProvider();
    }

    public String getTitle() {
        return i18n.translateString("RbServiceSelector");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbServiceManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;

        public RbServiceManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        public void performAction(ManagerView manager) {
            if ("Select".equals(this.name)) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Select")) {
                return 0 < selectionSize;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbServiceManagerConfig
    extends ServiceManagerConfig {
        private List<ManagerAction> declaredActions;
        private ManagerAction defaultAction;
        private String baseName;

        private RbServiceManagerConfig() {
        }

        public EntityManagerRowProvider getEntityRowProvider() {
            return super.getEntityRowProvider();
        }

        public List<ManagerAction> getDeclaredActions() {
            return this.declaredActions;
        }

        public ManagerAction getDefaultAction() {
            return this.defaultAction;
        }

        protected String getBaseName() {
            return this.baseName;
        }

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
            this.defaultAction = new RbServiceManagerAction("Select", 1, selectorListener);
            this.declaredActions = new Vector<ManagerAction>();
            this.declaredActions.add(this.defaultAction);
        }
    }
}

