/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.selectors.equipment;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.selectors.SelectorDialog;
import com.bwanms.rb.gui.configuration.SubscriberUnitsPanelTDD;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.SimpleRowTable;
import com.bwanms.ui.components.SimpleRowTableModel;
import com.bwanms.util.FormUtil;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MacAddress;
import com.bwanms.util.TableUtil;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class RbSubscriberUnitsSelectorPanel
extends JPanel {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(SubscriberUnitsPanelTDD.class);
    private SimpleRowTableModel table2Model;
    RbRegisteredSuTable table = null;
    private String filterString = "";
    private KeyAdapter theListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                try {
                    RbSubscriberUnitsSelectorPanel.this.table2.clearSelection();
                    SelectorDialog selDialog = (SelectorDialog)RbSubscriberUnitsSelectorPanel.this.getTopLevelAncestor();
                    selDialog.dispose();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    };
    private JPanel panel1;
    private JLabel lblFilterBy;
    private JComboBox cmbFilterBy;
    private JTextField txtFilter;
    private JComboBox cmbRegistrationStatus;
    private JComboBox cmbPermanenceStatus;
    private JSeparator separator1;
    private JScrollPane scrollPane2;
    private JTable table2;
    private JLabel lblStatus;

    public RbSubscriberUnitsSelectorPanel(RbBaseStationEquipment equipment) {
        this.initComponents();
        this.postInitComponents(equipment);
    }

    private void postInitComponents(RbBaseStationEquipment equipment) {
        i18n.getSwingInternationalizer().translateComponent((Component)this);
        ArrayList<Class<RbRegisteredSuTable>> moClasses = new ArrayList<Class<RbRegisteredSuTable>>();
        moClasses.add(RbRegisteredSuTable.class);
        try {
            this.table = (RbRegisteredSuTable)((Object)ServiceRegistry.getConfigurationService().retrieveCurrentConfiguration(equipment.getId(), "BS", moClasses, false).get(0));
        }
        catch (NullPointerException npe) {
            this.getLblStatus().setText(i18n.translateString("noUnitsToDisplay"));
        }
        catch (ServiceException s) {
            this.getLblStatus().setText(i18n.translateString("noUnitsToDisplay"));
        }
        FrameUtil.addKeyListenerRecursively((Component)this, (KeyAdapter)this.theListener);
        ComboItem[] permanence = new ComboItem[]{new ComboItem((Object)2, i18n.translateString("permanent")), new ComboItem((Object)1, i18n.translateString("temporary"))};
        ComboItem[] registration = new ComboItem[]{new ComboItem((Object)3, i18n.translateString("authenticated")), new ComboItem((Object)1, i18n.translateString("notRegistered")), new ComboItem((Object)2, i18n.translateString("registered"))};
        this.table2Model = new SimpleRowTableModel(new SimpleRowTableModel.ColumnDefinition[]{new SimpleRowTableModel.ColumnDefinition(i18n.translateString("ID"), Integer.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("Name"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("MACAddress"), String.class), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("RegistrationStatus"), String.class, registration), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("PermanenceStatus"), String.class, permanence), new SimpleRowTableModel.ColumnDefinition(i18n.translateString("AssociatedAU"), String.class)}, this.table2.getTableHeader());
        this.table2Model.setColumnReadonly(0, true);
        this.table2Model.setColumnReadonly(1, true);
        this.table2Model.setColumnReadonly(2, true);
        this.table2Model.setColumnReadonly(3, true);
        this.table2Model.setColumnReadonly(4, true);
        this.table2Model.setColumnReadonly(5, true);
        Comparator hexStringComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer i2;
                Integer i1;
                try {
                    i1 = Integer.valueOf(String.valueOf(o1), 16);
                }
                catch (Exception e) {
                    return -1;
                }
                try {
                    i2 = Integer.valueOf(String.valueOf(o2), 16);
                }
                catch (Exception e) {
                    return 1;
                }
                return i1.compareTo(i2);
            }
        };
        this.table2Model.setColumnComparator(Integer.valueOf(6), hexStringComparator);
        SimpleRowTable srTable = new SimpleRowTable(this.table2, this.table2Model, null);
        this.cmbFilterBy.addItem(new ComboItem((Object)1, i18n.translateString("Name")));
        this.cmbFilterBy.addItem(new ComboItem((Object)2, i18n.translateString("MACAddress")));
        this.cmbFilterBy.addItem(new ComboItem((Object)3, i18n.translateString("RegistrationStatus")));
        this.cmbFilterBy.addItem(new ComboItem((Object)4, i18n.translateString("PermanenceStatus")));
        this.cmbFilterBy.addItem(new ComboItem((Object)5, i18n.translateString("AssociatedAU")));
        for (ComboItem ci : registration) {
            this.cmbRegistrationStatus.addItem(ci);
        }
        for (ComboItem ci : permanence) {
            this.cmbPermanenceStatus.addItem(ci);
        }
        this.cmbRegistrationStatus.setVisible(false);
        this.cmbPermanenceStatus.setVisible(false);
        this.filterOptions();
        this.fillTableRows();
    }

    private void filterOptions() {
        this.getTxtFilter().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                this.updateTable(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.updateTable(e);
            }

            private void updateTable(DocumentEvent e) {
                try {
                    RbSubscriberUnitsSelectorPanel.this.filterString = e.getDocument().getText(0, e.getDocument().getLength()).trim().toUpperCase();
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                RbSubscriberUnitsSelectorPanel.this.fillTableRows();
            }
        });
        this.getCmbFilterBy().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbSubscriberUnitsSelectorPanel.this.getCmbRegistrationStatus().setVisible(((JComboBox)e.getSource()).getSelectedIndex() == 2);
                RbSubscriberUnitsSelectorPanel.this.getCmbPermanenceStatus().setVisible(((JComboBox)e.getSource()).getSelectedIndex() == 3);
                RbSubscriberUnitsSelectorPanel.this.getTxtFilter().setVisible(!RbSubscriberUnitsSelectorPanel.this.getCmbRegistrationStatus().isVisible() && !RbSubscriberUnitsSelectorPanel.this.getCmbPermanenceStatus().isVisible());
                RbSubscriberUnitsSelectorPanel.this.revalidate();
                RbSubscriberUnitsSelectorPanel.this.fillTableRows();
            }
        });
        this.getCmbRegistrationStatus().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbSubscriberUnitsSelectorPanel.this.fillTableRows();
            }
        });
        this.getCmbPermanenceStatus().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RbSubscriberUnitsSelectorPanel.this.fillTableRows();
            }
        });
    }

    private void fillTableRows() {
        if (this.table != null) {
            FormUtil.cancelTableEditing((JTable)this.table2);
            this.table2Model.clearTable();
            int row = 0;
            for (RbRegisteredSuEntry entry : this.table.getEntries()) {
                String stringMacAddress = MacAddress.fromOctetString((String)entry.getRbSuMacAddr()).toString();
                String stringRbAuId = entry.getRbAuId() != 255 ? String.valueOf(entry.getRbAuId()) : i18n.translateString("none");
                if (!(this.getCmbFilterBy().getSelectedIndex() != 2 && this.getCmbFilterBy().getSelectedIndex() != 3 && (this.filterString == null || this.filterString.length() == 0 || this.getCmbFilterBy().getSelectedIndex() == 0 && entry.getRbSuSysName().toUpperCase().indexOf(this.filterString) != -1 || this.getCmbFilterBy().getSelectedIndex() == 1 && stringMacAddress.toUpperCase().indexOf(this.filterString) != -1 || this.getCmbFilterBy().getSelectedIndex() == 4 && stringRbAuId.toUpperCase().indexOf(this.filterString) != -1) || this.getCmbFilterBy().getSelectedIndex() == 2 && entry.getRbSuRegistrationState().equals(((ComboItem)this.getCmbRegistrationStatus().getSelectedItem()).getValue())) && (this.getCmbFilterBy().getSelectedIndex() != 3 || !entry.getRbSuPersistence().equals(((ComboItem)this.getCmbPermanenceStatus().getSelectedItem()).getValue()))) continue;
                int col = 0;
                this.table2Model.addNewRow(entry.getRbSuMacAddr(), true);
                this.table2Model.setInitialValueAt((Object)(row + 1), row, col++);
                this.table2Model.setInitialValueAt((Object)entry.getRbSuSysName(), row, col++);
                this.table2Model.setInitialValueAt((Object)stringMacAddress, row, col++);
                this.table2Model.setInitialValueAt((Object)entry.getRbSuRegistrationState(), row, col++);
                this.table2Model.setInitialValueAt((Object)entry.getRbSuPersistence(), row, col++);
                if (this.table2Model.findColumn(i18n.translateString("AssociatedAU")) == col) {
                    this.table2Model.setInitialValueAt((Object)stringRbAuId, row, col++);
                }
                ++row;
            }
            this.getLblStatus().setText(i18n.translateString("displayedUnitsOf", new Object[]{row, this.table.getEntries().size()}));
            this.table2Model.sort();
        } else {
            this.getLblStatus().setText(i18n.translateString("noUnitsToDisplay"));
        }
        TableUtil.autoResizeColumn((JTable)this.table2, (int)0, (boolean)true);
        TableUtil.autoResizeColumnPreffredWidth((JTable)this.table2, (int)1, (boolean)false);
        TableUtil.autoResizeColumnPreffredWidth((JTable)this.table2, (int)2, (boolean)false);
        this.table2.setSelectionMode(0);
    }

    private void initComponents() {
        this.panel1 = new JPanel();
        this.lblFilterBy = new JLabel();
        this.cmbFilterBy = new JComboBox();
        this.txtFilter = new JTextField();
        this.cmbRegistrationStatus = new JComboBox();
        this.cmbPermanenceStatus = new JComboBox();
        this.separator1 = new JSeparator();
        this.scrollPane2 = new JScrollPane();
        this.table2 = new JTable();
        this.lblStatus = new JLabel();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec("max(default;5dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.dluX((int)45)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec((Size)Sizes.DLUX5)}, new RowSpec[]{new RowSpec((Size)Sizes.DLUY5), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.dluY((int)15), 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.dluY((int)15), 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.dluY((int)150), 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.panel1.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.lblFilterBy.setText("FilterBy");
        this.lblFilterBy.setHorizontalAlignment(4);
        this.lblFilterBy.setFont(new Font("Tahoma", 1, 11));
        this.panel1.add((Component)this.lblFilterBy, cc.xy(1, 1));
        this.panel1.add((Component)this.cmbFilterBy, cc.xy(3, 1));
        this.panel1.add((Component)this.txtFilter, cc.xy(5, 1));
        this.panel1.add((Component)this.cmbRegistrationStatus, cc.xy(5, 1));
        this.panel1.add((Component)this.cmbPermanenceStatus, cc.xy(5, 1));
        this.add((Component)this.panel1, cc.xywh(3, 3, 7, 1, CellConstraints.FILL, CellConstraints.DEFAULT));
        this.add((Component)this.separator1, cc.xywh(3, 5, 7, 1, CellConstraints.FILL, CellConstraints.CENTER));
        this.table2.setAutoResizeMode(3);
        this.table2.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                RbSubscriberUnitsSelectorPanel.this.table2MouseReleased(e);
            }
        });
        this.scrollPane2.setViewportView(this.table2);
        this.add((Component)this.scrollPane2, cc.xywh(3, 7, 7, 5));
        this.lblStatus.setHorizontalAlignment(2);
        this.add((Component)this.lblStatus, new CellConstraints(3, 13, 7, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 5, 0, 0)));
    }

    public JComboBox getCmbFilterBy() {
        return this.cmbFilterBy;
    }

    public JTextField getTxtFilter() {
        return this.txtFilter;
    }

    public JComboBox getCmbRegistrationStatus() {
        return this.cmbRegistrationStatus;
    }

    public JComboBox getCmbPermanenceStatus() {
        return this.cmbPermanenceStatus;
    }

    public JLabel getLblStatus() {
        return this.lblStatus;
    }

    public JTable getTable2() {
        return this.table2;
    }

    private void table2MouseReleased(MouseEvent e) {
        SelectorUtil.doubleClickExit((int)e.getClickCount(), (JComponent)this);
    }
}

