/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.selectors.equipment;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.gui.equipmentmanager.EquipmentRowProvider;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerResultView;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.IconEntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.selectors.DefaultCancelAction;
import com.bwanms.gui.selectors.DefaultSelectAction;
import com.bwanms.rb.gui.selectors.equipment.RbAURowCreator;
import com.bwanms.rb.model.RbAU;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.IpAddress;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbAUSelectorConfig
extends EntityManagerConfig {
    private static final Internationalizer rpI18n = Internationalizer.getInternationalizer(EquipmentRowProvider.class);
    private static String[] columnNames = new String[]{"Name", "Type", "HardwareRevision", "RunningSoftwareVersion", "MainSoftwareVersion", "ShadowSoftwareVersion", "IPAddress", "Location", "State"};
    private static String[] columnAttribNames = new String[]{"Name", "", "HardwareRevision", "RunningSoftwareVersion", "OperationalSoftwareVersion", "ShadowSoftwareVersion", "IPAddress", "Location", "State"};
    protected List<EntityManagerColumn> columns;
    protected EntityManagerRowProvider entityRowProvider;
    protected Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions = new Vector<ManagerAction>();
    private DefaultSelectAction selectAction = new DefaultSelectAction(1);
    private DefaultCancelAction cancelAction = new DefaultCancelAction(2);

    public RbAUSelectorConfig() {
        this(Integer.MAX_VALUE);
    }

    public RbAUSelectorConfig(int maxSelection) {
        this.declaredActions.add((ManagerAction)this.selectAction);
        this.declaredActions.add((ManagerAction)this.cancelAction);
        this.columns = new Vector<EntityManagerColumn>();
        this.addColumn(0, (Comparator<EntityManagerRow>)new EntityManagerRowDisplayComparator(0));
        this.addColumn(1, (Comparator<EntityManagerRow>)new EntityManagerRowDisplayComparator(1));
        this.addColumn(2, (Comparator<EntityManagerRow>)new EntityManagerRowComparator(2));
        this.addColumn(3, (Comparator<EntityManagerRow>)new EntityManagerRowComparator(3));
        this.addColumn(4, (Comparator<EntityManagerRow>)new EntityManagerRowComparator(4));
        this.addColumn(5, (Comparator<EntityManagerRow>)new EntityManagerRowComparator(5));
        this.addColumn(6, (Comparator<EntityManagerRow>)new EntityManagerRowComparator(6));
        this.addColumn(7, (Comparator<EntityManagerRow>)new EntityManagerRowDisplayComparator(7));
        this.addColumn(8, (Comparator<EntityManagerRow>)new EntityManagerRowDisplayComparator(8));
        this.entityRowProvider = new RbAURowCreator(RbAUSelectorConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.addTextFilterCriteria("Name", "name");
        this.addTextFilterCriteria("RunningSoftwareVersion", "runningSoftwareVersion");
        this.addTextFilterCriteria("MainSoftwareVersion", "operationalSoftwareVersion");
        this.addTextFilterCriteria("ShadowSoftwareVersion", "shadowSoftwareVersion");
        this.addIpAddressFilterCriteria();
        this.addTextFilterCriteria("Location", "location.name");
        this.addTextFilterCriteria("HardwareRevision", "hardwareRevision");
        this.addStateFilterCriteria();
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.selectAction;
    }

    public ManagerResultsView getResultsView() {
        return new EntityManagerResultView((EntityManagerRowTableModel)new IconEntityManagerRowTableModel(this.getEntityRowProvider(), this.getColumnTitles()){
            private static final long serialVersionUID = 6054567575618843883L;

            protected Icon getIcon(Serializable entity) {
                return UIIconFactory.getIcon((Object)entity, (int)2);
            }
        }, this.getColumns());
    }

    protected String getBaseName() {
        return RbAU.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public String getTitle() {
        return rpI18n.translateString("RbAUSelectorTitle");
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        this.selectAction.setSelectionListener(selectorListener);
        this.cancelAction.setSelectionListener(selectorListener);
    }

    protected void addColumn(int index, Comparator<EntityManagerRow> comparator) {
        this.columns.add(new EntityManagerColumn(columnNames[index], columnAttribNames[index], rpI18n.translateString(columnNames[index]), comparator));
    }

    protected void addTextFilterCriteria(String title, String attribute) {
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(rpI18n.translateString(title), attribute, 1, 1, null, false));
    }

    protected void addStateFilterCriteria() {
        Vector<ComboItem> stateItems = new Vector<ComboItem>();
        String[] stateTexts = new String[]{"Unknown", "Unreachable", "Up", "Down"};
        String[] stateValues = new String[]{"-3", "-1", "0", "1"};
        for (int i = 0; i < stateTexts.length; ++i) {
            stateItems.add(new ComboItem((Object)stateValues[i], rpI18n.translateString(stateTexts[i])));
        }
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(rpI18n.translateString("State"), "state", 1, 3, stateItems, false));
    }

    protected void addIpAddressFilterCriteria() {
        EntityManagerFilterCriteria ipAddrCriteria = new EntityManagerFilterCriteria(rpI18n.translateString("IPAddress"), "ipAddr", 3, 2, null, true, false);
        ipAddrCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                for (int i = 0; i < selectedValues.size(); ++i) {
                    String val = selectedValues.get(i).toString().trim();
                    if (!"".equals(val)) {
                        try {
                            selectedValues.set(i, new Long(new IpAddress(val).getIpAddress()));
                            continue;
                        }
                        catch (Exception e) {
                            throw new InvalidFilterValueException(val);
                        }
                    }
                    selectedValues.set(i, val);
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)ipAddrCriteria);
    }

    public String getHelpTopic() {
        return "ngnms.rb.help.au_tdd_view";
    }
}

