/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.selectors.equipment;

import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.gui.equipmentmanager.AllEquipmentManagerConfig;
import com.bwanms.gui.equipmentmanager.EquipmentRowProvider;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentStateEnum;
import com.bwanms.model.Location;
import com.bwanms.util.IpAddress;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbAURowCreator
extends EntityManagerRowProviderBase {
    private static final long serialVersionUID = -475533835251190913L;
    private static final int IDX_TYPE = 1;
    private static final int IDX_IP_ADDRESS = 6;
    private static final int IDX_LOCATION = 7;
    private static final int IDX_STATE = 8;

    public RbAURowCreator(List<String> attributes) {
        super(attributes);
    }

    protected String readEntityId(Serializable entity) {
        return String.valueOf(((Equipment)entity).getId());
    }

    protected List<Serializable> readAttributeValues(Serializable entity) {
        List ret = super.readAttributeValues(entity);
        ret.set(1, entity.getClass().getName());
        String ipAddress = (String)ret.get(6);
        ret.set(6, null != ipAddress ? new IpAddress(ipAddress) : null);
        Location location = (Location)ret.get(7);
        ret.set(7, location == null ? null : location.getName());
        ret.set(8, LicenseHelper.isLicensed((Object)entity) ? (Integer)ret.get(8) : null);
        return ret;
    }

    public List<String> getDisplayValues(EntityManagerRow entityRow) {
        List ret = super.getDisplayValues(entityRow);
        ret.set(1, AllEquipmentManagerConfig.ddI18N.translateString((String)ret.get(1)));
        Integer state = (Integer)entityRow.getAttributeValue(8);
        if (state == null) {
            ret.set(8, EquipmentRowProvider.i18n.translateString("Unlicensed"));
        } else {
            ret.set(8, EquipmentRowProvider.i18n.translateString(EquipmentStateEnum.toString((int)state)));
        }
        return ret;
    }
}

