/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers.filemanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.manager.generic.SimpleEntityQueryStrategy;
import com.bwanms.rb.gui.managers.filemanager.FileExportUtil;
import com.bwanms.rb.model.RbPMTMCollectionFile;
import com.bwanms.rb.tasks.pmtm.RbPMTMTask;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.DateFormatter;
import com.bwanms.util.IpAddress;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbPMTMCollectionManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(RbPMTMCollectionManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbPMTMCollectionManagerConfig.class);
    private static final Internationalizer i18nTask = Internationalizer.getInternationalizer((String)"com.bwanms.tasks");
    private static final Internationalizer i18nRbPMTM = Internationalizer.getInternationalizer(RbPMTMTask.class);
    private static String[] columnNames = new String[]{"EquipmentName", "EquipmentLocation", "EquipmentIp", "Date", "FileType"};
    private static String[] columnAttribNames = new String[]{"EquipmentName", "LocationName", "EquipmentIp", "Date", "FileType"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public RbPMTMCollectionManagerConfig() {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.add(new EntityManagerColumn(columnNames[i], columnAttribNames[i], i18n.translateString(columnNames[i]), (Comparator)new EntityManagerRowDisplayComparator(i)));
        }
        this.entityRowProvider = new PMTMManagerRowProvider(RbPMTMCollectionManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("EquipmentName"), "equipmentName", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("EquipmentLocation"), "locationName", 1, 1, null, false));
        EntityManagerFilterCriteria ipAddrCriteria = new EntityManagerFilterCriteria(i18n.translateString("EquipmentIp"), "equipmentIp", 3, 2, null, true, false);
        ipAddrCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                for (int i = 0; i < selectedValues.size(); ++i) {
                    String val = selectedValues.get(i).toString().trim();
                    if (!"".equals(val)) {
                        try {
                            selectedValues.set(i, IpAddress.parse((String)val));
                            continue;
                        }
                        catch (Exception e) {
                            throw new InvalidFilterValueException(val);
                        }
                    }
                    selectedValues.set(i, val);
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)ipAddrCriteria);
        EntityManagerFilterCriteria dateCriteria = new EntityManagerFilterCriteria(i18n.translateString("Date"), "timestamp", 4, 7, null, false);
        dateCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                for (int i = 0; i < selectedValues.size(); ++i) {
                    String val = selectedValues.get(i).toString().trim();
                    if (!"".equals(val)) {
                        try {
                            SimpleDateFormat dateFrom = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            Date date = dateFrom.parse(val);
                            selectedValues.set(i, date.getTime());
                            if (i != 1 || ((Long)selectedValues.get(i - 1)).compareTo((Long)selectedValues.get(i)) <= 0) continue;
                            throw new InvalidFilterValueException(val);
                        }
                        catch (Exception e) {
                            throw new InvalidFilterValueException(val);
                        }
                    }
                    selectedValues.set(i, val);
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)dateCriteria);
        Vector<ComboItem> vec = new Vector<ComboItem>();
        for (RbPMTMCollectionFile.FileType fileType : RbPMTMCollectionFile.FileType.values()) {
            vec.add(new ComboItem((Object)fileType, i18nRbPMTM.translateString(fileType.name())));
        }
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("FileType"), "fileType", 1, 3, vec, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new PMTMManagerAction("Export", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new PMTMManagerAction("Delete", 1));
    }

    protected String getBaseName() {
        return RbPMTMCollectionFile.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public EntityQueryStrategy getQueryStrategy() {
        return new SimpleEntityQueryStrategy();
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        if (this.declaredActions.get(0).getName().equals("New")) {
            this.declaredActions.remove(0);
        }
        this.defaultAction = new PMTMManagerAction("Select", 1, selectorListener);
        this.declaredActions.set(0, this.defaultAction);
    }

    public String getTitle() {
        return i18n.translateString("PMTMManager");
    }

    public String getHelpTopic() {
        return "pmtm_manager";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PMTMManagerRowProvider
    extends DefaultRowCreator {
        private static final long serialVersionUID = 6762642696642313629L;

        public PMTMManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            Date date = (Date)entityRow.getAttributeValue("Date");
            Long ipAddressLong = (Long)entityRow.getAttributeValue("EquipmentIp");
            IpAddress ipAddresss = new IpAddress(ipAddressLong.longValue());
            List ret = super.getDisplayValues(entityRow);
            ret.set(2, ipAddresss.toString());
            ret.set(3, DateFormatter.formatSimple((Date)date));
            ret.set(4, i18nRbPMTM.translateString((String)((Object)entityRow.getAttributeValue("FileType"))));
            return ret;
        }

        public String readEntityId(Serializable entity) {
            return String.valueOf(((RbPMTMCollectionFile)((Object)entity)).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PMTMManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;
        private String exportPath;

        public PMTMManagerAction(String name, int category) {
            this(name, category, null);
        }

        public PMTMManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        public void performAction(final ManagerView manager) {
            final List selections = manager.getSelection();
            if ("Delete".equals(this.name) && !selections.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult((Component)manager.getUI(), i18n.translateString("DeleteConfirmation"), i18n.translateString("DeleteConfirmationTitle"))) {
                    return;
                }
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selections.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)manager;
                        }
                        for (Serializable row : selections) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            RbPMTMCollectionFile dataFile = (RbPMTMCollectionFile)((Object)row);
                            String message = i18n.translateString("DeletingPMTMFile", new Object[]{dataFile.getEquipmentName(), DateFormatter.formatSimple((Date)dataFile.getDate())});
                            this.monitor.updateProgress(progress, message);
                            try {
                                ServiceRegistry.getEntityManagerService().delete((Serializable)((Object)dataFile));
                                if (listener != null) {
                                    listener.entityRemoved(row);
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", new Object[]{dataFile.getEquipmentName(), DateFormatter.formatSimple((Date)dataFile.getDate())}));
                            }
                            catch (ServiceException e) {
                                log.error((Object)e, (Throwable)e);
                                this.monitor.logMessage(i18n.translateString("DeletingError", new Object[]{dataFile.getEquipmentName(), DateFormatter.formatSimple((Date)dataFile.getDate())}));
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog((JComponent)manager.getUI(), (LongOperation)deleteOperation);
            } else if ("Export".equals(this.name) && !selections.isEmpty()) {
                try {
                    String currentExportPath = FileExportUtil.selectExportPath(this.exportPath);
                    if (null == currentExportPath) {
                        return;
                    }
                    this.exportPath = currentExportPath;
                }
                catch (IOException e) {
                    log.error((Object)i18n.translateString("ExportPathError"), (Throwable)e);
                }
                AbstractLongOperation exportOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("ExportTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selections.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)manager;
                        }
                        for (Serializable row : selections) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            boolean success = false;
                            RbPMTMCollectionFile file = (RbPMTMCollectionFile)((Object)row);
                            String formattedDate = DateFormatter.formatSimple((Date)file.getDate());
                            String exportFileName = String.format("%s", file.getFileName());
                            String message = i18n.translateString("ExportingFile", new Object[]{exportFileName, formattedDate});
                            this.monitor.updateProgress(progress, message);
                            try {
                                FileExportUtil.exportFile(file, PMTMManagerAction.this.exportPath, exportFileName);
                                success = true;
                            }
                            catch (ServiceException e) {
                                log.error((Object)e, (Throwable)e);
                                this.monitor.logMessage(i18n.translateString("ExportError", new Object[]{exportFileName, formattedDate}));
                            }
                            catch (IOException e) {
                                log.error((Object)e, (Throwable)e);
                                this.monitor.logMessage(i18n.translateString("ExportError", new Object[]{exportFileName, formattedDate}));
                            }
                            if (success) {
                                this.monitor.logMessage(i18n.translateString("SuccesfullyExported", new Object[]{exportFileName, formattedDate}));
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog((JComponent)manager.getUI(), (LongOperation)exportOperation);
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Delete")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "delete")) {
                    return false;
                }
                return selectionSize > 0;
            }
            if (this.name.equals("Export")) {
                return selectionSize > 0;
            }
            return true;
        }

        public Internationalizer getI18n() {
            return i18n;
        }
    }
}

