/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers.filemanager;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.ExceptionUtil;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.manager.generic.SimpleEntityQueryStrategy;
import com.bwanms.gui.taskmanager.VolatileTaskEditorFormContainer;
import com.bwanms.model.ConfigFileImporter;
import com.bwanms.model.Task;
import com.bwanms.rb.gui.managers.filemanager.FileExportUtil;
import com.bwanms.rb.model.RbBackupConfigFile;
import com.bwanms.rb.tasks.configbackup.RbConfigBackupTask;
import com.bwanms.rb.tasks.configbackup.RbConfigRestoreTask;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ExtensionFileFilter;
import com.bwanms.util.ConfigurationPluginUtil;
import com.bwanms.util.DateFormatter;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.MessageBox;
import com.bwanms.util.TaskPluginUtil;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBackupConfigManagerConfig
extends EntityManagerConfig {
    private static final Logger log = Logger.getLogger(RbBackupConfigManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbBackupConfigManagerConfig.class);
    private static final Internationalizer i18nTask = Internationalizer.getInternationalizer((String)"com.bwanms.tasks");
    private static final Internationalizer i18nRbBackup = Internationalizer.getInternationalizer(RbConfigBackupTask.class);
    private static String[] columnNames = new String[]{"EquipmentName", "EquipmentLocation", "EquipmentIp", "Date", "FileType", "Description", "Status"};
    private static String[] columnAttribNames = new String[]{"EquipmentName", "LocationName", "EquipmentIp", "Date", "FileType", "description", "status"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public RbBackupConfigManagerConfig() {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.add(new EntityManagerColumn(columnNames[i], columnAttribNames[i], i18n.translateString(columnNames[i]), (Comparator)new EntityManagerRowDisplayComparator(i)));
        }
        this.entityRowProvider = new ConfigBackupManagerRowProvider(RbBackupConfigManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("EquipmentName"), "equipmentName", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("EquipmentLocation"), "locationName", 1, 1, null, false));
        EntityManagerFilterCriteria ipAddrCriteria = new EntityManagerFilterCriteria(i18n.translateString("EquipmentIp"), "equipmentIp", 3, 2, null, true, false);
        ipAddrCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                for (int i = 0; i < selectedValues.size(); ++i) {
                    String val = selectedValues.get(i).toString().trim();
                    if (!"".equals(val)) {
                        try {
                            selectedValues.set(i, IpAddress.parse((String)val));
                            continue;
                        }
                        catch (Exception e) {
                            throw new InvalidFilterValueException(val);
                        }
                    }
                    selectedValues.set(i, val);
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)ipAddrCriteria);
        EntityManagerFilterCriteria dateCriteria = new EntityManagerFilterCriteria(i18n.translateString("Date"), "timestamp", 4, 7, null, false);
        dateCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                for (int i = 0; i < selectedValues.size(); ++i) {
                    String val = selectedValues.get(i).toString().trim();
                    if (!"".equals(val)) {
                        try {
                            SimpleDateFormat dateFrom = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                            Date date = dateFrom.parse(val);
                            selectedValues.set(i, date.getTime());
                            if (i != 1 || ((Long)selectedValues.get(i - 1)).compareTo((Long)selectedValues.get(i)) <= 0) continue;
                            throw new InvalidFilterValueException(val);
                        }
                        catch (Exception e) {
                            throw new InvalidFilterValueException(val);
                        }
                    }
                    selectedValues.set(i, val);
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)dateCriteria);
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Description"), "description", 1, 1, null, false));
        Vector<ComboItem> vec = new Vector<ComboItem>();
        for (RbBackupConfigFile.FileType fileType : RbBackupConfigFile.FileType.values()) {
            vec.add(new ComboItem((Object)fileType, i18nRbBackup.translateString(fileType.name())));
        }
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("FileType"), "fileType", 1, 3, vec, false));
        vec = new Vector();
        vec.add(new ComboItem((Object)2, i18n.translateString("status_imported")));
        vec.add(new ComboItem((Object)1, i18n.translateString("status_normal")));
        vec.add(new ComboItem((Object)3, i18n.translateString("status_orphan")));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("status"), "status", 2, 3, vec, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new ConfigBackupManagerAction("Restore", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new ConfigBackupManagerAction("Delete", 1));
        this.declaredActions.add(new ConfigBackupManagerAction("Export", 1));
        this.declaredActions.add(new ConfigBackupManagerAction("Import", 1));
    }

    protected String getBaseName() {
        return RbBackupConfigFile.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public EntityQueryStrategy getQueryStrategy() {
        return new SimpleEntityQueryStrategy();
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        if (this.declaredActions.get(0).getName().equals("New")) {
            this.declaredActions.remove(0);
        }
        this.defaultAction = new ConfigBackupManagerAction("Select", 1, selectorListener);
        this.declaredActions.set(0, this.defaultAction);
    }

    public String getTitle() {
        return i18n.translateString("ConfigBackupManager");
    }

    public String getHelpTopic() {
        return "backup_manager";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigBackupManagerRowProvider
    extends DefaultRowCreator {
        private static final long serialVersionUID = 6762642696642313629L;

        public ConfigBackupManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            Date date = (Date)entityRow.getAttributeValue("Date");
            Long ipAddressLong = (Long)entityRow.getAttributeValue("EquipmentIp");
            List ret = super.getDisplayValues(entityRow);
            ret.set(2, ipAddressLong != -1L ? new IpAddress(ipAddressLong.longValue()).toString() : "");
            ret.set(3, DateFormatter.formatSimple((Date)date));
            ret.set(4, i18nRbBackup.translateString((String)((Object)entityRow.getAttributeValue("FileType"))));
            switch ((Integer)entityRow.getAttributeValue("status")) {
                case 2: {
                    ret.set(6, i18n.translateString("status_imported"));
                    break;
                }
                case 1: {
                    ret.set(6, i18n.translateString("status_normal"));
                    break;
                }
                case 3: {
                    ret.set(6, i18n.translateString("status_orphan"));
                }
            }
            return ret;
        }

        public String readEntityId(Serializable entity) {
            return String.valueOf(((RbBackupConfigFile)((Object)entity)).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigBackupManagerAction
    extends ManagerAction {
        private EntitiesSelectedCallback selectorListener;
        private String exportPath;

        public ConfigBackupManagerAction(String name, int category) {
            this(name, category, null);
        }

        public ConfigBackupManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        public void performAction(final ManagerView manager) {
            final List selections = manager.getSelection();
            if ("Restore".equals(this.name)) {
                RbBackupConfigFile backup = (RbBackupConfigFile)((Object)manager.getSelection().get(0));
                try {
                    Class taskClass = TaskPluginUtil.getConfigRestoreTaskForClass(((Object)((Object)backup)).getClass());
                    RbConfigRestoreTask task = (RbConfigRestoreTask)((Object)taskClass.newInstance());
                    task.setBackup(backup);
                    new VolatileTaskEditorFormContainer(taskClass, (Task)task);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if ("Delete".equals(this.name) && !selections.isEmpty()) {
                if (!MessageBox.WarnConfirm.showResult((Component)manager.getUI(), i18n.translateString("DeleteConfirmation"), i18n.translateString("DeleteConfirmationTitle"))) {
                    return;
                }
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selections.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)manager;
                        }
                        for (Serializable row : selections) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            RbBackupConfigFile backup = (RbBackupConfigFile)((Object)row);
                            String message = i18n.translateString("DeletingBackup", new Object[]{backup.getEquipmentName(), DateFormatter.formatSimple((Date)backup.getDate())});
                            this.monitor.updateProgress(progress, message);
                            try {
                                ServiceRegistry.getEntityManagerService().delete((Serializable)((Object)backup));
                                if (listener != null) {
                                    listener.entityRemoved(row);
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", new Object[]{backup.getEquipmentName(), DateFormatter.formatSimple((Date)backup.getDate())}));
                            }
                            catch (ServiceException e) {
                                log.error((Object)e, (Throwable)e);
                                this.monitor.logMessage(i18n.translateString("DeletingError", new Object[]{backup.getEquipmentName(), DateFormatter.formatSimple((Date)backup.getDate())}));
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog((JComponent)manager.getUI(), (LongOperation)deleteOperation);
            } else if ("Export".equals(this.name) && !selections.isEmpty()) {
                try {
                    String currentExportPath = FileExportUtil.selectExportPath(this.exportPath);
                    if (null == currentExportPath) {
                        return;
                    }
                    this.exportPath = currentExportPath;
                }
                catch (IOException e) {
                    log.error((Object)i18n.translateString("ExportPathError"), (Throwable)e);
                }
                AbstractLongOperation exportOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("ExportTitle");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selections.size();
                    }

                    public void run() {
                        long progress = 0L;
                        EntityChangeListener listener = null;
                        if (manager instanceof EntityChangeListener) {
                            listener = (EntityChangeListener)manager;
                        }
                        for (Serializable row : selections) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            boolean success = false;
                            RbBackupConfigFile file = (RbBackupConfigFile)((Object)row);
                            String formattedDate = DateFormatter.formatSimple((Date)file.getDate());
                            String exportFileName = String.format("%s_%s_%s.res", file.getEquipmentName(), i18nTask.translateString(file.getFileType()), DateFormatter.formatDotted((Date)file.getDate()));
                            String message = i18n.translateString("ExportingFile", new Object[]{exportFileName, formattedDate});
                            this.monitor.updateProgress(progress, message);
                            try {
                                FileExportUtil.exportFile(file, ConfigBackupManagerAction.this.exportPath, exportFileName);
                                success = true;
                            }
                            catch (ServiceException e) {
                                log.error((Object)e, (Throwable)e);
                                this.monitor.logMessage(i18n.translateString("ExportError", new Object[]{exportFileName, formattedDate}));
                            }
                            catch (IOException e) {
                                log.error((Object)e, (Throwable)e);
                                this.monitor.logMessage(i18n.translateString("ExportError", new Object[]{exportFileName, formattedDate}));
                            }
                            if (success) {
                                this.monitor.logMessage(i18n.translateString("SuccesfullyExported", new Object[]{exportFileName, formattedDate}));
                            }
                            this.monitor.updateProgress(++progress, message);
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog((JComponent)manager.getUI(), (LongOperation)exportOperation);
            } else if ("Import".equals(this.name)) {
                JFileChooser chooser = new JFileChooser();
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle(i18n.translateString("ImportFileChooserTitle"));
                chooser.setApproveButtonText(i18n.translateString("ImportFileChooserApproveButton"));
                chooser.setApproveButtonToolTipText(i18n.translateString("ImportFileChooserApproveButtonToolTip"));
                ExtensionFileFilter fileExtFilter = new ExtensionFileFilter();
                fileExtFilter.addExtension("res");
                fileExtFilter.setDescription(i18n.translateString("ImportConfigFileFilterDescr", new Object[]{"*.res"}));
                chooser.setFileFilter((FileFilter)fileExtFilter);
                JFrame frame = FrameUtil.createFrame();
                int returnVal = chooser.showOpenDialog(frame);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    try {
                        FileInputStream in = new FileInputStream(file);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        byte[] buff = new byte[1024];
                        int count = 0;
                        while ((count = in.read(buff)) >= 0) {
                            out.write(buff, 0, count);
                        }
                        byte[] content = out.toByteArray();
                        List importers = ConfigurationPluginUtil.getInstance().getConfigFileImporters();
                        for (ConfigFileImporter importer : importers) {
                            if (importer.accept(content)) {
                                RbBackupConfigFile backup = (RbBackupConfigFile)importer.getBackup();
                                backup.setStatus(2);
                                try {
                                    backup = (RbBackupConfigFile)((Object)ServiceRegistry.getEntityManagerService().save((Serializable)((Object)backup)));
                                    if (!(manager instanceof EntityChangeListener)) continue;
                                    EntityChangeListener listener = (EntityChangeListener)manager;
                                    listener.entityAdded((Serializable)((Object)backup));
                                }
                                catch (ServiceException e) {
                                    log.debug((Object)e, (Throwable)e);
                                    MessageBox.Error.quickShow((Component)frame, i18n.translateString("PersistenceError", new Object[]{ExceptionUtil.getMessage((Throwable)e)}));
                                }
                                continue;
                            }
                            MessageBox.Error.quickShow((Component)frame, i18n.translateString("ImportError", new Object[]{file.getAbsolutePath()}));
                        }
                    }
                    catch (IOException e) {
                        log.debug((Object)e, (Throwable)e);
                        MessageBox.Error.quickShow((Component)frame, i18n.translateString("PersistenceError", new Object[]{ExceptionUtil.getMessage((Throwable)e)}));
                    }
                }
            } else if ("Select".equals(this.name) && 1 == selections.size()) {
                this.selectorListener.entitiesSelected(manager.getSelection());
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Open")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("Delete")) {
                if (!Security.getSecurity().checkPermissions("Av:ConfigureEquipment", "delete")) {
                    return false;
                }
                return selectionSize > 0;
            }
            if (this.name.equals("Restore")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("Export")) {
                return selectionSize > 0;
            }
            return true;
        }

        public Internationalizer getI18n() {
            return i18n;
        }
    }

    public static class ConfigBackupDummy
    implements Serializable {
        private static final long serialVersionUID = 241912756671575338L;
        private long id;
        private String equipment;
        private String date;
        private String type;

        public ConfigBackupDummy(long id, String string, String string2, String i) {
            this.id = id;
            this.equipment = string;
            this.date = string2;
            this.type = i;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getEquipment() {
            return this.equipment;
        }

        public void setEquipment(String equipment) {
            this.equipment = equipment;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

