/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers.filemanager;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.file.AbstractFile;
import com.bwanms.model.file.FileUtil;
import com.bwanms.services.ServiceException;
import com.bwanms.util.FrameUtil;
import com.l2fprod.common.swing.JDirectoryChooser;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFrame;

public class FileExportUtil {
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(FileExportUtil.class);

    public static String selectExportPath(String exportPath) throws IOException {
        String selectedExportPath = null;
        JFrame frame = FrameUtil.createFrame();
        JDirectoryChooser dirChooser = new JDirectoryChooser();
        String openingPath = exportPath;
        if (null == openingPath) {
            openingPath = ".";
        }
        dirChooser.setCurrentDirectory(new File(openingPath));
        dirChooser.setDialogTitle(i18n.translateString("ChooseDirectoryTitle"));
        dirChooser.setMultiSelectionEnabled(false);
        dirChooser.setDialogType(1);
        dirChooser.setApproveButtonText(i18n.translateString("Select"));
        if (dirChooser.showSaveDialog((Component)frame) == 0) {
            selectedExportPath = dirChooser.getSelectedFile().getCanonicalPath();
        }
        return selectedExportPath;
    }

    public static void exportFile(AbstractFile abstractFile, String exportPath, String fileName) throws ServiceException, IOException {
        Date date = abstractFile.getDate();
        if (date == null) {
            date = Calendar.getInstance().getTime();
        }
        String fullPathFileName = exportPath + File.separator + FileUtil.escapeForFilesystem((String)fileName);
        File file = new File(fullPathFileName);
        FileOutputStream pw = new FileOutputStream(file);
        pw.write(FileUtil.getFileBytes((AbstractFile)abstractFile, (boolean)false));
        pw.flush();
        pw.close();
    }
}

