/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerQueryJoinClass;
import com.bwanms.gui.manager.generic.EntityManagerRowComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.serviceprofilemanager.ServiceProfileManagerConfig;
import com.bwanms.rb.mo.services.RbServiceTemplateConfigEntry;
import com.bwanms.rb.model.services.RbForwardingRule;
import com.bwanms.rb.model.services.RbServiceProfile;
import com.bwanms.rb.util.ValidatorUtil;
import com.bwanms.ui.components.ComboItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceProfileManagerConfig
extends ServiceProfileManagerConfig {
    private static Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceProfileManagerConfig.class);
    private static String NONE_STR = i18n.translateString("None");
    private static String ON_STR = i18n.translateString("On");
    private static String OFF_STR = i18n.translateString("Off");
    private static String TRANSPARENT_STR = i18n.translateString("Transparent");
    private static String _802_1_P_STR = i18n.translateString("802.1p");
    private static String DSCP_STR = i18n.translateString("DSCP");
    private static String NOT_APPLICABLE = i18n.translateString("NotApplicable");
    private static String[] columnNames = new String[]{"VPLId", "VLANTransparency", "PriorityMarking", "PriorityMarkingValue", "ForwardingRule", "DeploymentCount"};
    private static String[] columnAttribNames = new String[]{"VPLId", "VLANTransparencyMode", "PriorityMarkingMode", "PriorityMarkingValue", "synthetic1", "synthetic2"};
    List<EntityManagerColumn> columns = super.getColumns();
    EntityManagerRowProvider entityRowProvider;
    private List<ManagerFilterCriteria> filterCriteria;
    List<ManagerAction> declaredActions;
    ManagerAction defaultAction;
    private String selectorName;

    public RbServiceProfileManagerConfig() {
        int baseColsSize = this.columns.size();
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), (Comparator)new EntityManagerRowComparator(baseColsSize + 0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(baseColsSize + 1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], columnAttribNames[2], i18n.translateString(columnNames[2]), (Comparator)new EntityManagerRowDisplayComparator(baseColsSize + 2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], columnAttribNames[3], i18n.translateString(columnNames[3]), (Comparator)new EntityManagerRowComparator(baseColsSize + 3)));
        this.columns.add(new EntityManagerColumn(columnNames[4], columnAttribNames[4], i18n.translateString(columnNames[4]), (Comparator)new EntityManagerRowDisplayComparator(baseColsSize + 4)));
        this.columns.add(new EntityManagerColumn(columnNames[5], columnAttribNames[5], i18n.translateString(columnNames[5]), (Comparator)new EntityManagerRowComparator(baseColsSize + 5)));
        this.entityRowProvider = new RbServiceProfileRowCreator(RbServiceProfileManagerConfig.getColumnAttributeNames(this.columns), baseColsSize);
        this.filterCriteria = super.getFilterCriteria();
        EntityManagerFilterCriteria VPLIdCriteria = new EntityManagerFilterCriteria(i18n.translateString("VPLId"), "VPLId", 2, 1, null, false);
        VPLIdCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                if (!selectedValues.isEmpty()) {
                    String vplid = selectedValues.get(0).toString().trim();
                    try {
                        if ("None".equalsIgnoreCase(vplid)) {
                            vplid = String.valueOf(4095);
                        } else if ("".equals(vplid)) {
                            vplid = "4096";
                        } else {
                            int vplIdInt = Integer.parseInt(vplid);
                            if (vplIdInt < 0 || vplIdInt > 4094) {
                                throw new InvalidFilterValueException(i18n.translateString("VPLIdFilterValue0to4094orNoneOrEmpty"));
                            }
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidFilterValueException(i18n.translateString("VPLIdFilterValue0to4094orNoneOrEmpty"));
                    }
                    selectedValues.set(0, vplid);
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)VPLIdCriteria);
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)1, ON_STR));
        items.add(new ComboItem((Object)2, OFF_STR));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("VLANTransparency"), "VLANTransparencyMode", 2, 3, items, false));
        items = new Vector();
        items.add(new ComboItem((Object)1, TRANSPARENT_STR));
        items.add(new ComboItem((Object)2, _802_1_P_STR));
        items.add(new ComboItem((Object)3, DSCP_STR));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("PriorityMarking"), "priorityMarkingMode", 2, 3, items, false));
        EntityManagerFilterCriteria priorityMarkingValueCriteria = new EntityManagerFilterCriteria(i18n.translateString("PriorityMarkingValue"), "priorityMarkingValue", 1, 1, null, false);
        priorityMarkingValueCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                String value;
                if (!(selectedValues.isEmpty() || (value = selectedValues.get(0).toString().trim()).equals("*") || value.equals(""))) {
                    try {
                        value = new Long(value).toString();
                        if (new Long(value) > 64L || new Long(value) < 0L) {
                            throw new InvalidFilterValueException(i18n.translateString("ValueMustBeLower"));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidFilterValueException(i18n.translateString("ValueMustBeANumberOrNumberToLarge"));
                    }
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)priorityMarkingValueCriteria);
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("ForwardingRuleName"), "forwardingRule.name", 1, 1, null, false));
        EntityManagerFilterCriteria deploymentCountCriteria = new EntityManagerFilterCriteria(i18n.translateString("DeploymentCount"), "serviceTemplateEntries.size", 3, 2, null, true, false);
        deploymentCountCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                if (!selectedValues.isEmpty()) {
                    try {
                        String value1 = (String)selectedValues.get(0);
                        String value2 = (String)selectedValues.get(1);
                        if (!value1.equals("") || !value2.equals("")) {
                            Integer.parseInt(value1);
                            Integer.parseInt(value2);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidFilterValueException(i18n.translateString("ValueMustBeANumber"));
                    }
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)deploymentCountCriteria);
    }

    protected String getBaseName() {
        return RbServiceProfile.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    public List<ManagerAction> getDeclaredActions() {
        if (null == this.declaredActions) {
            return super.getDeclaredActions();
        }
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        if (null == this.defaultAction) {
            return super.getDefaultAction();
        }
        return this.defaultAction;
    }

    public void setSelectorName(String selectorName) {
        this.selectorName = selectorName;
    }

    protected String getManagerName() {
        if (null != this.selectorName) {
            return this.selectorName;
        }
        return super.getManagerName();
    }

    public void setSelectorListener(EntitiesSelectedCallback selectorListener) {
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new RbServiceProfileManagerAction("Select", 1, selectorListener);
        this.declaredActions.add(this.defaultAction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RbServiceProfileRowCreator
    extends ServiceProfileManagerConfig.ServiceProfileRowCreator {
        private static final long serialVersionUID = 8907502871256170787L;
        int attrOffset;

        public RbServiceProfileRowCreator(List<String> attributes, int attrOffset) {
            super(attributes);
            this.attrOffset = attrOffset;
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            boolean vlanTransparencyModeOn;
            List ret = super.getDisplayValues(entityRow);
            String vplid = (String)ret.get(this.attrOffset);
            String strVlanTransparencyModeOn = (String)ret.get(this.attrOffset + 1);
            if (strVlanTransparencyModeOn == null || strVlanTransparencyModeOn.equals("")) {
                vlanTransparencyModeOn = true;
            } else {
                boolean bl = vlanTransparencyModeOn = 1 == Integer.parseInt(strVlanTransparencyModeOn);
            }
            if (vlanTransparencyModeOn) {
                ret.set(this.attrOffset, "");
            } else {
                ret.set(this.attrOffset, 4095 != Integer.parseInt(vplid) ? vplid : NONE_STR);
            }
            if (strVlanTransparencyModeOn == null || strVlanTransparencyModeOn.equals("")) {
                ret.set(this.attrOffset + 1, "");
            } else {
                ret.set(this.attrOffset + 1, vlanTransparencyModeOn ? ON_STR : OFF_STR);
            }
            String strPriorityMarkingMode = (String)ret.get(this.attrOffset + 2);
            if (strPriorityMarkingMode == null || strPriorityMarkingMode.equals("")) {
                ret.set(this.attrOffset + 2, "");
            } else {
                switch (Integer.parseInt(strPriorityMarkingMode)) {
                    case 1: {
                        ret.set(this.attrOffset + 2, TRANSPARENT_STR);
                        break;
                    }
                    case 2: {
                        ret.set(this.attrOffset + 2, _802_1_P_STR);
                        break;
                    }
                    case 3: {
                        ret.set(this.attrOffset + 2, DSCP_STR);
                        break;
                    }
                    case 4: {
                        ret.set(this.attrOffset + 2, "");
                    }
                }
            }
            String strPriorityMarkingValue = (String)ret.get(this.attrOffset + 3);
            if (strPriorityMarkingMode != null && ValidatorUtil.isNumeric(strPriorityMarkingValue) && Integer.parseInt(strPriorityMarkingValue) == RbServiceTemplateConfigEntry.RbServiceTemplateQoSMarkingValue_NotApplicable) {
                ret.set(this.attrOffset + 3, "");
            }
            if (((String)ret.get(1)).contains("IP Mode")) {
                for (int j = 0; this.attrOffset + j < ret.size() && j < 5; ++j) {
                    ret.set(this.attrOffset + j, "");
                }
            }
            return ret;
        }

        public List<EntityManagerQueryJoinClass> getEntityQueryJoinClasses() {
            ArrayList<EntityManagerQueryJoinClass> ret = super.getEntityQueryJoinClasses();
            if (null == ret) {
                ret = new ArrayList<EntityManagerQueryJoinClass>(1);
            }
            ret.add(new EntityManagerQueryJoinClass(RbServiceProfile.class, new String[]{"serviceTemplateEntries.size", "forwardingRule.name", "forwardingRule.type"}, new String[0], new String[0]));
            return ret;
        }

        public EntityManagerRow createRow(Serializable entity) {
            if (entity instanceof RbServiceProfile) {
                RbServiceProfile sp = (RbServiceProfile)((Object)entity);
                EntityManagerRow row = super.createRow((Serializable)((Object)sp));
                RbForwardingRule fwRule = sp.getForwardingRule();
                if (null != fwRule && !fwRule.isValueNull()) {
                    String fwRuleDesc = fwRule.getName() + " (" + i18n.translateString(RbForwardingRule.toStringType(fwRule.getType())) + ")";
                    row.setAttributeValue("synthetic1", (Serializable)((Object)fwRuleDesc));
                }
                row.setAttributeValue("synthetic2", (Serializable)Integer.valueOf(sp.getServiceTemplateEntries().size()));
                return row;
            }
            Object[] obj = (Object[])entity;
            EntityManagerRow row = super.createRow((Serializable)obj[0]);
            String fwRuleName = (String)obj[2];
            if (null != fwRuleName) {
                row.setAttributeValue("synthetic1", (Serializable)((Object)(fwRuleName + " (" + i18n.translateString(RbForwardingRule.toStringType((Integer)obj[3])) + ")")));
            }
            row.setAttributeValue("synthetic2", (Serializable)obj[1]);
            return row;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RbServiceProfileManagerAction
    extends ManagerAction {
        EntitiesSelectedCallback selectorListener;

        public RbServiceProfileManagerAction(String name, int category, EntitiesSelectedCallback selectorListener) {
            this.name = name;
            this.category = category;
            this.selectorListener = selectorListener;
        }

        public void performAction(ManagerView manager) {
            List selectionData = manager.getSelectionData();
            ArrayList selectionDataSerializable = new ArrayList(selectionData.size());
            selectionDataSerializable.addAll(selectionData);
            this.selectorListener.entitiesSelected(selectionDataSerializable);
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Select")) {
                return 0 < selectionSize;
            }
            return true;
        }
    }
}

