/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.client.gui.tasks.pmcollection.PMCollectionTaskWizardContainer;
import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.SelectorUtil;
import com.bwanms.gui.SelectorView;
import com.bwanms.gui.Selectors;
import com.bwanms.gui.View;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.gui.configuration.LongActionCallback;
import com.bwanms.gui.longoperation.AbstractLongOperation;
import com.bwanms.gui.longoperation.LongOperation;
import com.bwanms.gui.longoperation.LongOperationUtil;
import com.bwanms.gui.manager.EntitiesSelectedCallback;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerResultView;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerRowProviderBase;
import com.bwanms.gui.manager.generic.EntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.IconEntityManagerRowTableModel;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaJoinClass;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.manager.generic.SinglePageQueryStrategy;
import com.bwanms.gui.selectors.DefaultCancelAction;
import com.bwanms.gui.selectors.DefaultSelectAction;
import com.bwanms.gui.subscribermanager.SubscriberEditorContainer;
import com.bwanms.mo.EquipmentConfiguration;
import com.bwanms.model.Equipment;
import com.bwanms.model.Service;
import com.bwanms.model.Subscriber;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.persistence.Datastore;
import com.bwanms.rb.ddi.RbServiceEntryAssemblerFactory;
import com.bwanms.rb.gui.configuration.pm.ServicePerformanceMonitoringView;
import com.bwanms.rb.gui.icons.RbServiceEntryUIIconFactory;
import com.bwanms.rb.gui.managers.RbEntityManagerFilterView;
import com.bwanms.rb.gui.services.RbServiceEntryEditorContainer;
import com.bwanms.rb.mo.RbRegisteredSuEntry;
import com.bwanms.rb.mo.RbRegisteredSuTable;
import com.bwanms.rb.mo.services.RbServiceConfigEntry;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbBaseStationNRConfiguration;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.model.RbSUEquipmentConfiguration;
import com.bwanms.rb.model.services.RbSubscriber;
import com.bwanms.rb.performance.RbServiceEntryCollectionEntity;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceManagementService;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.platform.UIEventThread;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import com.bwanms.util.MacAddress;
import com.bwanms.util.MessageBox;
import com.bwanms.util.ServerValidationException;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbServiceGMLManagerConfig
extends EntityManagerConfig {
    private static final Logger logger = Logger.getLogger(RbServiceGMLManagerConfig.class);
    private static final Internationalizer i18n = Internationalizer.getInternationalizer(RbServiceGMLManagerConfig.class);
    private String[] columnNames = new String[]{"Name", "Type", "AdminStatus", "OperStatus", "ServiceProfile", "SubscriberId", "SUName", "SUMacAddr", "BS", "AUSlot"};
    private String[] columnAttribNames = new String[]{"", "", "", "", "", "", "", "", "", ""};
    private List<EntityManagerColumn> columns;
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;
    private String selectorName;

    public RbServiceGMLManagerConfig() {
        this.initCommon();
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add(new ServiceManagerAction("New", 1));
        this.defaultAction = new ServiceManagerAction("Open", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add(new ServiceManagerAction("ShowPM", 1));
        this.declaredActions.add(new ServiceManagerAction("PMCollect", 1));
        this.declaredActions.add(new ServiceManagerAction("OpenServingBST", 1));
        this.declaredActions.add(new ServiceManagerAction("OpenServingCPE", 1));
    }

    public RbServiceGMLManagerConfig(EntitiesSelectedCallback selectorListener) {
        this.initCommon();
        this.declaredActions = new Vector<ManagerAction>();
        DefaultSelectAction selectAction = new DefaultSelectAction(1, Integer.MAX_VALUE);
        selectAction.setSelectionListener(selectorListener);
        this.defaultAction = selectAction;
        this.declaredActions.add((ManagerAction)selectAction);
        DefaultCancelAction cancelAction = new DefaultCancelAction(1);
        cancelAction.setSelectionListener(selectorListener);
        this.declaredActions.add((ManagerAction)cancelAction);
    }

    public void setSelectorName(String selectorName) {
        this.selectorName = selectorName;
    }

    private void initCommon() {
        this.columns = new Vector<EntityManagerColumn>();
        this.columns.add(new EntityManagerColumn(this.columnNames[0], this.columnAttribNames[0], i18n.translateString(this.columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(this.columnNames[1], this.columnAttribNames[1], i18n.translateString(this.columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(this.columnNames[2], this.columnAttribNames[2], i18n.translateString(this.columnNames[2]), (Comparator)new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(this.columnNames[3], this.columnAttribNames[3], i18n.translateString(this.columnNames[3]), (Comparator)new EntityManagerRowDisplayComparator(3)));
        this.columns.add(new EntityManagerColumn(this.columnNames[4], this.columnAttribNames[4], i18n.translateString(this.columnNames[4]), (Comparator)new EntityManagerRowDisplayComparator(4)));
        this.columns.add(new EntityManagerColumn(this.columnNames[5], this.columnAttribNames[5], i18n.translateString(this.columnNames[5]), (Comparator)new EntityManagerRowDisplayComparator(5)));
        this.columns.add(new EntityManagerColumn(this.columnNames[6], this.columnAttribNames[6], i18n.translateString(this.columnNames[6]), (Comparator)new EntityManagerRowDisplayComparator(6)));
        this.columns.add(new EntityManagerColumn(this.columnNames[7], this.columnAttribNames[7], i18n.translateString(this.columnNames[7]), (Comparator)new EntityManagerRowDisplayComparator(7)));
        this.columns.add(new EntityManagerColumn(this.columnNames[8], this.columnAttribNames[8], i18n.translateString(this.columnNames[8]), (Comparator)new EntityManagerRowDisplayComparator(8)));
        this.columns.add(new EntityManagerColumn(this.columnNames[9], this.columnAttribNames[9], i18n.translateString(this.columnNames[9]), (Comparator)new EntityManagerRowDisplayComparator(9)));
        this.entityRowProvider = new RbServiceGMLRowCreator(RbServiceGMLManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Name"), "rbServiceName", 1, 1, null, false));
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)1, i18n.translateString("L2")));
        items.add(new ComboItem((Object)2, i18n.translateString("PPPoE")));
        items.add(new ComboItem((Object)3, i18n.translateString("VoIP")));
        items.add(new ComboItem((Object)4, i18n.translateString("IPmodeData")));
        items.add(new ComboItem((Object)5, i18n.translateString("IPmodeVoIP")));
        items.add(new ComboItem((Object)6, i18n.translateString("ManagedVoIP")));
        items.add(new ComboItem((Object)7, i18n.translateString("IPModeManagedVoIP")));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("Type"), "rbServiceType", 2, 3, items, false));
        items = new Vector();
        items.add(new ComboItem((Object)"1", i18n.translateString("Enable")));
        items.add(new ComboItem((Object)"2", i18n.translateString("Disable")));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("AdminStatus"), "rbServiceAdminStatus", 2, 3, items, false));
        items = new Vector();
        items.add(new ComboItem((Object)"1", i18n.translateString("Up")));
        items.add(new ComboItem((Object)"2", i18n.translateString("Down")));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("OperStatus"), "rbServiceOperStatus", 2, 3, items, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("ServiceProfile"), "rbServiceServiceTemplateName", 1, 1, null, false));
        EntityManagerFilterCriteria suNameCriteria = new EntityManagerFilterCriteria("RbServiceFilterBySuName", i18n.translateString("SUName"), "rbSuSysName", new ManagerFilterCriteriaJoinClass(RbRegisteredSuEntry.class, new String[]{"NRConfiguration", "rbServiceSuMacAddress"}, new String[]{"NRConfiguration", "rbSuMacAddr"}), 1, 1, null, false);
        this.filterCriteria.add((ManagerFilterCriteria)suNameCriteria);
        EntityManagerFilterCriteria macAddressCriteria = new EntityManagerFilterCriteria(i18n.translateString("SUMacAddr"), "rbServiceSuMacAddress", 1, 1, null, false);
        macAddressCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                String value = (String)selectedValues.get(0);
                String result = value.contains(":") ? "" : value.replace("-", ":");
                selectedValues.set(0, result);
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)macAddressCriteria);
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("SubscriberId"), "rbSubscriberID", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("BS"), "NRConfiguration.configuration.equipment.name", 1, 1, null, false));
        EntityManagerFilterCriteria auSlotCriteria = new EntityManagerFilterCriteria(i18n.translateString("AUSlotNumber"), "rbServiceAUSlotNumber", 2, 1, null, false);
        auSlotCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                String value = (String)selectedValues.get(0);
                if (null != value && 0 == value.trim().length()) {
                    selectedValues.set(0, "255");
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)auSlotCriteria);
        EntityManagerFilterCriteria BSIpAddressCriteria = new EntityManagerFilterCriteria(i18n.translateString("BSIp"), "NRConfiguration.configuration.equipment.ipAddr", 2, 1, null, false);
        BSIpAddressCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                String value = (String)selectedValues.get(0);
                if (null != value && 0 != value.trim().length()) {
                    selectedValues.set(0, IpAddress.parse((String)value));
                }
                return selectedValues;
            }
        });
        this.filterCriteria.add((ManagerFilterCriteria)BSIpAddressCriteria);
    }

    protected String getBaseName() {
        return RbServiceConfigEntry.class.getName();
    }

    protected String getManagerName() {
        return null != this.selectorName ? this.selectorName : super.getManagerName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    private static List<RbSUEquipmentConfiguration> getRbSUEquipmentConfigurationList(final RbServiceConfigEntry selectedService) {
        List ecList = null;
        try {
            LightQuery<RbSUEquipmentConfiguration> q = new LightQuery<RbSUEquipmentConfiguration>(RbSUEquipmentConfiguration.class){

                public List<RbSUEquipmentConfiguration> execute() {
                    String qry = "SELECT ec FROM " + RbSUEquipmentConfiguration.class.getName() + " AS ec WHERE ec.equipment.EUID = :mac";
                    List ret = Datastore.session().createQuery(qry).setParameter("mac", (Object)MacAddress.fromOctetString((String)selectedService.getRbServiceSuMacAddress()).toSimpleString()).list();
                    return ret;
                }
            };
            ecList = ServiceRegistry.getEntityManagerService().retrieveByQuery((LightQuery)q);
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
        }
        return ecList;
    }

    public ManagerResultsView getResultsView() {
        return new EntityManagerResultView((EntityManagerRowTableModel)new IconEntityManagerRowTableModel(this.getEntityRowProvider(), this.getColumnTitles()){

            protected Icon getIcon(Serializable entity) {
                return RbServiceEntryUIIconFactory.getIconImpl((RbServiceConfigEntry)((Object)entity));
            }
        }, this.getColumns());
    }

    public EntityQueryStrategy getQueryStrategy() {
        return new SinglePageQueryStrategy();
    }

    public String getTitle() {
        return i18n.translateString("RbServiceManager");
    }

    public ManagerFilterView getFilterView() {
        return new RbEntityManagerFilterView(this.getManagerName(), this.getBaseName(), this.getFilterCriteria(), this.getEntityRowProvider());
    }

    public static boolean nullSafeEquals(Object x, Object y) {
        logger.debug((Object)("Comparing '" + x + "' with '" + y + "'"));
        if (x == y) {
            return true;
        }
        if (x == null || x.toString().equals("")) {
            return y == null || y.toString().equals("");
        }
        return x.equals(y);
    }

    public String getHelpTopic() {
        return "ngnms.help.managing_services";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ServiceManagerAction
    extends ManagerAction {
        public ServiceManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
            this.setI18n(i18n);
        }

        public void performAction(final ManagerView manager) {
            final List selection = manager.getSelection();
            if ("New".equals(this.name)) {
                SelectorView selectorView = Selectors.getSelectorView(RbSubscriber.class, (String)(RbSubscriber.class.getName() + "_services_new"), (String)"singleSelection");
                if (null != selectorView) {
                    SelectorUtil.displayModalSelector((JComponent)manager.getUI(), (SelectorView)selectorView);
                }
                if (null != selectorView.getSelection() && !selectorView.getSelection().isEmpty()) {
                    try {
                        SubscriberEditorContainer container = new SubscriberEditorContainer((Subscriber)selectorView.getSelection().get(0));
                        container.setClientData((Object)new RbServiceConfigEntry(false));
                    }
                    catch (ServiceException ex) {
                        MessageBox.Error.quickShow((Component)manager.getUI(), ex.getMessage());
                    }
                }
            } else if ("Open".equals(this.name) && 1 == selection.size()) {
                RbServiceConfigEntry serviceEntry = (RbServiceConfigEntry)((Object)selection.get(0));
                if (0L < serviceEntry.getRbSubscriberIdx()) {
                    try {
                        RbServiceEntryAssemblerFactory.RbServiceEntryAssembly assembly = (RbServiceEntryAssemblerFactory.RbServiceEntryAssembly)ServiceRegistry.getEntityManagerService().get(RbServiceConfigEntry.class, serviceEntry.getId(), null);
                        SubscriberEditorContainer container = new SubscriberEditorContainer((Subscriber)(assembly == null ? null : assembly.getSubscriber()));
                        container.setClientData((Object)assembly.getEntity());
                    }
                    catch (ServiceException ex) {
                        MessageBox.Error.quickShow((Component)manager.getUI(), ex.getMessage());
                    }
                } else {
                    try {
                        new RbServiceEntryEditorContainer(serviceEntry);
                    }
                    catch (ServiceException ex) {
                        MessageBox.Error.quickShow((Component)manager.getUI(), ex.getMessage());
                    }
                }
            } else if ("PMCollect".equals(this.name)) {
                PerformanceCollectionGenericTask task = new PerformanceCollectionGenericTask();
                ArrayList<RbServiceEntryCollectionEntity> entities = new ArrayList<RbServiceEntryCollectionEntity>();
                for (int i = 0; i < selection.size(); ++i) {
                    entities.add(new RbServiceEntryCollectionEntity((RbServiceConfigEntry)((Object)selection.get(i))));
                }
                task.setEntityType("RbService");
                task.setName("");
                task.setEntities(entities);
                try {
                    PMCollectionTaskWizardContainer wizard = new PMCollectionTaskWizardContainer(task);
                    wizard.setWizardMode(true);
                    wizard.runEditor();
                }
                catch (Exception e) {
                    logger.error((Object)"Could not start PM Collection Task", (Throwable)e);
                }
            } else if ("Delete".equals(this.name)) {
                if (!FrameUtil.showConfirmation((Component)manager.getUI())) {
                    return;
                }
                final ServiceManagementService sms = ServiceRegistry.getServiceManagementService();
                AbstractLongOperation deleteOperation = new AbstractLongOperation(){

                    public String getTitle() {
                        return i18n.translateString("DeleteServices");
                    }

                    public boolean isCancelable() {
                        return true;
                    }

                    public long getMaxProgress() {
                        return selection.size();
                    }

                    public void run() {
                        long progress = 0L;
                        for (final Serializable row : selection) {
                            if (this.shouldCancel) {
                                this.monitor.logMessage(i18n.translateString("Canceled"));
                                break;
                            }
                            Service service = (Service)row;
                            this.monitor.updateProgress(progress, i18n.translateString("DeletingService", new Object[]{service.getName()}));
                            try {
                                sms.deleteService(service.getId());
                                if (manager instanceof EntityChangeListener) {
                                    UIEventThread.syncExec((Runnable)new Runnable(){

                                        public void run() {
                                            ((EntityChangeListener)manager).entityRemoved(row);
                                        }
                                    });
                                }
                                this.monitor.logMessage(i18n.translateString("SuccesfullyDeleted", new Object[]{service.getName()}));
                            }
                            catch (ServerValidationException sve) {
                                this.monitor.logMessage(i18n.translateString("ErrorDeletingService", new Object[]{service.getName(), i18n.translateString(((InvalidValue)sve.getInvalidValues().get(0)).getMessage())}));
                            }
                            catch (Throwable t) {
                                this.monitor.logMessage(i18n.translateString("ErrorDeletingService", new Object[]{service.getName(), t.getMessage()}));
                                logger.error((Object)t, t);
                            }
                            this.monitor.updateProgress(++progress, i18n.translateString("DeletingService", new Object[]{service.getName()}));
                        }
                        this.monitor.operationCompleted(false);
                    }
                };
                LongOperationUtil.startDetailLongOperationDialog((JComponent)manager.getUI(), (LongOperation)deleteOperation);
            } else if ("ShowPM".equals(this.name)) {
                RbServiceConfigEntry serviceEntry = (RbServiceConfigEntry)((Object)selection.get(0));
                ServicePerformanceMonitoringView monitorView = new ServicePerformanceMonitoringView();
                monitorView.setServiceID(serviceEntry.getRbServiceID());
                monitorView.setServiceName(serviceEntry.getRbServiceName());
                monitorView.setEquipment(serviceEntry.getNRConfiguration().getConfiguration().getEquipment());
                monitorView.registerLongActionCallback(new LongActionCallback(){

                    public void onStarting(String message) {
                    }

                    public void onFinished(String message) {
                    }
                });
                FrameUtil.runView((View)monitorView, (int)600, (int)400);
            } else if ("OpenServingCPE".equals(this.name)) {
                EquipmentConfiguration eqConfig;
                RbSU su;
                RbServiceConfigEntry selectedService = (RbServiceConfigEntry)((Object)selection.get(0));
                List ecList = RbServiceGMLManagerConfig.getRbSUEquipmentConfigurationList(selectedService);
                if (ecList != null && ecList.size() > 0 && (su = (RbSU)(eqConfig = (EquipmentConfiguration)ecList.get(0)).getEquipment()).getState() == 0) {
                    ConfigApplicationView configAppView = new ConfigApplicationView(eqConfig);
                    FrameUtil.runFrame((JFrame)new JFrame(), (String)(su.getName() + " on " + su.getIPAddress()), (View)configAppView, (int)1024, (int)768, (boolean)true);
                }
            } else if ("OpenServingBST".equals(this.name)) {
                RbServiceConfigEntry selectedService = (RbServiceConfigEntry)((Object)selection.get(0));
                RbBaseStationEquipment bs = (RbBaseStationEquipment)selectedService.getNRConfiguration().getConfigurationEquipment();
                ConfigApplicationView configAppView = new ConfigApplicationView((Equipment)bs);
                if (null == configAppView.getConfiguration()) {
                    throw new RuntimeException("Configuration does not exist for BS: " + bs.getEUID());
                }
                String url = "bwanms://config/" + bs.getEUID();
                configAppView.fireAction(url);
                FrameUtil.runFrame((JFrame)FrameUtil.createFrame(), (String)bs.getName(), (View)configAppView, (int)1024, (int)768, (boolean)true);
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize = null != selection ? selection.size() : 0;
            boolean isServingCPEUpAndLicensed = false;
            boolean isServingBSTUpAndLicensed = false;
            if (selectionSize > 0) {
                RbServiceConfigEntry selectedService = (RbServiceConfigEntry)((Object)selection.get(0));
                RbBaseStationEquipment bs = (RbBaseStationEquipment)selectedService.getNRConfiguration().getConfigurationEquipment();
                isServingBSTUpAndLicensed = bs.getState() == 0 && LicenseClient.getInstance().isLicensed((Object)bs);
                List ecList = RbServiceGMLManagerConfig.getRbSUEquipmentConfigurationList(selectedService);
                RbSU su = null;
                if (ecList != null && ecList.size() > 0) {
                    EquipmentConfiguration eqConfig = (EquipmentConfiguration)ecList.get(0);
                    su = (RbSU)eqConfig.getEquipment();
                }
                boolean bl = su != null ? su.getState() == 0 && LicenseClient.getInstance().isLicensed(su) : (isServingCPEUpAndLicensed = false);
            }
            if (this.name.equals("New")) {
                return true;
            }
            if (this.name.equals("Open")) {
                return 1 == selectionSize;
            }
            if (this.name.equals("OpenServingBST")) {
                return 1 == selectionSize && isServingBSTUpAndLicensed;
            }
            if (this.name.equals("OpenServingCPE")) {
                return 1 == selectionSize && isServingCPEUpAndLicensed;
            }
            if (this.name.equals("Delete")) {
                return 0 < selectionSize;
            }
            if (this.name.equals("ShowPM")) {
                if (1 != selectionSize) {
                    return false;
                }
                Integer serviceEntryOpStatus = ((RbServiceConfigEntry)((Object)selection.get(0))).getRbServiceOperStatus();
                return null != serviceEntryOpStatus && 1 == serviceEntryOpStatus;
            }
            if (this.name.equals("PMCollect")) {
                return 0 < selectionSize;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbServiceGMLRowCreator
    extends EntityManagerRowProviderBase {
        public RbServiceGMLRowCreator(List<String> attributes) {
            super(attributes);
        }

        protected List<Serializable> readAttributeValues(Serializable entity) {
            List ret = super.readAttributeValues(entity);
            RbServiceConfigEntry serviceEntry = (RbServiceConfigEntry)((Object)entity);
            ret.set(0, serviceEntry.getRbServiceName());
            ret.set(1, serviceEntry.getRbServiceType());
            ret.set(2, serviceEntry.getRbServiceAdminStatus());
            ret.set(3, serviceEntry.getRbServiceOperStatus());
            ret.set(4, serviceEntry.getRbServiceServiceTemplateName());
            RbBaseStationNRConfiguration nrConfig = (RbBaseStationNRConfiguration)serviceEntry.getNRConfiguration();
            ret.set(5, null != serviceEntry.getRbSubscriberID() ? serviceEntry.getRbSubscriberID() : "");
            RbRegisteredSuTable suTable = new RbRegisteredSuTable(nrConfig.getRbRegisteredSuEntries());
            RbRegisteredSuEntry suEntry = (RbRegisteredSuEntry)suTable.findEntry(serviceEntry.getRbServiceSuMacAddress().toUpperCase());
            ret.set(6, null != suEntry ? suEntry.getRbSuSysName() : "");
            ret.set(7, serviceEntry.getRbServiceSuMacAddress().replace(":", "-"));
            ret.set(8, serviceEntry.getNRConfiguration().getManagedEquipment().getName());
            Integer auSlotNo = serviceEntry.getRbServiceAUSlotNumber();
            if (null != auSlotNo && auSlotNo < 255) {
                ret.set(9, serviceEntry.getRbServiceAUSlotNumber());
            }
            return ret;
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List ret = super.getDisplayValues(entityRow);
            int type = Integer.parseInt((String)ret.get(1));
            String typeStr = null;
            switch (type) {
                case 1: {
                    typeStr = i18n.translateString("L2");
                    break;
                }
                case 2: {
                    typeStr = i18n.translateString("PPPoE");
                    break;
                }
                case 3: {
                    typeStr = i18n.translateString("VoIP");
                    break;
                }
                case 4: {
                    typeStr = i18n.translateString("IPmodeData");
                    break;
                }
                case 5: {
                    typeStr = i18n.translateString("IPmodeVoIP");
                    break;
                }
                case 6: {
                    typeStr = i18n.translateString("ManagedVoIP");
                    break;
                }
                case 7: {
                    typeStr = i18n.translateString("IPModeManagedVoIP");
                    break;
                }
                default: {
                    typeStr = i18n.translateString("Unknown");
                }
            }
            ret.set(1, typeStr);
            int adminStatus = Integer.parseInt((String)ret.get(2));
            String adminStatusStr = null;
            switch (adminStatus) {
                case 1: {
                    adminStatusStr = i18n.translateString("Enable");
                    break;
                }
                case 2: {
                    adminStatusStr = i18n.translateString("Disable");
                    break;
                }
                default: {
                    adminStatusStr = i18n.translateString("Unknown");
                }
            }
            ret.set(2, adminStatusStr);
            if ("".equals(ret.get(3))) {
                ret.set(3, i18n.translateString("Unknown"));
            } else {
                int opStatus = Integer.parseInt((String)ret.get(3));
                switch (opStatus) {
                    case 1: {
                        ret.set(3, i18n.translateString("Up"));
                        break;
                    }
                    case 2: {
                        ret.set(3, i18n.translateString("Down"));
                    }
                }
            }
            ret.set(6, ((String)ret.get(6)).toUpperCase());
            return ret;
        }

        protected String readEntityId(Serializable entity) {
            return String.valueOf(((RbServiceConfigEntry)((Object)entity)).getId());
        }
    }
}

