/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.client.gui.tasks.pmcollection.PMCollectionTaskWizardContainer;
import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.gui.equipmentmanager.AbstractEquipmentManagerConfig;
import com.bwanms.gui.equipmentmanager.AllEquipmentManagerConfig;
import com.bwanms.gui.equipmentmanager.EquipmentRowProvider;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.SortView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteriaView;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerSortByIdNoUI;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaTranslator;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaView;
import com.bwanms.gui.manager.generic.SinglePageQueryStrategy;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.model.Equipment;
import com.bwanms.model.EquipmentStateEnum;
import com.bwanms.model.ManagedEntity;
import com.bwanms.model.Settings;
import com.bwanms.model.Task;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.rb.gui.managers.RbServiceGMLManagerConfig;
import com.bwanms.rb.gui.selectors.service.RbSelfContainedSelectorDialog;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbSU;
import com.bwanms.rb.performance.RbPerformanceMECollectionEntity;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTask;
import com.bwanms.rb.tasks.softwareupgrade.RbSwUpgradeEquipmentWeakAssociation;
import com.bwanms.rb.util.RbGUIUtil;
import com.bwanms.security.Security;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.MacAddress;
import java.awt.Dimension;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbSUManagerConfig
extends AbstractEquipmentManagerConfig {
    private static final Logger logger = Logger.getLogger(RbSUManagerConfig.class);
    public static Internationalizer rbI18n = Internationalizer.getInternationalizer(RbSUManagerConfig.class);
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public RbSUManagerConfig(int maxSelection) {
        super(maxSelection);
        this.declaredActions = super.getDeclaredActions();
        this.defaultAction = super.getDefaultAction();
        this.Columns();
        this.updateFilterCriteria();
    }

    public RbSUManagerConfig() {
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "New", 1));
        this.defaultAction = new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "Configure", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "Edit", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "Delete", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "License", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "MultipleConfiguration", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "Export", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "OpenMap", 1));
        this.declaredActions.remove(0);
        this.declaredActions.add(new SUManagerAction("OpenBS", 1));
        SUManagerActionLocal showServicesAction = new SUManagerActionLocal("ShowServices", 1);
        showServicesAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)showServicesAction);
        SUManagerActionLocal softwareUpgradeAction = new SUManagerActionLocal("SoftwareUpgrade", 1);
        softwareUpgradeAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)softwareUpgradeAction);
        SUManagerActionLocal performanceCollectionAction = new SUManagerActionLocal("PerformanceCollectionTask", 1);
        performanceCollectionAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)performanceCollectionAction);
        this.Columns();
        this.updateFilterCriteria();
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public SortView getSortView() {
        return new EntityManagerSortByIdNoUI();
    }

    private void Columns() {
        this.columns.add(new EntityManagerColumn("serialNumber", "serialNumber", i18n.translateString("SerialNumber"), (Comparator)new EntityManagerRowDisplayComparator(6)));
        this.columns.add(new EntityManagerColumn("macAddress", "macAddress", i18n.translateString("macAddress"), (Comparator)new EntityManagerRowDisplayComparator(7)));
        this.columns.add(new EntityManagerColumn("Type", "model", i18n.translateString("SuType"), (Comparator)new EntityManagerRowDisplayComparator(8)));
        this.columns.add(new EntityManagerColumn("NGIndicator", "NGpresent", i18n.translateString("NGpresent"), (Comparator)new EntityManagerRowDisplayComparator(9)));
        this.columns.add(new EntityManagerColumn("VGIndicator", "VGpresent", i18n.translateString("VGpresent"), (Comparator)new EntityManagerRowDisplayComparator(10)));
        this.entityRowProvider = new RbSUEquipmentRowProvider(RbSUManagerConfig.getColumnAttributeNames((List)this.columns));
    }

    private void updateFilterCriteria() {
        this.filterCriteria.add(2, new EntityManagerFilterCriteria(i18n.translateString("MainSoftwareVersion"), "operationalSoftwareVersion", 1, 1, null, false));
        this.filterCriteria.add(3, new EntityManagerFilterCriteria(i18n.translateString("ShadowSoftwareVersion"), "shadowSoftwareVersion", 1, 1, null, false));
        this.filterCriteria.add(6, new EntityManagerFilterCriteria(i18n.translateString("HardwareRevision"), "hardwareRevision", 1, 1, null, false));
        EntityManagerFilterCriteria macAddressCriteria = new EntityManagerFilterCriteria(i18n.translateString("macAddress"), "macAddress", 1, 1, null, false);
        macAddressCriteria.setTranslator(new ManagerFilterCriteriaTranslator(){

            public List<Object> translateFilterValues(List<Object> selectedValues) throws InvalidFilterValueException {
                String value = (String)selectedValues.get(0);
                String result = value.contains(" ") ? "" : value.replace("-", " ");
                selectedValues.set(0, result);
                return selectedValues;
            }
        });
        this.filterCriteria.add(macAddressCriteria);
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("ConectedAUSlotID"), "servingAUId", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("ManagerBSname"), "managerBSName", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("SerialNumber"), "serialNumber", 1, 1, null, false));
        this.setSuTypeFilterCriteria();
        this.setSuIduFilterCriteria();
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("NGpresent"), "NGpresent", 1, 5, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("VGpresent"), "VGpresent", 1, 5, null, false));
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)"limited", i18n.translateString("Limited")));
        items.add(new ComboItem((Object)"unlimited", i18n.translateString("Unlimited")));
        this.filterCriteria.add(new EntityManagerFilterCriteria("CPELicenseType", i18n.translateString("CPELicenseType"), "model", null, 1, 3, items, false){

            public ManagerFilterCriteriaView createView() {
                return new EntityManagerFilterCriteriaView(super.getName(), super.getTitle(), super.getJoinClass(), super.getAttribute(), super.getType(), super.getUiType(), super.getValues(), super.isNumeric(), super.isNegation()){

                    public String getConditionToken(String alias) throws InvalidFilterValueException {
                        List selectedVals = super.getSelectedValues();
                        String ret = " upper(" + alias + ".model )";
                        if ("unlimited".equals(selectedVals.get(0))) {
                            ret = ret + " not";
                        }
                        ret = ret + " like upper('%L')";
                        return ret;
                    }
                };
            }
        });
    }

    protected void setSuIduFilterCriteria() {
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)"Basic", i18n.translateString("Basic")));
        items.add(new ComboItem((Object)"Voice", i18n.translateString("Voice")));
        items.add(new ComboItem((Object)"Wirelles", i18n.translateString("Wirelles")));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("SuIduType"), "suIduType", 1, 3, items, false));
    }

    protected void setSuTypeFilterCriteria() {
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)"CPE", i18n.translateString("CPE")));
        items.add(new ComboItem((Object)"CPE_PRO", i18n.translateString("CPE_PRO")));
        items.add(new ComboItem((Object)"CPE_SI", i18n.translateString("CPE_SI")));
        items.add(new ComboItem((Object)"CPE_PRO_L", i18n.translateString("CPE_PRO_L")));
        items.add(new ComboItem((Object)"CPE_SI_L", i18n.translateString("CPE_SI_L")));
        items.add(new ComboItem((Object)"CPE_2_PRO", i18n.translateString("CPE_2_PRO")));
        items.add(new ComboItem((Object)"CPE_2_SI", i18n.translateString("CPE_2_SI")));
        items.add(new ComboItem((Object)"CPE_2_PRO_L", i18n.translateString("CPE_2_PRO_L")));
        items.add(new ComboItem((Object)"CPE_2_SI_L", i18n.translateString("CPE_2_SI_L")));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("SuType"), "model", 1, 3, items, false));
    }

    protected String getManagerName() {
        return "BMAXSUEquipmentManager";
    }

    protected String getBaseName() {
        return RbSU.class.getName();
    }

    public EntityQueryStrategy getQueryStrategy() {
        return new SinglePageQueryStrategy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SUManagerAction
    extends ManagerAction {
        SUManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
            this.hidden = true;
            this.setI18n(AbstractEquipmentManagerConfig.i18n);
        }

        public void performAction(ManagerView manager) {
            if ("OpenBS".equals(this.name)) {
                List selection = manager.getSelection();
                RbSU selectedSU = (RbSU)((Object)selection.get(0));
                RbBaseStationEquipment bs = selectedSU.getManagerBS();
                ConfigApplicationView configAppView = new ConfigApplicationView((Equipment)bs);
                if (null == configAppView.getConfiguration()) {
                    throw new RuntimeException("Configuration does not exist for BS: " + bs.getEUID());
                }
                FrameUtil.runFrame((JFrame)FrameUtil.createFrame(), (String)bs.getName(), (View)configAppView, (int)1024, (int)768, (boolean)true);
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            if ("OpenBS".equals(this.name) && selection.size() >= 1) {
                RbBaseStationEquipment bsEquipment = ((RbSU)((Object)selection.get(0))).getManagerBS();
                Long ip = ((RbSU)((Object)selection.get(0))).getIpAddr();
                if (null == ip || null == bsEquipment || !LicenseClient.getInstance().isLicensed((Object)bsEquipment)) {
                    return false;
                }
                if (selection.size() > 1) {
                    for (Serializable su : selection) {
                        if (ip.equals(((RbSU)((Object)su)).getIpAddr())) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbSUEquipmentRowProvider
    extends EquipmentRowProvider {
        public RbSUEquipmentRowProvider(List<String> attributes) {
            super(attributes);
        }

        protected String translateNgVgIndicators(String value) {
            if ("false".equals(value)) {
                return i18n.translateString("No");
            }
            return i18n.translateString("Yes");
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            ArrayList<String> ret = new ArrayList<String>(this.attributes.size());
            for (int i = 0; i < this.attributes.size(); ++i) {
                Serializable val = entityRow.getAttributeValue(i);
                ret.add(null != val ? val.toString() : "");
            }
            ret.set(1, AllEquipmentManagerConfig.ddI18N.translateString((String)ret.get(1)));
            ret.set(2, this.translateUnknown((String)ret.get(2)));
            Integer state = (Integer)entityRow.getAttributeValue(5);
            if (null == state) {
                ret.set(5, i18n.translateString("Unlicensed"));
            } else {
                ret.set(5, i18n.translateString(EquipmentStateEnum.toString((int)state)));
            }
            ret.set(6, this.translateUnknown((String)ret.get(6)));
            ret.set(7, MacAddress.fromSimpleString((String)((String)ret.get(7))).toDashedString());
            ret.set(8, i18n.translateString(this.translateUnknown((String)ret.get(8))));
            ret.set(9, this.translateNgVgIndicators((String)ret.get(9)));
            ret.set(10, this.translateNgVgIndicators((String)ret.get(10)));
            return ret;
        }

        protected String translateUnknown(String str) {
            if (str.equalsIgnoreCase("unknown")) {
                return "N/A";
            }
            return str;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SUManagerActionLocal
    extends AbstractEquipmentManagerConfig.EquipmentManagerAction {
        public SUManagerActionLocal(String name, int category) {
            super((AbstractEquipmentManagerConfig)RbSUManagerConfig.this, name, category);
        }

        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            if ("SoftwareUpgrade".equals(this.name)) {
                RbSoftwareUpgradeTask task = new RbSoftwareUpgradeTask();
                ArrayList<RbSwUpgradeEquipmentWeakAssociation> targetEquipment = new ArrayList<RbSwUpgradeEquipmentWeakAssociation>();
                for (int i = 0; i < selection.size(); ++i) {
                    RbSwUpgradeEquipmentWeakAssociation wa = new RbSwUpgradeEquipmentWeakAssociation((ManagedEntity)((RbSU)((Object)selection.get(i))));
                    wa.setUpgrade(true);
                    targetEquipment.add(wa);
                }
                task.setEquipmentSelectionMode(1);
                task.setTargetEquipment(targetEquipment);
                new TaskEditorFormContainer(((Object)((Object)task)).getClass(), (Task)task);
            } else if ("PerformanceCollectionTask".equals(this.name)) {
                PerformanceCollectionGenericTask task = new PerformanceCollectionGenericTask();
                ArrayList<RbPerformanceMECollectionEntity> entities = new ArrayList<RbPerformanceMECollectionEntity>();
                for (int i = 0; i < selection.size(); ++i) {
                    entities.add(new RbPerformanceMECollectionEntity((ManagedEntity)((RbSU)((Object)selection.get(i)))));
                }
                task.setEntityType("RbEquipment");
                task.setName("");
                task.setEntities(entities);
                try {
                    PMCollectionTaskWizardContainer wizard = new PMCollectionTaskWizardContainer(task);
                    wizard.setWizardMode(true);
                    wizard.runEditor();
                }
                catch (Exception e) {
                    logger.error((Object)"Could not start PM Collection Task", (Throwable)e);
                }
            } else if ("ShowServices".equals(this.name)) {
                RbSelfContainedSelectorDialog dialog;
                RbSU selectedSU = (RbSU)((Object)selection.get(0));
                String SUName = selectedSU.getName();
                String macAddr = selectedSU.getMacAddress();
                Settings settings = ServiceRegistry.getSettingsService().fetchSettings(Security.getSecurity().getCurrentUserId(), true);
                settings.setProperty("ActiveFilters:SUShowServices", "1_1_0_rbServiceSuMacAddress");
                settings.setProperty("SelectedFilterValues:SUShowServices:1_1_0_rbServiceSuMacAddress", macAddr.length() + ":" + macAddr.replace(" ", "-"));
                ServiceRegistry.getSettingsService().updateSettings(settings);
                RbServiceGMLManagerConfig serviceManagerConfig = new RbServiceGMLManagerConfig();
                serviceManagerConfig.setSelectorName("SUShowServices");
                Window parentWindow = SwingUtilities.getWindowAncestor(manager.getUI());
                if (parentWindow instanceof JFrame) {
                    dialog = new RbSelfContainedSelectorDialog((JFrame)parentWindow);
                } else if (parentWindow instanceof JDialog) {
                    dialog = new RbSelfContainedSelectorDialog((JDialog)parentWindow);
                } else {
                    throw new IllegalArgumentException("Unsupported parent window of type: " + parentWindow.getClass().getName());
                }
                EntityManagerView managerView = new EntityManagerView((EntityManagerConfig)serviceManagerConfig);
                dialog.setView((View)managerView);
                dialog.setModal(false);
                dialog.setTitle("Services for " + SUName);
                dialog.setPreferredSize(new Dimension(managerView.getUI().getPreferredSize().width + 10, managerView.getUI().getPreferredSize().height + 70));
                dialog.pack();
                RbGUIUtil.centerDialog((JDialog)((Object)dialog));
                dialog.setVisible(true);
            } else {
                super.performAction(manager);
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            super.isEnabled(selection);
            int n = selectionSize = null != selection ? selection.size() : 0;
            return !("SoftwareUpgrade".equals(this.name) || "PerformanceCollectionTask".equals(this.name) ? selectionSize == 0 : "ShowServices".equals(this.name) && selectionSize != 1);
        }

        public Internationalizer getI18n() {
            return rbI18n;
        }
    }
}

