/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.gui.manager.ResultsViewListener;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.util.treetable.TreeTableModelAdapter;
import com.bwanms.rb.gui.managers.RbGPSChainTreeCellRenderer;
import com.bwanms.rb.gui.managers.RbGPSManagerTreeModel;
import com.bwanms.rb.gui.managers.RbGPSManagerTreeTableResultsPanel;
import com.bwanms.rb.gui.managers.RbGlobalGPSChain;
import com.bwanms.rb.model.RbGlobalGPSChainElement;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbGPSManagerTreeTableResultsView
implements ManagerResultsView {
    private RbGPSManagerTreeTableResultsPanel ui;
    private RbGPSManagerTreeModel model;
    private ArrayList<ResultsViewListener> listeners = new ArrayList();
    private HashMap<RbGlobalGPSChainElement, EntityManagerRow> rowMap = new HashMap();
    private Action defaultAction;

    public EntityQuerySort getEntityQuerySort() {
        return null;
    }

    public void setEntityQueryResults(EntityQueryResults data) {
        ArrayList<RbGlobalGPSChain> rbGPSChains = new ArrayList<RbGlobalGPSChain>();
        for (EntityManagerRow row : data.getData()) {
            RbGlobalGPSChainElement rbGlobalGPSChainElement = (RbGlobalGPSChainElement)row.getEntity();
            RbGlobalGPSChain parent = null;
            for (RbGlobalGPSChain rbGPSChain : rbGPSChains) {
                if (!rbGPSChain.getRbGPSChainName().equals(String.valueOf(rbGlobalGPSChainElement.getChainNumber()))) continue;
                parent = rbGPSChain;
                break;
            }
            if (parent == null) {
                parent = new RbGlobalGPSChain(String.valueOf(rbGlobalGPSChainElement.getChainNumber()));
                rbGPSChains.add(parent);
            }
            boolean added = false;
            for (int i = 0; i < parent.getGpsChains().size(); ++i) {
                if (rbGlobalGPSChainElement.getClockMode() >= parent.getGpsChains().get(i).getClockMode()) continue;
                parent.getGpsChains().add(i, rbGlobalGPSChainElement);
                added = true;
                break;
            }
            if (!added) {
                parent.getGpsChains().add(rbGlobalGPSChainElement);
            }
            this.rowMap.put(rbGlobalGPSChainElement, row);
        }
        this.model.setChainClusters(rbGPSChains);
        this.fireSelectionChanged();
        ((TreeTableModelAdapter)this.ui.getLicenseTreeTable().getModel()).fireTableDataChanged();
        for (int i = 0; i < this.ui.getLicenseTreeTable().getRowCount(); ++i) {
            this.ui.getLicenseTreeTable().getTree().expandRow(i);
        }
    }

    public List<EntityManagerRow> getSelection() {
        ArrayList<EntityManagerRow> selection = new ArrayList<EntityManagerRow>(5);
        TreePath[] selectionPaths = this.ui.getLicenseTreeTable().getTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return selection;
        }
        for (TreePath selectionPath : selectionPaths) {
            EntityManagerRow row;
            Object userObj;
            if (selectionPath == null || !((userObj = ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject()) instanceof RbGlobalGPSChainElement) || selection.contains(row = this.rowMap.get(userObj))) continue;
            selection.add(row);
        }
        return selection;
    }

    public void addResultsAreaListener(ResultsViewListener listener) {
        this.listeners.add(listener);
    }

    public void removeResultsAreaListener(ResultsViewListener listener) {
        this.listeners.remove(listener);
    }

    public RbGPSManagerTreeTableResultsPanel getUI() {
        if (this.ui == null) {
            this.model = new RbGPSManagerTreeModel();
            this.ui = new RbGPSManagerTreeTableResultsPanel(this.model);
            this.ui.getLicenseTreeTable().getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent arg0) {
                    RbGPSManagerTreeTableResultsView.this.fireSelectionChanged();
                }
            });
            this.ui.getLicenseTreeTable().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent arg0) {
                    if (2 <= arg0.getClickCount() && null != RbGPSManagerTreeTableResultsView.this.defaultAction && RbGPSManagerTreeTableResultsView.this.defaultAction.isEnabled()) {
                        RbGPSManagerTreeTableResultsView.this.defaultAction.actionPerformed(new ActionEvent(arg0.getSource(), arg0.getID(), null));
                    }
                }
            });
            this.ui.getLicenseTreeTable().getTree().setCellRenderer(new RbGPSChainTreeCellRenderer());
        }
        return this.ui;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return "";
    }

    public void updateContextMenu(List<JMenuItem> menuItems) {
        this.ui.getPopup().removeAll();
        for (JMenuItem item : menuItems) {
            if (null != item) {
                this.ui.getPopup().add(item);
                continue;
            }
            this.ui.getPopup().addSeparator();
        }
    }

    public void setDefaultActionListener(Action listener) {
        this.defaultAction = listener;
    }

    public void entityChanged(EntityManagerRow row) {
    }

    public void entityAdded(EntityManagerRow row) {
        this.model.addChainCluster((RbGlobalGPSChain)row.getEntity());
    }

    public void entityRemoved(Serializable entity) {
        this.model.removeChainCluster((RbGlobalGPSChain)entity);
    }

    private void fireSelectionChanged() {
        for (ResultsViewListener listener : this.listeners) {
            listener.selectionChanged(this.getSelection());
        }
    }

    public List<EntityManagerRow> getData() {
        return new ArrayList<EntityManagerRow>();
    }
}

