/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.gui.util.treetable.AbstractTreeTableModel;
import com.bwanms.gui.util.treetable.TreeTableModel;
import com.bwanms.rb.gui.managers.RbGPSChainTreeTableManagerConfig;
import com.bwanms.rb.gui.managers.RbGlobalGPSChain;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.model.RbGlobalGPSChainElement;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbGPSManagerTreeModel
extends AbstractTreeTableModel {
    public RbGPSManagerTreeModel() {
        super((Object)new DefaultMutableTreeNode("root"));
    }

    public void setChainClusters(List<RbGlobalGPSChain> rbGPSChains) {
        ((DefaultMutableTreeNode)this.root).removeAllChildren();
        for (RbGlobalGPSChain cc : rbGPSChains) {
            DefaultMutableTreeNode chainClusterNode = new DefaultMutableTreeNode(cc);
            for (RbGlobalGPSChainElement gpsChain : cc.getGpsChains()) {
                chainClusterNode.add(new DefaultMutableTreeNode(gpsChain));
            }
            ((DefaultMutableTreeNode)this.root).add(chainClusterNode);
        }
        this.fireTreeStructureChanged((Object)this, ((DefaultMutableTreeNode)this.root).getPath(), null, null);
    }

    public void addChainCluster(RbGlobalGPSChain newChainCluster) {
        ((DefaultMutableTreeNode)this.root).add(new DefaultMutableTreeNode(newChainCluster));
        this.fireTreeStructureChanged((Object)this, ((DefaultMutableTreeNode)this.root).getPath(), null, null);
    }

    public void removeChainCluster(RbGlobalGPSChain rbGPSChain) {
        while (((DefaultMutableTreeNode)this.root).children().hasMoreElements()) {
            DefaultMutableTreeNode chainClusterNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.root).children().nextElement();
            if (!chainClusterNode.getUserObject().equals(rbGPSChain)) continue;
            ((DefaultMutableTreeNode)this.root).remove(chainClusterNode);
            this.fireTreeStructureChanged((Object)this, ((DefaultMutableTreeNode)this.root).getPath(), null, null);
        }
    }

    public Object getRoot() {
        return this.root;
    }

    public TreeNode getChild(Object parent, int index) {
        if (parent instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)parent).getChildAt(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)parent).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        if (node instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)node).isLeaf();
        }
        return true;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof DefaultMutableTreeNode && child instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)parent).getIndex((DefaultMutableTreeNode)child);
        }
        return 0;
    }

    public int getColumnCount() {
        return RbGPSChainTreeTableManagerConfig.columnNames.length;
    }

    public String getColumnName(int column) {
        return RbGPSChainTreeTableManagerConfig.i18n.translateString(RbGPSChainTreeTableManagerConfig.columnNames[column]);
    }

    public Object getValueAt(Object node, int column) {
        if (node instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)node).getUserObject() instanceof RbGlobalGPSChainElement) {
            RbGlobalGPSChainElement rbGlobalGPSChainElement = (RbGlobalGPSChainElement)((DefaultMutableTreeNode)node).getUserObject();
            switch (column) {
                case 0: {
                    return rbGlobalGPSChainElement.getManagerBsEUID();
                }
                case 1: {
                    return RbGPSChainTreeTableManagerConfig.i18n.translateString(RbBSClockConfigParameters.toStringRbBSCurrentClockMode(rbGlobalGPSChainElement.getClockMode()));
                }
                case 2: {
                    return RbGPSChainTreeTableManagerConfig.i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(rbGlobalGPSChainElement.getGpsType()));
                }
                case 3: {
                    return rbGlobalGPSChainElement.getTimeZoneOffsetFromUTC();
                }
                case 4: {
                    return RbGPSChainTreeTableManagerConfig.i18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(rbGlobalGPSChainElement.getStopTxAfterHoldOverTimeout()));
                }
                case 5: {
                    return rbGlobalGPSChainElement.getHoldOverPassedTimeout();
                }
            }
        }
        if (column == 0) {
            return String.valueOf(node);
        }
        return "";
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return TreeTableModel.class;
        }
        return Object.class;
    }
}

