/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.configuration.ConfigApplicationView;
import com.bwanms.gui.equipmentmanager.AbstractEquipmentManagerConfig;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.model.Equipment;
import com.bwanms.model.entity.LightQuery;
import com.bwanms.rb.gui.managers.RbGPSManagerTreeTableResultsView;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbGlobalGPSChainElement;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbGPSChainTreeTableManagerConfig
extends EntityManagerConfig {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(RbGPSChainTreeTableManagerConfig.class);
    public static final Logger logger = Logger.getLogger(RbGPSChainTreeTableManagerConfig.class);
    public static String[] columnNames = new String[]{"chainNumber", "clockMode", "gpsType", "timeZoneOffsetFromUTC", "stopTxAfterHoldOverTimeout", "holdOverPassedTimeout", "latitude", "longitude", "altitude"};
    private static String[] columnAttribNames = new String[]{"chainNumber", "clockMode", "gpsType", "timeZoneOffsetFromUTC", "stopTxAfterHoldOverTimeout", "holdOverPassedTimeout", "latitude", "longitude", "altitude"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;
    private RbGPSManagerTreeTableResultsView gpsManagerResultsView;

    public RbGPSChainTreeTableManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], columnAttribNames[2], i18n.translateString(columnNames[2]), (Comparator)new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], columnAttribNames[3], i18n.translateString(columnNames[3]), (Comparator)new EntityManagerRowDisplayComparator(3)));
        this.columns.add(new EntityManagerColumn(columnNames[4], columnAttribNames[4], i18n.translateString(columnNames[4]), (Comparator)new EntityManagerRowDisplayComparator(4)));
        this.columns.add(new EntityManagerColumn(columnNames[5], columnAttribNames[5], i18n.translateString(columnNames[5]), (Comparator)new EntityManagerRowDisplayComparator(5)));
        this.columns.add(new EntityManagerColumn(columnNames[6], columnAttribNames[6], i18n.translateString(columnNames[6]), (Comparator)new EntityManagerRowDisplayComparator(6)));
        this.columns.add(new EntityManagerColumn(columnNames[7], columnAttribNames[7], i18n.translateString(columnNames[7]), (Comparator)new EntityManagerRowDisplayComparator(7)));
        this.columns.add(new EntityManagerColumn(columnNames[8], columnAttribNames[8], i18n.translateString(columnNames[8]), (Comparator)new EntityManagerRowDisplayComparator(8)));
        this.entityRowProvider = new RbGPSChainManagerRowProvider(RbGPSChainTreeTableManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("chainNumber"), "chainNumber", 1, 1, null, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new GPSChainTreeTableManagerAction("Configure", 1);
        this.defaultAction.setI18n(AbstractEquipmentManagerConfig.i18n);
        this.declaredActions.add(this.defaultAction);
    }

    protected String getBaseName() {
        return RbGlobalGPSChainElement.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public ManagerResultsView getResultsView() {
        this.gpsManagerResultsView = new RbGPSManagerTreeTableResultsView();
        return this.gpsManagerResultsView;
    }

    public String getTitle() {
        return i18n.translateString("GPSChainManager");
    }

    public String getHelpTopic() {
        return "rb_gps_chain_manager";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbGPSChainManagerRowProvider
    extends DefaultRowCreator {
        private static final long serialVersionUID = 1L;

        public RbGPSChainManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        public String readEntityId(Serializable entity) {
            return String.valueOf(((RbGlobalGPSChainElement)entity).getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GPSChainTreeTableManagerAction
    extends ManagerAction {
        public GPSChainTreeTableManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            if ("Configure".equals(this.name)) {
                if (selection.isEmpty()) {
                    return;
                }
                RbGlobalGPSChainElement chainElement = (RbGlobalGPSChainElement)selection.get(0);
                LightQuery query = new LightQuery(RbBaseStationEquipment.class);
                query.addParameter("euid", (Object)chainElement.getManagerBsEUID());
                List eqs = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
                if (null != eqs && 1 == eqs.size()) {
                    RbBaseStationEquipment bsEquipment = (RbBaseStationEquipment)((Object)eqs.get(0));
                    ConfigApplicationView configAppView = new ConfigApplicationView((Equipment)bsEquipment, "Configuration");
                    if (null == configAppView.getConfiguration()) {
                        throw new RuntimeException("Configuration does not exist for equipment with euid = " + bsEquipment.getEUID());
                    }
                    configAppView.fireAction("bwanms://config/" + chainElement.getManagerBsEUID() + "/GPS/");
                    IpAddress ip = new IpAddress(bsEquipment.getIpAddr().longValue());
                    JFrame frame = FrameUtil.createModalFrame(null, (boolean)true);
                    FrameUtil.runFrame((JFrame)frame, (String)AbstractEquipmentManagerConfig.i18n.translateString("ConfiguringEquipment", new Object[]{bsEquipment.getName(), ip.toString()}), (View)configAppView, (int)1024, (int)768, (boolean)true);
                }
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Configure")) {
                if (1 == selectionSize && selection.get(0) instanceof RbGlobalGPSChainElement) {
                    RbGlobalGPSChainElement chainElement = (RbGlobalGPSChainElement)selection.get(0);
                    LightQuery query = new LightQuery(RbBaseStationEquipment.class);
                    query.addParameter("euid", (Object)chainElement.getManagerBsEUID());
                    List eqs = ServiceRegistry.getEntityManagerService().retrieveByQuery(query);
                    if (null != eqs && 1 == eqs.size()) {
                        RbBaseStationEquipment eq = (RbBaseStationEquipment)((Object)eqs.get(0));
                        return eq != null && LicenseClient.getInstance().isLicensed((Object)eq);
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
    }
}

