/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.rb.gui.managers.RbGlobalGPSChain;
import com.bwanms.rb.model.RbGlobalGPSChainElement;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

class RbGPSChainTreeCellRenderer
extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component component = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof RbGlobalGPSChain) {
            int childCount = tree.getModel().getChildCount(value);
            if (childCount > 0) {
                Object childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, 0)).getUserObject();
                int clockMode = ((RbGlobalGPSChainElement)childObj).getClockMode();
                if (clockMode != 1) {
                    component.setForeground(Color.RED);
                }
                if (childCount > 1) {
                    childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, 1)).getUserObject();
                    clockMode = ((RbGlobalGPSChainElement)childObj).getClockMode();
                    if (clockMode != 2 && clockMode != 3) {
                        component.setForeground(Color.RED);
                    }
                    int lastClockMode = clockMode;
                    for (int i = 2; i < childCount; ++i) {
                        childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, i)).getUserObject();
                        clockMode = ((RbGlobalGPSChainElement)childObj).getClockMode();
                        if (clockMode != lastClockMode + 1) {
                            component.setForeground(Color.RED);
                            break;
                        }
                        lastClockMode = clockMode;
                    }
                }
            }
        } else if (userObject instanceof RbGlobalGPSChainElement) {
            // empty if block
        }
        return component;
    }
}

