/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import au.com.bytecode.opencsv.CSVWriter;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.manager.DefaultRowCreator;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterCriteria;
import com.bwanms.rb.mo.RbChainConfig;
import com.bwanms.rb.model.RbGlobalGPSChainElement;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.ui.components.ExtensionFileFilter;
import com.bwanms.util.MessageBox;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbGPSChainManagerConfig
extends EntityManagerConfig {
    public static final Internationalizer i18n = Internationalizer.getInternationalizer(RbGPSChainManagerConfig.class);
    private static final Logger logger = Logger.getLogger(RbGPSChainManagerConfig.class);
    private static String[] columnNames = new String[]{"chainNumber", "gpsType", "timeZoneOffsetFromUTC", "stopTxAfterHoldOverTimeout", "holdOverPassedTimeout", "numberOfRxSatellites", "latitude", "longitude", "altitude"};
    private static String[] columnAttribNames = new String[]{"chainNumber", "gpsType", "timeZoneOffsetFromUTC", "stopTxAfterHoldOverTimeout", "holdOverPassedTimeout", "numberOfRxSatellites", "latitude", "longitude", "altitude"};
    private List<EntityManagerColumn> columns = new Vector<EntityManagerColumn>();
    private EntityManagerRowProvider entityRowProvider;
    private Vector<ManagerFilterCriteria> filterCriteria;
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public RbGPSChainManagerConfig() {
        this.columns.add(new EntityManagerColumn(columnNames[0], columnAttribNames[0], i18n.translateString(columnNames[0]), (Comparator)new EntityManagerRowDisplayComparator(0)));
        this.columns.add(new EntityManagerColumn(columnNames[1], columnAttribNames[1], i18n.translateString(columnNames[1]), (Comparator)new EntityManagerRowDisplayComparator(1)));
        this.columns.add(new EntityManagerColumn(columnNames[2], columnAttribNames[2], i18n.translateString(columnNames[2]), (Comparator)new EntityManagerRowDisplayComparator(2)));
        this.columns.add(new EntityManagerColumn(columnNames[3], columnAttribNames[3], i18n.translateString(columnNames[3]), (Comparator)new EntityManagerRowDisplayComparator(3)));
        this.columns.add(new EntityManagerColumn(columnNames[4], columnAttribNames[4], i18n.translateString(columnNames[4]), (Comparator)new EntityManagerRowDisplayComparator(4)));
        this.columns.add(new EntityManagerColumn(columnNames[5], columnAttribNames[5], i18n.translateString(columnNames[5]), (Comparator)new EntityManagerRowDisplayComparator(5)));
        this.columns.add(new EntityManagerColumn(columnNames[6], columnAttribNames[6], i18n.translateString(columnNames[6]), (Comparator)new EntityManagerRowDisplayComparator(6)));
        this.columns.add(new EntityManagerColumn(columnNames[7], columnAttribNames[7], i18n.translateString(columnNames[7]), (Comparator)new EntityManagerRowDisplayComparator(7)));
        this.columns.add(new EntityManagerColumn(columnNames[8], columnAttribNames[8], i18n.translateString(columnNames[8]), (Comparator)new EntityManagerRowDisplayComparator(8)));
        this.entityRowProvider = new RbGPSChainManagerRowProvider(RbGPSChainManagerConfig.getColumnAttributeNames(this.columns));
        this.filterCriteria = new Vector();
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("chainNumber"), "chainNumber", 1, 1, null, false));
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)0, i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(0))));
        items.add(new ComboItem((Object)2, i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(1))));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("gpsType"), "gpsType", 2, 3, items, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("timeZoneOffsetFromUTC"), "timeZoneOffsetFromUTC", 1, 1, null, false));
        items = new Vector();
        items.add(new ComboItem((Object)2, i18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(2))));
        items.add(new ComboItem((Object)1, i18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(1))));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("stopTxAfterHoldOverTimeout"), "stopTxAfterHoldOverTimeout", 2, 3, items, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("holdOverPassedTimeout"), "holdOverPassedTimeout", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("numberOfRxSatellites"), "numberOfRxSatellites", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("latitude"), "latitude", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("longitude"), "longitude", 1, 1, null, false));
        this.filterCriteria.add((ManagerFilterCriteria)new EntityManagerFilterCriteria(i18n.translateString("altitude"), "altitude", 1, 1, null, false));
        this.declaredActions = new Vector<ManagerAction>();
        this.defaultAction = new GPSChainManagerAction("Export", 1);
        this.declaredActions.add(this.defaultAction);
    }

    protected String getBaseName() {
        return RbGlobalGPSChainElement.class.getName();
    }

    public List<EntityManagerColumn> getColumns() {
        return this.columns;
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return this.entityRowProvider;
    }

    protected List<ManagerFilterCriteria> getFilterCriteria() {
        return this.filterCriteria;
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public String getTitle() {
        return i18n.translateString("GPSChainManager");
    }

    private File getExportFile(String fileExt, JComponent uiParent) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(i18n.translateString("ExportGPSChainTitle"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setApproveButtonText(i18n.translateString("FileChooserApproveButton"));
        fileChooser.setApproveButtonToolTipText(i18n.translateString("FileChooserApproveButtonToolTip"));
        ExtensionFileFilter fileExtFilter = new ExtensionFileFilter();
        fileExtFilter.addExtension(fileExt);
        fileExtFilter.setDescription(i18n.translateString("ExportGPSChainFilterDescr", new Object[]{"*." + fileExt}));
        fileChooser.setFileFilter((FileFilter)fileExtFilter);
        int ret = fileChooser.showOpenDialog(uiParent);
        if (ret == 0) {
            String ext;
            File exportFile = fileChooser.getSelectedFile();
            int lastDotIndex = exportFile.getName().lastIndexOf(46);
            String string = ext = lastDotIndex == -1 ? null : exportFile.getName().substring(lastDotIndex + 1);
            if (!fileExt.equalsIgnoreCase(ext)) {
                exportFile = new File(exportFile.getAbsolutePath() + "." + fileExt);
            }
            return exportFile;
        }
        return null;
    }

    private void exportGPSChains(List<EntityManagerRow> selectedRows, File selectedFile) throws IOException {
        if (selectedRows == null || selectedRows.size() == 0 || selectedFile == null) {
            return;
        }
        if (!selectedFile.exists()) {
            selectedFile.createNewFile();
        }
        CSVWriter csvOut = new CSVWriter((Writer)new FileWriter(selectedFile));
        csvOut.writeNext(this.getColumnTitles());
        for (EntityManagerRow row : selectedRows) {
            csvOut.writeNext(row.getDisplayValues().toArray(new String[0]));
        }
        csvOut.close();
    }

    public String getHelpTopic() {
        return "rb_gps_chain_manager";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RbGPSChainManagerRowProvider
    extends DefaultRowCreator {
        public RbGPSChainManagerRowProvider(List<String> attributes) {
            super(attributes);
        }

        public String readEntityId(Serializable entity) {
            return String.valueOf(((RbGlobalGPSChainElement)entity).getId());
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List ret = super.getDisplayValues(entityRow);
            RbGlobalGPSChainElement globalGPSChain = (RbGlobalGPSChainElement)entityRow.getEntity();
            ret.set(1, i18n.translateString(RbChainConfig.toStringRbGPSCurrentType(globalGPSChain.getGpsType())));
            ret.set(3, i18n.translateString(RbChainConfig.toStringRbStopTxAfterHoldOverTimeout(globalGPSChain.getStopTxAfterHoldOverTimeout())));
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GPSChainManagerAction
    extends ManagerAction {
        public GPSChainManagerAction(String name, int category) {
            this.name = name;
            this.category = category;
        }

        public void performAction(ManagerView manager) {
            File exportFile;
            List selection = manager.getSelection();
            if ("Export".equals(this.name) && (exportFile = RbGPSChainManagerConfig.this.getExportFile("csv", manager.getUI())) != null) {
                boolean overwriteExistingFile = false;
                if (exportFile.exists() && !(overwriteExistingFile = MessageBox.WarnConfirm.showResult((Component)manager.getUI(), i18n.translateString("ExportFileReplacingConfirmation", new Object[]{exportFile.getAbsolutePath()}), i18n.translateString("ExportGPSChainTitle")))) {
                    logger.info((Object)i18n.translateString("ExportFileReplacingRejected", new Object[]{exportFile.getAbsolutePath()}));
                    return;
                }
                try {
                    RbGPSChainManagerConfig.this.exportGPSChains(((EntityManagerView)manager).getSelectionData(), exportFile);
                    logger.info((Object)i18n.translateString("GPSChainLogsExported", new Object[]{selection.size(), exportFile.getAbsolutePath()}));
                }
                catch (IOException e) {
                    logger.debug((Object)"Export GPS Chains error", (Throwable)e);
                    MessageBox.Error.showResult((Component)manager.getUI(), e.getMessage(), i18n.translateString("ExportGPSChainTitle"));
                }
            }
        }

        public boolean isEnabled(List<Serializable> selection) {
            int selectionSize;
            int n = selectionSize = null != selection ? selection.size() : 0;
            if (this.name.equals("Export")) {
                return selectionSize > 0;
            }
            return true;
        }
    }
}

