/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryFilter;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteriaView;
import com.bwanms.gui.manager.generic.EntityManagerQueryJoinClass;
import com.bwanms.gui.manager.generic.InvalidFilterValueException;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaJoinClass;
import com.bwanms.gui.manager.generic.ManagerFilterCriteriaView;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbEntityManagerFilter
implements EntityQueryFilter {
    public static final String FILTER_ATTRIBUTE_CLASS = "CLASS";
    private static final Logger logger = Logger.getLogger(RbEntityManagerFilter.class);
    private String queryString;
    private EntityManagerRowProvider rowCreator;
    List<String> invisibleFiltersList;

    public RbEntityManagerFilter(String entityBaseName, List<ManagerFilterCriteriaView> selectedCriteria, EntityManagerRowProvider rowCreator, List<String> invisibleFiltersList) throws InvalidFilterValueException {
        this.invisibleFiltersList = invisibleFiltersList;
        this.rowCreator = rowCreator;
        this.createFilterQueryString(entityBaseName, selectedCriteria);
    }

    private void createFilterQueryString(String entityBaseName, List<ManagerFilterCriteriaView> selectedCriteria) throws InvalidFilterValueException {
        String queryFromClassName = entityBaseName;
        StringBuffer conditionSB = new StringBuffer();
        boolean isDistinct = false;
        ArrayList<String> selectClauseItems = new ArrayList<String>();
        ArrayList<String> selectItems = new ArrayList<String>();
        TreeMap<String, String> joinClassesAliases = new TreeMap<String, String>();
        ArrayList<String> groupItems = new ArrayList<String>();
        int aliasIdx = 1;
        List creatorJoinClasses = this.rowCreator.getEntityQueryJoinClasses();
        if (null != creatorJoinClasses) {
            for (EntityManagerQueryJoinClass joinCls : creatorJoinClasses) {
                String clsName;
                String alias;
                if (!isDistinct && joinCls.isDistinct()) {
                    isDistinct = true;
                }
                if (null == (alias = (String)joinClassesAliases.get(clsName = joinCls.getJoinClass().getName()))) {
                    if (clsName.equals(entityBaseName)) {
                        alias = "tbl1";
                    } else {
                        alias = "tbl" + ++aliasIdx;
                        joinClassesAliases.put(clsName, alias);
                    }
                }
                if (joinCls.isInSelectClause()) {
                    selectClauseItems.add(alias);
                }
                if (null != joinCls.getQueryAttribNames()) {
                    for (String queryAttr : joinCls.getQueryAttribNames()) {
                        selectItems.add(queryAttr.replace("<alias>", alias));
                    }
                }
                for (String joinCondition : joinCls.getJoinConditions()) {
                    if (0 != conditionSB.length()) {
                        conditionSB.append(" and ");
                    }
                    conditionSB.append('(');
                    conditionSB.append(joinCondition.replace("<alias>", alias));
                    conditionSB.append(')');
                }
                if (null == joinCls.getGroupAttribs()) continue;
                for (String groupAttr : joinCls.getGroupAttribs()) {
                    groupItems.add(groupAttr.replace("<alias>", alias));
                }
            }
        }
        if (null != this.invisibleFiltersList && this.invisibleFiltersList.size() > 0) {
            for (String condition : this.invisibleFiltersList) {
                if (0 != conditionSB.length()) {
                    conditionSB.append(" and ");
                }
                conditionSB.append('(');
                conditionSB.append(condition);
                conditionSB.append(')');
            }
        }
        if (null != selectedCriteria) {
            for (ManagerFilterCriteriaView criteria : selectedCriteria) {
                String condition;
                if (criteria instanceof EntityManagerFilterCriteriaView && FILTER_ATTRIBUTE_CLASS.equals(((EntityManagerFilterCriteriaView)criteria).getAttribute())) {
                    queryFromClassName = (String)((EntityManagerFilterCriteriaView)criteria).getSelectedValues().get(0);
                    continue;
                }
                String alias = null;
                ManagerFilterCriteriaJoinClass joinCls = criteria.getConditionClass();
                if (null != joinCls) {
                    String clsName = joinCls.getJoinClass().getName();
                    alias = (String)joinClassesAliases.get(clsName);
                    if (null == alias) {
                        if (clsName.equals(entityBaseName)) {
                            alias = "tbl1";
                        } else {
                            alias = "tbl" + ++aliasIdx;
                            joinClassesAliases.put(clsName, alias);
                        }
                    }
                    for (int i = 0; i < joinCls.getJoinBaseAttrNames().length; ++i) {
                        if (0 != conditionSB.length()) {
                            conditionSB.append(" and ");
                        }
                        conditionSB.append('(');
                        conditionSB.append("tbl1." + joinCls.getJoinBaseAttrNames()[i] + "=" + alias + "." + joinCls.getJoinLocalAttrbNames()[i]);
                        conditionSB.append(')');
                    }
                } else {
                    alias = "tbl1";
                }
                if (null == (condition = criteria.getConditionToken(alias))) continue;
                if (0 != conditionSB.length()) {
                    conditionSB.append(" and ");
                }
                conditionSB.append('(');
                conditionSB.append(condition);
                conditionSB.append(')');
            }
        }
        StringBuilder sb = new StringBuilder(isDistinct ? "select distinct " : "select ");
        if (selectClauseItems.size() > 0) {
            for (int i = 0; i < selectClauseItems.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((String)selectClauseItems.get(i));
            }
        } else {
            sb.append(" tbl1 ");
        }
        StringBuffer queryStringSB = new StringBuffer(sb.toString());
        for (String queryAttr : selectItems) {
            queryStringSB.append(", " + queryAttr);
        }
        queryStringSB.append(" from " + queryFromClassName + " as tbl1");
        for (String clsName : joinClassesAliases.keySet()) {
            queryStringSB.append(", " + clsName + " as " + (String)joinClassesAliases.get(clsName));
        }
        if (conditionSB.length() > 0) {
            queryStringSB.append(" where " + conditionSB.toString());
        }
        if (groupItems.size() > 0) {
            queryStringSB.append(" group by " + (String)groupItems.get(0));
            for (int i = 1; i < groupItems.size(); ++i) {
                queryStringSB.append(", " + (String)groupItems.get(i));
            }
        }
        this.queryString = queryStringSB.toString();
        logger.debug((Object)("----- getFilterQueryString() " + this.queryString));
    }

    public String getFilterQueryString() {
        return this.queryString;
    }

    public EntityManagerRowProvider getEntityRowCreator() {
        return this.rowCreator;
    }
}

