/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.bwanms.ddi.DDRegistry;
import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.editor.EntityTypeSelectorContainer;
import com.bwanms.gui.equipmentmanager.CraftAutoDiscoveryEditorContainer;
import com.bwanms.gui.equipmentmanager.CraftBaseStationManagerConfig;
import com.bwanms.gui.equipmentmanager.CraftConnectivityTestPanel;
import com.bwanms.gui.equipmentmanager.CraftSnmpConnectivityTestJob;
import com.bwanms.gui.equipmentmanager.EquipmentEditorContainer;
import com.bwanms.gui.manager.EntityChangeListener;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagementInterface;
import com.bwanms.model.NetworkIpAddressRange;
import com.bwanms.model.SNMPManagementInterface;
import com.bwanms.rb.gui.bs.RbBsEditorPanel;
import com.bwanms.rb.gui.bs.RbBsEditorView;
import com.bwanms.rb.model.RbBS;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbMBS;
import com.bwanms.rb.model.RbSU;
import com.bwanms.services.EntityManagerService;
import com.bwanms.services.ServiceException;
import com.bwanms.services.ServiceRegistry;
import com.bwanms.util.FrameUtil;
import com.bwanms.util.IpAddress;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbCraftBaseStationManagerConfig
extends CraftBaseStationManagerConfig {
    private static final Logger logger = Logger.getLogger(RbCraftBaseStationManagerConfig.class);
    private static final Internationalizer I18n = Internationalizer.getInternationalizer(RbCraftBaseStationManagerConfig.class);
    protected NetworkIpAddressRange addressRange;
    Thread refreshSUListThread = new Thread(new Runnable(){

        public void run() {
            EntityManagerService entityService = ServiceRegistry.getEntityManagerService();
            List temps = entityService.retrieveAll(((Object)((Object)new RbSU())).getClass());
            for (RbSU su : temps) {
                if (su.getManagerBS() != null) continue;
                try {
                    entityService.delete((Serializable)((Object)su));
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
            }
        }
    });

    public RbCraftBaseStationManagerConfig(int maxSelection) {
        super(maxSelection);
        this.declaredActions.add(1, new CraftBaseStationManagerConfig.CraftEquipmentManagerAction((CraftBaseStationManagerConfig)this, "AutoDiscovery", 1));
        this.declaredActions.add(2, new CraftBaseStationManagerConfig.CraftEquipmentManagerAction((CraftBaseStationManagerConfig)this, "TestConnectivity", 1));
        this.refreshSUListThread.start();
        this.addressRange = new NetworkIpAddressRange();
        this.addressRange.setType(Integer.valueOf(0));
    }

    public RbCraftBaseStationManagerConfig() {
        this.declaredActions.add(1, new CraftBaseStationManagerConfig.CraftEquipmentManagerAction((CraftBaseStationManagerConfig)this, "AutoDiscovery", 1));
        this.declaredActions.add(2, new CraftBaseStationManagerConfig.CraftEquipmentManagerAction((CraftBaseStationManagerConfig)this, "TestConnectivity", 1));
        this.refreshSUListThread.start();
        this.addressRange = new NetworkIpAddressRange();
        this.addressRange.setType(Integer.valueOf(0));
    }

    protected void performActionNew(final ManagerView manager) {
        EntityTypeSelectorContainer typeSelectorContainer = new EntityTypeSelectorContainer("RbBaseStationEquipment", (JFrame)SwingUtilities.getWindowAncestor(manager.getUI()), I18n.translateString("RbBaseStationEquipment"));
        typeSelectorContainer.showDialog();
        Class selectedType = typeSelectorContainer.getSelectedEntityType();
        if (null != selectedType) {
            try {
                EquipmentEditorContainer editorContainer = new EquipmentEditorContainer((JFrame)SwingUtilities.getWindowAncestor(manager.getUI()), (Equipment)selectedType.newInstance()){

                    public void actionOKPerformed() {
                        block3: {
                            block2: {
                                if (this.save() == null) break block2;
                                this.cleanup();
                                Equipment eq = this.getAddedEquipment();
                                if (null == eq || !(manager instanceof EntityChangeListener)) break block3;
                                EntityChangeListener listener = (EntityChangeListener)manager;
                                listener.entityAdded((Serializable)eq);
                                break block3;
                            }
                            if (this.invalidValues.size() <= 0) {
                                for (EntityManagerRow row : manager.getData()) {
                                    IpAddress ipAddr = new IpAddress(((RbBsEditorView)this.getView()).getRbBsEditorPanel().getTxtIpAddress().getText());
                                    if (ipAddr.compareTo(new IpAddress(((Equipment)row.getEntity()).getIpAddr().longValue())) != 0) continue;
                                    this.invalidValuesUtil.clearReportedInvalidValues(this.invalidValues);
                                    this.invalidValues.add(new InvalidValue("IP already in list", JTextField.class, "IP Address", (Object)ipAddr, (Object)((RbBsEditorView)this.getView()).getRbBsEditorPanel().getTxtIpAddress()));
                                    this.reportErrors();
                                    break;
                                }
                            }
                        }
                    }
                };
                FrameUtil.addKeyListenerRecursively((Component)editorContainer.getFrame(), (KeyAdapter)this.theListener);
                this.removeFromEditorPanel(editorContainer);
            }
            catch (InstantiationException e) {
                logger.debug((Object)"", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.debug((Object)"", (Throwable)e);
            }
            catch (ServiceException e) {
                // empty catch block
            }
        }
    }

    protected void performActionAutoDiscovery(ManagerView manager) {
        try {
            CraftAutoDiscoveryEditorContainer editorContainer = new CraftAutoDiscoveryEditorContainer(manager.getUI(), this.addressRange);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void performActionTestConnectivity(ManagerView manager) {
        List selectedRows = ((EntityManagerView)manager).getSelectionData();
        int i = 0;
        ArrayList<SNMPManagementInterface> managementInterfaces = new ArrayList<SNMPManagementInterface>();
        ArrayList<String> names = new ArrayList<String>();
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        for (EntityManagerRow row : selectedRows) {
            RbBaseStationEquipment equipment = (RbBaseStationEquipment)((Object)row.getEntity());
            names.add(equipment.getName());
            managementInterfaces.add(equipment.getManagementInterface());
        }
        CraftSnmpConnectivityTestJob connectivityTestThread = new CraftSnmpConnectivityTestJob(managementInterfaces, names);
        CraftConnectivityTestPanel cctp = new CraftConnectivityTestPanel(connectivityTestThread);
        connectivityTestThread.setCctp(cctp);
        DefaultTableModel tblModel = cctp.getTableModel();
        for (SNMPManagementInterface managementInterface : managementInterfaces) {
            tblModel.addRow(new Object[]{names.get(i), managementInterface.getIp(), null, null});
            ++i;
        }
        connectivityTestThread.schedule();
        FrameUtil.runDialog((JDialog)new JDialog((JFrame)SwingUtilities.getWindowAncestor(manager.getUI())), (String)I18n.translateString("TestConnectivity"), (JPanel)cctp, (int)150, (int)150);
    }

    protected void removeFromEditorPanel(EquipmentEditorContainer editorContainer) {
        try {
            RbBsEditorPanel component = (RbBsEditorPanel)editorContainer.getView().getUI();
            component.getSelectorLocation().setVisible(false);
            component.getSelectorContact().setVisible(false);
            component.getLblDeviceLocation().setVisible(false);
            component.getLblContact().setVisible(false);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected void exportEquipments(List<EntityManagerRow> selectedRows, File selectedFile) throws IOException {
        if (selectedRows == null || selectedRows.size() == 0 || selectedFile == null) {
            return;
        }
        if (!selectedFile.exists()) {
            selectedFile.createNewFile();
        }
        CSVWriter csvOut = new CSVWriter((Writer)new FileWriter(selectedFile));
        for (EntityManagerRow row : selectedRows) {
            RbBaseStationEquipment equipment = (RbBaseStationEquipment)((Object)row.getEntity());
            String[] equipmentValues = new String[7];
            equipmentValues[0] = equipment.getName();
            if (equipment instanceof RbBS) {
                equipmentValues[1] = "BS";
            }
            if (equipment instanceof RbMBS) {
                equipmentValues[1] = "MBS";
            }
            equipmentValues[2] = equipment.getIPAddress();
            equipmentValues[3] = equipment.getSnmpReadCommunity();
            equipmentValues[4] = equipment.getSnmpWriteCommunity();
            equipmentValues[5] = equipment.getSnmpRetries().toString();
            equipmentValues[6] = equipment.getSnmpTimeout().toString();
            csvOut.writeNext(equipmentValues);
        }
        csvOut.close();
    }

    protected boolean importEquipments(EntityChangeListener<Equipment> listener, CSVReader reader) {
        boolean eqFound = false;
        try {
            String[] eq = reader.readNext();
            while (eq != null) {
                if (eq[1].equalsIgnoreCase("BS")) {
                    RbBS bs = new RbBS();
                    eqFound = true;
                    bs.setName(eq[0]);
                    bs.setIPAddress(eq[2]);
                    bs.setSnmpReadCommunity(eq[3]);
                    bs.setSnmpWriteCommunity(eq[4]);
                    bs.setSnmpRetries(Integer.parseInt(eq[5]));
                    bs.setSnmpTimeout(Long.parseLong(eq[6]));
                    bs.setSnmpPort(161);
                    try {
                        bs = (RbBS)DDRegistry.getInstance().createEquipment((ManagementInterface)bs.getManagementInterface(), ((Object)((Object)bs)).getClass().getName(), bs.getName());
                        bs = (RbBS)((Object)ServiceRegistry.getEntityManagerService().save((Serializable)((Object)bs)));
                        listener.entityAdded((Serializable)((Object)bs));
                    }
                    catch (ServiceException e) {
                        // empty catch block
                    }
                }
                if (eq[1].equalsIgnoreCase("MBS")) {
                    RbMBS mbs = new RbMBS();
                    eqFound = true;
                    mbs.setName(eq[0]);
                    mbs.setIPAddress(eq[2]);
                    mbs.setSnmpReadCommunity(eq[3]);
                    mbs.setSnmpWriteCommunity(eq[4]);
                    mbs.setSnmpRetries(Integer.parseInt(eq[5]));
                    mbs.setSnmpTimeout(Long.parseLong(eq[6]));
                    mbs.setSnmpPort(161);
                    try {
                        mbs = (RbMBS)DDRegistry.getInstance().createEquipment((ManagementInterface)mbs.getManagementInterface(), ((Object)((Object)mbs)).getClass().getName(), mbs.getName());
                        mbs = (RbMBS)((Object)ServiceRegistry.getEntityManagerService().save((Serializable)((Object)mbs)));
                        listener.entityAdded((Serializable)((Object)mbs));
                        eqFound = true;
                    }
                    catch (ServiceException e) {
                        // empty catch block
                    }
                }
                eq = reader.readNext();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return eqFound;
    }

    public String getHelp() {
        return "ngnms.rb.help.craft_device_manager";
    }

    protected String getManagerNameString() {
        return "CraftBMAXBSEquipmentManager";
    }

    protected String getBaseNameString() {
        return RbBaseStationEquipment.class.getName();
    }

    protected void Columns() {
        super.Columns();
        this.columns.add(new EntityManagerColumn("serialNumber", "serialNumber", i18n.translateString("SerialNumber"), (Comparator)new EntityManagerRowDisplayComparator(5)));
        this.columns.add(new EntityManagerColumn("switchingMode", "switchingMode", I18n.translateString("SwitchingMode"), (Comparator)new EntityManagerRowDisplayComparator(7)));
    }

    protected void initEntityRowProvider() {
        this.entityRowProvider = new RbCraftEquipmentRowProvider(RbCraftBaseStationManagerConfig.getColumnAttributeNames((List)this.columns));
    }

    private static String toStringSwitchingMode(String switchingMode) {
        if ("1".equals(switchingMode)) {
            return I18n.translateString("Ethernet_CS");
        }
        if ("2".equals(switchingMode)) {
            return I18n.translateString("IP_CS");
        }
        return I18n.translateString("Unknown");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RbCraftEquipmentRowProvider
    extends CraftBaseStationManagerConfig.CraftEquipmentRowProvider {
        public RbCraftEquipmentRowProvider(List<String> attributes) {
            super(attributes);
        }

        public List<String> getDisplayValues(EntityManagerRow entityRow) {
            List ret = super.getDisplayValues(entityRow);
            ret.set(6, RbCraftBaseStationManagerConfig.toStringSwitchingMode((String)ret.get(6)));
            return ret;
        }
    }
}

