/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.client.gui.fault.events.OpenAlarmsView;
import com.bwanms.client.gui.tasks.pmcollection.PMCollectionTaskWizardContainer;
import com.bwanms.domain.logic.LicenseClient;
import com.bwanms.entitymanager.EntityManagerRowProvider;
import com.bwanms.entitymanager.EntityQueryStrategy;
import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.View;
import com.bwanms.gui.equipmentmanager.AbstractEquipmentManagerConfig;
import com.bwanms.gui.manager.ManagerView;
import com.bwanms.gui.manager.SortView;
import com.bwanms.gui.manager.generic.EntityManagerColumn;
import com.bwanms.gui.manager.generic.EntityManagerConfig;
import com.bwanms.gui.manager.generic.EntityManagerFilterCriteria;
import com.bwanms.gui.manager.generic.EntityManagerFilterView;
import com.bwanms.gui.manager.generic.EntityManagerRowDisplayComparator;
import com.bwanms.gui.manager.generic.EntityManagerSortByIdNoUI;
import com.bwanms.gui.manager.generic.EntityManagerView;
import com.bwanms.gui.manager.generic.ManagerAction;
import com.bwanms.gui.manager.generic.ManagerFilterView;
import com.bwanms.gui.manager.generic.SinglePageQueryStrategy;
import com.bwanms.gui.taskmanager.TaskEditorFormContainer;
import com.bwanms.model.Equipment;
import com.bwanms.model.ManagedEntity;
import com.bwanms.model.Task;
import com.bwanms.model.task.PerformanceCollectionGenericTask;
import com.bwanms.plugin.ExtensionRegistryFactory;
import com.bwanms.plugin.IConfigurationElement;
import com.bwanms.plugin.IExtensionPoint;
import com.bwanms.plugin.IExtensionRegistry;
import com.bwanms.rb.gui.managers.RbBaseStationEquipmentRowProvider;
import com.bwanms.rb.gui.managers.RbSUManagerConfig;
import com.bwanms.rb.gui.managers.RbServiceGMLManagerConfig;
import com.bwanms.rb.gui.selectors.service.RbSelfContainedSelectorDialog;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.performance.RbPerformanceMECollectionEntity;
import com.bwanms.rb.tasks.configbackup.RbConfigBackupTask;
import com.bwanms.rb.tasks.frequencybandfile.RbFrequencyBandFileTask;
import com.bwanms.rb.tasks.servicedistribution.RbServiceProfileDistributionTask;
import com.bwanms.rb.tasks.softwareupgrade.RbSoftwareUpgradeTask;
import com.bwanms.rb.tasks.softwareupgrade.RbSwUpgradeEquipmentWeakAssociation;
import com.bwanms.rb.util.RbGUIUtil;
import com.bwanms.ui.components.ComboItem;
import com.bwanms.util.FrameUtil;
import java.awt.Dimension;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbBaseStationManagerConfig
extends AbstractEquipmentManagerConfig {
    private static final Logger logger = Logger.getLogger(RbBaseStationManagerConfig.class);
    private static final Internationalizer ddI18N = Internationalizer.getInternationalizer((String)"com.bwanms.ddi");
    private static final Internationalizer rbI18n = Internationalizer.getInternationalizer(RbBaseStationManagerConfig.class);
    private List<ManagerAction> declaredActions;
    private ManagerAction defaultAction;

    public RbBaseStationManagerConfig(int maxSelection) {
        super(maxSelection);
        this.declaredActions = super.getDeclaredActions();
        this.defaultAction = super.getDefaultAction();
        this.Columns();
        this.updateFilterCriteria();
    }

    public RbBaseStationManagerConfig() {
        this.declaredActions = new Vector<ManagerAction>();
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "New", 1, "RbBaseStationEquipment"));
        this.defaultAction = new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "Configure", 1);
        this.declaredActions.add(this.defaultAction);
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "Edit", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "Delete", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "License", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "CutThrough", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "MultipleConfiguration", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "Export", 1));
        this.declaredActions.add((ManagerAction)new AbstractEquipmentManagerConfig.EquipmentManagerAction((AbstractEquipmentManagerConfig)this, "OpenMap", 1));
        RbBSEquipmentManagerAction showSUsAction = new RbBSEquipmentManagerAction("ShowSUs", 1);
        showSUsAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)showSUsAction);
        RbBSEquipmentManagerAction showServicesAction = new RbBSEquipmentManagerAction("ShowServices", 1);
        showServicesAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)showServicesAction);
        RbBSEquipmentManagerAction openAlarmsAction = new RbBSEquipmentManagerAction("OpenAlarms", 1);
        openAlarmsAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)openAlarmsAction);
        RbBSEquipmentManagerAction softwareUpgradeTaskAction = new RbBSEquipmentManagerAction("SoftwareUpgradeTask", 1);
        softwareUpgradeTaskAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)softwareUpgradeTaskAction);
        RbBSEquipmentManagerAction serviceProfileDistributionTaskAction = new RbBSEquipmentManagerAction("ServiceProfileDistributionTask", 1);
        serviceProfileDistributionTaskAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)serviceProfileDistributionTaskAction);
        RbBSEquipmentManagerAction performanceCollectionTaskAction = new RbBSEquipmentManagerAction("PerformanceCollectionTask", 1);
        performanceCollectionTaskAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)performanceCollectionTaskAction);
        RbBSEquipmentManagerAction freqBandTaskAction = new RbBSEquipmentManagerAction("FreqBandTask", 1);
        freqBandTaskAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)freqBandTaskAction);
        RbBSEquipmentManagerAction configurationBackupTaskAction = new RbBSEquipmentManagerAction("ConfigurationBackupTask", 1);
        configurationBackupTaskAction.setI18n(rbI18n);
        this.declaredActions.add((ManagerAction)configurationBackupTaskAction);
        this.Columns();
        this.updateFilterCriteria();
    }

    public List<ManagerAction> getDeclaredActions() {
        return this.declaredActions;
    }

    public ManagerAction getDefaultAction() {
        return this.defaultAction;
    }

    public SortView getSortView() {
        return new EntityManagerSortByIdNoUI();
    }

    private void Columns() {
        this.columns.add(new EntityManagerColumn("serialNumber", "serialNumber", i18n.translateString("SerialNumber"), (Comparator)new EntityManagerRowDisplayComparator(6)));
        this.columns.add(new EntityManagerColumn("switchingMode", "switchingMode", rbI18n.translateString("SwitchingMode"), (Comparator)new EntityManagerRowDisplayComparator(7)));
        this.entityRowProvider = new RbBaseStationEquipmentRowProvider(RbBaseStationManagerConfig.getColumnAttributeNames((List)this.columns));
    }

    private void updateFilterCriteria() {
        this.setTypeFilterCriteria(RbBaseStationEquipment.class);
        this.filterCriteria.add(3, new EntityManagerFilterCriteria(i18n.translateString("MainSoftwareVersion"), "operationalSoftwareVersion", 1, 1, null, false));
        this.filterCriteria.add(4, new EntityManagerFilterCriteria(i18n.translateString("ShadowSoftwareVersion"), "shadowSoftwareVersion", 1, 1, null, false));
        this.filterCriteria.add(7, new EntityManagerFilterCriteria(i18n.translateString("HardwareRevision"), "hardwareRevision", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("OperatorID"), "operatorID", 1, 1, null, false));
        this.filterCriteria.add(new EntityManagerFilterCriteria(i18n.translateString("CellID"), "cellID", 1, 1, null, false));
        Vector<ComboItem> items = new Vector<ComboItem>();
        items.add(new ComboItem((Object)new Integer(RbBaseStationEquipment.SWITCHING_MODE_ETHERNET_CS), rbI18n.translateString("Ethernet_CS")));
        items.add(new ComboItem((Object)new Integer(RbBaseStationEquipment.SWITCHING_MODE_IP_CS), rbI18n.translateString("IP_CS")));
        this.filterCriteria.add(new EntityManagerFilterCriteria(rbI18n.translateString("SwitchingMode"), "switchingMode", 2, 3, items, false));
    }

    protected void setTypeFilterCriteria(Class<?> baseClass) {
        String ATTR_TYPE = "CLASS";
        int typeIndex = -1;
        for (int i = 0; i < this.filterCriteria.size(); ++i) {
            if (!"CLASS".equals(((EntityManagerFilterCriteria)this.filterCriteria.get(i)).getAttribute())) continue;
            typeIndex = i;
            break;
        }
        Vector<ComboItem> items = new Vector<ComboItem>();
        try {
            IExtensionRegistry extensionRegistry = ExtensionRegistryFactory.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("com.bwanms.supportedEquipment");
            if (null != extensionPoint) {
                for (IConfigurationElement element : extensionPoint.getConfigurationElements()) {
                    String equipmentClassName = element.getAttribute("class");
                    if (!baseClass.isAssignableFrom(Class.forName(equipmentClassName))) continue;
                    items.add(new ComboItem((Object)equipmentClassName, ddI18N.translateString(equipmentClassName)));
                }
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"Configuration Error!", (Throwable)e);
            return;
        }
        EntityManagerFilterCriteria newTypeCriteria = new EntityManagerFilterCriteria(i18n.translateString("Type"), "CLASS", 2, 3, items, false);
        if (typeIndex < 0) {
            this.filterCriteria.add(1, newTypeCriteria);
        } else {
            this.filterCriteria.set(typeIndex, newTypeCriteria);
        }
    }

    protected String getManagerName() {
        return "BMAXBSEquipmentManager";
    }

    protected String getBaseName() {
        return RbBaseStationEquipment.class.getName();
    }

    public EntityManagerRowProvider getEntityRowProvider() {
        return super.getEntityRowProvider();
    }

    public EntityQueryStrategy getQueryStrategy() {
        return new SinglePageQueryStrategy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RbBSEquipmentManagerAction
    extends AbstractEquipmentManagerConfig.EquipmentManagerAction {
        public RbBSEquipmentManagerAction(String name, int category) {
            super((AbstractEquipmentManagerConfig)RbBaseStationManagerConfig.this, name, category);
        }

        public boolean isEnabled(List<Serializable> selection) {
            super.isEnabled(selection);
            int selectionSize = null != selection ? selection.size() : 0;
            boolean haveOneUnlincenced = false;
            for (int i = 0; i < selectionSize; ++i) {
                if (LicenseClient.getInstance().isLicensed((Object)((RbBaseStationEquipment)((Object)selection.get(i))))) continue;
                haveOneUnlincenced = true;
                break;
            }
            if (haveOneUnlincenced) {
                return false;
            }
            if (this.name.equals("SoftwareUpgradeTask") || this.name.equals("ServiceProfileDistributionTask") || this.name.equals("PerformanceCollectionTask") || this.name.equals("FreqBandTask") || this.name.equals("ConfigurationBackupTask")) {
                if (selectionSize == 0) {
                    return false;
                }
            } else if (this.name.equals("ShowServices") || this.name.equals("OpenAlarms")) {
                if (selectionSize != 1) {
                    return false;
                }
            } else if (this.name.equals("ShowSUs")) {
                if (selectionSize != 1) {
                    return false;
                }
                RbBaseStationEquipment bs = (RbBaseStationEquipment)((Object)selection.get(0));
                int bsState = bs.getState();
                if (bsState == -3 || bsState == -1) {
                    return false;
                }
            }
            return true;
        }

        public void performAction(ManagerView manager) {
            List selection = manager.getSelection();
            final RbBaseStationEquipment bs = (RbBaseStationEquipment)((Object)selection.get(0));
            if ("ShowSUs".equals(this.name)) {
                RbSelfContainedSelectorDialog dialog;
                String BSName = bs.getName();
                Window parentWindow = SwingUtilities.getWindowAncestor(manager.getUI());
                if (parentWindow instanceof JFrame) {
                    dialog = new RbSelfContainedSelectorDialog((JFrame)parentWindow);
                } else if (parentWindow instanceof JDialog) {
                    dialog = new RbSelfContainedSelectorDialog((JDialog)parentWindow);
                } else {
                    throw new IllegalArgumentException("Unsupported parent window of type: " + parentWindow.getClass().getName());
                }
                RbSUManagerConfig suManagerConfig = new RbSUManagerConfig(){

                    public ManagerFilterView getFilterView() {
                        String adittionalFilter = " tbl1.managerBS.IPAddress = '" + bs.getIPAddress() + "'";
                        return new EntityManagerFilterView(this.getManagerName(), this.getBaseName(), this.getFilterCriteria(), this.getEntityRowProvider(), adittionalFilter);
                    }
                };
                EntityManagerView managerView = new EntityManagerView((EntityManagerConfig)suManagerConfig);
                dialog.setView((View)managerView);
                dialog.setModal(false);
                dialog.setTitle(rbI18n.translateString("ShowSUs") + " : " + BSName);
                dialog.setPreferredSize(new Dimension(managerView.getUI().getPreferredSize().width + 10, managerView.getUI().getPreferredSize().height + 70));
                dialog.pack();
                RbGUIUtil.centerDialog((JDialog)((Object)dialog));
                dialog.setVisible(true);
            } else if ("ShowServices".equals(this.name)) {
                RbSelfContainedSelectorDialog dialog;
                String BSName = bs.getName();
                RbServiceGMLManagerConfig serviceManagerConfig = new RbServiceGMLManagerConfig(){

                    public ManagerFilterView getFilterView() {
                        String adittionalFilter = " tbl1.NRConfiguration.configuration.equipment.ipAddr = '" + bs.getIpAddr() + "'";
                        return new EntityManagerFilterView(this.getManagerName(), this.getBaseName(), this.getFilterCriteria(), this.getEntityRowProvider(), adittionalFilter);
                    }
                };
                serviceManagerConfig.setSelectorName("BSShowServices");
                Window parentWindow = SwingUtilities.getWindowAncestor(manager.getUI());
                if (parentWindow instanceof JFrame) {
                    dialog = new RbSelfContainedSelectorDialog((JFrame)parentWindow);
                } else if (parentWindow instanceof JDialog) {
                    dialog = new RbSelfContainedSelectorDialog((JDialog)parentWindow);
                } else {
                    throw new IllegalArgumentException("Unsupported parent window of type: " + parentWindow.getClass().getName());
                }
                EntityManagerView managerView = new EntityManagerView((EntityManagerConfig)serviceManagerConfig);
                dialog.setView((View)managerView);
                dialog.setModal(false);
                dialog.setTitle(rbI18n.translateString("ShowServices") + " : " + BSName);
                dialog.setPreferredSize(new Dimension(managerView.getUI().getPreferredSize().width + 10, managerView.getUI().getPreferredSize().height + 70));
                dialog.pack();
                RbGUIUtil.centerDialog((JDialog)((Object)dialog));
                dialog.setVisible(true);
            } else if ("SoftwareUpgradeTask".equals(this.name)) {
                RbSoftwareUpgradeTask task = new RbSoftwareUpgradeTask();
                ArrayList<RbSwUpgradeEquipmentWeakAssociation> targetEquipment = new ArrayList<RbSwUpgradeEquipmentWeakAssociation>();
                for (int i = 0; i < selection.size(); ++i) {
                    RbSwUpgradeEquipmentWeakAssociation wa = new RbSwUpgradeEquipmentWeakAssociation((ManagedEntity)((RbBaseStationEquipment)((Object)selection.get(i))));
                    wa.setUpgrade(true);
                    targetEquipment.add(wa);
                }
                task.setTargetEquipment(targetEquipment);
                new TaskEditorFormContainer(((Object)((Object)task)).getClass(), (Task)task);
            } else if ("ServiceProfileDistributionTask".equals(this.name)) {
                RbServiceProfileDistributionTask task = new RbServiceProfileDistributionTask();
                ArrayList<RbBaseStationEquipment> equipmentList = new ArrayList<RbBaseStationEquipment>();
                for (int i = 0; i < selection.size(); ++i) {
                    equipmentList.add((RbBaseStationEquipment)((Object)selection.get(i)));
                }
                task.setEquipmentList(equipmentList);
                new TaskEditorFormContainer(((Object)((Object)task)).getClass(), (Task)task);
            } else if ("PerformanceCollectionTask".equals(this.name)) {
                PerformanceCollectionGenericTask task = new PerformanceCollectionGenericTask();
                ArrayList<RbPerformanceMECollectionEntity> entities = new ArrayList<RbPerformanceMECollectionEntity>();
                for (int i = 0; i < selection.size(); ++i) {
                    entities.add(new RbPerformanceMECollectionEntity((ManagedEntity)((RbBaseStationEquipment)((Object)selection.get(i)))));
                }
                task.setEntityType("RbEquipment");
                task.setName("");
                task.setEntities(entities);
                try {
                    PMCollectionTaskWizardContainer wizard = new PMCollectionTaskWizardContainer(task);
                    wizard.setWizardMode(true);
                    wizard.runEditor();
                }
                catch (Exception e) {
                    logger.error((Object)"Could not start PM Collection Task", (Throwable)e);
                }
            } else if ("FreqBandTask".equals(this.name)) {
                RbFrequencyBandFileTask task = new RbFrequencyBandFileTask();
                ArrayList<RbBaseStationEquipment> equipmentList = new ArrayList<RbBaseStationEquipment>();
                for (int i = 0; i < selection.size(); ++i) {
                    equipmentList.add((RbBaseStationEquipment)((Object)selection.get(i)));
                }
                task.setEquipmentList(equipmentList);
                new TaskEditorFormContainer(((Object)((Object)task)).getClass(), (Task)task);
            } else if ("ConfigurationBackupTask".equals(this.name)) {
                RbConfigBackupTask task = new RbConfigBackupTask();
                ArrayList<RbBaseStationEquipment> equipmentList = new ArrayList<RbBaseStationEquipment>();
                for (int i = 0; i < selection.size(); ++i) {
                    equipmentList.add((RbBaseStationEquipment)((Object)selection.get(i)));
                }
                task.setEquipments(equipmentList);
                new TaskEditorFormContainer(((Object)((Object)task)).getClass(), (Task)task);
            } else if ("OpenAlarms".equals(this.name)) {
                try {
                    FrameUtil.runView((View)new OpenAlarmsView((Equipment)bs), (int)640, (int)480);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                super.performAction(manager);
            }
        }

        public Internationalizer getI18n() {
            return rbI18n;
        }
    }
}

