/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.rb.gui.managers;

import com.bwanms.entitymanager.EntityManagerRow;
import com.bwanms.entitymanager.EntityQueryResults;
import com.bwanms.entitymanager.EntityQuerySort;
import com.bwanms.gui.UIIconFactory;
import com.bwanms.gui.manager.ResultsViewListener;
import com.bwanms.gui.manager.generic.ManagerResultsView;
import com.bwanms.gui.util.AbstractTreeCellEditor;
import com.bwanms.gui.util.treetable.JTreeTable;
import com.bwanms.gui.util.treetable.TreeTableModelAdapter;
import com.bwanms.model.Equipment;
import com.bwanms.rb.gui.managers.GPSChainManagerConfig;
import com.bwanms.rb.gui.managers.GPSManagerTreeModel;
import com.bwanms.rb.gui.managers.GPSManagerTreeTableResultsPanel;
import com.bwanms.rb.mo.RbBSClockConfigParameters;
import com.bwanms.rb.model.RbBaseStationEquipment;
import com.bwanms.rb.model.RbGPSChain;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSManagerTreeTableResultsView
implements ManagerResultsView {
    private GPSManagerTreeTableResultsPanel ui;
    private GPSManagerTreeModel model;
    private ArrayList<ResultsViewListener> listeners = new ArrayList();
    private HashMap<RbGPSChain, EntityManagerRow> rowMap = new HashMap();
    private Action defaultAction;

    public EntityQuerySort getEntityQuerySort() {
        return null;
    }

    public void setEntityQueryResults(EntityQueryResults data) {
        String label;
        String[] numbers;
        int i;
        ArrayList<RbGPSChain> gpsChains = new ArrayList<RbGPSChain>();
        for (EntityManagerRow row : data.getData()) {
            RbGPSChain gpsChain = (RbGPSChain)row.getEntity();
            gpsChains.add(gpsChain);
            this.rowMap.put(gpsChain, row);
        }
        ArrayList<String> expandedChains = new ArrayList<String>();
        for (i = 0; i < this.ui.getLicenseTreeTable().getRowCount(); ++i) {
            if (!this.ui.getLicenseTreeTable().getTree().isExpanded(i) || (numbers = (label = (String)this.ui.getLicenseTreeTable().getModel().getValueAt(i, 0)).split("\\D+")).length <= 1) continue;
            expandedChains.add(numbers[1]);
        }
        this.model.setChainClusters(gpsChains);
        this.fireSelectionChanged();
        ((TreeTableModelAdapter)this.ui.getLicenseTreeTable().getModel()).fireTableDataChanged();
        for (i = 0; i < this.ui.getLicenseTreeTable().getRowCount(); ++i) {
            label = (String)this.ui.getLicenseTreeTable().getModel().getValueAt(i, 0);
            numbers = label.split("\\D+");
            if (numbers.length <= 1 || !expandedChains.contains(numbers[1])) continue;
            this.ui.getLicenseTreeTable().getTree().expandRow(i);
        }
    }

    public List<EntityManagerRow> getSelection() {
        ArrayList<EntityManagerRow> selection = new ArrayList<EntityManagerRow>(5);
        TreePath[] selectionPaths = this.ui.getLicenseTreeTable().getTree().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return selection;
        }
        for (TreePath selectionPath : selectionPaths) {
            EntityManagerRow row;
            if (selectionPath == null) continue;
            Object userObj = ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
            if (userObj instanceof RbGPSChain) {
                row = this.rowMap.get(userObj);
                if (selection.contains(row)) continue;
                selection.add(row);
                continue;
            }
            if (!(userObj instanceof RbBaseStationEquipment) || selection.contains(row = new EntityManagerRow((Serializable)((Equipment)userObj), String.valueOf(((Equipment)userObj).getId()), new ArrayList(), new ArrayList(), null))) continue;
            selection.add(row);
        }
        return selection;
    }

    public void addResultsAreaListener(ResultsViewListener listener) {
        this.listeners.add(listener);
    }

    public void removeResultsAreaListener(ResultsViewListener listener) {
        this.listeners.remove(listener);
    }

    public GPSManagerTreeTableResultsPanel getUI() {
        if (this.ui == null) {
            this.model = new GPSManagerTreeModel();
            this.ui = new GPSManagerTreeTableResultsPanel(this.model);
            this.ui.getLicenseTreeTable().getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent arg0) {
                    GPSManagerTreeTableResultsView.this.fireSelectionChanged();
                }
            });
            this.ui.getLicenseTreeTable().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (1 < e.getClickCount() && null != GPSManagerTreeTableResultsView.this.defaultAction && GPSManagerTreeTableResultsView.this.defaultAction.isEnabled()) {
                        GPSManagerTreeTableResultsView.this.defaultAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), null));
                    }
                }
            });
            this.ui.getLicenseTreeTable().getTree().setCellRenderer(new GPSChainTreeCellRenderer());
            this.ui.getLicenseTreeTable().getTree().setCellEditor((TreeCellEditor)((Object)new GPSChainTreeCellEditor(this.ui.getLicenseTreeTable())));
            this.ui.getLicenseTreeTable().getTree().setEditable(true);
            this.ui.getLicenseTreeTable().setSelectRowsFromTree(true);
        }
        return this.ui;
    }

    public boolean close() {
        return true;
    }

    public void cleanup() {
    }

    public String getTitle() {
        return "";
    }

    public void updateContextMenu(List<JMenuItem> menuItems) {
        this.ui.getPopup().removeAll();
        for (JMenuItem item : menuItems) {
            if (null != item) {
                this.ui.getPopup().add(item);
                continue;
            }
            this.ui.getPopup().addSeparator();
        }
    }

    public void setDefaultActionListener(Action listener) {
        this.defaultAction = listener;
    }

    public void entityChanged(EntityManagerRow row) {
    }

    public void entityAdded(EntityManagerRow row) {
        this.model.addChainCluster((RbGPSChain)row.getEntity());
    }

    public void entityRemoved(Serializable entity) {
        this.model.removeChainCluster((RbGPSChain)entity);
    }

    private void fireSelectionChanged() {
        for (ResultsViewListener listener : this.listeners) {
            listener.selectionChanged(this.getSelection());
        }
    }

    public List<EntityManagerRow> getData() {
        return new ArrayList<EntityManagerRow>();
    }

    private class GPSChainTreeCellEditor
    extends AbstractTreeCellEditor {
        private Object value = null;
        private JTreeTable jTreeTable;
        private JLabel label = new JLabel();

        public GPSChainTreeCellEditor(JTreeTable jTreeTable) {
            this.jTreeTable = jTreeTable;
            this.initComponents();
        }

        private void initComponents() {
            this.label.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    GPSChainTreeCellEditor.this.stopTableEditing();
                }
            });
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof RbGPSChain) {
                RbGPSChain gpsChain = (RbGPSChain)userObject;
                String errMessage = null;
                int childCount = tree.getModel().getChildCount(value);
                if (childCount > 0) {
                    Object childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, 0)).getUserObject();
                    int clockMode = ((RbBaseStationEquipment)((Object)childObj)).getGpsClockMode();
                    if (clockMode != 1) {
                        this.label.setForeground(Color.RED);
                        errMessage = "MasterIsMissing";
                    } else {
                        int i;
                        if (childCount > 1) {
                            childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, 1)).getUserObject();
                            clockMode = ((RbBaseStationEquipment)((Object)childObj)).getGpsClockMode();
                            if (clockMode == 1) {
                                this.label.setForeground(Color.RED);
                                errMessage = "DuplicateMasterInChain";
                            } else if (clockMode > 3) {
                                this.label.setForeground(Color.RED);
                                errMessage = "BSMissingfromChain";
                            } else {
                                int lastClockMode = clockMode;
                                for (i = 2; i < childCount; ++i) {
                                    childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, i)).getUserObject();
                                    clockMode = ((RbBaseStationEquipment)((Object)childObj)).getGpsClockMode();
                                    if (clockMode == lastClockMode) {
                                        this.label.setForeground(Color.RED);
                                        errMessage = "DuplicateBSInChain";
                                        break;
                                    }
                                    if (clockMode > lastClockMode + 1) {
                                        this.label.setForeground(Color.RED);
                                        errMessage = "BSMissingfromChain";
                                        errMessage = "Slave" + clockMode + "Missing";
                                        break;
                                    }
                                    lastClockMode = clockMode;
                                }
                            }
                        }
                        if (null == errMessage) {
                            String chainComplexKey = gpsChain.getComplexKey();
                            for (i = 0; i < childCount; ++i) {
                                childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, i)).getUserObject();
                                String bsGpsChainComplexKey = ((RbBaseStationEquipment)((Object)childObj)).getGpsChainComplexKey();
                                if (chainComplexKey.equals(bsGpsChainComplexKey)) continue;
                                this.label.setForeground(Color.ORANGE.darker());
                                errMessage = "DifferentParametersInChain";
                                break;
                            }
                        }
                    }
                }
                if (null != errMessage) {
                    this.label.setText(this.label.getText() + " (" + GPSChainManagerConfig.i18n.translateString(errMessage) + ")");
                } else {
                    this.label.setText(String.valueOf(value));
                }
                this.label.setIcon(UIIconFactory.getIcon((Object)gpsChain, (int)2));
            } else if (userObject instanceof RbBaseStationEquipment) {
                RbBaseStationEquipment bsEquipment = (RbBaseStationEquipment)((Object)userObject);
                String text = GPSChainManagerConfig.i18n.translateString(RbBSClockConfigParameters.toStringRbBSCurrentClockMode(bsEquipment.getGpsClockMode())) + " (" + bsEquipment.getName() + "/" + bsEquipment.getIPAddress() + ")";
                this.label.setText(text);
                this.label.setIcon(UIIconFactory.getIcon((Object)((Object)bsEquipment), (int)2));
            }
            this.stopTableEditing();
            return this.label;
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped(new ChangeEvent((Object)this));
            return true;
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled(new ChangeEvent((Object)this));
        }

        private void stopTableEditing() {
            this.stopCellEditing();
            if (this.jTreeTable != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GPSChainTreeCellEditor.this.jTreeTable.dispatchEvent((AWTEvent)new KeyEvent((Component)GPSChainTreeCellEditor.this.jTreeTable, 401, new Date().getTime(), 0, 27, '\uffff'));
                    }
                });
            }
        }
    }

    private class GPSChainTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private GPSChainTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof RbGPSChain) {
                RbGPSChain gpsChain = (RbGPSChain)userObject;
                String errMessage = null;
                int childCount = tree.getModel().getChildCount(value);
                if (childCount > 0) {
                    Object childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, 0)).getUserObject();
                    int clockMode = ((RbBaseStationEquipment)((Object)childObj)).getGpsClockMode();
                    if (clockMode != 1) {
                        label.setForeground(Color.RED);
                        errMessage = "MasterIsMissing";
                    } else {
                        int i;
                        if (childCount > 1) {
                            childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, 1)).getUserObject();
                            clockMode = ((RbBaseStationEquipment)((Object)childObj)).getGpsClockMode();
                            if (clockMode == 1) {
                                label.setForeground(Color.RED);
                                errMessage = "DuplicateMasterInChain";
                            } else if (clockMode > 3) {
                                label.setForeground(Color.RED);
                                errMessage = "BSMissingfromChain";
                            } else {
                                int lastClockMode = clockMode;
                                for (i = 2; i < childCount; ++i) {
                                    childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, i)).getUserObject();
                                    clockMode = ((RbBaseStationEquipment)((Object)childObj)).getGpsClockMode();
                                    if (clockMode == lastClockMode) {
                                        label.setForeground(Color.RED);
                                        errMessage = "DuplicateBSInChain";
                                        break;
                                    }
                                    if (clockMode > lastClockMode + 1) {
                                        label.setForeground(Color.RED);
                                        errMessage = "BSMissingfromChain";
                                        break;
                                    }
                                    lastClockMode = clockMode;
                                }
                            }
                        }
                        if (null == errMessage) {
                            String chainComplexKey = gpsChain.getComplexKey();
                            for (i = 0; i < childCount; ++i) {
                                childObj = ((DefaultMutableTreeNode)tree.getModel().getChild(value, i)).getUserObject();
                                String bsGpsChainComplexKey = ((RbBaseStationEquipment)((Object)childObj)).getGpsChainComplexKey();
                                if (chainComplexKey.equals(bsGpsChainComplexKey)) continue;
                                label.setForeground(Color.ORANGE.darker());
                                errMessage = "DifferentParametersInChain";
                                break;
                            }
                        }
                    }
                }
                if (null != errMessage) {
                    label.setText(label.getText() + " (" + GPSChainManagerConfig.i18n.translateString(errMessage) + ")");
                }
                label.setIcon(UIIconFactory.getIcon((Object)gpsChain, (int)2));
            } else if (userObject instanceof RbBaseStationEquipment) {
                RbBaseStationEquipment bsEquipment = (RbBaseStationEquipment)((Object)userObject);
                String text = GPSChainManagerConfig.i18n.translateString(RbBSClockConfigParameters.toStringRbBSCurrentClockMode(bsEquipment.getGpsClockMode())) + " (" + bsEquipment.getName() + "/" + bsEquipment.getIPAddress() + ")";
                label.setText(text);
                label.setIcon(UIIconFactory.getIcon((Object)((Object)bsEquipment), (int)2));
                RbGPSChain gpsChain = (RbGPSChain)((DefaultMutableTreeNode)((DefaultMutableTreeNode)value).getParent()).getUserObject();
                if (!gpsChain.getComplexKey().equals(bsEquipment.getGpsChainComplexKey())) {
                    label.setForeground(Color.ORANGE.darker());
                }
            }
            label.setBackground(selected ? this.backgroundSelectionColor : this.backgroundNonSelectionColor);
            return label;
        }
    }
}

